/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckedTextView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.GroupAvatarDrawable_v2;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.mm.MMZoomGroup;
import com.zipow.videobox.view.mm.MMZoomGroupComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMNotificationExceptionGroupSettingsListView
extends ListView {
    private MMNotificationExceptionGroupAdapter mAdapter;

    public MMNotificationExceptionGroupSettingsListView(Context context) {
        super(context);
        this.init();
    }

    public MMNotificationExceptionGroupSettingsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMNotificationExceptionGroupSettingsListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mAdapter = new MMNotificationExceptionGroupAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mAdapter);
        this.updateDefaultNotificationSettings();
    }

    private void updateDefaultNotificationSettings() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        int[] allSettings = mgr.getBlockAllSettings();
        if (allSettings == null) {
            return;
        }
        int action = allSettings[0];
        int type = allSettings[1];
        if (action == 1 && type == 1) {
            this.mAdapter.setDefaultNotificationType(1);
        } else if (action == 2) {
            this.mAdapter.setDefaultNotificationType(3);
        } else if (action == 1 && type == 4) {
            this.mAdapter.setDefaultNotificationType(2);
        }
    }

    public void updateData(Map<String, Integer> mySettings) {
        this.mAdapter.cleanData();
        List<MMZoomGroup> groups = this.loadAllGroups();
        this.mAdapter.setNormalGroups(groups);
        this.updateDefaultNotificationSettings();
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        PTAppProtos.MUCNotifySettings settings = mgr.getMUCDiffFromGeneralSetting();
        if (settings != null) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            groups = new ArrayList<MMZoomGroup>();
            for (PTAppProtos.MUCNotifySettingItem item : settings.getItemsList()) {
                MMZoomGroup mmZoomGroup;
                ZoomGroup group = messenger.getGroupById(item.getSessionId());
                if (group == null || (mmZoomGroup = MMZoomGroup.initWithZoomGroup(group)) == null) continue;
                mmZoomGroup.setNotifyType(item.getType());
                groups.add(mmZoomGroup);
            }
            this.mAdapter.setExceptionGroups(groups);
        }
        this.mAdapter.setSettings(mySettings);
        this.mAdapter.notifyDataSetChanged();
    }

    @Nullable
    private List<MMZoomGroup> loadAllGroups() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ArrayList<MMZoomGroup> groups = new ArrayList<MMZoomGroup>();
        for (int i = 0; i < messenger.getGroupCount(); ++i) {
            ZoomGroup group = messenger.getGroupAt(i);
            if (group == null) continue;
            MMZoomGroup mmZoomGroup = MMZoomGroup.initWithZoomGroup(group);
            groups.add(mmZoomGroup);
        }
        return groups;
    }

    public void setFilter(String key) {
        this.mAdapter.setFilter(key);
        this.mAdapter.notifyDataSetChanged();
    }

    public void updateGroup(String groupId) {
        this.mAdapter.updateGroup(groupId);
        this.mAdapter.notifyDataSetChanged();
    }

    public void removeGroup(String groupId) {
        this.mAdapter.removeGroup(groupId);
        this.mAdapter.notifyDataSetChanged();
    }

    public MMZoomGroup getItem(int position) {
        Object item = this.mAdapter.getItem(position - this.getHeaderViewsCount());
        if (item instanceof MMZoomGroup) {
            return (MMZoomGroup)item;
        }
        return null;
    }

    static class MMNotificationExceptionGroupAdapter
    extends BaseAdapter {
        private static final String TAG_GROUPS_LABEL = "label";
        private static final String TAG_GROUPS_ITEM = "item";
        private List<MMZoomGroup> mNormalGroups = new ArrayList<MMZoomGroup>();
        private List<MMZoomGroup> mExceptionGroups = new ArrayList<MMZoomGroup>();
        private Context mContext;
        private List<Object> mDisplayData = new ArrayList<Object>();
        private String mKey;
        private int mDefaultNotificationType = 1;
        private Map<String, Integer> mySettings;

        public MMNotificationExceptionGroupAdapter(Context context) {
            this.mContext = context;
        }

        public void setDefaultNotificationType(int type) {
            this.mDefaultNotificationType = type;
        }

        public void setNormalGroups(List<MMZoomGroup> groups) {
            if (groups == null) {
                return;
            }
            this.mNormalGroups.clear();
            for (MMZoomGroup group : groups) {
                this.mNormalGroups.add(group);
            }
            MMZoomGroupComparator comparator = new MMZoomGroupComparator(CompatUtils.getLocalDefault());
            Collections.sort(this.mNormalGroups, comparator);
            this.removeExceptionGroupInNormal();
        }

        public void cleanData() {
            this.mNormalGroups.clear();
            this.mExceptionGroups.clear();
            this.mDisplayData.clear();
            this.mySettings = null;
        }

        public void setSettings(Map<String, Integer> mySettings) {
            this.mySettings = mySettings;
        }

        public void updateGroup(String groupId) {
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            ZoomGroup group = messenger.getGroupById(groupId);
            if (group == null) {
                return;
            }
            boolean isInException = false;
            for (int i = 0; i < this.mExceptionGroups.size(); ++i) {
                MMZoomGroup eGroup = this.mExceptionGroups.get(i);
                if (!StringUtil.isSameString((String)groupId, (String)eGroup.getGroupId())) continue;
                this.mExceptionGroups.set(i, MMZoomGroup.initWithZoomGroup(group));
                isInException = true;
                break;
            }
            if (!isInException) {
                boolean isFind = false;
                for (int i = 0; i < this.mNormalGroups.size(); ++i) {
                    MMZoomGroup eGroup = this.mNormalGroups.get(i);
                    if (!StringUtil.isSameString((String)groupId, (String)eGroup.getGroupId())) continue;
                    this.mNormalGroups.set(i, MMZoomGroup.initWithZoomGroup(group));
                    isFind = true;
                }
                if (!isFind) {
                    this.mNormalGroups.add(MMZoomGroup.initWithZoomGroup(group));
                }
            }
        }

        public void removeGroup(String groupId) {
            MMZoomGroup group;
            int i;
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            for (i = 0; i < this.mNormalGroups.size(); ++i) {
                group = this.mNormalGroups.get(i);
                if (!StringUtil.isSameString((String)groupId, (String)group.getGroupId())) continue;
                this.mNormalGroups.remove(i);
                break;
            }
            for (i = 0; i < this.mExceptionGroups.size(); ++i) {
                group = this.mExceptionGroups.get(i);
                if (!StringUtil.isSameString((String)groupId, (String)group.getGroupId())) continue;
                this.mExceptionGroups.remove(i);
                break;
            }
        }

        public void setFilter(String key) {
            this.mKey = key;
        }

        public void setExceptionGroups(List<MMZoomGroup> groups) {
            if (groups == null) {
                return;
            }
            this.mExceptionGroups.clear();
            for (MMZoomGroup group : groups) {
                this.mExceptionGroups.add(group);
            }
            MMZoomGroupComparator comparator = new MMZoomGroupComparator(CompatUtils.getLocalDefault());
            Collections.sort(this.mExceptionGroups, comparator);
            this.removeExceptionGroupInNormal();
        }

        private void removeExceptionGroupInNormal() {
            if (CollectionsUtil.isListEmpty(this.mExceptionGroups) || CollectionsUtil.isListEmpty(this.mNormalGroups)) {
                return;
            }
            block0: for (MMZoomGroup group : this.mExceptionGroups) {
                for (int i = 0; i < this.mNormalGroups.size(); ++i) {
                    MMZoomGroup item = this.mNormalGroups.get(i);
                    if (!StringUtil.isSameString((String)item.getGroupId(), (String)group.getGroupId())) continue;
                    this.mNormalGroups.remove(i);
                    continue block0;
                }
            }
        }

        public void notifyDataSetChanged() {
            this.sortAll();
            super.notifyDataSetChanged();
        }

        public int getViewTypeCount() {
            return 2;
        }

        public int getItemViewType(int position) {
            Object item = this.getItem(position);
            if (item instanceof ZoomGroup) {
                return 0;
            }
            return 1;
        }

        public int getCount() {
            return this.mDisplayData == null ? 0 : this.mDisplayData.size();
        }

        public Object getItem(int position) {
            return this.mDisplayData == null ? null : this.mDisplayData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object item = this.getItem(position);
            if (item instanceof MMZoomGroup) {
                return this.getGroupItemView((MMZoomGroup)item, convertView, parent);
            }
            return this.getLabelItemView((String)item, convertView, parent);
        }

        private View getLabelItemView(String label, View convertView, ViewGroup parent) {
            if (convertView == null || !TAG_GROUPS_LABEL.equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_listview_label_item, null);
                convertView.setTag((Object)TAG_GROUPS_LABEL);
            }
            TextView txtHeaderLabel = (TextView)convertView.findViewById(R.id.txtHeaderLabel);
            txtHeaderLabel.setText((CharSequence)label);
            return convertView;
        }

        private View getGroupItemView(MMZoomGroup group, View convertView, ViewGroup parent) {
            Integer t;
            if (convertView == null || !TAG_GROUPS_ITEM.equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_contacts_group_item, null);
                convertView.setTag((Object)TAG_GROUPS_ITEM);
            }
            AvatarView avatarView = (AvatarView)convertView.findViewById(R.id.avatarView);
            TextView txtGroupName = (TextView)convertView.findViewById(R.id.txtGroupName);
            TextView txtMemberNo = (TextView)convertView.findViewById(R.id.txtMemberNo);
            TextView txtGroupDes = (TextView)convertView.findViewById(R.id.txtGroupdes);
            CheckedTextView checked = (CheckedTextView)convertView.findViewById(R.id.check);
            avatarView.setAvatar(new GroupAvatarDrawable_v2(group.getGroupId()));
            txtGroupName.setText((CharSequence)group.getGroupName());
            txtMemberNo.setText((CharSequence)String.format("(%s)", group.getMemberCount()));
            checked.setVisibility(8);
            int type = group.getNotifyType();
            if (this.mySettings != null && (t = this.mySettings.get(group.getGroupId())) != null) {
                type = t;
            }
            block0 : switch (type) {
                case 1: {
                    txtGroupDes.setText(R.string.zm_lbl_notification_all_msg_19898);
                    break;
                }
                case 2: {
                    txtGroupDes.setText(R.string.zm_lbl_notification_private_msg_19898);
                    break;
                }
                case 3: {
                    txtGroupDes.setText(R.string.zm_lbl_notification_nothing_19898);
                    break;
                }
                default: {
                    switch (this.mDefaultNotificationType) {
                        case 1: {
                            txtGroupDes.setText(R.string.zm_lbl_notification_all_msg_19898);
                            break block0;
                        }
                        case 2: {
                            txtGroupDes.setText(R.string.zm_lbl_notification_private_msg_19898);
                            break block0;
                        }
                        case 3: {
                            txtGroupDes.setText(R.string.zm_lbl_notification_nothing_19898);
                            break block0;
                        }
                    }
                    txtGroupDes.setText((CharSequence)"");
                }
            }
            return convertView;
        }

        private void sortAll() {
            Integer type;
            this.mDisplayData.clear();
            ArrayList<MMZoomGroup> exceptionGroups = new ArrayList<MMZoomGroup>();
            ArrayList<MMZoomGroup> normalGroups = new ArrayList<MMZoomGroup>();
            for (MMZoomGroup group : this.mExceptionGroups) {
                if (StringUtil.isEmptyOrNull((String)group.getGroupName()) || !StringUtil.isEmptyOrNull((String)this.mKey) && !group.getGroupName().contains(this.mKey)) continue;
                Integer n = type = this.mySettings == null ? null : this.mySettings.get(group.getGroupId());
                if (type != null && (type == this.mDefaultNotificationType || type == 0)) {
                    normalGroups.add(group);
                    continue;
                }
                exceptionGroups.add(group);
            }
            for (MMZoomGroup group : this.mNormalGroups) {
                if (StringUtil.isEmptyOrNull((String)group.getGroupName()) || !StringUtil.isEmptyOrNull((String)this.mKey) && !group.getGroupName().contains(this.mKey)) continue;
                Integer n = type = this.mySettings == null ? null : this.mySettings.get(group.getGroupId());
                if (type != null && type != this.mDefaultNotificationType) {
                    exceptionGroups.add(group);
                    continue;
                }
                normalGroups.add(group);
            }
            MMZoomGroupComparator comparator = new MMZoomGroupComparator(CompatUtils.getLocalDefault());
            Collections.sort(exceptionGroups, comparator);
            Collections.sort(normalGroups, comparator);
            if (!CollectionsUtil.isListEmpty(exceptionGroups)) {
                this.mDisplayData.add(this.mContext.getString(R.string.zm_title_notification_exception_group_19898) + String.format("(%d)", exceptionGroups.size()));
                this.mDisplayData.addAll(exceptionGroups);
            }
            if (!CollectionsUtil.isListEmpty(normalGroups)) {
                this.mDisplayData.add(this.mContext.getString(R.string.zm_lbl_group_19898, new Object[]{normalGroups.size()}));
                this.mDisplayData.addAll(normalGroups);
            }
        }
    }
}

