/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.tempbean.IMessageTemplateMessage;
import com.zipow.videobox.tempbean.IMessageTemplateTextStyle;
import com.zipow.videobox.view.mm.IEditTemplateListener;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.util.List;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMMessageTemplateItemView
extends LinearLayout {
    private MMMessageItem mmMessageItem;
    private IEditTemplateListener mEditTemplateListener;

    public MMMessageTemplateItemView(Context context) {
        super(context);
        this.initView(context);
    }

    public MMMessageTemplateItemView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public MMMessageTemplateItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public MMMessageTemplateItemView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.setOrientation(1);
    }

    public void setmEditTemplateListener(IEditTemplateListener mEditTemplateListener) {
        this.mEditTemplateListener = mEditTemplateListener;
    }

    public void setData(MMMessageItem messageItem, List<IMessageTemplateMessage> list) {
        if (list == null || list.isEmpty()) {
            this.setVisibility(8);
            return;
        }
        this.setVisibility(0);
        this.mmMessageItem = messageItem;
        this.removeAllViews();
        for (IMessageTemplateMessage item : list) {
            this.addMessageItem(item);
        }
    }

    private void addMessageItem(final IMessageTemplateMessage item) {
        if (item != null) {
            IMessageTemplateTextStyle style2;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            if (this.getChildCount() > 0) {
                params.topMargin = UIUtil.dip2px((Context)this.getContext(), (float)7.0f);
            }
            View child = MMMessageTemplateItemView.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_template_item, null);
            TextView message = (TextView)child.findViewById(R.id.message);
            ImageView edit = (ImageView)child.findViewById(R.id.edit);
            if (!TextUtils.isEmpty((CharSequence)item.getLink())) {
                message.setMovementMethod(LinkMovementMethod.getInstance());
                SpannableString spannableString = new SpannableString((CharSequence)item.getText());
                spannableString.setSpan((Object)new ClickableSpan(){

                    public void onClick(View widget) {
                        UIUtil.openURL((Context)MMMessageTemplateItemView.this.getContext(), (String)item.getLink());
                    }

                    public void updateDrawState(TextPaint ds) {
                        ds.setColor(ContextCompat.getColor((Context)MMMessageTemplateItemView.this.getContext(), (int)R.color.zm_template_link));
                        ds.setUnderlineText(false);
                    }
                }, 0, spannableString.length(), 33);
                message.setText((CharSequence)spannableString);
            } else {
                message.setText((CharSequence)item.getText());
            }
            if (item.isEditable()) {
                edit.setVisibility(0);
                edit.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (MMMessageTemplateItemView.this.mEditTemplateListener != null) {
                            MMMessageTemplateItemView.this.mEditTemplateListener.onEditTemplate(((MMMessageTemplateItemView)MMMessageTemplateItemView.this).mmMessageItem.messageXMPPId, item.getEvent_id());
                        }
                    }
                });
            }
            if ((style2 = item.getStyle()) != null) {
                style2.applyStyle(message);
            }
            this.addView(child, (ViewGroup.LayoutParams)params);
        }
    }
}

