/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.MaskedDrawable;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.ZMGifView;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.io.File;
import java.io.InputStream;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMMessagePicView
extends AbsMessageView {
    private int PREVIEW_PIC_SIZE_MAX;
    private static final String TAG = MMMessagePicView.class.getSimpleName();
    protected MMMessageItem mMessageItem;
    protected AvatarView mAvatarView;
    protected ZMGifView mImgPic;
    protected ImageView mImgStatus;
    protected ProgressBar mProgressBar;
    protected TextView mTxtScreenName;
    protected LinearLayout mPanelProgress;
    protected ProgressBar mProgressBarDownload;
    protected TextView mTxtRatio;
    private int mImgPaddingLeft = 0;
    private int mImgPaddingRight = 0;
    private int mImgPaddingTop = 0;
    private int mImgPaddingBottom = 0;

    public MMMessagePicView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMMessagePicView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.PREVIEW_PIC_SIZE_MAX = UIUtil.dip2px((Context)this.getContext(), (float)200.0f);
        this.inflateLayout();
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mImgStatus = (ImageView)this.findViewById(R.id.imgStatus);
        this.mImgPic = (ZMGifView)this.findViewById(R.id.imgPic);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBar1);
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mPanelProgress = (LinearLayout)this.findViewById(R.id.panelProgress);
        this.mProgressBarDownload = (ProgressBar)this.findViewById(R.id.progressBarDownload);
        this.mTxtRatio = (TextView)this.findViewById(R.id.txtRatio);
        this.mImgPaddingLeft = this.mImgPic.getPaddingLeft();
        this.mImgPaddingRight = this.mImgPic.getPaddingRight();
        this.mImgPaddingTop = this.mImgPic.getPaddingTop();
        this.mImgPaddingBottom = this.mImgPic.getPaddingBottom();
        this.setStatusImage(false, 0);
        if (this.mImgPic != null) {
            this.mImgPic.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnShowContextMenuListener l = MMMessagePicView.this.getOnShowContextMenuListener();
                    if (l != null) {
                        return l.onShowContextMenu(MMMessagePicView.this.mMessageItem);
                    }
                    return false;
                }
            });
            this.mImgPic.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickMessageListener l = MMMessagePicView.this.getOnClickMessageListener();
                    if (l != null) {
                        l.onClickMessage(MMMessagePicView.this.mMessageItem);
                    }
                }
            });
        }
        if (this.mPanelProgress != null) {
            this.mPanelProgress.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickMessageListener l = MMMessagePicView.this.getOnClickMessageListener();
                    if (l != null) {
                        l.onClickMessage(MMMessagePicView.this.mMessageItem);
                    }
                }
            });
        }
        if (this.mImgStatus != null) {
            this.mImgStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickStatusImageListener l = MMMessagePicView.this.getOnClickStatusImageListener();
                    if (l != null) {
                        l.onClickStatusImage(MMMessagePicView.this.mMessageItem);
                    }
                }
            });
        }
        if (this.mAvatarView != null) {
            this.mAvatarView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickAvatarListener l = MMMessagePicView.this.getOnClickAvatarListener();
                    if (l != null) {
                        l.onClickAvatar(MMMessagePicView.this.mMessageItem);
                    }
                }
            });
            this.mAvatarView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnLongClickAvatarListener l = MMMessagePicView.this.getOnLongClickAvatarListener();
                    if (l != null) {
                        return l.onLongClickAvatar(MMMessagePicView.this.mMessageItem);
                    }
                    return false;
                }
            });
        }
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_pic_from, (ViewGroup)this);
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    public void setRatio(int ratio) {
        if (this.mTxtRatio != null) {
            this.mTxtRatio.setText((CharSequence)(ratio + "%"));
        }
        if (this.mImgPic != null) {
            this.mImgPic.setRatio(ratio);
        }
    }

    public void clearRatio() {
        if (this.mTxtRatio != null) {
            this.mTxtRatio.setText((CharSequence)"");
        }
        if (this.mImgPic != null) {
            this.mImgPic.clearRatio();
        }
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    public void setStatusImage(boolean visible, int resId) {
        if (this.mImgStatus != null) {
            this.mImgStatus.setVisibility(visible ? 0 : 8);
            this.mImgStatus.setImageResource(resId);
        }
    }

    protected Drawable getMesageBackgroudDrawable() {
        return null;
    }

    protected Drawable getProgressBackgroudDrawable() {
        return null;
    }

    public void setPic(String pic) {
        if (this.mImgPic != null) {
            Context context = this.getContext();
            if (context == null) {
                return;
            }
            int sizeMax = this.PREVIEW_PIC_SIZE_MAX;
            Uri imageUri = Uri.parse((String)("file://" + pic));
            Bitmap bmp = null;
            try {
                BitmapFactory.Options o = new BitmapFactory.Options();
                o.inJustDecodeBounds = true;
                BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(imageUri), null, (BitmapFactory.Options)o);
                int width = o.outWidth;
                int height = o.outHeight;
                bmp = width <= sizeMax && height <= sizeMax ? ZMBitmapFactory.decodeFile(pic) : ImageUtil.translateImageAsSmallBitmap(context, imageUri, sizeMax, true);
            }
            catch (Exception o) {
                // empty catch block
            }
            if (bmp != null) {
                this.mImgPic.setBackgroundResource(0);
                this.mImgPic.setPadding(0, 0, 0, 0);
                this.mImgPic.setImageDrawable((Drawable)new BitmapDrawable(this.getResources(), bmp));
            } else {
                int sdk = Build.VERSION.SDK_INT;
                if (sdk < 16) {
                    this.mImgPic.setBackgroundDrawable(this.getMesageBackgroudDrawable());
                } else {
                    this.mImgPic.setBackground(this.getMesageBackgroudDrawable());
                }
                this.mImgPic.setPadding(this.mImgPaddingLeft, this.mImgPaddingTop, this.mImgPaddingRight, this.mImgPaddingBottom);
                this.mImgPic.setImageResource(R.drawable.zm_image_placeholder);
            }
        }
    }

    protected Drawable getMaskDrawable() {
        return this.getMesageBackgroudDrawable();
    }

    protected int getBubbleImageRes() {
        return R.drawable.zm_chatfrom_bg;
    }

    protected int[] getImgRadius() {
        return null;
    }

    private Drawable createMaskedDrawable(Context context, Bitmap bmp) {
        float scale = context.getResources().getDisplayMetrics().density;
        Drawable drawableMask = this.getMaskDrawable();
        MaskedDrawable drawable2 = new MaskedDrawable(drawableMask, bmp, scale);
        return drawable2;
    }

    public void setScreenName(String screenName) {
        if (screenName != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText((CharSequence)screenName);
        }
    }

    public void setMessageItem(MMMessageItem item) {
        this.mMessageItem = item;
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(item.fromScreenName);
            this.mAvatarView.setBgColorSeedString(item.fromJid);
        }
        LinearLayout content = (LinearLayout)this.findViewById(R.id.panelMsgLayout);
        if (item.onlyMessageShow) {
            this.mAvatarView.setVisibility(4);
            if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
            content.setPadding(content.getPaddingLeft(), 0, content.getPaddingRight(), content.getPaddingBottom());
        } else {
            content.setPadding(content.getPaddingLeft(), content.getPaddingBottom(), content.getPaddingRight(), content.getPaddingBottom());
            this.mAvatarView.setVisibility(0);
            if (this.mTxtScreenName != null && item.isIncomingMessage() && item.isGroupMessage) {
                this.setScreenName(item.fromScreenName);
                if (this.mTxtScreenName != null) {
                    this.mTxtScreenName.setVisibility(0);
                }
            } else if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
            if (!this.isInEditMode()) {
                String fromJid = item.fromJid;
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger != null) {
                    File file;
                    String phoneNumber = null;
                    ZoomBuddy buddy = null;
                    ZoomBuddy myself = messenger.getMyself();
                    if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                        buddy = myself;
                    } else {
                        buddy = messenger.getBuddyWithJID(fromJid);
                        if (buddy != null) {
                            phoneNumber = buddy.getPhoneNumber();
                        }
                    }
                    String avatarPath = null;
                    if (buddy != null) {
                        avatarPath = buddy.getLocalPicturePath();
                    }
                    boolean hasAvatarFile = false;
                    if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                        this.setAvatar(avatarPath);
                        hasAvatarFile = true;
                    }
                    if (!hasAvatarFile) {
                        if (item.fromContact == null && phoneNumber != null && buddy != null) {
                            item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                        }
                        if (item.fromContact != null) {
                            this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                        } else {
                            this.setAvatar((String)null);
                        }
                    }
                }
            }
        }
        int[] radius = this.getImgRadius();
        if (radius != null && this.mImgPic != null) {
            this.mImgPic.setRadius(radius);
        }
        if (!(!StringUtil.isEmptyOrNull((String)item.picturePreviewPath) && new File(item.picturePreviewPath).exists() || !StringUtil.isEmptyOrNull((String)item.localFilePath) && new File(item.localFilePath).exists())) {
            if (this.mPanelProgress != null) {
                this.mPanelProgress.setVisibility(0);
                int sdk = Build.VERSION.SDK_INT;
                if (sdk < 16) {
                    this.mPanelProgress.setBackgroundDrawable(this.getProgressBackgroudDrawable());
                } else {
                    this.mPanelProgress.setBackground(this.getProgressBackgroudDrawable());
                }
                this.mImgPic.setVisibility(8);
                if (this.mProgressBarDownload != null) {
                    this.mProgressBarDownload.setVisibility(item.isPreviewDownloadFailed ? 4 : 0);
                }
            }
        } else {
            if (this.mPanelProgress != null) {
                this.mPanelProgress.setVisibility(8);
            }
            this.mImgPic.setVisibility(0);
        }
        if ((item.messageType == 27 || item.messageType == 28) && (!StringUtil.isEmptyOrNull((String)item.localFilePath) && new File(item.localFilePath).exists() || !StringUtil.isEmptyOrNull((String)item.picturePreviewPath) && new File(item.picturePreviewPath).exists())) {
            String path = !StringUtil.isEmptyOrNull((String)item.localFilePath) && new File(item.localFilePath).exists() ? item.localFilePath : item.picturePreviewPath;
            this.mImgPic.setGifResourse(path);
        } else if (!StringUtil.isEmptyOrNull((String)item.picturePreviewPath) && new File(item.picturePreviewPath).exists() && ImageUtil.isValidImageFile(item.picturePreviewPath)) {
            this.setPic(item.picturePreviewPath);
        } else if (!StringUtil.isEmptyOrNull((String)item.localFilePath)) {
            this.setPic(item.localFilePath);
        } else {
            this.setPic(null);
        }
    }
}

