/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.AddrBookItemDetailsActivity;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.fragment.MMChatFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.UnSupportMessageMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.CallHistory;
import com.zipow.videobox.sip.CallHistoryMgr;
import com.zipow.videobox.tempbean.IMessageTemplateActionItem;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.ZMWebUtil;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.JoinConfView;
import com.zipow.videobox.view.mm.LinkPreviewMetaInfo;
import com.zipow.videobox.view.mm.MMAddonMessage;
import com.zipow.videobox.view.mm.MMContentMessageItem;
import com.zipow.videobox.view.mm.MMMessageItem;
import com.zipow.videobox.view.mm.MMMessageListAdapter;
import com.zipow.videobox.view.mm.MMMessageView;
import com.zipow.videobox.view.mm.sticker.CommonEmojiHelper;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.androidlib.widget.PullDownRefreshListView;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMMessageListView
extends PullDownRefreshListView
implements SensorEventListener,
AbsListView.OnScrollListener {
    private static final String TAG = MMMessageListView.class.getSimpleName();
    private static final int PAGE_SIZE = 13;
    private static final int PAGE_SIZE_MAX = 30;
    private static final String MSGID_NEW_MSG_MARK = "MSGID_NEW_MSG_MARK";
    private MMMessageListAdapter mAdapter;
    private boolean mLoaded = false;
    private MMChatFragment mParentFragment;
    private boolean mHasNewMessageDuringPaused = true;
    private String mGroupId;
    private String mBuddyId;
    private String mSessionId;
    private boolean mIsGroup = false;
    private String mMessageContextReqId;
    private boolean mIsHistorySyncing;
    private String mEarliestNoDirtyMsgId;
    private IMAddrBookItem mIMAddrBookItem;
    private MediaPlayer mMediaPlayer;
    private MMMessageItem mPlayingMessage;
    private MMContentMessageItem.MMContentMessageAnchorInfo mAnchorMessageInfo;
    private int mOldVolume = -1;
    private int mVolumeChangedTo = -1;
    private boolean mbVolumeChanged = false;
    private View mPanelLoadMoreView;
    private boolean mIsMsgContextBackHasMore = true;
    private boolean mIsMsgContextForwardHasMore = true;
    private ArrayList<String> mMsgContextGUIDS = new ArrayList();
    private int mSearchMessageContextType;
    private int mSearchMarkUnreadContextType;
    private boolean mIsE2EChat = false;
    private HashMap<String, String> mLinkPreviewReqIds = new HashMap();
    private HashMap<String, String> mGiphyReqIds = new HashMap();
    private int currentScrollState = 0;
    private Handler mHander = new Handler(Looper.getMainLooper());
    private Runnable mAutoMarkReadRunnable = new Runnable(){

        @Override
        public void run() {
            MMMessageListView.this.autoMarkRead();
        }
    };
    private String mPendingSyncRepId;
    private String mBackgroundSyncReqId;
    private String mLatestReadMsgXmppId;
    private int mAutoLoadMoreTimes = 0;
    private int mUnreadMsgCount;
    private boolean mIsReloadWhenFirstFailed = false;
    private List<String> mLocalDirtyMsgs;
    private int SyncMsgTimeOut = 15000;
    private final ArrayList<String> messageIds = new ArrayList();
    private final HashMap<String, Entry> urlAndTimes = new HashMap();
    private Runnable mSyncMsgTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            String reqId;
            if (!ViewCompat.isAttachedToWindow((View)MMMessageListView.this)) {
                return;
            }
            String string2 = reqId = MMMessageListView.this.mPendingSyncRepId == null ? MMMessageListView.this.mBackgroundSyncReqId : MMMessageListView.this.mPendingSyncRepId;
            if (!TextUtils.isEmpty((CharSequence)reqId)) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                ZoomChatSession session = messenger.getSessionById(MMMessageListView.this.mSessionId);
                if (session == null) {
                    return;
                }
                session.cancelSearchHistoryMessageRequest(reqId);
                MMMessageListView.this.mPendingSyncRepId = null;
                MMMessageListView.this.mBackgroundSyncReqId = null;
                MMMessageListView.this.mIsHistorySyncing = false;
                MMMessageListView.this.showRefreshing(false);
            }
        }
    };

    public MMMessageListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMMessageListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMMessageListView(Context context) {
        super(context);
        this.initView();
    }

    public void setUnreadMsgCount(int count) {
        this.mUnreadMsgCount = count;
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            HashMap giphyReqIds;
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("MMMessageListView.superState");
            this.mMessageContextReqId = allState.getString("MMMessageListView.mMessageContextReqId");
            this.mIsMsgContextBackHasMore = allState.getBoolean("MMMessageListView.mIsMsgContextBackHasMore", true);
            this.mIsMsgContextForwardHasMore = allState.getBoolean("MMMessageListView.mIsMsgContextForwardHasMore", true);
            this.mSearchMessageContextType = allState.getInt("MMMessageListView.mSearchMessageContextType", 0);
            this.mSearchMarkUnreadContextType = allState.getInt("MMMessageListView.mSearchMarkUnreadContextType", 0);
            this.mAutoLoadMoreTimes = allState.getInt("MMMessageListView.mAutoLoadMoreTimes", 0);
            ArrayList contextGuids = allState.getStringArrayList("MMMessageListView.mMsgContextGUIDS");
            if (contextGuids != null && contextGuids.size() > 0) {
                this.mMsgContextGUIDS = contextGuids;
            }
            this.mAnchorMessageInfo = (MMContentMessageItem.MMContentMessageAnchorInfo)allState.getSerializable("MMMessageListView.mAnchorMessageInfo");
            HashMap linkPreviewReqIds = (HashMap)allState.getSerializable("MMMessageListView.mLinkPreviewReqIds");
            if (linkPreviewReqIds != null) {
                this.mLinkPreviewReqIds = linkPreviewReqIds;
            }
            if ((giphyReqIds = (HashMap)allState.getSerializable("MMMessageListView.mGiphyReqIds")) != null) {
                this.mGiphyReqIds = giphyReqIds;
            }
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MMMessageListView.superState", superState);
        bundle.putString("MMMessageListView.mMessageContextReqId", this.mMessageContextReqId);
        bundle.putStringArrayList("MMMessageListView.mMsgContextGUIDS", this.mMsgContextGUIDS);
        bundle.putInt("MMMessageListView.mSearchMarkUnreadContextType", this.mSearchMarkUnreadContextType);
        bundle.putSerializable("MMMessageListView.mLinkPreviewReqIds", this.mLinkPreviewReqIds);
        bundle.putSerializable("MMMessageListView.mGiphyReqIds", this.mGiphyReqIds);
        bundle.putSerializable("MMMessageListView.mAnchorMessageInfo", (Serializable)this.mAnchorMessageInfo);
        bundle.putInt("MMMessageListView.mSearchMessageContextType", this.mSearchMessageContextType);
        bundle.putBoolean("MMMessageListView.mIsMsgContextBackHasMore", this.mIsMsgContextBackHasMore);
        bundle.putBoolean("MMMessageListView.mIsMsgContextForwardHasMore", this.mIsMsgContextForwardHasMore);
        bundle.putInt("MMMessageListView.mAutoLoadMoreTimes", this.mAutoLoadMoreTimes);
        return bundle;
    }

    public void setParentFragment(MMChatFragment fragment) {
        this.mParentFragment = fragment;
    }

    public boolean isParentFragmentResumed() {
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.isResumed();
    }

    public void setLatestReadMsgXmppId(String msgXmppId) {
        this.mLatestReadMsgXmppId = msgXmppId;
    }

    @Nullable
    public MMMessageItem getLatestMsgIdInCache(List<String> msgIds) {
        if (CollectionsUtil.isCollectionEmpty(msgIds)) {
            return null;
        }
        return this.mAdapter.getLatestMsgIdInCache(msgIds);
    }

    public int jumpToMsgServerTime(long serverTime) {
        if (serverTime <= 0L) {
            return -1;
        }
        if (this.mAdapter == null) {
            return -1;
        }
        int index = this.mAdapter.findItem(serverTime);
        if (index >= 0) {
            this.setSelection(index);
            return index;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return -1;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return -1;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return -1;
        }
        String myJid = myself.getJid();
        if (myJid == null) {
            return -1;
        }
        ArrayList messages = new ArrayList();
        int size = session.getMarkUnreadMessageContext(this.mAdapter.getMessageItemsCount(), serverTime);
        if (size <= 0) {
            return -1;
        }
        this.loadMore(size, false);
        this.setSelection(0);
        return size;
    }

    public void jumpToMsgXmppId(String msgXmppId) {
        if (TextUtils.isEmpty((CharSequence)msgXmppId)) {
            return;
        }
        if (this.mAdapter == null) {
            return;
        }
        int index = this.mAdapter.findItemByXmppId(msgXmppId);
        if (index > 0) {
            this.setSelection(index);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        index = session.getMessageInCacheIndex(msgXmppId);
        int leftCount = index - this.mAdapter.getMessageItemsCount();
        if (leftCount <= 0) {
            this.loadAllCacheMsg();
        } else {
            this.loadMore(leftCount, false);
            this.mAdapter.notifyDataSetChanged();
        }
        int position = this.mAdapter.findItemByXmppId(msgXmppId);
        if (position != -1) {
            this.setSelection(position);
        }
    }

    public void loadAllCacheMsg() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        if (this.mAdapter == null) {
            return;
        }
        int count = session.getMessageCount();
        int leftCount = count - this.mAdapter.getMessageItemsCount();
        if (leftCount <= 0) {
            return;
        }
        this.loadMore(leftCount, false);
        this.mAdapter.notifyDataSetChanged();
    }

    public int getMessageItemsCount() {
        if (this.mAdapter == null) {
            return 0;
        }
        return this.mAdapter.getMessageItemsCount();
    }

    public void setIsE2EChat(boolean isE2E) {
        this.mIsE2EChat = isE2E;
    }

    public void updateUI() {
        if (this.mAdapter.getCount() > 0) {
            this.checkMessageCleared();
        }
        this.mAdapter.notifyDataSetChanged();
        if (this.mHasNewMessageDuringPaused) {
            this.scrollToBottom(false);
        }
    }

    private void checkMessageCleared() {
        ArrayList<ZoomMessage> messages;
        ZoomChatSession session;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (session = messenger.getSessionById(this.mSessionId)) != null && session.getMessages(messages = new ArrayList<ZoomMessage>(), 0, 1) <= 0) {
            this.mAdapter.clear();
            this.mEarliestNoDirtyMsgId = null;
        }
    }

    public void onParentFragmentPause() {
        this.mHasNewMessageDuringPaused = false;
        this.stopPlayAudioMessage();
    }

    private void checkAndReloadAllMsg() {
        if (this.mIsHistorySyncing) {
            return;
        }
        if (this.mAnchorMessageInfo != null) {
            return;
        }
        if (this.mAdapter == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        PTAppProtos.SyncHistoryMsgInfo info = session.getNewestPageRequest(30);
        if (info == null) {
            return;
        }
        boolean ready = info.getIsReady();
        List<String> msgIds = info.getMsgIdsList();
        if (!ready && messenger.isConnectionGood()) {
            this.mIsHistorySyncing = true;
            this.setPullDownRefreshEnabled(true);
            this.mPendingSyncRepId = info.getReqId();
            this.mHander.removeCallbacks(this.mSyncMsgTimeOutRunnable);
            this.mHander.postDelayed(this.mSyncMsgTimeOutRunnable, (long)this.SyncMsgTimeOut);
        }
        if (CollectionsUtil.isListEmpty(msgIds)) {
            return;
        }
        if (session.isAnyNewMessagesForreload()) {
            ZMLog.i((String)TAG, (String)"maybe has message hole , call getNewestPageRequest to check", (Object[])new Object[0]);
            this.mAdapter.clear();
            this.mEarliestNoDirtyMsgId = null;
            this.setPullDownRefreshEnabled(true);
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            String myJid = myself.getJid();
            if (myJid == null) {
                return;
            }
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            for (String messageId : msgIds) {
                Resources res;
                ZoomMessage message = session.getMessageById(messageId);
                if (message == null) continue;
                boolean isOutMessage = StringUtil.isSameString((String)message.getSenderID(), (String)myJid);
                MMMessageItem item = this.addMessageToListAdapter(message, messenger, isOutMessage, this.mIsGroup, false, mgr);
                session.checkAutoDownloadForMessage(message.getMessageID());
                if (item != null && item.messageType == 25 && (res = this.getResources()) != null) {
                    this.addE2ESystemMsg(res.getString(R.string.zm_msg_e2e_state_ready, new Object[]{this.mParentFragment.getBuddyName()}), this.mSessionId, "E2E_SYSTEM_STATE_READY_MSG_ID", item.messageTime);
                }
                if (this.mLatestReadMsgXmppId == null || !TextUtils.equals((CharSequence)this.mLatestReadMsgXmppId, (CharSequence)message.getMessageXMPPGuid())) continue;
                MMMessageItem newMark = MMMessageItem.createNewMsgsMark();
                newMark.messageTime = message.getStamp();
                newMark.messageXMPPId = MSGID_NEW_MSG_MARK;
                this.mAdapter.addItem(newMark);
            }
            this.mLoaded = true;
        }
    }

    public void onConnectReturn(int errorCode) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && messenger.isConnectionGood() && this.mParentFragment != null) {
            this.mIsReloadWhenFirstFailed = false;
            EventTaskManager mgr = this.mParentFragment.getEventTaskManager();
            if (mgr == null) {
                return;
            }
            mgr.push("onConnectReturnInListView", new EventAction(){

                public void run(IUIElement ui) {
                    MMMessageListView.this.checkAndReloadAllMsg();
                }
            });
        }
    }

    private void initView() {
        View footer = View.inflate((Context)this.getContext(), (int)R.layout.zm_list_load_more_footer, null);
        this.mPanelLoadMoreView = footer.findViewById(R.id.panelLoadMoreView);
        this.addFooterView(footer);
        this.mAdapter = new MMMessageListAdapter(this.getContext());
        this.mAdapter.setParentListView(this);
        if (this.isInEditMode()) {
            this._editmode_loadAllMessageItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setTextResources(R.string.zm_lbl_release_to_load_more, R.string.zm_lbl_pull_down_to_load_more, R.string.zm_empty_string);
        this.setOnScrollListener(this);
    }

    private void _editmode_loadAllMessageItems(MMMessageListAdapter adapter) {
        for (int i = 0; i < 5; ++i) {
            MMMessageItem item = new MMMessageItem();
            item.fromScreenName = i % 2 == 0 ? "Zoom" : "Reed Yang";
            item.message = "Hi, Zoom! I like you!";
            item.messageTime = System.currentTimeMillis();
            item.messageType = i % 2 == 0 ? 0 : 1;
            adapter.addItem(item);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        final int lastVisiblePos = this.getLastVisiblePosition();
        super.onLayout(changed, l, t, r, b);
        if (!changed) {
            return;
        }
        if (lastVisiblePos >= 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    MMMessageListView.this.setSelection(lastVisiblePos);
                }
            });
        }
    }

    public void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    public boolean hasMessageFromJid(String jid) {
        return this.mAdapter.hasMessageFromJid(jid);
    }

    public void showMessageContextMenu(int messagePosition, final MMMessageItem message) {
        ZoomBuddy myself;
        boolean isCanceled;
        Activity activity = (Activity)this.getContext();
        if (activity == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ArrayList<MessageContextMenuItem> items = new ArrayList<MessageContextMenuItem>();
        boolean isSendFail = message.messageState == 4;
        boolean isSending = message.messageState == 1;
        boolean bl = isCanceled = message.messageState == 6;
        if (isSendFail) {
            items.add(new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_resend_message), 2));
        }
        if ((myself = messenger.getMyself()) == null) {
            return;
        }
        boolean isDeleteable = message.isDeleteable(this.mSessionId);
        boolean isE2E = message.isE2E || messenger.e2eGetMyOption() == 2;
        boolean isWaitDecrypt = message.isMessageE2EWaitDecrypt();
        if (!isSendFail && !PTApp.getInstance().isFileTransferDisabled() && message.messageType != 2 && message.messageType != 3) {
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return;
            }
            ZoomFile file = mgr.getFileWithMessageID(this.mSessionId, message.messageXMPPId);
            if (file != null) {
                int transferState;
                if (!message.isE2E && messenger.e2eGetMyOption() != 2 && (transferState = file.getFileTransferState()) != 2 && transferState != 3 && transferState != 1 && transferState != 0) {
                    boolean isSelfStiker;
                    items.add(new MessageContextMenuItem(activity.getString(R.string.zm_btn_share), 4));
                    boolean bl2 = isSelfStiker = message.isStikcerMsg && TextUtils.equals((CharSequence)myself.getJid(), (CharSequence)message.fromJid);
                    if (ZmPtUtils.isImageFile(file.getFileType()) && !isSelfStiker) {
                        items.add(new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_save_emoji), 6));
                    }
                }
                mgr.destroyFileObject(file);
            }
        }
        switch (message.messageType) {
            case 0: 
            case 1: 
            case 34: 
            case 35: {
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_copy_message), 1));
                if (!(isSendFail || isSending || isCanceled)) {
                    if (!isWaitDecrypt) {
                        if (this.isMessageMarkUnread(message)) {
                            items.add(new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_mark_as_read_14491), 10));
                        } else {
                            items.add(new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_mark_unread_14491), 9));
                        }
                    }
                    if (!isDeleteable) break;
                    if (!isE2E) {
                        items.add(new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_edit_message_19884), 8));
                    }
                    items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 0));
                    break;
                }
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 14));
                break;
            }
            case 4: 
            case 5: 
            case 27: 
            case 28: {
                if (!(isSendFail || isSending || isCanceled)) {
                    if (!isDeleteable) break;
                    items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 0));
                    break;
                }
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 14));
                break;
            }
            case 2: 
            case 3: {
                if (!(isSendFail || isSending || isCanceled)) {
                    if (!isDeleteable) break;
                    items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 0));
                    break;
                }
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 14));
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 10: 
            case 11: {
                if (!(isSendFail || isSending || isCanceled)) {
                    if (!isDeleteable) break;
                    items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 0));
                    break;
                }
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 14));
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 32: 
            case 33: {
                if (!(isSendFail || isSending || isCanceled)) {
                    if (!isE2E && !PTApp.getInstance().isFileTransferDisabled()) {
                        items.add(new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_save_emoji), 6));
                    }
                    items.add(new MessageContextMenuItem(activity.getString(R.string.zm_mm_btn_save_image), 11));
                    if (!isDeleteable) break;
                    items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 0));
                    break;
                }
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 14));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 40: {
                CallHistory callHistory;
                CallHistoryMgr callHistoryMgr = PTApp.getInstance().getCallHistoryMgr();
                if (callHistoryMgr == null || (callHistory = callHistoryMgr.getCallHistoryByID(message.messageXMPPId)) == null || TextUtils.isEmpty((CharSequence)callHistory.getNumber())) break;
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_copy_url), 13));
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_btn_mm_join_meeting_21854), 12));
                break;
            }
            case 37: 
            case 38: {
                if (!isDeleteable) break;
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_lbl_delete), 0));
                break;
            }
            case 39: {
                items.add(new MessageContextMenuItem(activity.getString(R.string.zm_btn_share), 4));
            }
        }
        if (items.isEmpty()) {
            return;
        }
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(this.mParentFragment.getTitle()).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MessageContextMenuItem item = (MessageContextMenuItem)((Object)menuAdapter.getItem(which));
                MMMessageListView.this.onSelectContextMenuItem(item, message);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectContextMenuItem(MessageContextMenuItem item, MMMessageItem message) {
        if (item == null || message == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        boolean isNetWorkWell = messenger.isConnectionGood();
        switch (item.getAction()) {
            case 1: {
                AndroidAppUtil.copyText((Context)this.getContext(), (CharSequence)message.message);
                break;
            }
            case 0: {
                if (isNetWorkWell) {
                    if (this.mParentFragment == null) break;
                    message.deleteMessage((Context)this.mParentFragment.getActivity());
                    break;
                }
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.zm_mm_msg_network_unavailable), (int)1).show();
                break;
            }
            case 14: {
                this.deleteLocalMessage(message, session);
                break;
            }
            case 2: {
                this.resendMessage(message);
                break;
            }
            case 4: {
                this.shareMessage(message);
                break;
            }
            case 6: {
                this.saveEmoji(message);
                break;
            }
            case 8: {
                if (isNetWorkWell) {
                    this.editMessage(message);
                    break;
                }
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.zm_mm_msg_network_unavailable), (int)1).show();
                break;
            }
            case 9: {
                if (isNetWorkWell) {
                    this.markUnreadMessage(message);
                    break;
                }
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.zm_mm_msg_network_unavailable), (int)1).show();
                break;
            }
            case 10: {
                this.markAsReadMessage(message);
                break;
            }
            case 11: {
                this.saveImage(message);
                break;
            }
            case 12: {
                if (isNetWorkWell) {
                    this.joinMeeting(message);
                    break;
                }
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.zm_mm_msg_network_unavailable), (int)1).show();
                break;
            }
            case 13: {
                this.copyUrl(message);
            }
        }
    }

    private boolean isMessageMarkUnread(MMMessageItem message) {
        if (message == null) {
            return false;
        }
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.isMessageMarkUnread(message);
    }

    private void markUnreadMessage(MMMessageItem message) {
        if (message == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(message.sessionId);
        if (session == null) {
            return;
        }
        if (session.markMessageAsUnread(message.messageXMPPId)) {
            this.updateMessage(session.getMessageByXMPPGuid(message.messageXMPPId));
        }
    }

    private void markAsReadMessage(MMMessageItem message) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        if (!session.isMessageMarkUnread(message.messageXMPPId)) {
            return;
        }
        if (session.unmarkMessageAsUnread(message.messageXMPPId)) {
            this.updateMessage(session.getMessageByXMPPGuid(message.messageXMPPId));
        }
        if (this.mParentFragment != null && this.mParentFragment.isResumed()) {
            this.mParentFragment.resetOldMarkUnreadsItem(message.serverSideTime);
            this.mParentFragment.updateTopHint(session);
        }
    }

    private void editMessage(MMMessageItem message) {
        if (this.mParentFragment != null) {
            this.mParentFragment.editMessage(message);
        }
    }

    private void saveEmoji(MMMessageItem message) {
        if (this.mParentFragment != null) {
            this.mParentFragment.saveEmoji(message);
        }
    }

    private void saveImage(MMMessageItem message) {
        if (this.mParentFragment != null) {
            this.mParentFragment.saveImage(message);
        }
    }

    private void joinMeeting(MMMessageItem message) {
        if (message == null || this.getContext() == null) {
            return;
        }
        CallHistoryMgr callHistoryMgr = PTApp.getInstance().getCallHistoryMgr();
        if (callHistoryMgr == null) {
            return;
        }
        CallHistory callHistory = callHistoryMgr.getCallHistoryByID(message.messageXMPPId);
        if (callHistory == null) {
            return;
        }
        this.joinMeetingByNO(callHistory.getNumber());
    }

    private void copyUrl(MMMessageItem message) {
        if (message == null || this.getContext() == null) {
            return;
        }
        CallHistoryMgr callHistoryMgr = PTApp.getInstance().getCallHistoryMgr();
        if (callHistoryMgr == null) {
            return;
        }
        String domain = PTApp.getInstance().getZoomDomain();
        CallHistory callHistory = callHistoryMgr.getCallHistoryByID(message.messageXMPPId);
        if (callHistory == null || TextUtils.isEmpty((CharSequence)domain.trim())) {
            return;
        }
        String url = domain + "/j/" + callHistory.getNumber();
        AndroidAppUtil.copyText((Context)this.getContext(), (CharSequence)url);
    }

    public void onStartToDownloadFileForMessage(MMMessageItem item, boolean notShowWaiting) {
        if (item == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage message = session.getMessageById(item.messageId);
        if (message == null) {
            return;
        }
        item = this.updateMessage(message);
        if (item != null) {
            item.isDownloading = true;
        }
        this.notifyDataSetChanged();
        this.mParentFragment.onStartToDownloadFileForMessage(item, notShowWaiting);
    }

    public void cancelPendingPlay() {
        this.mAdapter.cancelPendingPlay();
    }

    public void Indicate_MessageDeleted(String sessionID, String msgID) {
        if (StringUtil.isSameString((String)sessionID, (String)this.mSessionId)) {
            this.mAdapter.removeItem(msgID);
            this.mAdapter.notifyDataSetChanged();
            if (TextUtils.equals((CharSequence)msgID, (CharSequence)this.mEarliestNoDirtyMsgId)) {
                this.mEarliestNoDirtyMsgId = null;
            }
        }
    }

    public void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        if (StringUtil.isSameString((String)newSession, (String)this.mSessionId)) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession session = messenger.getSessionById(newSession);
            if (session == null) {
                return;
            }
            ZoomMessage message = session.getMessageByXMPPGuid(newMsgXmppID);
            if (message == null) {
                return;
            }
            MMMessageItem item = this.addMessageToListAdapter(message, messenger, true, this.mIsGroup, false, PTApp.getInstance().getZoomFileContentMgr());
            if (item == null) {
                return;
            }
            item.messageState = 2;
            this.mAdapter.notifyDataSetChanged();
            this.scrollToBottom(false);
        }
    }

    public boolean containAnchorMessage(List<String> msgGuids) {
        if (msgGuids == null || msgGuids.isEmpty()) {
            return false;
        }
        if (this.mAnchorMessageInfo == null) {
            return false;
        }
        if (this.mAnchorMessageInfo.getmType() == 0) {
            if (!TextUtils.isEmpty((CharSequence)this.mAnchorMessageInfo.getMsgGuid())) {
                return msgGuids.contains(this.mAnchorMessageInfo.getMsgGuid());
            }
        } else if (this.mAnchorMessageInfo.getmType() == 1) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return false;
            }
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            if (session == null) {
                return false;
            }
            for (String guid : msgGuids) {
                ZoomMessage zoomMessage;
                if (TextUtils.isEmpty((CharSequence)guid) || (zoomMessage = session.getMessageByXMPPGuid(guid)) == null || zoomMessage.getServerSideTime() <= 0L || zoomMessage.getServerSideTime() != this.mAnchorMessageInfo.getServerTime()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean Indicate_MarkUnreadContext(String reqID, int result, String session, List<String> msgGuids) {
        if (this.mMessageContextReqId != null && StringUtil.isSameString((String)reqID, (String)this.mMessageContextReqId)) {
            this.mMessageContextReqId = null;
            this.loadContextMsg(msgGuids);
            if (msgGuids != null && msgGuids.size() != 0) {
                if (this.mMsgContextGUIDS == null) {
                    this.mMsgContextGUIDS = new ArrayList();
                }
                for (String id2 : msgGuids) {
                    if (this.mMsgContextGUIDS.contains(id2)) continue;
                    this.mMsgContextGUIDS.add(id2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean Indicate_MessageContext(int result, String reqID, String session, List<String> msgGuids) {
        if (this.mMessageContextReqId != null && StringUtil.isSameString((String)reqID, (String)this.mMessageContextReqId)) {
            this.mMessageContextReqId = null;
            if (msgGuids == null || msgGuids.size() == 0) {
                this.notifyRefreshDone();
                if (result == 100000200) {
                    this.insertTimedChatMsg();
                    this.setPullDownRefreshEnabled(false);
                }
            }
            this.loadContextMsg(msgGuids);
            if (msgGuids == null || msgGuids.size() == 0) {
                if (this.mSearchMessageContextType == 3) {
                    this.mIsMsgContextBackHasMore = false;
                } else if (this.mSearchMessageContextType == 2) {
                    this.mIsMsgContextForwardHasMore = false;
                }
            } else {
                if (this.mMsgContextGUIDS == null) {
                    this.mMsgContextGUIDS = new ArrayList();
                }
                boolean isAllLoaded = true;
                for (String id2 : msgGuids) {
                    if (this.mMsgContextGUIDS.contains(id2)) continue;
                    this.mMsgContextGUIDS.add(id2);
                    isAllLoaded = false;
                }
                if (isAllLoaded) {
                    if (this.mSearchMessageContextType == 3) {
                        this.mIsMsgContextBackHasMore = false;
                    } else if (this.mSearchMessageContextType == 2) {
                        this.mIsMsgContextForwardHasMore = false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void FT_OnDownloadByMsgIDTimeOut(String sessionID, String messageID) {
        if (!StringUtil.isSameString((String)sessionID, (String)this.mSessionId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionID);
        if (session == null) {
            return;
        }
        ZoomMessage msg = session.getMessageById(messageID);
        if (msg == null) {
            return;
        }
        this.updateMessage(msg);
    }

    public void FT_UploadFileInChatTimeOut(String sessionID, String messageID) {
        if (!StringUtil.isSameString((String)sessionID, (String)this.mSessionId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionID);
        if (session == null) {
            return;
        }
        ZoomMessage msg = session.getMessageById(messageID);
        if (msg == null) {
            return;
        }
        this.updateMessage(msg);
    }

    public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
        if (result != 0) {
            return;
        }
        List<MMMessageItem> items = this.mAdapter.getItemsByFileId(webFileID);
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        for (MMMessageItem item : items) {
            ZoomFile file = mgr.getFileWithWebFileID(webFileID);
            if (file == null) {
                return;
            }
            item.isFileDownloaded = true;
            item.localFilePath = file.getLocalPath();
            item.isPreviewDownloadFailed = false;
            item.transferInfo = new ZoomMessage.FileTransferInfo();
            item.transferInfo.state = 13;
            mgr.destroyFileObject(file);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void Indicate_DownloadFileByUrlIml(String reqID, int result) {
        if (result != 0) {
            return;
        }
    }

    public void Indicate_SendAddonCommandResultIml(String msgID, boolean result) {
        if (TextUtils.isEmpty((CharSequence)msgID)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage message = session.getMessageById(msgID);
        if (message == null) {
            return;
        }
        this.updateMessage(message);
    }

    public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
        if (StringUtil.isSameString((String)sessionId, (String)this.mSessionId)) {
            ZoomMessage message;
            if (actionType != 1 && actionType != 2) {
                if (actionType == 3) {
                    this.mAdapter.notifyDataSetChanged();
                }
                return;
            }
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            if (session == null) {
                return;
            }
            this.mAdapter.removeItemByFileId(fileId);
            if (!StringUtil.isEmptyOrNull((String)msgId) && (message = session.getMessageById(msgId)) != null) {
                this.addMessageToListAdapter(message, messenger, true, this.mIsGroup, false, PTApp.getInstance().getZoomFileContentMgr());
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void indicate_HistoryMessageArrived(int result, String reqId, List<String> msgIds, boolean isFirstSync, String sessionId) {
        if (TextUtils.equals((CharSequence)reqId, (CharSequence)this.mPendingSyncRepId)) {
            this.mPendingSyncRepId = null;
        }
        if (!TextUtils.equals((CharSequence)sessionId, (CharSequence)this.mSessionId)) {
            return;
        }
        this.mIsHistorySyncing = false;
        boolean isBackgroundLoad = TextUtils.equals((CharSequence)reqId, (CharSequence)this.mBackgroundSyncReqId);
        if (isBackgroundLoad) {
            this.mBackgroundSyncReqId = null;
            return;
        }
        this.mBackgroundSyncReqId = null;
        if (result != 0) {
            if (isFirstSync) {
                if (this.mIsReloadWhenFirstFailed) {
                    this.showRefreshing(false);
                    this.mIsHistorySyncing = false;
                    return;
                }
                this.loadMessages(this.mGroupId, this.mBuddyId, this.mIMAddrBookItem, false);
                this.mIsReloadWhenFirstFailed = true;
            } else {
                this.showRefreshing(false);
                if (!CollectionsUtil.isListEmpty(this.mLocalDirtyMsgs)) {
                    this.addSyncMessagesIntoAdapter(this.mLocalDirtyMsgs, false);
                }
            }
        } else {
            this.showRefreshing(false);
            if (CollectionsUtil.isListEmpty(msgIds) && this.mAutoLoadMoreTimes < 2) {
                this.loadMore();
                ++this.mAutoLoadMoreTimes;
                return;
            }
            if (CollectionsUtil.isListEmpty(msgIds)) {
                return;
            }
            this.addSyncMessagesIntoAdapter(msgIds, isFirstSync);
        }
        this.mLocalDirtyMsgs = null;
    }

    public void cancelPendingSyncRequest() {
        if (StringUtil.isEmptyOrNull((String)this.mPendingSyncRepId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        session.cancelSearchHistoryMessageRequest(this.mPendingSyncRepId);
        this.mPendingSyncRepId = null;
    }

    private void loadContextMsg(List<String> msgGuids) {
        if (msgGuids == null || msgGuids.size() == 0) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        if (myJid == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        if (this.mAnchorMessageInfo == null) {
            return;
        }
        String anchorMsgId = null;
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        for (String guid : msgGuids) {
            boolean isOutMessage;
            MMMessageItem item;
            ZoomMessage message = session.getMessageByXMPPGuid(guid);
            if (message == null || (item = MMMessageItem.initWithZoomMessage(message, this.mSessionId, messenger, this.mIsGroup, isOutMessage = StringUtil.isSameString((String)message.getSenderID(), (String)myJid), this.getContext(), this.mIMAddrBookItem, mgr)) == null) continue;
            if (StringUtil.isSameString((String)guid, (String)this.mAnchorMessageInfo.getMsgGuid())) {
                anchorMsgId = item.messageId;
            }
            session.checkAutoDownloadForMessage(message.getMessageID());
            this.mAdapter.insertMessageSortByTime(item);
        }
        this.mAdapter.notifyDataSetChanged();
        if (!StringUtil.isEmptyOrNull(anchorMsgId)) {
            this.setSelection(this.mAdapter.findItem(anchorMsgId));
        }
        this.notifyRefreshDone();
        this.mPanelLoadMoreView.setVisibility(8);
    }

    public void setAnchorMessageItem(MMContentMessageItem.MMContentMessageAnchorInfo item) {
        this.mAnchorMessageInfo = item;
    }

    public int loadMessages(String groupId, String buddyId, IMAddrBookItem abItem, boolean ignoreIfLoaded) {
        return this.loadMessages(groupId, buddyId, abItem, ignoreIfLoaded, true);
    }

    public int loadMessages(String groupId, String buddyId, IMAddrBookItem abItem, boolean ignoreIfLoaded, boolean containsLocalMsg) {
        if (this.mLoaded && ignoreIfLoaded) {
            return 0;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) && StringUtil.isEmptyOrNull((String)buddyId)) {
            return 0;
        }
        if (this.mIsHistorySyncing) {
            return 0;
        }
        this.mGroupId = groupId;
        this.mBuddyId = buddyId;
        this.mIsGroup = !StringUtil.isEmptyOrNull((String)this.mGroupId);
        this.mSessionId = this.mIsGroup ? this.mGroupId : this.mBuddyId;
        this.mIMAddrBookItem = abItem;
        String sessionId = this.mGroupId;
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            sessionId = this.mBuddyId;
        }
        this.mAdapter.setSessionId(sessionId);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return 0;
        }
        if (this.mAnchorMessageInfo != null) {
            if (this.mMsgContextGUIDS != null && this.mMsgContextGUIDS.size() > 0) {
                this.loadContextMsg(this.mMsgContextGUIDS);
                this.mParentFragment.onMessageContextLoadSuccess();
            } else if (this.mAnchorMessageInfo.getmType() == 0) {
                this.mMessageContextReqId = messenger.microServiceSearchHistoryMessage(this.mSessionId, this.mAnchorMessageInfo.getSendTime(), 50, 1);
                this.mSearchMessageContextType = 1;
                if (StringUtil.isEmptyOrNull((String)this.mMessageContextReqId) && this.mParentFragment != null) {
                    this.mParentFragment.onMessageContextLoadFailed();
                }
            } else if (this.mAnchorMessageInfo.getmType() == 1) {
                ZoomChatSession session = messenger.getSessionById(this.mSessionId);
                if (session == null) {
                    return 0;
                }
                this.mMessageContextReqId = session.searchMarkUnreadMessageCtx(this.mAnchorMessageInfo.getServerTime(), 1, 20);
                this.mSearchMarkUnreadContextType = 1;
                if (StringUtil.isEmptyOrNull((String)this.mMessageContextReqId) && this.mParentFragment != null) {
                    this.mParentFragment.onMessageContextLoadFailed();
                }
            }
            return 0;
        }
        ZoomChatSession session = null;
        if (!StringUtil.isEmptyOrNull((String)groupId)) {
            session = messenger.getSessionById(groupId);
        } else if (!StringUtil.isEmptyOrNull((String)buddyId)) {
            session = messenger.getSessionById(buddyId);
        }
        this.mEarliestNoDirtyMsgId = null;
        this.setPullDownRefreshEnabled(true);
        if (session == null) {
            return 0;
        }
        int count = 13;
        if (this.mUnreadMsgCount > 30) {
            count = 30;
        } else if (this.mUnreadMsgCount > 13) {
            count = this.mUnreadMsgCount;
        }
        PTAppProtos.SyncHistoryMsgInfo info = session.getNewestPageRequest(count);
        if (info == null) {
            return 0;
        }
        this.mAutoLoadMoreTimes = 0;
        boolean ready = info.getIsReady();
        List<String> msgIds = info.getMsgIdsList();
        if (!ready && messenger.isConnectionGood()) {
            this.showRefreshing(true);
            this.mIsHistorySyncing = true;
            this.mPendingSyncRepId = info.getReqId();
            this.mHander.removeCallbacks(this.mSyncMsgTimeOutRunnable);
            this.mHander.postDelayed(this.mSyncMsgTimeOutRunnable, (long)this.SyncMsgTimeOut);
        }
        if (ready) {
            this.mPendingSyncRepId = null;
            this.showRefreshing(false);
            this.mIsHistorySyncing = false;
        }
        if (CollectionsUtil.isCollectionEmpty(msgIds) || !containsLocalMsg) {
            return 0;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return 0;
        }
        String myJid = myself.getJid();
        if (myJid == null) {
            return 0;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        for (String messageId : msgIds) {
            Resources res;
            ZoomMessage message = session.getMessageById(messageId);
            if (message == null) continue;
            boolean isOutMessage = StringUtil.isSameString((String)message.getSenderID(), (String)myJid);
            MMMessageItem item = this.addMessageToListAdapter(message, messenger, isOutMessage, this.mIsGroup, false, mgr);
            session.checkAutoDownloadForMessage(message.getMessageID());
            if (item != null && item.messageType == 25 && (res = this.getResources()) != null) {
                this.addE2ESystemMsg(res.getString(R.string.zm_msg_e2e_state_ready, new Object[]{this.mParentFragment.getBuddyName()}), this.mSessionId, "E2E_SYSTEM_STATE_READY_MSG_ID", item.messageTime);
            }
            if (this.mLatestReadMsgXmppId == null || !TextUtils.equals((CharSequence)this.mLatestReadMsgXmppId, (CharSequence)message.getMessageXMPPGuid())) continue;
            MMMessageItem newMark = MMMessageItem.createNewMsgsMark();
            newMark.messageTime = message.getStamp();
            newMark.messageXMPPId = MSGID_NEW_MSG_MARK;
            this.mAdapter.addItem(newMark);
        }
        this.mLoaded = true;
        if (!this.mParentFragment.isResumed()) {
            this.mHasNewMessageDuringPaused = true;
        }
        return msgIds.size();
    }

    public void checkE2ETimeoutMsg() {
        this.mAdapter.checkE2ETimeoutMsg();
    }

    public MMMessageItem findMessageById(String messageId) {
        return this.mAdapter.getItemByMessageId(messageId);
    }

    public MMMessageItem findMessageByXmppId(String Xmppid) {
        return this.mAdapter.findRealItemByXmppId(Xmppid);
    }

    public MMMessageItem findMessageByServerTime(long serverTime) {
        return this.mAdapter.getItemByServerSideTime(serverTime);
    }

    public int getItemIndexByServerTime(long serverTime) {
        return this.mAdapter.findItem(serverTime);
    }

    private void loadMore() {
        this.loadMore(0, false);
    }

    private void loadMoreMessageContext(boolean isForward) {
        if (!StringUtil.isEmptyOrNull((String)this.mMessageContextReqId)) {
            this.notifyRefreshDone();
            return;
        }
        if (this.mAnchorMessageInfo == null || this.mAdapter == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        long stamp = 0L;
        stamp = isForward ? this.mAdapter.getLatestMessageStamp() : this.mAdapter.getEarliestMessageStamp();
        this.mSearchMessageContextType = isForward ? 2 : 3;
        this.mMessageContextReqId = messenger.microServiceSearchHistoryMessage(this.mSessionId, stamp, 50, this.mSearchMessageContextType);
    }

    private void loadMore(int count, boolean backgroundLoad) {
        if (StringUtil.isEmptyOrNull((String)this.mGroupId) && StringUtil.isEmptyOrNull((String)this.mBuddyId)) {
            return;
        }
        if (this.mIsHistorySyncing) {
            if (this.mBackgroundSyncReqId != null) {
                this.mPendingSyncRepId = this.mBackgroundSyncReqId;
                this.mBackgroundSyncReqId = null;
                this.showRefreshing(true);
                this.setPullDownRefreshEnabled(true);
            }
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = null;
        if (!StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            session = messenger.getSessionById(this.mGroupId);
        } else if (!StringUtil.isEmptyOrNull((String)this.mBuddyId)) {
            session = messenger.getSessionById(this.mBuddyId);
        }
        if (session == null) {
            return;
        }
        boolean isConnectGood = messenger.isConnectionGood();
        if (!session.containMoreMessages()) {
            this.insertTimedChatMsg();
            this.setPullDownRefreshEnabled(false);
            return;
        }
        String startMsgId = this.mEarliestNoDirtyMsgId;
        if (TextUtils.isEmpty((CharSequence)startMsgId)) {
            startMsgId = this.mAdapter.getEarliestMessageId();
        }
        if (TextUtils.isEmpty((CharSequence)startMsgId)) {
            if (session.containMoreMessages()) {
                session.clearSyncedFlag();
                this.loadMessages(this.mGroupId, this.mBuddyId, this.mIMAddrBookItem, false, false);
            } else {
                this.setPullDownRefreshEnabled(false);
            }
            return;
        }
        PTAppProtos.SyncHistoryMsgInfo info = session.getPrevPageRequest(startMsgId, count = count <= 0 ? 13 : count);
        if (info == null) {
            return;
        }
        boolean isReady = info.getIsReady();
        List<String> msgIds = info.getMsgIdsList();
        if (!isConnectGood || isReady) {
            this.mEarliestNoDirtyMsgId = null;
            if (CollectionsUtil.isCollectionEmpty(msgIds)) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            String myJid = myself.getJid();
            if (myJid == null) {
                return;
            }
            String earliestMsgId = null;
            long timestamp = 0L;
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            for (int i = msgIds.size() - 1; i >= 0; --i) {
                Resources res;
                String msgId = msgIds.get(i);
                ZoomMessage message = session.getMessageById(msgId);
                if (message == null) continue;
                if (TextUtils.isEmpty(earliestMsgId) || message.getServerSideTime() < timestamp) {
                    earliestMsgId = msgId;
                    timestamp = message.getServerSideTime();
                }
                session.checkAutoDownloadForMessage(message.getMessageID());
                boolean isOutMessage = StringUtil.isSameString((String)message.getSenderID(), (String)myJid);
                MMMessageItem item = this.addMessageToListAdapter(message, messenger, isOutMessage, this.mIsGroup, false, mgr);
                message.setAsReaded(true);
                if (item != null && item.messageType == 25 && (res = this.getResources()) != null) {
                    this.addE2ESystemMsg(res.getString(R.string.zm_msg_e2e_state_ready, new Object[]{this.mParentFragment.getBuddyName()}), this.mSessionId, "E2E_SYSTEM_STATE_READY_MSG_ID", item.messageTime);
                }
                if (this.mLatestReadMsgXmppId == null || !TextUtils.equals((CharSequence)this.mLatestReadMsgXmppId, (CharSequence)message.getMessageXMPPGuid())) continue;
                this.mAdapter.removeItemByXMPPGuid(MSGID_NEW_MSG_MARK);
                MMMessageItem newMark = MMMessageItem.createNewMsgsMark();
                newMark.messageTime = message.getStamp();
                newMark.messageXMPPId = MSGID_NEW_MSG_MARK;
                this.mAdapter.insertMessageSortByTime(newMark);
            }
            if (isReady) {
                this.mEarliestNoDirtyMsgId = earliestMsgId;
            }
            this.mAdapter.notifyDataSetChanged();
        } else if (!isReady) {
            this.mLocalDirtyMsgs = info.getMsgIdsList();
            this.mIsHistorySyncing = true;
            if (backgroundLoad) {
                this.mBackgroundSyncReqId = info.getReqId();
            } else {
                this.showRefreshing(true);
                this.setPullDownRefreshEnabled(true);
                this.mPendingSyncRepId = info.getReqId();
            }
            this.mHander.removeCallbacks(this.mSyncMsgTimeOutRunnable);
            this.mHander.postDelayed(this.mSyncMsgTimeOutRunnable, (long)this.SyncMsgTimeOut);
        }
    }

    private void addSyncMessagesIntoAdapter(List<String> msgIds, boolean isFirstSync) {
        if (CollectionsUtil.isCollectionEmpty(msgIds)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = null;
        if (!StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            session = messenger.getSessionById(this.mGroupId);
        } else if (!StringUtil.isEmptyOrNull((String)this.mBuddyId)) {
            session = messenger.getSessionById(this.mBuddyId);
        }
        if (session == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        if (myJid == null) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        boolean clearAll = isFirstSync && session.isAnyNewMessagesForreload();
        final int oldCount = this.mAdapter.getCount();
        if (clearAll) {
            this.mEarliestNoDirtyMsgId = null;
            this.mAdapter.removeUnincludeMsg(msgIds);
            this.setPullDownRefreshEnabled(true);
        }
        String earliestMsgId = null;
        long timestamp = 0L;
        for (int i = msgIds.size() - 1; i >= 0; --i) {
            String msgId = msgIds.get(i);
            ZoomMessage message = session.getMessageById(msgId);
            if (message == null) continue;
            if (TextUtils.isEmpty(earliestMsgId) || message.getServerSideTime() < timestamp) {
                earliestMsgId = msgId;
                timestamp = message.getServerSideTime();
            }
            session.checkAutoDownloadForMessage(message.getMessageID());
            boolean isOutMessage = StringUtil.isSameString((String)message.getSenderID(), (String)myJid);
            boolean isInCache = this.mAdapter != null && this.mAdapter.findItem(message.getMessageID()) != -1;
            MMMessageItem item = this.addMessageToListAdapter(message, messenger, isOutMessage, this.mIsGroup, false, mgr);
            message.setAsReaded(true);
            if (item != null) {
                Resources res;
                if (!isInCache) {
                    item.isFirstSync = true;
                }
                if (item.messageType == 25 && (res = this.getResources()) != null) {
                    this.addE2ESystemMsg(res.getString(R.string.zm_msg_e2e_state_ready, new Object[]{this.mParentFragment.getBuddyName()}), this.mSessionId, "E2E_SYSTEM_STATE_READY_MSG_ID", item.messageTime);
                }
            }
            if (this.mLatestReadMsgXmppId == null || !TextUtils.equals((CharSequence)this.mLatestReadMsgXmppId, (CharSequence)message.getMessageXMPPGuid())) continue;
            this.mAdapter.removeItemByXMPPGuid(MSGID_NEW_MSG_MARK);
            MMMessageItem newMark = MMMessageItem.createNewMsgsMark();
            newMark.messageTime = message.getStamp();
            newMark.messageXMPPId = MSGID_NEW_MSG_MARK;
            this.mAdapter.insertMessageSortByTime(newMark);
        }
        this.mAdapter.removeOldMsg(timestamp);
        this.mAdapter.notifyDataSetChanged();
        this.mEarliestNoDirtyMsgId = earliestMsgId;
        if (!session.containMoreMessages()) {
            this.insertTimedChatMsg();
            this.setPullDownRefreshEnabled(false);
        }
        if (clearAll) {
            this.scrollToBottom(true);
            this.setSelection(this.getCount() - 1);
        } else if (this.mParentFragment.isResumed()) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    int curCount = MMMessageListView.this.mAdapter.getCount();
                    if (curCount > oldCount) {
                        MMMessageListView.this.setSelectionFromTop(curCount - oldCount, 0);
                    }
                }
            });
        }
    }

    private boolean isBuddyWithPhoneNumberInSession(String phoneNumber) {
        if (phoneNumber == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        if (this.mIsGroup) {
            ZoomGroup group = messenger.getGroupById(this.mSessionId);
            if (group == null) {
                return false;
            }
            int count = group.getBuddyCount();
            for (int i = 0; i < count; ++i) {
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null || !StringUtil.isSameString((String)phoneNumber, (String)buddy.getPhoneNumber())) continue;
                return true;
            }
        } else {
            ZoomBuddy buddy = messenger.getBuddyWithPhoneNumber(phoneNumber);
            if (buddy == null) {
                return false;
            }
            return StringUtil.isSameString((String)phoneNumber, (String)buddy.getPhoneNumber());
        }
        return false;
    }

    public void e2eMessageStateUpdate(String sessionID, String messageID, int e2eSessionState) {
        boolean res = this.mAdapter.updateE2EPendingMessageState(sessionID, messageID, e2eSessionState);
        if (!res) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            if (session == null) {
                return;
            }
            ZoomMessage zoomMessage = session.getMessageById(messageID);
            if (zoomMessage == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            String myJid = myself.getJid();
            if (myJid == null) {
                return;
            }
            MMMessageItem item = this.mAdapter.getItemByMessageId(messageID);
            if (item != null && item.isE2E) {
                this.updateMessage(zoomMessage);
            }
        }
    }

    private boolean isBuddyWithJIDInSession(String jid) {
        if (jid == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        if (this.mIsGroup) {
            ZoomGroup group = messenger.getGroupById(this.mSessionId);
            if (group == null) {
                return false;
            }
            int count = group.getBuddyCount();
            for (int i = 0; i < count; ++i) {
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null || !StringUtil.isSameString((String)jid, (String)buddy.getJid())) continue;
                return true;
            }
        } else {
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null) {
                return false;
            }
            return StringUtil.isSameString((String)jid, (String)buddy.getJid());
        }
        return false;
    }

    public void onIndicateBuddyInfoUpdated(String phoneNumber) {
        if (!this.isBuddyWithPhoneNumberInSession(phoneNumber)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithPhoneNumber(phoneNumber);
        if (buddy == null) {
            return;
        }
        String jid = buddy.getJid();
        int count = this.mAdapter.getMessageItemsCount();
        for (int i = 0; i < count; ++i) {
            MMMessageItem item = this.mAdapter.getMessageItem(i);
            if (item == null || !StringUtil.isSameString((String)item.fromJid, (String)jid)) continue;
            item.fromScreenName = BuddyNameUtil.getBuddyDisplayName(buddy, item.isIncomingMessage() ? this.mIMAddrBookItem : null);
        }
        if (this.mParentFragment.isResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mHander != null && this.mAutoMarkReadRunnable != null) {
            this.mHander.removeCallbacks(this.mAutoMarkReadRunnable);
        }
    }

    public boolean isMessageItemVisiable(String messageId) {
        if (StringUtil.isEmptyOrNull((String)messageId)) {
            return false;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            MMMessageItem item;
            View child = this.getChildAt(i);
            if (!(child instanceof MMMessageView) || (item = ((MMMessageView)child).getMessageItem()) == null || !StringUtil.isSameString((String)messageId, (String)item.messageId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVisiableMessageDecryptedTimeout() {
        if (!this.mIsE2EChat) {
            return false;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            MMMessageItem item;
            View child = this.getChildAt(i);
            if (!(child instanceof MMMessageView) || (item = ((MMMessageView)child).getMessageItem()) == null || !item.isMessageE2EWaitDecrypt()) continue;
            return true;
        }
        return false;
    }

    public boolean isAllVisiableMessageDecrypted() {
        if (!this.mIsE2EChat) {
            return true;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return false;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean isDecoded;
            MMMessageItem item;
            View child = this.getChildAt(i);
            if (!(child instanceof MMMessageView) || (item = ((MMMessageView)child).getMessageItem()) == null || !item.isE2E) continue;
            ZoomMessage msg = session.getMessageById(item.messageId);
            if (msg == null) {
                return false;
            }
            int state = msg.getMessageState();
            boolean bl = isDecoded = state == 7 || state == 4 || state == 1 || state == 2;
            if (isDecoded) continue;
            return false;
        }
        return true;
    }

    public boolean tryDecryptVisiableE2EMesssage() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        boolean hasTimeout = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            MMMessageItem item;
            View child = this.getChildAt(i);
            if (!(child instanceof MMMessageView) || (item = ((MMMessageView)child).getMessageItem()) == null || !item.isMessageE2EWaitDecrypt()) continue;
            hasTimeout = true;
            messenger.e2eTryDecodeMessage(this.mSessionId, item.messageId);
        }
        return hasTimeout;
    }

    private void checkMessageAtMe(MMMessageItem message) {
        List<String> atList;
        if (this.mIsGroup && message != null && message.isUnread && (atList = message.atList) != null && atList.size() > 0) {
            if (!message.isIncomingMessage() || !message.isUnread) {
                return;
            }
            if (message.isAtEveryone || message.isMsgAtMe) {
                this.mParentFragment.addAtListHintMsg(message);
            }
        }
    }

    public void onIndicateInfoUpdatedWithJID(String jid) {
        if (!this.isBuddyWithJIDInSession(jid)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        int count = this.mAdapter.getMessageItemsCount();
        for (int i = 0; i < count; ++i) {
            MMMessageItem item = this.mAdapter.getMessageItem(i);
            if (item == null || !StringUtil.isSameString((String)item.fromJid, (String)jid)) continue;
            item.fromScreenName = BuddyNameUtil.getBuddyDisplayName(buddy, item.isIncomingMessage() ? this.mIMAddrBookItem : null);
        }
        if (this.mParentFragment.isResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private MMMessageItem addLinkPreview(MMMessageItem item) {
        MMMessageItem mmMessageItem;
        block10: {
            if (item == null) {
                return null;
            }
            mmMessageItem = item;
            int itemType = mmMessageItem.messageType;
            if (itemType != 34 && itemType != 35) break block10;
            List<LinkPreviewMetaInfo> list = mmMessageItem.linkPreviewMetaInfos;
            long itemTime = mmMessageItem.messageTime;
            if (!this.messageIds.contains(mmMessageItem.messageXMPPId)) {
                this.messageIds.add(mmMessageItem.messageXMPPId);
                Iterator<LinkPreviewMetaInfo> iter = list.iterator();
                while (iter.hasNext()) {
                    LinkPreviewMetaInfo linkPreviewMetaInfo = iter.next();
                    String listItemUrl = linkPreviewMetaInfo.getUrl();
                    if (this.urlAndTimes.containsKey(listItemUrl = this.getUrlWithourSlash(listItemUrl))) {
                        long cacheItemTime = this.urlAndTimes.get(listItemUrl).getTime();
                        if (itemTime - cacheItemTime > 3600000L) {
                            this.urlAndTimes.put(listItemUrl, new Entry(itemTime, mmMessageItem.messageXMPPId));
                            continue;
                        }
                        iter.remove();
                        continue;
                    }
                    this.urlAndTimes.put(listItemUrl, new Entry(itemTime, mmMessageItem.messageXMPPId));
                }
            } else {
                HashSet<String> set = new HashSet<String>();
                for (int j = list.size() - 1; j >= 0; --j) {
                    LinkPreviewMetaInfo linkPreviewMetaInfo = list.get(j);
                    String temp = this.getUrlWithourSlash(linkPreviewMetaInfo.getUrl());
                    if (this.urlAndTimes.containsKey(temp)) {
                        if (!mmMessageItem.messageXMPPId.equals(this.urlAndTimes.get(temp).getXmppId())) {
                            list.remove(j);
                            continue;
                        }
                        if (!set.contains(temp)) {
                            set.add(temp);
                            continue;
                        }
                        list.remove(j);
                        continue;
                    }
                    this.urlAndTimes.put(temp, new Entry(itemTime, mmMessageItem.messageXMPPId));
                }
            }
        }
        return mmMessageItem;
    }

    private String getUrlWithourSlash(String url) {
        if (this.isZoomURL(url)) {
            url = ZMWebUtil.getDefaultWebDomain();
        }
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    private void deleteLinkPreview(String recallMsgXmppId) {
        this.messageIds.remove(recallMsgXmppId);
        Iterator<Map.Entry<String, Entry>> map1it = this.urlAndTimes.entrySet().iterator();
        while (map1it.hasNext()) {
            Map.Entry<String, Entry> entry = map1it.next();
            if (!entry.getValue().getXmppId().equals(recallMsgXmppId)) continue;
            map1it.remove();
        }
    }

    private void editLinkPreview(MMMessageItem mmMessageItem) {
        String messageID = "";
        if (mmMessageItem != null) {
            messageID = mmMessageItem.messageId;
            this.deleteLinkPreview(messageID);
            this.addLinkPreview(mmMessageItem);
        }
    }

    public void onReceivedMessage(ZoomMessage message) {
        Resources res;
        if (this.mAnchorMessageInfo != null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        if (myJid == null) {
            return;
        }
        boolean isOutMessage = StringUtil.isSameString((String)message.getSenderID(), (String)myJid);
        MMMessageItem item = this.addMessageToListAdapter(message, messenger, isOutMessage, this.mIsGroup, false, PTApp.getInstance().getZoomFileContentMgr());
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session != null) {
            session.checkAutoDownloadForMessage(message.getMessageID());
        }
        if (item != null && item.messageType == 25 && (res = this.getResources()) != null) {
            this.addE2ESystemMsg(res.getString(R.string.zm_msg_e2e_state_ready, new Object[]{this.mParentFragment.getBuddyName()}), this.mSessionId, "E2E_SYSTEM_STATE_READY_MSG_ID", item.messageTime);
        }
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
            if (this.mAdapter.isLastItem(message.getMessageID())) {
                this.scrollToBottom(false);
            }
            if (!message.isHistorySyncMessage()) {
                NotificationMgr.playNotificationVibrate(this.getContext());
            }
        } else {
            this.mHasNewMessageDuringPaused = true;
        }
    }

    public void NotifyOutdatedHistoryRemoved(long erasetime) {
        this.mAdapter.removeHistory(erasetime);
        this.insertTimedChatMsg();
    }

    public void insertTimedChatMsg() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        PTAppProtos.LocalStorageTimeInterval interval = messenger.getLocalStorageTimeInterval();
        if (interval != null) {
            ZMLog.i((String)TAG, (String)"year:%d,month:%d,day:%d", (Object[])new Object[]{interval.getYear(), interval.getMonth(), interval.getDay()});
            MMMessageItem item = new MMMessageItem();
            item.messageId = "TIMED_CHAT_MSG_ID";
            item.messageType = 39;
            item.message = this.getContext().getResources().getString(R.string.zm_mm_msg_remove_history_message_33479, new Object[]{this.mParentFragment.timecChatTimeInterval});
            this.mAdapter.addItemAtFirst(item);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onGiphyMessageSended(String msgID) {
        if (!TextUtils.isEmpty((CharSequence)msgID)) {
            this.mAdapter.removeItem(msgID);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void updateVisibleMessageState() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            MMMessageView itemView;
            MMMessageItem item;
            View children = this.getChildAt(i);
            if (!(children instanceof MMMessageView) || (item = (itemView = (MMMessageView)children).getMessageItem()) == null) continue;
            this.updateMessage(session.getMessageByXMPPGuid(item.messageXMPPId));
        }
    }

    public MMMessageItem updateMessage(ZoomMessage message) {
        if (message == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return null;
        }
        String myJid = myself.getJid();
        if (myJid == null) {
            return null;
        }
        boolean isOutMessage = StringUtil.isSameString((String)message.getSenderID(), (String)myJid);
        MMMessageItem item = this.addMessageToListAdapter(message, messenger, isOutMessage, this.mIsGroup, true, PTApp.getInstance().getZoomFileContentMgr());
        this.editLinkPreview(item);
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        } else {
            this.mHasNewMessageDuringPaused = true;
        }
        return item;
    }

    public void updateMessagePreviewStatus(String messageId, boolean isFailed) {
        if (StringUtil.isEmptyOrNull((String)messageId)) {
            return;
        }
        MMMessageItem item = this.mAdapter.getItemByMessageId(messageId);
        if (item != null) {
            item.isPreviewDownloadFailed = isFailed;
        }
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public boolean playAudioMessage(MMMessageItem message) {
        if (message == null) {
            return false;
        }
        if (this.mPlayingMessage != null) {
            this.stopPlayAudioMessage();
        }
        this.mMediaPlayer = new MediaPlayer();
        this.mPlayingMessage = message;
        try {
            this.mbVolumeChanged = false;
            this.mOldVolume = -1;
            this.mVolumeChangedTo = -1;
            this.startMonitorProximity();
            this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    try {
                        mp.stop();
                        mp.release();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MMMessageListView.this.mMediaPlayer = null;
                    if (MMMessageListView.this.mPlayingMessage != null) {
                        ((MMMessageListView)MMMessageListView.this).mPlayingMessage.isPlaying = false;
                        MMMessageListView.this.mPlayingMessage = null;
                    }
                    MMMessageListView.this.notifyDataSetChanged();
                    MMMessageListView.this.stopMonitorProximity();
                    MMMessageListView.this.restoreVolume();
                }
            });
            this.mMediaPlayer.setDataSource(new FileInputStream(message.localFilePath).getFD());
            this.mMediaPlayer.prepare();
            this.mMediaPlayer.start();
            message.isPlaying = true;
            this.setMessageAsPlayed(message);
            this.notifyDataSetChanged();
            AudioManager audiomanger = (AudioManager)this.getContext().getSystemService("audio");
            if (audiomanger != null) {
                this.mOldVolume = audiomanger.getStreamVolume(3);
                int max = audiomanger.getStreamMaxVolume(3);
                if ((double)this.mOldVolume <= (double)max * 0.6) {
                    this.mVolumeChangedTo = (int)((double)max * 0.8);
                    audiomanger.setStreamVolume(3, this.mVolumeChangedTo, 0);
                    this.mbVolumeChanged = true;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.mPlayingMessage = null;
            this.stopMonitorProximity();
            return false;
        }
    }

    private void restoreVolume() {
        try {
            int curVolume;
            AudioManager audiomanger;
            if (this.mbVolumeChanged && this.mOldVolume >= 0 && (audiomanger = (AudioManager)this.getContext().getSystemService("audio")) != null && (curVolume = audiomanger.getStreamVolume(3)) == this.mVolumeChangedTo) {
                audiomanger.setStreamVolume(3, this.mOldVolume, 0);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.mbVolumeChanged = false;
            this.mOldVolume = -1;
            this.mVolumeChangedTo = -1;
        }
    }

    private void startMonitorProximity() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        try {
            SensorManager mgr = (SensorManager)context.getSystemService("sensor");
            if (mgr == null) {
                return;
            }
            Sensor proximity = mgr.getDefaultSensor(8);
            if (proximity == null) {
                return;
            }
            mgr.registerListener((SensorEventListener)this, proximity, 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopMonitorProximity() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        try {
            SensorManager mgr = (SensorManager)context.getSystemService("sensor");
            if (mgr != null) {
                mgr.unregisterListener((SensorEventListener)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onSensorChanged(SensorEvent event) {
        if (event != null && event.sensor != null && event.sensor.getType() == 8 && event.values != null && event.values.length > 0 && !HeadsetUtil.getInstance().isWiredHeadsetOn() && !HeadsetUtil.getInstance().isBluetoothScoAudioOn()) {
            float maxRange = event.sensor.getMaximumRange();
            if ((int)maxRange > 3) {
                this.routeAudioToEarSpeaker(event.values[0] <= 3.0f);
            } else {
                this.routeAudioToEarSpeaker(event.values[0] < event.sensor.getMaximumRange());
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void routeAudioToEarSpeaker(boolean b) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (this.mMediaPlayer == null || !this.mMediaPlayer.isPlaying()) {
            return;
        }
        boolean paused = false;
        try {
            this.mMediaPlayer.pause();
            paused = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (b) {
            if (audioManager != null && audioManager.getMode() != 2) {
                audioManager.setMode(2);
            }
        } else if (audioManager != null && audioManager.getMode() != 0) {
            audioManager.setMode(0);
        }
        try {
            if (paused) {
                this.mMediaPlayer.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setMessageAsPlayed(MMMessageItem item) {
        item.isPlayed = true;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage message = session.getMessageById(item.messageId);
        if (message == null) {
            return;
        }
        message.setAsPlayed(true);
    }

    public void onMessageShowed(String msgId) {
        UnSupportMessageMgr mgr;
        MMMessageItem item;
        if (this.mParentFragment != null) {
            this.mParentFragment.onMessageShowed(msgId);
        }
        if ((item = this.mAdapter.getItemByMessageId(msgId)) != null && item.needTriggerUpdate && (mgr = PTApp.getInstance().getUnsupportMessageMgr()) != null) {
            mgr.searchUnSupportMessage(this.mSessionId, item.serverSideTime + "");
        }
    }

    public boolean stopPlayAudioMessage() {
        if (this.mPlayingMessage != null) {
            this.mPlayingMessage.isPlaying = false;
            this.mPlayingMessage = null;
        }
        if (this.mMediaPlayer == null) {
            return true;
        }
        try {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMediaPlayer = null;
        this.notifyDataSetChanged();
        this.stopMonitorProximity();
        this.restoreVolume();
        return true;
    }

    public void askToResendMessage(final MMMessageItem message) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder(context).setTitle(R.string.zm_mm_msg_resend_message_confirm).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMMessageListView.this.resendMessage(message);
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.show();
    }

    public boolean checkStoragePermission() {
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.checkStoragePermission();
    }

    public void requestStoragePermission(MMMessageItem message) {
        if (this.mParentFragment == null) {
            return;
        }
        this.mParentFragment.requestStoragePermission(message);
    }

    public void handleMessageItem(MMMessageItem message) {
        if (this.mAdapter == null || message == null) {
            return;
        }
        this.mAdapter.doMessageItem(message);
    }

    public void onClickMessageAvatar(MMMessageItem message) {
        if (!message.isIncomingMessage()) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        IMAddrBookItem contact = this.getIMAddrBookItemFromMMMessageItem(message);
        if (contact == null) {
            return;
        }
        AddrBookItemDetailsActivity.show(activity, contact, !this.mIsGroup, 0);
    }

    private IMAddrBookItem getIMAddrBookItemFromMMMessageItem(MMMessageItem message) {
        if (message == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(message.fromJid);
        if (buddy == null) {
            return null;
        }
        IMAddrBookItem contact = message.fromContact;
        if (contact == null) {
            contact = IMAddrBookItem.fromZoomBuddy(buddy);
        }
        return contact;
    }

    public boolean onLongClickMessageAvatar(MMMessageItem message) {
        return this.mParentFragment.onLongClickMessageAvatar(this.getIMAddrBookItemFromMMMessageItem(message));
    }

    private void shareMessage(MMMessageItem message) {
        this.mParentFragment.shareMessage(message.messageXMPPId);
    }

    private void resendMessage(MMMessageItem message) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        Resources res = this.getResources();
        if (res == null) {
            return;
        }
        boolean ret = false;
        ret = message.isE2E && message.messageType == 5 ? session.resendPendingE2EImageMessage(message.messageId, res.getString(R.string.zm_msg_e2e_fake_message), message.localFilePath) : session.resendPendingMessage(message.messageId, message.isE2E ? res.getString(R.string.zm_msg_e2e_fake_message) : "");
        if (ret) {
            message.messageState = 1;
            if (this.mParentFragment != null && (message.messageType == 5 || message.messageType == 28)) {
                this.mParentFragment.addUploadFileRatio(message.messageId, 0);
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void deleteLocalMessage(MMMessageItem message, ZoomChatSession session) {
        session.deleteLocalMessage(message.messageId);
        this.mAdapter.removeItem(message.messageId);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onSentMessage(ZoomMessage message, boolean updateOnly) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.addMessageToListAdapter(message, messenger, true, this.mIsGroup, updateOnly, PTApp.getInstance().getZoomFileContentMgr());
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
            if (this.mAdapter.isLastItem(message.getMessageID())) {
                this.scrollToBottom(false);
            }
        } else {
            this.mHasNewMessageDuringPaused = true;
        }
    }

    public void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage message = session.getMessageById(messageId);
        if (message == null) {
            return;
        }
        MMMessageItem item = this.updateMessage(message);
        if (item != null) {
            item.isDownloading = false;
        }
        this.mAdapter.onConfirmFileDownloaded(sessionId, messageId, result);
    }

    public void onGroupMessage(int result, ZoomMessage message) {
        if (result == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            this.addMessageToListAdapter(message, messenger, true, true, false, null);
            if (this.isParentFragmentResumed()) {
                this.mAdapter.notifyDataSetChanged();
                if (this.mAdapter.isLastItem(message.getMessageID())) {
                    this.scrollToBottom(false);
                }
            } else {
                this.mHasNewMessageDuringPaused = true;
            }
        }
    }

    public void onRecallMessage(boolean result, ZoomMessage message, String recallMsgXmppId) {
        if (result) {
            this.deleteLinkPreview(recallMsgXmppId);
            this.mAdapter.removeItemByXMPPGuid(recallMsgXmppId);
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            if (message != null) {
                this.addMessageToListAdapter(message, messenger, true, true, false, null);
            }
            if (this.isParentFragmentResumed()) {
                this.mAdapter.notifyDataSetChanged();
                if (message != null && this.mAdapter.isLastItem(message.getMessageID())) {
                    this.scrollToBottom(false);
                }
            } else {
                this.mHasNewMessageDuringPaused = true;
            }
        }
    }

    public void FT_Cancel(MMMessageItem item) {
        if (item == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            boolean sending = item.messageState == 1;
            messenger.FT_Cancel(item.sessionId, item.messageId);
            ZoomChatSession session = messenger.getSessionById(item.sessionId);
            if (session == null) {
                return;
            }
            if (sending) {
                this.deleteLocalMessage(item, session);
            } else {
                ZoomMessage message = session.getMessageById(item.messageId);
                if (message != null) {
                    this.updateMessage(message);
                }
            }
        }
    }

    public void OnLinkCrawlResult(PTAppProtos.CrawlLinkResponse resp) {
        if (resp == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage msg = session.getMessageByXMPPGuid(resp.getMsgGuid());
        if (msg == null) {
            return;
        }
        this.updateMessage(msg);
        this.scrollToBottom(false);
    }

    public void OnDownloadFavicon(int result, String req_id) {
        if (StringUtil.isEmptyOrNull((String)req_id)) {
            return;
        }
        String msgId = this.mLinkPreviewReqIds.remove(req_id);
        if (!StringUtil.isEmptyOrNull((String)msgId) && result == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            if (session == null) {
                return;
            }
            this.updateMessage(session.getMessageById(msgId));
        }
    }

    public void OnDownloadImage(int result, String req_id) {
        if (StringUtil.isEmptyOrNull((String)req_id)) {
            return;
        }
        String msgId = this.mLinkPreviewReqIds.remove(req_id);
        if (!StringUtil.isEmptyOrNull((String)msgId) && result == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            if (session == null) {
                return;
            }
            this.updateMessage(session.getMessageById(msgId));
            this.scrollToBottom(false);
        }
    }

    public void OnUnsupportMessageRecevied(int result, String reqID, String session, String msgGuids) {
        MMMessageItem item = this.mAdapter.findRealItemByXmppId(msgGuids);
        if (item != null) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession chatSession = messenger.getSessionById(session);
            if (chatSession == null) {
                return;
            }
            ZoomMessage msg = chatSession.getMessageById(msgGuids);
            if (msg == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            boolean isOutMessage = StringUtil.isSameString((String)msg.getSenderID(), (String)myself.getJid());
            MMFileContentMgr fileContentMgr = PTApp.getInstance().getZoomFileContentMgr();
            item = MMMessageItem.initWithZoomMessage(msg, this.mSessionId, messenger, this.mIsGroup, isOutMessage, this.getContext(), this.mIMAddrBookItem, fileContentMgr);
            if (item == null) {
                return;
            }
            this.addMessageToListAdapter(item, messenger, true);
        }
    }

    public void Indicate_DownloadGIFFromGiphyResultIml(int result, String reqID, String url, String localPath, String sessionID, String giphyID) {
        if (result != 0 || StringUtil.isEmptyOrNull((String)reqID)) {
            return;
        }
        String msgID = this.mGiphyReqIds.remove(reqID);
        MMMessageItem item = this.mAdapter.getItemByMessageId(msgID);
        if (item != null) {
            this.mAdapter.addOrUpdateGiphyMsg(item);
            if (this.isParentFragmentResumed()) {
                this.mAdapter.notifyDataSetChanged();
            } else {
                this.mHasNewMessageDuringPaused = true;
            }
        }
    }

    public void Indicate_GetGIFFromGiphyResultIml(int result, String reqID, String giphyID, String msgStr, String sessionID) {
        if (result != 0 || StringUtil.isEmptyOrNull((String)reqID)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        MMMessageItem item = this.addMessageToListAdapter(reqID, -1, messenger, giphyID, msgStr, true, !TextUtils.isEmpty((CharSequence)this.mGroupId), false);
        if (item == null) {
            return;
        }
        this.mAdapter.notifyDataSetChanged();
        this.scrollToBottom(true);
    }

    public void onClickAddon(MMAddonMessage.NodeMsgHref href) {
        if (this.mParentFragment != null) {
            this.mParentFragment.onClickAddon(href);
        }
    }

    public void onClickActionMore(String jid, List<MMAddonMessage.AddonNode> nodes) {
        if (this.mParentFragment != null) {
            this.mParentFragment.onClickActionMore(jid, nodes);
        }
    }

    public void onClickTemplateActionMore(View v, String jid, List<IMessageTemplateActionItem> actionItems) {
        if (this.mParentFragment != null) {
            this.mParentFragment.onClickTemplateActionMore(v, jid, actionItems);
        }
    }

    public void onClickEditTemplate(String xmppid, String eventID) {
        if (this.mParentFragment != null) {
            this.mParentFragment.editTemplateMessage(xmppid, eventID);
        }
    }

    public void onClickAction(String jid, String action) {
        if (this.mParentFragment != null) {
            this.mParentFragment.onClickAction(jid, action);
        }
    }

    public void onClickLinkPreview(MMMessageItem message, LinkPreviewMetaInfo url) {
        if (this.mParentFragment != null) {
            this.mParentFragment.onClickLinkPreview(message, url);
        }
    }

    public void onClickMeetingNO(final String no) {
        Activity activity = (Activity)this.getContext();
        if (activity == null) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ArrayList<MeetingNoMenuItem> items = new ArrayList<MeetingNoMenuItem>();
        items.add(new MeetingNoMenuItem(activity.getString(R.string.zm_btn_copy), 2));
        items.add(new MeetingNoMenuItem(activity.getString(R.string.zm_btn_join_meeting), 0));
        items.add(new MeetingNoMenuItem(activity.getString(R.string.zm_btn_call), 1));
        menuAdapter.addAll(items);
        TextView titleView = new TextView((Context)activity);
        if (Build.VERSION.SDK_INT < 23) {
            titleView.setTextAppearance((Context)activity, R.style.ZMTextView_Medium);
        } else {
            titleView.setTextAppearance(R.style.ZMTextView_Medium);
        }
        int padding = UIUtil.dip2px((Context)activity, (float)20.0f);
        titleView.setPadding(padding, padding, padding, padding / 2);
        titleView.setText((CharSequence)activity.getString(R.string.zm_msg_meetingno_hook_title, new Object[]{no}));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitleView((View)titleView).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MeetingNoMenuItem item = (MeetingNoMenuItem)((Object)menuAdapter.getItem(which));
                MMMessageListView.this.onSelectMeetingNoMenuItem(item, no);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    public void onClickSendGiphyBtn(MMMessageItem message, View view) {
        if (this.mParentFragment != null) {
            this.mParentFragment.onClickSendGiphyBtn(message, view);
        }
    }

    private void onSelectMeetingNoMenuItem(MeetingNoMenuItem item, String no) {
        if (item == null || StringUtil.isEmptyOrNull((String)no)) {
            return;
        }
        switch (item.getAction()) {
            case 1: {
                AndroidAppUtil.sendDial((Context)this.getContext(), (String)no);
                break;
            }
            case 0: {
                this.joinMeetingByNO(no);
                break;
            }
            case 2: {
                AndroidAppUtil.copyText((Context)this.getContext(), (CharSequence)no);
            }
        }
    }

    private void joinMeetingByNO(String meetingNO) {
        if (!NetworkUtil.hasDataNetwork((Context)this.getContext())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            JoinConfView.CannotJoinDialog.show(activity, message);
            return;
        }
        long confNumber = 0L;
        try {
            confNumber = Long.parseLong(meetingNO);
        }
        catch (Exception e) {
            return;
        }
        String screenName = "";
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            screenName = profile.getUserName();
        }
        ConfActivity.joinById(this.getContext(), confNumber, screenName, "", null, false, false);
    }

    public void FT_OnSent(String sessionID, String messageID, int result) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage message = session.getMessageById(messageID);
        if (message == null) {
            return;
        }
        this.updateMessage(message);
        this.mAdapter.FT_OnSent(sessionID, messageID, result);
    }

    public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        List<MMMessageItem> msgs = this.mAdapter.getItemsByFileId(webFileID);
        if (CollectionsUtil.isListEmpty(msgs)) {
            return;
        }
        ZoomMessage.FileTransferInfo info = new ZoomMessage.FileTransferInfo();
        info.bitsPerSecond = bitPerSecond;
        info.percentage = ratio;
        info.transferredSize = completeSize;
        info.state = 10;
        for (MMMessageItem item : msgs) {
            item.transferInfo = info;
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void FT_OnProgress(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage message = session.getMessageById(messageID);
        if (message == null) {
            return;
        }
        MMMessageItem item = this.updateMessage(message);
        if (item != null) {
            item.isDownloading = ratio < 100;
            item.fileRatio = ratio;
        }
        this.notifyDataSetChanged();
        this.mAdapter.FT_OnProgress(sessionID, messageID, ratio, completeSize, bitPerSecond);
    }

    public void FT_OnResumed(String sessionID, String messageID, int result) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage message = session.getMessageById(messageID);
        if (message == null) {
            return;
        }
        this.updateMessage(message);
        this.mAdapter.FT_OnResumed(sessionID, messageID, result);
    }

    public void scrollToBottom(boolean force) {
        int lastVisiblePos = this.getLastVisiblePosition();
        final int lastPos = this.getCount() - 1;
        if (force) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    MMMessageListView.this.setSelection(lastPos);
                }
            });
        } else if (lastPos - lastVisiblePos < 5) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.smoothScrollToPosition(lastPos);
            } else {
                this.setSelection(lastPos);
            }
        }
    }

    public boolean isInAutoScrollBottomMode() {
        int lastVisiblePos = this.getLastVisiblePosition();
        int lastPos = this.getCount() - 1;
        return lastPos - lastVisiblePos < 5;
    }

    public MMMessageItem addE2ESystemMsg(String msg, String sessionId, String msgId, long msgTime) {
        if (TextUtils.isEmpty((CharSequence)msg) || TextUtils.isEmpty((CharSequence)sessionId)) {
            return null;
        }
        MMMessageItem item = new MMMessageItem();
        item.sessionId = this.mSessionId;
        item.messageId = msgId;
        item.messageType = 26;
        item.messageTime = msgTime;
        item.message = msg;
        this.mAdapter.addItem(item);
        return item;
    }

    @Nullable
    private MMMessageItem addMessageToListAdapter(MMMessageItem item, ZoomMessenger messenger, boolean updateOnly) {
        if (item != null) {
            MMMessageItem oldItem;
            Integer ratio;
            if (item.messageState == 1 && this.mParentFragment != null && (ratio = this.mParentFragment.getUploadFileRatio(item.messageId)) != null) {
                item.fileRatio = ratio;
            }
            if ((oldItem = this.mAdapter.getItemByMessageId(item.messageId)) != null) {
                item.isPlaying = oldItem.isPlaying;
                boolean bl = item.isDownloading = oldItem.isDownloading && !item.isFileDownloaded;
                if (this.mPlayingMessage == oldItem) {
                    this.mPlayingMessage = item;
                }
            } else {
                if (updateOnly) {
                    return null;
                }
                if (item.isE2E && item.isMessageE2EWaitDecrypt()) {
                    int code = messenger.e2eTryDecodeMessage(this.mSessionId, item.messageId);
                    item.messageState = 3;
                    if (code == 0) {
                        ZoomMessage msg;
                        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
                        if (session != null && (msg = session.getMessageById(item.messageId)) != null) {
                            item.message = msg.getBody();
                            item.messageState = msg.getMessageState();
                        }
                    } else if (code == 37) {
                        item.messageState = 3;
                        item.message = this.getContext().getResources().getString(R.string.zm_msg_e2e_message_decrypting);
                    }
                }
            }
            if (!CollectionsUtil.isListEmpty(item.linkPreviewMetaInfos)) {
                List<String> reqIds = this.mAdapter.addOrUpdateLinkPreviewMsg(item);
                if (!CollectionsUtil.isListEmpty(reqIds)) {
                    for (String reqId : reqIds) {
                        this.mLinkPreviewReqIds.put(reqId, item.messageId);
                    }
                }
            } else {
                this.mAdapter.insertMessageSortByTime(item);
            }
            this.checkMessageAtMe(item);
            CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
            if (!helper.isEmojiInstalled()) {
                boolean hasUnSupport = false;
                if (item.isE2E) {
                    if (!item.isMessageE2EWaitDecrypt()) {
                        hasUnSupport = helper.containCommonEmoji(item.message);
                    }
                } else {
                    hasUnSupport = helper.containCommonEmoji(item.message);
                }
                if (hasUnSupport && this.mParentFragment != null) {
                    this.mParentFragment.onUnSupportEmojiReceived(item.fromJid);
                }
            }
            return item;
        }
        return null;
    }

    @Nullable
    private MMMessageItem addMessageToListAdapter(ZoomMessage message, ZoomMessenger messenger, boolean isOutMessage, boolean isGroupMessage, boolean updateOnly, MMFileContentMgr mgr) {
        MMMessageItem item = MMMessageItem.initWithZoomMessage(message, this.mSessionId, messenger, isGroupMessage, isOutMessage, this.getContext(), this.mIMAddrBookItem, mgr);
        return this.addMessageToListAdapter(this.addLinkPreview(item), messenger, updateOnly);
    }

    @Nullable
    private MMMessageItem addMessageToListAdapter(String reqID, int idx, ZoomMessenger messenger, String giphyID, String giphyStr, boolean isOutMessage, boolean isGroupMessage, boolean updateOnly) {
        MMMessageItem item = MMMessageItem.initWithZoomMessage(reqID, this.mSessionId, messenger, giphyID, giphyStr, isGroupMessage, isOutMessage);
        return this.addMessageToListAdapter(item, messenger, updateOnly);
    }

    public void scrollToMessage(String msgId) {
        int position = this.mAdapter.findItem(msgId);
        if (position != -1) {
            this.setSelection(position);
        }
    }

    public void markALlMsgReadBeforeMsgId(String msgId) {
        int position = this.mAdapter.findItem(msgId);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        for (int i = 0; i < position; ++i) {
            Object o = this.mAdapter.getItem(position);
            if (o == null || !(o instanceof MMMessageItem) || ((MMMessageItem)o).isUnread) continue;
            ZoomMessage msg = session.getMessageById(((MMMessageItem)o).messageId);
            if (msg != null) {
                msg.setAsReaded(true);
            }
            ((MMMessageItem)o).isUnread = false;
        }
    }

    protected void onPullDownRefresh() {
        if (this.mAnchorMessageInfo != null) {
            if (this.mIsMsgContextBackHasMore) {
                this.loadMoreMessageContext(false);
            }
        } else {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    int oldCount = MMMessageListView.this.mAdapter.getCount();
                    MMMessageListView.this.mAutoLoadMoreTimes = 0;
                    MMMessageListView.this.notifyRefreshDone();
                    MMMessageListView.this.loadMore();
                    if (MMMessageListView.this.mParentFragment.isResumed()) {
                        MMMessageListView.this.mAdapter.notifyDataSetChanged();
                        int curCount = MMMessageListView.this.mAdapter.getCount();
                        if (curCount > oldCount) {
                            MMMessageListView.this.setSelectionFromTop(curCount - oldCount, 0);
                        }
                    }
                }
            }, 200L);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.currentScrollState = scrollState;
        if (scrollState == 0) {
            if (this.mIsE2EChat) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                boolean hasTimeout = this.tryDecryptVisiableE2EMesssage();
                if (this.mParentFragment != null) {
                    if (hasTimeout) {
                        this.mParentFragment.showE2EMessageDecryptTimeoutHint();
                    } else {
                        this.mParentFragment.closeE2EMessageDecryptTimeoutHint();
                    }
                }
            }
            if (this.mParentFragment != null) {
                this.mParentFragment.updateBottomHint(true);
            }
        }
    }

    private void autoMarkRead() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            MMMessageView itemView;
            MMMessageItem item;
            View children = this.getChildAt(i);
            if (!(children instanceof MMMessageView) || (item = (itemView = (MMMessageView)children).getMessageItem()) == null || this.mParentFragment == null || !this.mParentFragment.isContainInOldMarkUnreads(item.serverSideTime)) continue;
            this.markAsReadMessage(item);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        ZoomChatSession session;
        ZoomMessenger messenger;
        ListAdapter adapter;
        this.mHander.removeCallbacks(this.mAutoMarkReadRunnable);
        this.mHander.postDelayed(this.mAutoMarkReadRunnable, 1000L);
        if (this.mAnchorMessageInfo != null && this.mIsMsgContextForwardHasMore && firstVisibleItem != 0 && firstVisibleItem + visibleItemCount >= totalItemCount && StringUtil.isEmptyOrNull((String)this.mMessageContextReqId)) {
            this.loadMoreMessageContext(true);
            this.mPanelLoadMoreView.setVisibility(0);
        }
        if ((adapter = this.getAdapter()) == null) {
            return;
        }
        for (int i = 0; i < visibleItemCount; ++i) {
            if (adapter.getCount() <= firstVisibleItem + i) {
                return;
            }
            Object o = adapter.getItem(firstVisibleItem + i);
            if (o == null || !(o instanceof MMMessageItem)) continue;
            MMMessageItem item = (MMMessageItem)o;
            if (!TextUtils.isEmpty((CharSequence)this.mLatestReadMsgXmppId) && item.messageType == 36) {
                if (this.mParentFragment != null) {
                    this.mParentFragment.onLastestReadMsgReached();
                }
                this.mLatestReadMsgXmppId = null;
            }
            if (!item.isUnread && !item.isAtEveryone && !item.isMsgAtMe || !item.isUnread) continue;
            this.setMessageReaded(item);
        }
        if (firstVisibleItem + visibleItemCount == totalItemCount && (messenger = PTApp.getInstance().getZoomMessenger()) != null && (session = messenger.getSessionById(this.mSessionId)) != null && session.getUnreadMessageCount() > 0) {
            session.cleanUnreadMessageCount();
            if (this.mParentFragment != null) {
                this.mParentFragment.updateBottomHint(true);
            }
        }
    }

    private void setMessageReaded(MMMessageItem item) {
        if (item == null || !item.isUnread) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (this.mSessionId == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage msg = session.getMessageById(item.messageId);
        if (msg == null) {
            return;
        }
        msg.setAsReaded(true);
        item.isUnread = false;
    }

    private boolean isZoomURL(String url) {
        return url.matches("(https?://)?zoom\\.us/?");
    }

    static class Entry {
        long time;
        String xmppId;

        public long getTime() {
            return this.time;
        }

        public String getXmppId() {
            return this.xmppId;
        }

        public Entry(long time, String xmppId) {
            this.time = time;
            this.xmppId = xmppId;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setXmppId(String xmppId) {
            this.xmppId = xmppId;
        }
    }

    static class MeetingNoMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_JOIN_MEETING = 0;
        public static final int ACTION_CALL = 1;
        public static final int ACTION_COPY = 2;

        public MeetingNoMenuItem(String label, int action) {
            super(action, label);
        }
    }

    static class MessageContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_DELETE = 0;
        public static final int ACTION_COPY = 1;
        public static final int ACTION_RESEND = 2;
        public static final int ACTION_SHARE = 4;
        public static final int ACTION_SAVE_EMOJI = 6;
        public static final int ACTION_EDIT = 8;
        public static final int ACTION_UNREAD = 9;
        public static final int ACTION_READ = 10;
        public static final int ACTION_SAVE_IMAGE = 11;
        public static final int ACTION_JOIN_MEETING = 12;
        public static final int ACTION_COPY_URL = 13;
        public static final int ACTION_LOCAL_DELETE = 14;

        public MessageContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

