/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.JoinByURLActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.util.ZMWebLinkFilter;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.TextViewFixTouchConsume;
import com.zipow.videobox.view.ZMGifView;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.LinkPreviewMetaInfo;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMMessageLinkPreviewView
extends AbsMessageView {
    private static final String TAG = MMMessageLinkPreviewView.class.getSimpleName();
    protected MMMessageItem mMessageItem;
    protected TextView mTxtMessage;
    protected AvatarView mAvatarView;
    protected TextView mTxtScreenName;
    protected TextView mTxtEditTime;
    protected TextView mNewMessage;
    protected LinearLayout mPanelMessage;
    protected LinearLayout mPanelLinkPreview;

    public MMMessageLinkPreviewView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMMessageLinkPreviewView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtMessage = (TextView)this.findViewById(R.id.txtMessage);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mTxtEditTime = (TextView)this.findViewById(R.id.txtMessage_edit_time);
        this.mPanelMessage = (LinearLayout)this.findViewById(R.id.panel_textMessage);
        this.mNewMessage = (TextView)this.findViewById(R.id.newMessage);
        this.mPanelLinkPreview = (LinearLayout)this.findViewById(R.id.panelLinkPreview);
        if (this.mPanelMessage != null) {
            this.mPanelMessage.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnShowContextMenuListener l = MMMessageLinkPreviewView.this.getOnShowContextMenuListener();
                    if (l != null) {
                        return l.onShowContextMenu(MMMessageLinkPreviewView.this.mMessageItem);
                    }
                    return false;
                }
            });
            this.mPanelMessage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickMessageListener l = MMMessageLinkPreviewView.this.getOnClickMessageListener();
                    if (l != null) {
                        l.onClickMessage(MMMessageLinkPreviewView.this.mMessageItem);
                    }
                }
            });
        }
        if (this.mAvatarView != null) {
            this.mAvatarView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickAvatarListener l = MMMessageLinkPreviewView.this.getOnClickAvatarListener();
                    if (l != null) {
                        l.onClickAvatar(MMMessageLinkPreviewView.this.mMessageItem);
                    }
                }
            });
            this.mAvatarView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnLongClickAvatarListener l = MMMessageLinkPreviewView.this.getOnLongClickAvatarListener();
                    if (l != null) {
                        return l.onLongClickAvatar(MMMessageLinkPreviewView.this.mMessageItem);
                    }
                    return false;
                }
            });
        }
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_preview_from, (ViewGroup)this);
    }

    protected int getTextColor() {
        int colorResource = -1;
        colorResource = this.mMessageItem.isE2E ? (this.mMessageItem.messageState == 9 || this.mMessageItem.messageState == 8 || this.mMessageItem.messageState == 10 ? R.color.zm_chat_msg_txt_e2e_warn : (this.mMessageItem.messageState == 3 || this.mMessageItem.messageState == 11 || this.mMessageItem.messageState == 13 ? R.color.zm_half_translucent_black : R.color.zm_text_on_light)) : R.color.zm_text_on_light;
        return this.getResources().getColor(colorResource);
    }

    public void setMessage(CharSequence message, long editTime) {
        if (message != null && this.mTxtMessage != null) {
            this.mTxtMessage.setText(message);
            this.mTxtMessage.setMovementMethod((MovementMethod)TextViewFixTouchConsume.LocalLinkMovementMethod.getInstance());
            this.mTxtMessage.setTextColor(this.getTextColor());
            this.mTxtMessage.setLinkTextColor(this.getTextColor());
            if (editTime > 0L) {
                this.mTxtEditTime.setVisibility(0);
                this.mTxtEditTime.setText((CharSequence)this.getResources().getString(R.string.zm_mm_edit_message_time_19884));
            } else {
                this.mTxtEditTime.setVisibility(8);
            }
        }
        this.hookZoomURL(this.mTxtMessage);
        ZMWebLinkFilter.filter(this.mTxtMessage);
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    public void setScreenName(String screenName) {
        if (screenName != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText((CharSequence)screenName);
        }
    }

    protected Drawable getMesageBackgroudDrawable() {
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private void updateChatMsgBackground() {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            this.mPanelMessage.setBackgroundDrawable(this.getMesageBackgroudDrawable());
        } else {
            this.mPanelMessage.setBackground(this.getMesageBackgroudDrawable());
        }
    }

    public MMMessageItem getMessageItem() {
        return this.mMessageItem;
    }

    public void setMessageItem(MMMessageItem item) {
        this.mMessageItem = item;
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(item.fromScreenName);
            this.mAvatarView.setBgColorSeedString(item.fromJid);
        }
        this.setMessage(item.message, item.editMessageTime);
        this.updateChatMsgBackground();
        LinearLayout content = (LinearLayout)this.findViewById(R.id.panelMsgLayout);
        if (item.onlyMessageShow) {
            this.mAvatarView.setVisibility(4);
            if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
            content.setPadding(content.getPaddingLeft(), 0, content.getPaddingRight(), content.getPaddingBottom());
        } else {
            content.setPadding(content.getPaddingLeft(), content.getPaddingBottom(), content.getPaddingRight(), content.getPaddingBottom());
            this.mAvatarView.setVisibility(0);
            if (this.mTxtScreenName != null && item.isIncomingMessage() && item.isGroupMessage) {
                this.setScreenName(item.fromScreenName);
                if (this.mTxtScreenName != null) {
                    this.mTxtScreenName.setVisibility(0);
                }
            } else if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
            if (!this.isInEditMode()) {
                String fromJid = item.fromJid;
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger != null) {
                    File file;
                    String phoneNumber = null;
                    ZoomBuddy buddy = null;
                    ZoomBuddy myself = messenger.getMyself();
                    if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                        buddy = myself;
                    } else {
                        buddy = messenger.getBuddyWithJID(fromJid);
                        if (buddy != null) {
                            phoneNumber = buddy.getPhoneNumber();
                        }
                    }
                    String avatarPath = null;
                    if (buddy != null) {
                        avatarPath = buddy.getLocalPicturePath();
                    }
                    boolean hasAvatarFile = false;
                    if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                        this.setAvatar(avatarPath);
                        hasAvatarFile = true;
                    }
                    if (!hasAvatarFile) {
                        if (item.fromContact == null && phoneNumber != null && buddy != null) {
                            item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                        }
                        if (item.fromContact != null) {
                            this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                        } else {
                            this.setAvatar((String)null);
                        }
                    }
                }
            }
        }
        this.mNewMessage.setVisibility(8);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(item.sessionId);
        if (session == null) {
            return;
        }
        if (session.isMessageMarkUnread(item.messageXMPPId)) {
            this.mNewMessage.setVisibility(0);
        } else {
            this.mNewMessage.setVisibility(8);
        }
        this.updateLinkPreview(item);
    }

    private void updateLinkPreview(MMMessageItem item) {
        if (item == null || CollectionsUtil.isListEmpty(item.linkPreviewMetaInfos)) {
            if (this.mPanelLinkPreview != null) {
                this.mPanelLinkPreview.setVisibility(8);
            }
            return;
        }
        if (!CollectionsUtil.isListEmpty(item.linkPreviewMetaInfos) && this.mPanelLinkPreview != null) {
            this.mPanelLinkPreview.setVisibility(0);
        }
        for (int i = 0; i < 4; ++i) {
            TextView txtSiteName;
            TextView txtLinkTitle;
            LinkPreviewMetaInfo info = null;
            LinearLayout panelItem = null;
            if (i < item.linkPreviewMetaInfos.size()) {
                info = item.linkPreviewMetaInfos.get(i);
            }
            if (i < this.mPanelLinkPreview.getChildCount()) {
                panelItem = (LinearLayout)this.mPanelLinkPreview.getChildAt(i);
            }
            if (info == null) {
                if (panelItem == null) break;
                panelItem.setVisibility(8);
                continue;
            }
            if (panelItem == null) {
                panelItem = (LinearLayout)View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_preview_item, null);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
                if (i != 0) {
                    lp.topMargin = UIUtil.dip2px((Context)this.getContext(), (float)5.0f);
                    panelItem.setBackgroundResource(R.drawable.zm_msg_preview_bg);
                } else {
                    panelItem.setBackgroundResource(R.drawable.zm_msg_preview_top_bg);
                }
                this.mPanelLinkPreview.addView((View)panelItem, (ViewGroup.LayoutParams)lp);
                panelItem.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        AbsMessageView.OnClickLinkPreviewListener listener = MMMessageLinkPreviewView.this.getOnClickLinkPreviewListener();
                        if (listener != null) {
                            Object tag = v.getTag();
                            if (tag == null || !(tag instanceof LinkPreviewMetaInfo)) {
                                return;
                            }
                            listener.onClickLinkPreview(MMMessageLinkPreviewView.this.mMessageItem, (LinkPreviewMetaInfo)tag);
                        }
                    }
                });
            }
            panelItem.setVisibility(0);
            panelItem.setTag((Object)info);
            ZMGifView imgLinkIcon = (ZMGifView)panelItem.findViewById(R.id.imgLinkIcon);
            TextView txtLinkDes = (TextView)panelItem.findViewById(R.id.txtLinkDes);
            if (PTSettingHelper.isImLlinkPreviewDescription()) {
                String imgPath = info.getImagePath();
                if (imgLinkIcon != null) {
                    if (ImageUtil.isValidImageFile(imgPath)) {
                        imgLinkIcon.setImageDrawable(new LazyLoadDrawable(imgPath));
                        imgLinkIcon.setVisibility(0);
                        int[] radius = new int[4];
                        int corner = UIUtil.dip2px((Context)this.getContext(), (float)10.0f);
                        radius[0] = i == 0 ? 0 : corner;
                        radius[1] = i == 0 ? 0 : corner;
                        radius[2] = 0;
                        radius[2] = 0;
                        imgLinkIcon.setRadius(radius);
                    } else {
                        imgLinkIcon.setVisibility(8);
                    }
                }
                if (txtLinkDes != null) {
                    txtLinkDes.setText((CharSequence)info.getDesc());
                    txtLinkDes.setVisibility(0);
                }
            } else {
                if (imgLinkIcon != null) {
                    imgLinkIcon.setVisibility(8);
                }
                if (txtLinkDes != null) {
                    txtLinkDes.setVisibility(8);
                }
            }
            String faviconPath = info.getFaviconPath();
            ImageView imgFavicon = (ImageView)panelItem.findViewById(R.id.imgFavicon);
            if (imgFavicon != null) {
                if (ImageUtil.isValidImageFile(faviconPath)) {
                    imgFavicon.setImageDrawable((Drawable)new LazyLoadDrawable(faviconPath));
                    imgFavicon.setVisibility(0);
                } else {
                    imgFavicon.setVisibility(8);
                }
            }
            if ((txtLinkTitle = (TextView)panelItem.findViewById(R.id.txtLinkTitle)) != null) {
                txtLinkTitle.setText((CharSequence)info.getTitle());
            }
            if ((txtSiteName = (TextView)panelItem.findViewById(R.id.txtSiteName)) == null) continue;
            txtSiteName.setText((CharSequence)info.getSiteName());
        }
    }

    private void removeMeetingNoHookInfoInArea(List<MeetingNoHookInfo> infos, int start, int end) {
        if (CollectionsUtil.isListEmpty(infos)) {
            return;
        }
        if (start < 0 || start >= end) {
            return;
        }
        for (int i = 0; i < infos.size(); ++i) {
            MeetingNoHookInfo info = infos.get(i);
            if (info.start < start || info.end > end) continue;
            infos.remove(i);
            --i;
        }
    }

    private void hookZoomURL(TextView tv) {
        if (tv == null) {
            return;
        }
        CharSequence text = tv.getText();
        String patternStr = "(?<!\\d)(?:([0-9]{9,11}))(?!\\d)|(?<!\\d)(?:([0-9]{3})-([0-9]{3})-([0-9]{3,5}))(?!\\d)|(?<!\\d)(?:([0-9]{3}) ([0-9]{3}) ([0-9]{3,5}))(?!\\d)";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        ArrayList<MeetingNoHookInfo> infos = new ArrayList<MeetingNoHookInfo>();
        while (matcher.find()) {
            MeetingNoHookInfo info = new MeetingNoHookInfo();
            info.end = matcher.end();
            info.start = matcher.start();
            info.lable = matcher.group();
            info.no = info.lable.replace("-", "").replace(" ", "");
            infos.add(info);
        }
        if (infos.size() > 0 && !(text instanceof Spannable)) {
            text = new SpannableString(text);
            tv.setText(text);
        }
        if (text instanceof Spannable) {
            Spannable spannable = (Spannable)text;
            URLSpan[] urls = tv.getUrls();
            if ((urls == null || urls.length < 1) && infos.size() == 0) {
                return;
            }
            if (urls != null && urls.length > 0) {
                for (int i = 0; i < urls.length; ++i) {
                    int flags;
                    int end;
                    int start;
                    URLSpan newSpan;
                    URLSpan span = urls[i];
                    String url = span.getURL();
                    if (url.startsWith("http://https://") || url.startsWith("http://http://")) {
                        url = url.substring(7);
                    } else if (url.startsWith("tel:")) {
                        url = url.substring(4);
                    }
                    if (this.isZoomURL(url)) {
                        final String zoomUrl = url;
                        newSpan = new URLSpan(zoomUrl){

                            public void onClick(View widget) {
                                MMMessageLinkPreviewView.this.joinByURL(zoomUrl);
                            }
                        };
                        start = spannable.getSpanStart((Object)span);
                        end = spannable.getSpanEnd((Object)span);
                        flags = spannable.getSpanFlags((Object)span);
                        if (start >= 0 && end > start) {
                            spannable.removeSpan((Object)span);
                            spannable.setSpan((Object)newSpan, start, end, flags);
                        }
                        this.removeMeetingNoHookInfoInArea(infos, start, end);
                        continue;
                    }
                    if (!this.isZoomMeetingNo(url)) continue;
                    final String meetingNo = url;
                    newSpan = new URLSpan(meetingNo){

                        public void onClick(View widget) {
                            AbsMessageView.OnClickMeetingNOListener l = MMMessageLinkPreviewView.this.getOnClickMeetingNOListener();
                            if (l != null) {
                                l.onClickMeetingNO(meetingNo);
                            }
                        }
                    };
                    start = spannable.getSpanStart((Object)span);
                    end = spannable.getSpanEnd((Object)span);
                    flags = spannable.getSpanFlags((Object)span);
                    if (start >= 0 && end > start) {
                        spannable.removeSpan((Object)span);
                        spannable.setSpan((Object)newSpan, start, end, flags);
                    }
                    this.removeMeetingNoHookInfoInArea(infos, start, end);
                }
            }
            for (MeetingNoHookInfo info : infos) {
                final String meetingNo = info.no;
                URLSpan newSpan = new URLSpan(meetingNo){

                    public void onClick(View widget) {
                        AbsMessageView.OnClickMeetingNOListener l = MMMessageLinkPreviewView.this.getOnClickMeetingNOListener();
                        if (l != null) {
                            l.onClickMeetingNO(meetingNo);
                        }
                    }
                };
                if (info.start < 0 || info.end <= info.start) continue;
                spannable.setSpan((Object)newSpan, info.start, info.end, 33);
            }
        }
    }

    private void joinByURL(String url) {
        Intent intent = new Intent(this.getContext(), JoinByURLActivity.class);
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        this.getContext().startActivity(intent);
    }

    private boolean isZoomURL(String url) {
        return url.matches("https?://.+\\.zoom\\.us/[j|w]/.+");
    }

    private boolean isZoomMeetingNo(String str) {
        return !StringUtil.isEmptyOrNull((String)str) && str.matches("^[0-9]{9,11}$");
    }

    static class MeetingNoHookInfo {
        public String no;
        public String lable;
        public int start;
        public int end;

        MeetingNoHookInfo() {
        }
    }
}

