/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.CrawlerLinkPreview;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessageTemplate;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.tempbean.IZoomMessageTemplate;
import com.zipow.videobox.tempbean.parse.MessageTemplateParse;
import com.zipow.videobox.util.TimeFormatUtil;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.LinkPreviewMetaInfo;
import com.zipow.videobox.view.mm.MMAddonMessage;
import com.zipow.videobox.view.mm.MMGiphyToView;
import com.zipow.videobox.view.mm.MMGiphyView;
import com.zipow.videobox.view.mm.MMMessageAddonView;
import com.zipow.videobox.view.mm.MMMessageAudioFromView;
import com.zipow.videobox.view.mm.MMMessageAudioToView;
import com.zipow.videobox.view.mm.MMMessageBlewNewMsgView;
import com.zipow.videobox.view.mm.MMMessageCallFromView;
import com.zipow.videobox.view.mm.MMMessageCodeSnippetFromView;
import com.zipow.videobox.view.mm.MMMessageCodeSnippetToView;
import com.zipow.videobox.view.mm.MMMessageFileFromView;
import com.zipow.videobox.view.mm.MMMessageFileToView;
import com.zipow.videobox.view.mm.MMMessageFromView;
import com.zipow.videobox.view.mm.MMMessageItemAtNameSpan;
import com.zipow.videobox.view.mm.MMMessageLinkPreviewFromView;
import com.zipow.videobox.view.mm.MMMessageLinkPreviewToView;
import com.zipow.videobox.view.mm.MMMessagePicFromView;
import com.zipow.videobox.view.mm.MMMessagePicToView;
import com.zipow.videobox.view.mm.MMMessageRemoveHistory;
import com.zipow.videobox.view.mm.MMMessageSystemView;
import com.zipow.videobox.view.mm.MMMessageTemplateView;
import com.zipow.videobox.view.mm.MMMessageToView;
import com.zipow.videobox.view.mm.MMMessageUnSupportFromView;
import com.zipow.videobox.view.mm.MMMessageUnSupportToView;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.sticker.CommonEmojiHelper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.videomeetings.R;

public class MMMessageItem {
    private static final String TAG = MMMessageItem.class.getSimpleName();
    public static final int ITEM_TYPE_TEXT_RECEIVED = 0;
    public static final int ITEM_TYPE_TEXT_SENT = 1;
    public static final int ITEM_TYPE_AUDIO_RECEIVED = 2;
    public static final int ITEM_TYPE_AUDIO_SENT = 3;
    public static final int ITEM_TYPE_PICTURE_RECEIVED = 4;
    public static final int ITEM_TYPE_PICTURE_SENT = 5;
    public static final int ITEM_TYPE_VIDEO_RECEIVED = 6;
    public static final int ITEM_TYPE_VIDEO_SENT = 7;
    public static final int ITEM_TYPE_MEETING_INVITATION_RECEIVED = 8;
    public static final int ITEM_TYPE_MEETING_INVITATION_SENT = 9;
    public static final int ITEM_TYPE_OTHER_FILE_RECEIVED = 10;
    public static final int ITEM_TYPE_OTHER_FILE_SENT = 11;
    public static final int ITEM_TYPE_CREATE_GROUP = 12;
    public static final int ITEM_TYPE_ADD_TO_GROUP = 13;
    public static final int ITEM_TYPE_REMOVE_FROM_GROUP = 14;
    public static final int ITEM_TYPE_QUIT_GROUP = 15;
    public static final int ITEM_TYPE_MODIFY_GROUP = 16;
    public static final int ITEM_TYPE_ACCEPT_INVITE = 17;
    public static final int ITEM_TYPE_NOTE = 18;
    public static final int ITEM_TYPE_TIME_STAMP = 19;
    public static final int ITEM_TYPE_UNKNOWN = 20;
    public static final int ITEM_TYPE_CALL_MISSED_RECEIVED = 21;
    public static final int ITEM_TYPE_CALL_ACCEPTED_RECEIVED = 22;
    public static final int ITEM_TYPE_CALL_DECLINED_RECEIVED = 23;
    public static final int ITEM_TYPE_E2E_INVITE_RECEIVED = 24;
    public static final int ITEM_TYPE_E2E_ACCEPT_RECEIVED = 25;
    public static final int ITEM_TYPE_E2E_SYSTEM_MESSAGE = 26;
    public static final int ITEM_TYPE_GIF_RECEIVED = 27;
    public static final int ITEM_TYPE_GIF_SENT = 28;
    public static final int ITEM_TYPE_ADDON = 29;
    public static final int ITEM_TYPE_UNSUPPORT_SENT = 30;
    public static final int ITEM_TYPE_UNSUPPORT_RECEIVED = 31;
    public static final int ITEM_TYPE_GIPHY_SENT = 32;
    public static final int ITEM_TYPE_GIPHY_RECEIVED = 33;
    public static final int ITEM_TYPE_LINK_PREVIEW_SENT = 34;
    public static final int ITEM_TYPE_LINK_PREVIEW_RECEIVED = 35;
    public static final int ITEM_TYPE_SYSTEM_NEW_MSG_BELOW = 36;
    public static final int ITEM_TYPE_CODE_SNIPPT_RECEIVED = 37;
    public static final int ITEM_TYPE_CODE_SNIPPT_SENT = 38;
    public static final int ITEM_TYPE_REMOVE_HISTORY = 39;
    public static final int ITEM_TYPE_CALL_UNKNOW_RECEIVED = 40;
    public static final int ITEM_TYPE_MESSAGE_TEMPLATE = 41;
    public static final int ITEM_TYPE_TOTAL_COUNT = 42;
    public static final long MSG_DELETEABLE_TIME = 63072000000L;
    public String sessionId;
    public String fromScreenName;
    public String fromJid;
    public String toScreenName;
    public String toJid;
    public CharSequence message;
    public int messageState = 0;
    public long messageTime;
    public long serverSideTime;
    public String messageId;
    public String messageXMPPId;
    public int messageType = 0;
    public String picturePreviewPath;
    public String localFilePath;
    public boolean isFileDownloaded = false;
    public int audioVideoLength = 0;
    public boolean isDownloading = false;
    public boolean isPlaying = false;
    public boolean isUnread = false;
    public boolean isPlayed = false;
    public boolean isGroupMessage = false;
    public boolean isE2E = false;
    public boolean onlyMessageShow = false;
    public boolean isAtEveryone = false;
    public boolean isPreviewDownloadFailed = false;
    public boolean isHistorySyncMessage = false;
    public String fileId;
    public List<String> atList;
    public List<MMMessageItemAtNameSpan> atNameSpanList;
    public IMAddrBookItem fromContact;
    public ZoomMessage.FileInfo fileInfo;
    public ZoomMessage.FileTransferInfo transferInfo;
    public MMAddonMessage addonMsg;
    public IZoomMessageTemplate template;
    public boolean isStikcerMsg;
    public boolean isSupportMsg;
    public int fileRatio = -1;
    public long editMessageTime;
    public String giphyID;
    public List<LinkPreviewMetaInfo> linkPreviewMetaInfos;
    public boolean isMsgAtMe = false;
    public boolean isBodyAllEmojis = false;
    public boolean isFirstSync = false;
    public boolean needTriggerUpdate;
    public static final String E2E_SYSTEM_MSG_ID = "E2E_SYSTEM_MSG_ID";
    public static final String E2E_SYSTEM_STATE_READY_MSG_ID = "E2E_SYSTEM_STATE_READY_MSG_ID";
    public static final String TIMED_CHAT_MSG_ID = "TIMED_CHAT_MSG_ID";

    public static MMMessageItem initWithZoomMessage(String reqID, String sessionId, ZoomMessenger messenger, String giphyID, String giphyStr, boolean isGroupMessage, boolean isOutMessage) {
        if (StringUtil.isEmptyOrNull((String)reqID) || StringUtil.isEmptyOrNull((String)sessionId) || StringUtil.isEmptyOrNull((String)giphyID) || StringUtil.isEmptyOrNull((String)giphyStr)) {
            return null;
        }
        if (messenger == null) {
            return null;
        }
        ZoomBuddy buddy = messenger.getMyself();
        if (buddy == null) {
            return null;
        }
        MMMessageItem item = new MMMessageItem();
        item.messageId = reqID;
        item.sessionId = sessionId;
        item.fromJid = buddy.getJid();
        item.toJid = buddy.getJid();
        item.messageTime = System.currentTimeMillis();
        item.giphyID = giphyID;
        item.message = giphyStr;
        item.isGroupMessage = isGroupMessage;
        item.messageType = isOutMessage ? 32 : 33;
        return item;
    }

    public static MMMessageItem createNewMsgsMark() {
        MMMessageItem item = new MMMessageItem();
        item.messageType = 36;
        return item;
    }

    @Nullable
    public static MMMessageItem initWithZoomMessage(ZoomMessage message, String sessionId, ZoomMessenger messenger, boolean isGroupMessage, boolean isOutMessage, Context context, IMAddrBookItem imaddrBookItem, MMFileContentMgr mgr) {
        Resources res;
        ZoomBuddy buddyTo;
        ZoomFile file;
        if (message == null || StringUtil.isEmptyOrNull((String)sessionId) || messenger == null || context == null) {
            return null;
        }
        MMMessageItem item = new MMMessageItem();
        item.sessionId = sessionId;
        item.isGroupMessage = isGroupMessage;
        item.messageState = message.getMessageState();
        item.fromJid = message.getSenderID();
        item.toJid = message.getReceiverID();
        item.messageTime = message.getStamp();
        item.serverSideTime = message.getServerSideTime();
        item.messageId = message.getMessageID();
        item.isUnread = message.isUnread();
        item.isPlayed = message.isPlayed();
        item.isE2E = message.isE2EMessage();
        item.atList = message.getMsgAtList();
        item.isAtEveryone = message.isMessageAtEveryone();
        item.messageXMPPId = message.getMessageXMPPGuid();
        item.isStikcerMsg = message.isStickerMessage();
        item.isSupportMsg = message.isSupportedMessage();
        item.editMessageTime = message.getEditActionMilliSecTime();
        item.isHistorySyncMessage = message.isHistorySyncMessage();
        item.giphyID = message.getGiphyID();
        item.isMsgAtMe = message.isMessageAtMe();
        item.needTriggerUpdate = message.needTriggerUpdate();
        ZoomBuddy buddyFrom = messenger.getBuddyWithJID(item.fromJid);
        if (buddyFrom == null) {
            item.fromScreenName = message.getSenderName();
        } else {
            String phoneNumber = buddyFrom.getPhoneNumber();
            if (!isOutMessage) {
                IMAddrBookItem abItem = imaddrBookItem;
                if (abItem == null) {
                    abItem = IMAddrBookItem.fromZoomBuddy(buddyFrom);
                    item.fromScreenName = BuddyNameUtil.getBuddyDisplayName(buddyFrom, abItem);
                } else {
                    item.fromScreenName = BuddyNameUtil.getBuddyDisplayName(buddyFrom, abItem);
                    abItem.addPhoneNumber(phoneNumber, phoneNumber);
                    abItem.setAccoutEmail(buddyFrom.getEmail());
                    abItem.setScreenName(item.fromScreenName);
                }
                if (abItem != null) {
                    abItem.setIsZoomUser(true);
                }
                item.fromContact = abItem;
            } else {
                item.fromScreenName = BuddyNameUtil.getMyDisplayName(buddyFrom);
            }
        }
        if (mgr != null && (file = mgr.getFileWithMessageID(sessionId, item.messageXMPPId)) != null) {
            item.fileId = file.getWebFileID();
            mgr.destroyFileObject(file);
        }
        if ((buddyTo = messenger.getBuddyWithJID(item.toJid)) != null) {
            item.toScreenName = BuddyNameUtil.getBuddyDisplayName(buddyTo, isOutMessage ? imaddrBookItem : null);
        }
        if ((res = context.getResources()) == null) {
            return null;
        }
        if (!item.isSupportMsg) {
            item.messageType = isOutMessage ? 30 : 31;
            return item;
        }
        int messageType = message.getMessageType();
        switch (messageType) {
            case 51: {
                item.message = message.getBody();
                item.messageType = 22;
                break;
            }
            case 52: {
                item.message = message.getBody();
                item.messageType = 23;
                break;
            }
            case 50: {
                item.message = message.getBody();
                item.messageType = 21;
                break;
            }
            case 53: {
                item.message = message.getBody();
                item.messageType = 40;
                break;
            }
            case 0: {
                CrawlerLinkPreview linkCrawler;
                item.message = message.getBody();
                if ((item.messageState == 3 || item.messageState == 2) && PTSettingHelper.isImLlinkPreviewDescription() && !item.isE2E && (linkCrawler = PTApp.getInstance().getLinkCrawler()) != null && linkCrawler.isLinkPreviewEnable()) {
                    LinkedHashSet urls = new LinkedHashSet();
                    List temp = StringUtil.getUrls((CharSequence)item.message);
                    if (temp != null) {
                        urls.addAll(temp);
                    }
                    if (urls.size() > 0 && urls.size() <= 4) {
                        ArrayList<LinkPreviewMetaInfo> infos = new ArrayList<LinkPreviewMetaInfo>();
                        for (String url : urls) {
                            LinkPreviewMetaInfo info = LinkPreviewMetaInfo.createFromProto(linkCrawler.FuzzyGetLinkMetaInfo(url), sessionId, item.messageXMPPId);
                            if (info == null || StringUtil.isEmptyOrNull((String)info.getDesc()) && StringUtil.isEmptyOrNull((String)info.getImgUrl())) continue;
                            infos.add(info);
                        }
                        if (infos.size() > 0) {
                            item.linkPreviewMetaInfos = infos;
                        }
                    }
                }
                item.messageType = !CollectionsUtil.isListEmpty(item.linkPreviewMetaInfos) ? (isOutMessage ? 34 : 35) : (isOutMessage ? 1 : 0);
                MMMessageItem.highLightAtNameSpanInMessageItem(item, messenger, context);
                CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
                item.message = helper.tranToEmojiText(item.message);
                item.isBodyAllEmojis = helper.isAllEmojis(item.message);
                break;
            }
            case 13: {
                item.localFilePath = message.getLocalFilePath();
                item.isFileDownloaded = message.isFileDownloaded();
                item.messageType = isOutMessage ? 38 : 37;
                item.fileInfo = message.getFileInfo();
                break;
            }
            case 12: {
                item.localFilePath = message.getLocalFilePath();
                item.picturePreviewPath = message.getPicturePreviewPath();
                item.isFileDownloaded = message.isFileDownloaded();
                item.message = message.getBody();
                if (isOutMessage) {
                    item.messageType = 32;
                    break;
                }
                item.messageType = 33;
                break;
            }
            case 1: 
            case 5: {
                item.localFilePath = message.getLocalFilePath();
                item.picturePreviewPath = message.getPicturePreviewPath();
                item.isFileDownloaded = message.isFileDownloaded();
                if (isOutMessage) {
                    item.messageType = 5;
                    break;
                }
                item.messageType = 4;
                break;
            }
            case 6: {
                item.localFilePath = message.getLocalFilePath();
                item.picturePreviewPath = message.getPicturePreviewPath();
                item.isFileDownloaded = message.isFileDownloaded();
                if (isOutMessage) {
                    item.messageType = 28;
                    break;
                }
                item.messageType = 27;
                break;
            }
            case 2: {
                item.localFilePath = message.getLocalFilePath();
                item.isFileDownloaded = message.isFileDownloaded();
                item.audioVideoLength = message.getAudioLength();
                if (isOutMessage) {
                    item.messageType = 3;
                    break;
                }
                item.messageType = 2;
                break;
            }
            case 10: {
                item.localFilePath = message.getLocalFilePath();
                item.isFileDownloaded = message.isFileDownloaded();
                item.fileInfo = message.getFileInfo();
                item.transferInfo = message.getFileTransferInfo();
                if (isOutMessage) {
                    item.messageType = 11;
                    break;
                }
                item.messageType = 10;
                break;
            }
            case 4: {
                item.messageType = isOutMessage ? 9 : 8;
                item = null;
                break;
            }
            case 20: {
                item.messageType = 12;
                item.message = MMMessageItem.buildGroupMessageBody(message.getBody(), context);
                if (item.message != null) break;
                return null;
            }
            case 21: {
                item.messageType = 13;
                item.message = MMMessageItem.buildGroupMessageBody(message.getBody(), context);
                if (item.message != null) break;
                return null;
            }
            case 22: {
                item.messageType = 14;
                item.message = MMMessageItem.buildGroupMessageBody(message.getBody(), context);
                if (item.message != null) break;
                return null;
            }
            case 23: {
                item.messageType = 15;
                item.message = MMMessageItem.buildGroupMessageBody(message.getBody(), context);
                if (item.message != null) break;
                return null;
            }
            case 24: {
                item.messageType = 16;
                item.message = MMMessageItem.buildGroupMessageBody(message.getBody(), context);
                if (item.message != null) break;
                return null;
            }
            case 88: {
                item.messageType = 18;
                item.message = message.getBody();
                if (item.message != null) break;
                return null;
            }
            case 99: {
                item.messageType = 19;
                break;
            }
            case 71: {
                item.messageType = 25;
                item.message = res.getString(R.string.zm_msg_e2e_invite_accepted, new Object[]{item.fromScreenName});
                break;
            }
            case 70: {
                item.messageType = 24;
                item.message = res.getString(R.string.zm_msg_e2e_get_invite, new Object[]{item.fromScreenName});
                break;
            }
            case 3: 
            case 100: {
                ZMLog.e((String)TAG, (String)"addMessageToListAdapter, MessageType unknow %d", (Object[])new Object[]{messageType});
                item = null;
                break;
            }
            case 80: {
                item.messageType = 18;
                item.message = MMMessageItem.buildRecallMessageBody(message.getBody(), context);
                break;
            }
            case 11: {
                MMAddonMessage addonMsg = MMAddonMessage.initFromMsgBody(message.getBody().toString());
                if (addonMsg == null) break;
                if (addonMsg.isPlainText()) {
                    item.message = addonMsg.getPlainText();
                    item.messageType = 0;
                    break;
                }
                item.messageType = 29;
                item.addonMsg = addonMsg;
                break;
            }
            case 14: {
                ZoomMessageTemplate messageTemplate = PTApp.getInstance().getZoomMessageTemplate();
                if (messageTemplate == null) break;
                PTAppProtos.RobotMsg robotMsg = messageTemplate.robotDecode(sessionId, message.getMessageXMPPGuid());
                if (robotMsg != null) {
                    if (robotMsg.getIsUnSupportRobotMessage()) {
                        if (isOutMessage) {
                            item.messageType = 30;
                            break;
                        }
                        item.messageType = 31;
                        break;
                    }
                    item.messageType = 41;
                    String jsonStr = robotMsg.getJsonMsg();
                    item.template = MessageTemplateParse.parse(jsonStr);
                    break;
                }
                item.messageType = 18;
                item.message = message.getBody();
                break;
            }
            default: {
                item.messageType = isOutMessage ? 30 : 31;
                return item;
            }
        }
        if (item != null && item.isE2E) {
            if (item.messageState == 8 || item.messageState == 9 || item.messageState == 10) {
                item.message = context.getResources().getString(R.string.zm_msg_e2e_decrypt_failed_12310);
                item.messageType = isOutMessage ? 1 : 0;
            } else if (item.messageState == 3) {
                item.message = context.getResources().getString(R.string.zm_msg_e2e_message_decrypting);
            } else if (item.messageState == 11 || item.messageState == 13) {
                item.message = context.getResources().getString(R.string.zm_msg_e2e_unable_decrypt);
                item.messageType = isOutMessage ? 1 : 0;
            }
        }
        return item;
    }

    private static void highLightAtNameSpanInMessageItem(MMMessageItem item, ZoomMessenger messenger, Context context) {
        if (item == null || messenger == null || context == null) {
            return;
        }
        List<String> nameList = MMMessageItem.getAtNameListInMessageItem(item, messenger, context);
        if (nameList == null || nameList.isEmpty()) {
            return;
        }
        MMMessageItem.spanAtName(nameList, item, context);
    }

    private static List<String> getAtNameListInMessageItem(MMMessageItem item, ZoomMessenger messenger, Context context) {
        List<String> jidList = item.atList;
        if (jidList == null || jidList.isEmpty()) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>(jidList.size());
        if (item.isAtEveryone) {
            nameList.add(context.getString(R.string.zm_lbl_select_everyone));
        }
        for (int i = 0; i < jidList.size(); ++i) {
            ZoomBuddy buddy = messenger.getBuddyWithJID(jidList.get(i));
            if (buddy == null) continue;
            nameList.add(BuddyNameUtil.getBuddyDisplayName(buddy, null));
        }
        return nameList;
    }

    private static void spanAtName(List<String> nameList, MMMessageItem item, Context context) {
        int msgTxtCount = item.message.length();
        int size = nameList.size();
        SpannableString spanStr = new SpannableString(item.message);
        item.atNameSpanList = new ArrayList<MMMessageItemAtNameSpan>(nameList.size());
        for (int i = 0; i < size; ++i) {
            String atname = '@' + nameList.get(i);
            for (int index = 0; index < msgTxtCount && (index = TextUtils.indexOf((CharSequence)item.message, (CharSequence)atname, (int)index)) >= 0; index += atname.length()) {
                MMMessageItemAtNameSpan span = new MMMessageItemAtNameSpan(ContextCompat.getColor((Context)context, (int)R.color.zm_highlight), index, index + atname.length());
                spanStr.setSpan((Object)span, index, index + atname.length(), 33);
                item.atNameSpanList.add(span);
            }
        }
        item.message = spanStr;
    }

    private static CharSequence buildRecallMessageBody(CharSequence body, Context context) {
        boolean isMe;
        if (context == null || body == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomBuddy myself = messenger.getMyself();
        String jid = body.toString();
        boolean bl = isMe = myself != null && StringUtil.isSameString((String)myself.getJid(), (String)jid);
        if (isMe) {
            return context.getString(R.string.zm_msg_delete_by_me_24679);
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy != null) {
            return context.getString(R.string.zm_msg_delete_by_other_24679, new Object[]{buddy.getScreenName()});
        }
        return null;
    }

    private static CharSequence buildGroupMessageBody(CharSequence body, Context context) {
        GroupAction action = GroupAction.loadFromString(body == null ? null : body.toString());
        if (action == null) {
            return body;
        }
        if (context == null) {
            return body;
        }
        return action.toMessage(context);
    }

    public boolean isMessageE2EWaitDecrypt() {
        if (!this.isE2E) {
            return false;
        }
        return this.messageState == 3 || this.messageState == 12 || this.messageState == 13 || this.messageState == 11;
    }

    public AbsMessageView getView(Context context, View convertView) {
        AbsMessageView view = null;
        switch (this.messageType) {
            case 1: {
                view = this.createMessageTextToView(context, convertView);
                break;
            }
            case 0: {
                view = this.createMessageTextFromView(context, convertView);
                break;
            }
            case 19: {
                view = this.createMessageTimeView(context, convertView);
                break;
            }
            case 3: {
                view = this.createAudioSentView(context, convertView);
                break;
            }
            case 2: {
                view = this.createAudioReceivedView(context, convertView);
                break;
            }
            case 5: 
            case 28: {
                view = this.createPictureSentView(context, convertView);
                break;
            }
            case 4: 
            case 27: {
                view = this.createPictureReceivedView(context, convertView);
                break;
            }
            case 11: {
                view = this.createOtherFileSentView(context, convertView);
                break;
            }
            case 10: {
                view = this.createOtherFileReceivedView(context, convertView);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 40: {
                view = this.createMessageCallFromView(context, convertView);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: {
                view = this.createSystemMessageView(context, convertView);
                break;
            }
            case 29: {
                view = this.createAddonMsgView(context, convertView);
                break;
            }
            case 41: {
                view = this.createTemplateView(context, convertView);
                break;
            }
            case 31: {
                view = this.createUnSupportMsgFromView(context, convertView);
                break;
            }
            case 30: {
                view = this.createUnSupportMsgToView(context, convertView);
                break;
            }
            case 35: {
                view = this.createLinkPreviewMsgFromView(context, convertView);
                break;
            }
            case 34: {
                view = this.createLinkPreviewMsgToView(context, convertView);
                break;
            }
            case 32: {
                view = this.createGiphyToView(context, convertView);
                break;
            }
            case 33: {
                view = this.createGiphyFromView(context, convertView);
                break;
            }
            case 36: {
                view = this.createNewMsgBelowView(context, convertView);
                break;
            }
            case 37: {
                view = this.createCodeSnippetReceivedView(context, convertView);
                break;
            }
            case 38: {
                view = this.createCodeSnippetSentView(context, convertView);
                break;
            }
            case 39: {
                view = this.createRemoveHistoryView(context, convertView);
            }
        }
        return view;
    }

    private boolean recallMessage(Context context) {
        if (context == null) {
            return false;
        }
        if (CmmTime.getMMNow() - this.messageTime > 63072000000L) {
            Toast.makeText((Context)context, (int)R.string.zm_msg_delete_timeout_19888, (int)1).show();
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        if (!messenger.isConnectionGood()) {
            Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
            return false;
        }
        ZoomChatSession session = messenger.getSessionById(this.sessionId);
        if (session == null) {
            return false;
        }
        boolean res = session.revokeMessageByXMPPGuid(this.messageXMPPId);
        if (!res) {
            Toast.makeText((Context)context, (int)R.string.zm_alert_delete_meeting_failed, (int)1).show();
        }
        return res;
    }

    private boolean unshareFile(Context context) {
        if (context == null || StringUtil.isEmptyOrNull((String)this.fileId)) {
            return false;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return false;
        }
        ZoomFile file = mgr.getFileWithWebFileID(this.fileId);
        if (file == null) {
            return false;
        }
        MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
        if (mmFile == null) {
            return false;
        }
        String reqId = mgr.deleteFile(mmFile, this.sessionId);
        if (StringUtil.isEmptyOrNull((String)reqId)) {
            if (context instanceof FragmentActivity) {
                ErrorMsgDialog.newInstance(context.getString(R.string.zm_alert_unshare_file_failed), -1).show(((FragmentActivity)context).getSupportFragmentManager(), ErrorMsgDialog.class.getName());
            }
            return false;
        }
        return true;
    }

    public boolean deleteMessage(Context context) {
        boolean result = false;
        switch (this.messageType) {
            case 0: 
            case 1: 
            case 34: 
            case 35: {
                result = this.recallMessage(context);
                break;
            }
            case 4: 
            case 5: 
            case 27: 
            case 28: {
                if (this.isStikcerMsg || this.isE2E) {
                    result = this.recallMessage(context);
                    break;
                }
                result = this.unshareFile(context);
                break;
            }
            case 2: 
            case 3: {
                result = this.recallMessage(context);
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 10: 
            case 11: 
            case 37: 
            case 38: {
                if (this.isE2E) {
                    result = this.recallMessage(context);
                    break;
                }
                result = this.unshareFile(context);
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 32: 
            case 33: {
                result = this.recallMessage(context);
            }
        }
        return result;
    }

    public boolean isIncomingMessage() {
        switch (this.messageType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    public boolean isE2EMessagePending() {
        if (this.isE2E) {
            return this.messageState != 7 && this.messageState != 8 && this.messageState != 9;
        }
        return false;
    }

    public boolean isDeleteable(String sessionId) {
        ZoomChatSession session;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return false;
        }
        boolean adminDeleteable = false;
        if (!TextUtils.isEmpty((CharSequence)sessionId) && (session = messenger.getSessionById(sessionId)) != null && session.isGroup()) {
            boolean e2e = this.isE2E || messenger.e2eGetMyOption() == 2;
            ZoomGroup group = session.getSessionGroup();
            boolean isAdmin = group != null && group.isRoom() && group.isGroupOperatorable();
            adminDeleteable = isAdmin && !e2e;
        }
        return adminDeleteable || StringUtil.isSameString((String)myself.getJid(), (String)this.fromJid) && CmmTime.getMMNow() - this.messageTime <= 63072000000L;
    }

    public AbsMessageView createGiphyToView(Context context, View convertView) {
        MMGiphyToView view = null;
        if (convertView instanceof MMGiphyToView && "GiphyTo".equals(convertView.getTag())) {
            view = (MMGiphyToView)convertView;
        } else {
            view = new MMGiphyToView(context);
            view.setTag("GiphyTo");
        }
        view.setMessageItem(this);
        return view;
    }

    public AbsMessageView createGiphyFromView(Context context, View convertView) {
        MMGiphyView view = null;
        if (convertView instanceof MMGiphyView && "GiphyFrom".equals(convertView.getTag())) {
            view = (MMGiphyView)convertView;
        } else {
            view = new MMGiphyView(context);
            view.setTag("GiphyFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    public AbsMessageView createLinkPreviewMsgToView(Context context, View convertView) {
        MMMessageLinkPreviewToView view = null;
        if (convertView instanceof MMMessageLinkPreviewToView && "LinkPreviewTo".equals(convertView.getTag())) {
            view = (MMMessageLinkPreviewToView)convertView;
        } else {
            view = new MMMessageLinkPreviewToView(context);
            view.setTag("LinkPreviewTo");
        }
        view.setMessageItem(this);
        return view;
    }

    public AbsMessageView createLinkPreviewMsgFromView(Context context, View convertView) {
        MMMessageLinkPreviewFromView view = null;
        if (convertView instanceof MMMessageLinkPreviewFromView && "LinkPreviewFrom".equals(convertView.getTag())) {
            view = (MMMessageLinkPreviewFromView)convertView;
        } else {
            view = new MMMessageLinkPreviewFromView(context);
            view.setTag("LinkPreviewFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    public AbsMessageView createUnSupportMsgToView(Context context, View convertView) {
        MMMessageUnSupportToView view = null;
        if (convertView instanceof MMMessageUnSupportToView && "UnSupportTo".equals(convertView.getTag())) {
            view = (MMMessageUnSupportToView)convertView;
        } else {
            view = new MMMessageUnSupportToView(context);
            view.setTag("UnSupportTo");
        }
        view.setMessageItem(this);
        return view;
    }

    public AbsMessageView createUnSupportMsgFromView(Context context, View convertView) {
        MMMessageUnSupportFromView view = null;
        if (convertView instanceof MMMessageUnSupportFromView && "UnSupportFrom".equals(convertView.getTag())) {
            view = (MMMessageUnSupportFromView)convertView;
        } else {
            view = new MMMessageUnSupportFromView(context);
            view.setTag("UnSupportFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createMessageTextToView(Context context, View convertView) {
        MMMessageToView view = null;
        if (convertView instanceof MMMessageToView && "textTo".equals(convertView.getTag())) {
            view = (MMMessageToView)convertView;
        } else {
            view = new MMMessageToView(context);
            view.setTag("textTo");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createMessageCallFromView(Context context, View convertView) {
        MMMessageCallFromView view = null;
        if (convertView instanceof MMMessageCallFromView && "callFrom".equals(convertView.getTag())) {
            view = (MMMessageCallFromView)convertView;
        } else {
            view = new MMMessageCallFromView(context);
            view.setTag("callFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createMessageTextFromView(Context context, View convertView) {
        MMMessageFromView view = null;
        if (convertView instanceof MMMessageFromView && "textFrom".equals(convertView.getTag())) {
            view = (MMMessageFromView)convertView;
        } else {
            view = new MMMessageFromView(context);
            view.setTag("textFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createMessageTimeView(Context context, View convertView) {
        MMMessageSystemView view = null;
        if (convertView instanceof MMMessageSystemView && "systemMessage".equals(convertView.getTag())) {
            view = (MMMessageSystemView)convertView;
        } else {
            view = new MMMessageSystemView(context);
            view.setTag("systemMessage");
        }
        String sTime = TimeFormatUtil.formatDateTime(context, this.messageTime, false);
        if (sTime == null || sTime.indexOf("null") >= 0) {
            sTime = "Monday, 00:00 am";
        }
        view.setMessage(sTime);
        return view;
    }

    private AbsMessageView createAudioSentView(Context context, View convertView) {
        MMMessageAudioToView view = null;
        if (convertView instanceof MMMessageAudioToView && "audioTo".equals(convertView.getTag())) {
            view = (MMMessageAudioToView)convertView;
        } else {
            view = new MMMessageAudioToView(context);
            view.setTag("audioTo");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createAudioReceivedView(Context context, View convertView) {
        MMMessageAudioFromView view = null;
        if (convertView instanceof MMMessageAudioFromView && "audioFrom".equals(convertView.getTag())) {
            view = (MMMessageAudioFromView)convertView;
        } else {
            view = new MMMessageAudioFromView(context);
            view.setTag("audioFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createPictureSentView(Context context, View convertView) {
        MMMessagePicToView view = null;
        if (convertView instanceof MMMessagePicToView && "picTo".equals(convertView.getTag())) {
            view = (MMMessagePicToView)convertView;
        } else {
            view = new MMMessagePicToView(context);
            view.setTag("picTo");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createPictureReceivedView(Context context, View convertView) {
        MMMessagePicFromView view = null;
        if (convertView instanceof MMMessagePicFromView && "picFrom".equals(convertView.getTag())) {
            view = (MMMessagePicFromView)convertView;
        } else {
            view = new MMMessagePicFromView(context);
            view.setTag("picFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createSystemMessageView(Context context, View convertView) {
        MMMessageSystemView view = null;
        if (convertView instanceof MMMessageSystemView && "systemMessage".equals(convertView.getTag())) {
            view = (MMMessageSystemView)convertView;
        } else {
            view = new MMMessageSystemView(context);
            view.setTag("systemMessage");
        }
        view.setMessage(this.message);
        return view;
    }

    private AbsMessageView createAddonMsgView(Context context, View convertView) {
        MMMessageAddonView view = null;
        if (convertView instanceof MMMessageAddonView && "addonView".equals(convertView.getTag())) {
            view = (MMMessageAddonView)convertView;
        } else {
            view = new MMMessageAddonView(context);
            view.setTag("addonView");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createTemplateView(Context context, View convertView) {
        MMMessageTemplateView view = null;
        if (convertView instanceof MMMessageTemplateView && "templateView".equals(convertView.getTag())) {
            view = (MMMessageTemplateView)convertView;
        } else {
            view = new MMMessageTemplateView(context);
            view.setTag("templateView");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createOtherFileSentView(Context context, View convertView) {
        MMMessageFileToView view = null;
        if (convertView instanceof MMMessageFileToView && "fileTo".equals(convertView.getTag())) {
            view = (MMMessageFileToView)convertView;
        } else {
            view = new MMMessageFileToView(context);
            view.setTag("fileTo");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createOtherFileReceivedView(Context context, View convertView) {
        MMMessageFileFromView view = null;
        if (convertView instanceof MMMessageFileFromView && "fileFrom".equals(convertView.getTag())) {
            view = (MMMessageFileFromView)convertView;
        } else {
            view = new MMMessageFileFromView(context);
            view.setTag("fileFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createNewMsgBelowView(Context context, View convertView) {
        MMMessageBlewNewMsgView view = null;
        if (convertView instanceof MMMessageBlewNewMsgView && "newMsgBelow".equals(convertView.getTag())) {
            view = (MMMessageBlewNewMsgView)convertView;
        } else {
            view = new MMMessageBlewNewMsgView(context);
            view.setTag("newMsgBelow");
        }
        return view;
    }

    private AbsMessageView createCodeSnippetReceivedView(Context context, View convertView) {
        MMMessageCodeSnippetFromView view = null;
        if (convertView instanceof MMMessageCodeSnippetFromView && "codeSnippetFrom".equals(convertView.getTag())) {
            view = (MMMessageCodeSnippetFromView)convertView;
        } else {
            view = new MMMessageCodeSnippetFromView(context);
            view.setTag("codeSnippetFrom");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createCodeSnippetSentView(Context context, View convertView) {
        MMMessageCodeSnippetToView view = null;
        if (convertView instanceof MMMessageCodeSnippetToView && "codeSnippetTo".equals(convertView.getTag())) {
            view = (MMMessageCodeSnippetToView)convertView;
        } else {
            view = new MMMessageCodeSnippetToView(context);
            view.setTag("codeSnippetTo");
        }
        view.setMessageItem(this);
        return view;
    }

    private AbsMessageView createRemoveHistoryView(Context context, View convertView) {
        MMMessageRemoveHistory view = null;
        if (convertView instanceof MMMessageRemoveHistory && "removeHistory".equals(convertView.getTag())) {
            view = (MMMessageRemoveHistory)convertView;
        } else {
            view = new MMMessageRemoveHistory(context);
            view.setTag("removeHistory");
        }
        view.setMessage(this.message);
        return view;
    }
}

