/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageLoader;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.MMAddonMessage;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMMessageAddonView
extends AbsMessageView {
    protected MMMessageItem mMessageItem;
    protected AvatarView mAvatarView;
    protected TextView mTxtScreenName;
    protected View mPanelTitle;
    protected ImageView mImgIcon;
    protected TextView mTxtSummary;
    protected TextView mTxtBody;
    protected TextView mTxtFooter;
    protected LinearLayout mActionBarLinear;
    protected TextView mActionBtn1;
    protected TextView mActionBtn2;
    protected TextView mActionBtnMore;
    protected View mPanelAddon;

    public MMMessageAddonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMMessageAddonView(Context context) {
        super(context);
        this.initView();
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_addon, (ViewGroup)this);
    }

    private void initView() {
        this.inflateLayout();
        this.mPanelAddon = this.findViewById(R.id.panelAddon);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mPanelTitle = this.findViewById(R.id.panelTitle);
        this.mImgIcon = (ImageView)this.findViewById(R.id.imgIcon);
        this.mTxtSummary = (TextView)this.findViewById(R.id.txtSummary);
        this.mTxtBody = (TextView)this.findViewById(R.id.txtBody);
        this.mTxtFooter = (TextView)this.findViewById(R.id.txtFooter);
        this.mActionBarLinear = (LinearLayout)this.findViewById(R.id.addon_action_bar_linear);
        this.mActionBtn1 = (TextView)this.findViewById(R.id.addon_action_btn1);
        this.mActionBtn2 = (TextView)this.findViewById(R.id.addon_action_btn2);
        this.mActionBtnMore = (TextView)this.findViewById(R.id.addon_action_btn_more);
        this.mTxtSummary.setMovementMethod(LinkMovementMethod.getInstance());
        this.mTxtBody.setMovementMethod(LinkMovementMethod.getInstance());
        this.mTxtSummary.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                AbsMessageView.OnShowContextMenuListener l = MMMessageAddonView.this.getOnShowContextMenuListener();
                if (l != null) {
                    return l.onShowContextMenu(MMMessageAddonView.this.mMessageItem);
                }
                return false;
            }
        });
        this.mTxtBody.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                AbsMessageView.OnShowContextMenuListener l = MMMessageAddonView.this.getOnShowContextMenuListener();
                if (l != null) {
                    return l.onShowContextMenu(MMMessageAddonView.this.mMessageItem);
                }
                return false;
            }
        });
        if (this.mPanelAddon != null) {
            this.mPanelAddon.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnShowContextMenuListener l = MMMessageAddonView.this.getOnShowContextMenuListener();
                    if (l != null) {
                        return l.onShowContextMenu(MMMessageAddonView.this.mMessageItem);
                    }
                    return false;
                }
            });
            this.mPanelAddon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickMessageListener l = MMMessageAddonView.this.getOnClickMessageListener();
                    if (l != null) {
                        l.onClickMessage(MMMessageAddonView.this.mMessageItem);
                    }
                }
            });
        }
        if (this.mAvatarView != null) {
            this.mAvatarView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickAvatarListener l = MMMessageAddonView.this.getOnClickAvatarListener();
                    if (l != null) {
                        l.onClickAvatar(MMMessageAddonView.this.mMessageItem);
                    }
                }
            });
        }
    }

    public void setMessageItem(MMMessageItem item) {
        MMAddonMessage addon;
        this.mMessageItem = item;
        this.setScreenName(item.fromScreenName);
        if (!this.isInEditMode()) {
            String fromJid = item.fromJid;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null) {
                File file;
                String phoneNumber = null;
                ZoomBuddy buddy = null;
                ZoomBuddy myself = messenger.getMyself();
                if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                    buddy = myself;
                } else {
                    buddy = messenger.getBuddyWithJID(fromJid);
                    if (buddy != null) {
                        phoneNumber = buddy.getPhoneNumber();
                    }
                }
                String avatarPath = null;
                if (buddy != null) {
                    avatarPath = buddy.getLocalPicturePath();
                }
                boolean hasAvatarFile = false;
                if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                    this.setAvatar(avatarPath);
                    hasAvatarFile = true;
                }
                if (!hasAvatarFile) {
                    if (item.fromContact == null && phoneNumber != null && buddy != null) {
                        item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                    }
                    if (item.fromContact != null) {
                        this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                    } else {
                        this.setAvatar((String)null);
                    }
                }
            }
        }
        if (item.onlyMessageShow) {
            if (this.mAvatarView != null) {
                this.mAvatarView.setVisibility(4);
            }
            if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
        } else {
            if (this.mAvatarView != null) {
                this.mAvatarView.setVisibility(0);
            }
            if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(0);
            }
        }
        if ((addon = item.addonMsg) == null) {
            return;
        }
        int gbResource = R.drawable.zm_msg_github_title_bg_normal;
        int abResource = R.drawable.zm_msg_addon_action_btn_jira_bg;
        switch (addon.getType()) {
            case 2: {
                gbResource = this.mMessageItem.onlyMessageShow ? R.drawable.zm_msg_github_title_bg_normal : R.drawable.zm_msg_github_title_bg_top;
                abResource = R.drawable.zm_msg_addon_action_btn_github_bg;
                break;
            }
            case 1: {
                gbResource = this.mMessageItem.onlyMessageShow ? R.drawable.zm_msg_jira_title_bg_normal : R.drawable.zm_msg_jira_title_bg_top;
                abResource = R.drawable.zm_msg_addon_action_btn_jira_bg;
                break;
            }
            case 3: {
                gbResource = this.mMessageItem.onlyMessageShow ? R.drawable.zm_msg_gitlab_title_bg_normal : R.drawable.zm_msg_gitlab_title_bg_top;
                abResource = R.drawable.zm_msg_addon_action_btn_gitlab_bg;
                break;
            }
        }
        this.mPanelTitle.setBackgroundResource(gbResource);
        this.setTitle(addon.getType(), addon.getTitleIcon(), addon.getTitleImg(), addon.getTitle());
        this.setRichText(addon.getBody(), this.mTxtBody);
        this.setRichText(addon.getSummary(), this.mTxtSummary);
        this.setFooter(addon.getBody());
        this.setAction(addon.getAction());
    }

    public void setAction(final List<MMAddonMessage.AddonNode> nodes) {
        MMAddonMessage.ActionNode actionNode;
        if (nodes == null || nodes.size() <= 0) {
            this.mActionBarLinear.setVisibility(8);
            return;
        }
        this.mActionBarLinear.setVisibility(0);
        if (nodes.get(0) instanceof MMAddonMessage.ActionNode) {
            actionNode = (MMAddonMessage.ActionNode)nodes.get(0);
            this.mActionBtn1.setText((CharSequence)(actionNode == null ? "" : actionNode.getValue()));
            this.mActionBtn1.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickActionListener l = MMMessageAddonView.this.getmOnClickActionListener();
                    if (l != null && actionNode != null) {
                        l.onClickAction(MMMessageAddonView.this.mMessageItem.fromJid, actionNode.getAction());
                    }
                }
            });
        }
        if (nodes.size() > 1 && nodes.get(1) instanceof MMAddonMessage.ActionNode) {
            actionNode = (MMAddonMessage.ActionNode)nodes.get(1);
            this.mActionBtn2.setText((CharSequence)(actionNode == null ? "" : actionNode.getValue()));
            this.mActionBtn2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickActionListener l = MMMessageAddonView.this.getmOnClickActionListener();
                    if (l != null && actionNode != null) {
                        l.onClickAction(MMMessageAddonView.this.mMessageItem.fromJid, actionNode.getAction());
                    }
                }
            });
        }
        if (nodes.size() == 1) {
            this.mActionBtnMore.setVisibility(8);
            this.mActionBtn1.setVisibility(0);
            this.mActionBtn2.setVisibility(8);
        } else if (nodes.size() == 2) {
            this.mActionBtnMore.setVisibility(8);
            this.mActionBtn1.setVisibility(0);
            this.mActionBtn2.setVisibility(0);
        } else {
            this.mActionBtnMore.setVisibility(0);
            this.mActionBtn1.setVisibility(0);
            this.mActionBtn2.setVisibility(8);
            this.mActionBtnMore.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickActionMoreListener l = MMMessageAddonView.this.getmOnClickActionMoreListener();
                    if (l != null) {
                        l.onClickActionMore(MMMessageAddonView.this.mMessageItem.fromJid, nodes);
                    }
                }
            });
        }
    }

    public void setRichText(List<MMAddonMessage.AddonNode> nodes, TextView textView) {
        if (nodes == null || textView == null) {
            if (textView != null) {
                textView.setText((CharSequence)"");
            }
            return;
        }
        SpannableStringBuilder builder = new SpannableStringBuilder();
        for (MMAddonMessage.AddonNode node : nodes) {
            SpannableString span;
            if (node instanceof MMAddonMessage.NodeMsgHref) {
                MMAddonMessage.NodeMsgHref href = (MMAddonMessage.NodeMsgHref)node;
                SpannableString span2 = new SpannableString((CharSequence)node.getValue());
                this.parseNodeStyle(node, span2);
                ForegroundColorSpan[] spans = (ForegroundColorSpan[])span2.getSpans(0, span2.length(), ForegroundColorSpan.class);
                span2.setSpan((Object)new ForegroundColorClickableSpan(spans, href), 0, span2.length(), 33);
                builder.append((CharSequence)span2);
                continue;
            }
            if (node instanceof MMAddonMessage.NodeBR) {
                builder.append((CharSequence)"\n");
                continue;
            }
            if (!(node instanceof MMAddonMessage.NodeLabel) && !(node instanceof MMAddonMessage.NodeP) || (span = this.parseNodeStyle(node)) == null) continue;
            builder.append((CharSequence)span);
        }
        textView.setText((CharSequence)builder);
    }

    private SpannableString parseNodeStyle(MMAddonMessage.AddonNode node) {
        return this.parseNodeStyle(node, null);
    }

    private SpannableString parseNodeStyle(MMAddonMessage.AddonNode node, SpannableString span) {
        Node styleNode;
        NamedNodeMap map;
        if (node == null) {
            return null;
        }
        if (span == null) {
            span = new SpannableString((CharSequence)node.getValue());
        }
        if ((map = node.getAttrs()) != null && (styleNode = map.getNamedItem("style")) != null) {
            String styleMsg = styleNode.getNodeValue();
            Map<String, String> styleMap = this.parseStyleMsg(styleMsg);
            String color2 = styleMap.get("color");
            String font = styleMap.get("font-weight");
            if (!TextUtils.isEmpty((CharSequence)color2)) {
                try {
                    ForegroundColorSpan colorSpan = new ForegroundColorSpan(Color.parseColor((String)color2));
                    span.setSpan((Object)colorSpan, 0, span.length(), 33);
                }
                catch (Exception e) {
                    if ("orange".equalsIgnoreCase(color2)) {
                        ForegroundColorSpan colorSpan = new ForegroundColorSpan(Color.parseColor((String)"#FFA500"));
                        span.setSpan((Object)colorSpan, 0, span.length(), 33);
                    }
                    Log.e((String)MMMessageAddonView.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)font)) {
                StyleSpan styleSpan = new StyleSpan(0);
                if (font.equalsIgnoreCase("bold")) {
                    styleSpan = new StyleSpan(1);
                } else if (font.equalsIgnoreCase("ITALIC")) {
                    styleSpan = new StyleSpan(2);
                } else if (font.equalsIgnoreCase("BOLD_ITALIC")) {
                    styleSpan = new StyleSpan(3);
                }
                span.setSpan((Object)styleSpan, 0, span.length(), 33);
            }
        }
        return span;
    }

    private Map<String, String> parseStyleMsg(String msg) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return map;
        }
        String[] items = msg.split(";");
        if (items.length > 0) {
            for (String item : items) {
                String[] mapItem = item.split(":");
                if (mapItem.length != 2) continue;
                map.put(mapItem[0], mapItem[1]);
            }
        }
        return map;
    }

    public void setFooter(List<MMAddonMessage.AddonNode> nodes) {
        if (this.mTxtFooter == null) {
            return;
        }
        if (nodes == null || nodes.isEmpty()) {
            this.mTxtFooter.setText((CharSequence)"");
            this.mTxtFooter.setVisibility(8);
            return;
        }
        SpannableStringBuilder builder = new SpannableStringBuilder();
        for (MMAddonMessage.AddonNode node : nodes) {
            if (node instanceof MMAddonMessage.NodeFooter) {
                SpannableString span = this.parseNodeStyle(node);
                if (span == null) continue;
                builder.append((CharSequence)span);
                continue;
            }
            if (!(node instanceof MMAddonMessage.NodeBR) || builder.length() <= 0) continue;
            builder.append((CharSequence)"\n");
        }
        if (builder.length() > 0) {
            this.mTxtFooter.setVisibility(0);
            this.mTxtFooter.setText((CharSequence)builder);
        } else {
            this.mTxtFooter.setText((CharSequence)"");
            this.mTxtFooter.setVisibility(8);
        }
    }

    public void setTitle(int type, int imgId, String url, List<MMAddonMessage.AddonNode> list) {
        if (this.mImgIcon != null) {
            if (type > 0) {
                this.mImgIcon.setVisibility(0);
                this.mImgIcon.setImageResource(imgId);
            } else {
                this.mImgIcon.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)url)) {
                this.mImgIcon.setVisibility(0);
                this.mImgIcon.setImageBitmap(null);
                ImageLoader.getInstance().displayImage(this.mImgIcon, url);
            }
        }
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.zm_msg_addon_title_linear);
        linearLayout.removeAllViews();
        if (list != null) {
            for (MMAddonMessage.AddonNode node : list) {
                if (node instanceof MMAddonMessage.NodeLabel) {
                    SpannableString content = this.parseNodeStyle(node);
                    if (type > 0) {
                        this.addTitleLabel(content, R.color.zm_text_on_dark);
                        continue;
                    }
                    this.addTitleLabel(content, R.color.zm_addon_title_label_bg);
                    continue;
                }
                if (!(node instanceof MMAddonMessage.NodeMsgHref)) continue;
                SpannableString href = this.parseNodeStyle(node);
                if (type > 0) {
                    this.addTitleHref(href, (MMAddonMessage.NodeMsgHref)node, R.color.zm_text_on_dark);
                    continue;
                }
                this.addTitleHref(href, (MMAddonMessage.NodeMsgHref)node, R.color.zm_addon_title_label_bg);
            }
        }
    }

    private TextView addTitleLabel(SpannableString label, int defaultColor) {
        TextView textView = new TextView(this.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.rightMargin = UIUtil.dip2px((Context)this.getContext(), (float)5.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setSingleLine();
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setTextColor(this.getResources().getColor(defaultColor));
        textView.setText((CharSequence)label);
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.zm_msg_addon_title_linear);
        linearLayout.addView((View)textView);
        return textView;
    }

    private void addTitleHref(SpannableString href, MMAddonMessage.NodeMsgHref node, int defaultColor) {
        TextView textView = this.addTitleLabel(href, defaultColor);
        textView.setTag((Object)node);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbsMessageView.OnClickAddonListener l = MMMessageAddonView.this.getOnClickAddonListener();
                if (l != null) {
                    l.onClickAddon((MMAddonMessage.NodeMsgHref)v.getTag());
                }
            }
        });
    }

    public void setScreenName(String screenName) {
        if (screenName != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText((CharSequence)screenName);
        }
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    class ForegroundColorClickableSpan
    extends ClickableSpan {
        ForegroundColorSpan[] spans;
        MMAddonMessage.NodeMsgHref href;

        public ForegroundColorClickableSpan(ForegroundColorSpan[] spans, MMAddonMessage.NodeMsgHref href) {
            this.spans = spans;
            this.href = href;
        }

        public void updateDrawState(TextPaint ds) {
            if (this.spans == null || this.spans.length <= 0) {
                ds.setColor(ds.linkColor);
            } else {
                ds.setColor(this.spans[0].getForegroundColor());
            }
            ds.setUnderlineText(true);
        }

        public void onClick(View widget) {
            AbsMessageView.OnClickAddonListener l = MMMessageAddonView.this.getOnClickAddonListener();
            if (l != null) {
                l.onClickAddon(this.href);
            }
        }
    }
}

