/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomPublicRoomSearchData;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.mm.MMZoomXMPPRoom;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMJoinPublicGroupListView
extends ListView
implements AbsListView.OnScrollListener,
AdapterView.OnItemClickListener {
    private PublicGroupAdater mAdapter;
    private String mFilter;
    private static final int MAX_GROUPS_SIZE = 20;
    private OnItemSelectChangeListener mOnItemSelectChangeListener;
    private ArrayList<String> mCannotSelectGroups = new ArrayList();

    public MMJoinPublicGroupListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMJoinPublicGroupListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMJoinPublicGroupListView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mAdapter = new PublicGroupAdater(this.getContext());
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnScrollListener(this);
        this.setOnItemClickListener(this);
        this.updateCannotSelectGroups();
    }

    private void updateCannotSelectGroups() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        for (int i = 0; i < messenger.getGroupCount(); ++i) {
            ZoomGroup group = messenger.getGroupAt(i);
            if (group == null) continue;
            this.mCannotSelectGroups.add(group.getGroupID());
        }
    }

    public ArrayList<MMZoomXMPPRoom> getSelectGroups() {
        return this.mAdapter.getSelectGroups();
    }

    public boolean doSearchPublicGroups(String key) {
        if (StringUtil.isSameString((String)key, (String)this.mFilter)) {
            return false;
        }
        this.mFilter = key;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ZoomPublicRoomSearchData searchData = messenger.getPublicRoomSearchData();
        if (searchData == null) {
            return false;
        }
        boolean res = searchData.search(this.mFilter, 20);
        if (res) {
            this.mAdapter.clearAll();
            this.mAdapter.notifyDataSetChanged();
        }
        return res;
    }

    private void loadMore() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomPublicRoomSearchData searchData = messenger.getPublicRoomSearchData();
        if (searchData == null) {
            return;
        }
        if (searchData.hasMoreDataOnServerSide()) {
            searchData.getNextPage();
        }
    }

    public void onSearchResponse(int errCode, int fromIdx, int count) {
        if (errCode != 0 || count == 0) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomPublicRoomSearchData searchData = messenger.getPublicRoomSearchData();
        if (searchData == null) {
            return;
        }
        if (fromIdx == 0) {
            this.mAdapter.clearAll();
        }
        for (int i = fromIdx; i < searchData.getRoomCount(); ++i) {
            MMZoomXMPPRoom room = searchData.getZoomXMPPRoomAt(i);
            if (room == null || this.mCannotSelectGroups.contains(room.getJid())) continue;
            this.mAdapter.addItem(room);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void setOnItemSelectChangeListener(OnItemSelectChangeListener onItemSelectChangeListener) {
        this.mOnItemSelectChangeListener = onItemSelectChangeListener;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (firstVisibleItem != 0 && firstVisibleItem + visibleItemCount >= totalItemCount) {
            this.loadMore();
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mAdapter.onItemClick(position);
        this.mAdapter.notifyDataSetChanged();
        if (this.mOnItemSelectChangeListener != null) {
            this.mOnItemSelectChangeListener.onItemSelectChange();
        }
    }

    static class PublicGroupAdater
    extends BaseAdapter {
        private Context mContext;
        private ArrayList<MMZoomXMPPRoom> mGroups = new ArrayList();
        private ArrayList<MMZoomXMPPRoom> mSelectGroups = new ArrayList();

        public void addItems(List<MMZoomXMPPRoom> groups) {
            this.mGroups.addAll(groups);
        }

        public void addItem(MMZoomXMPPRoom group) {
            this.mGroups.add(group);
        }

        public void onItemClick(int position) {
            if (position < 0 || position >= this.mGroups.size()) {
                return;
            }
            MMZoomXMPPRoom group = this.mGroups.get(position);
            if (group != null) {
                if (this.mSelectGroups.contains(group)) {
                    this.mSelectGroups.remove(group);
                } else {
                    this.mSelectGroups.add(group);
                }
            }
        }

        public void clearAll() {
            this.mGroups.clear();
            this.mSelectGroups.clear();
        }

        public PublicGroupAdater(Context context) {
            this.mContext = context;
        }

        public int getCount() {
            return this.mGroups.size();
        }

        public MMZoomXMPPRoom getItem(int position) {
            return this.mGroups.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public ArrayList<MMZoomXMPPRoom> getSelectGroups() {
            return this.mSelectGroups;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_contacts_group_item, null);
            }
            MMZoomXMPPRoom group = this.getItem(position);
            AvatarView avatarView = (AvatarView)convertView.findViewById(R.id.avatarView);
            TextView txtGroupName = (TextView)convertView.findViewById(R.id.txtGroupName);
            txtGroupName.setText((CharSequence)(group.getName() + String.format("(%s)", group.getCount())));
            convertView.findViewById(R.id.txtGroupdes).setVisibility(8);
            avatarView.setVisibility(8);
            return convertView;
        }
    }

    public static interface OnItemSelectChangeListener {
        public void onItemSelectChange();
    }
}

