/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomPublicRoomSearchUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomPublicRoomSearchData;
import com.zipow.videobox.view.mm.MMJoinPublicGroupListView;
import com.zipow.videobox.view.mm.MMZoomXMPPRoom;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMJoinPublicGroupFragment
extends ZMDialogFragment
implements ZoomPublicRoomSearchUI.IZoomPublicRoomSearchUIListener,
View.OnClickListener,
TextView.OnEditorActionListener,
SimpleActivity.ExtListener,
MMJoinPublicGroupListView.OnItemSelectChangeListener {
    public static final String RESULT_ARG_SELECTED_ITEMS = "selectItems";
    private MMJoinPublicGroupListView mGroupListView;
    private EditText mEdtSearch;
    private EditText mEdtSearchDummy;
    private FrameLayout mListContainer;
    private Button mBtnClearSearchView;
    private Button mBtnSearch;
    private Drawable mDimmedForground = null;
    private View mPanelNoItemMsg;
    private View mPanelTitleBar;
    private View mPanelSearchBar;
    private ProgressDialog mProgressDialog;

    public static void showAsActivity(Fragment fragment, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMJoinPublicGroupFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_join_public_group, container, false);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mGroupListView = (MMJoinPublicGroupListView)view.findViewById(R.id.groupListView);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mBtnSearch = (Button)view.findViewById(R.id.btnSearch);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mEdtSearchDummy = (EditText)view.findViewById(R.id.edtSearchDummy);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        this.mGroupListView.setOnItemSelectChangeListener(this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                MMJoinPublicGroupFragment.this.updateSearchButtons();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mBtnSearch.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        view.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        ZoomPublicRoomSearchUI.getInstance().addListener(this);
        this.doSearchGroups("");
        return view;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            this.doSearchGroups(this.mEdtSearch.getText().toString());
            return true;
        }
        return false;
    }

    public void onDestroyView() {
        ZoomPublicRoomSearchUI.getInstance().removeListener(this);
        super.onDestroyView();
    }

    @Override
    public void onSearchResponse(int errCode, int fromIdx, int count) {
        this.mGroupListView.onSearchResponse(errCode, fromIdx, count);
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
            this.mProgressDialog = null;
        }
        if (this.mGroupListView.getEmptyView() == null) {
            this.mGroupListView.setEmptyView(this.mPanelNoItemMsg);
        }
    }

    @Override
    public void onJoinRoom(String roomId, int errCode) {
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnCancel) {
            this.dismiss();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnSearch) {
            this.onClickBtnSearch();
        }
    }

    public void onDestroy() {
        ZoomPublicRoomSearchData searchData;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (searchData = messenger.getPublicRoomSearchData()) != null) {
            searchData.cancelSearch();
        }
        super.onDestroy();
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    private void onClickBtnSearch() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.doSearchGroups(this.mEdtSearch.getText().toString());
    }

    private void doSearchGroups(String key) {
        if (this.mGroupListView.doSearchPublicGroups(key)) {
            this.mProgressDialog = UIUtil.showSimpleWaitingDialog((Activity)this.getActivity(), (int)R.string.zm_msg_waiting);
        }
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearchDummy.hasFocus()) {
            this.mEdtSearchDummy.setVisibility(8);
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelSearchBar.setVisibility(0);
            this.mListContainer.setForeground(this.mDimmedForground);
            this.mEdtSearch.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearchDummy.setVisibility(0);
        this.mPanelSearchBar.setVisibility(4);
        this.mListContainer.setForeground(null);
        this.mPanelTitleBar.setVisibility(0);
        this.mGroupListView.post(new Runnable(){

            @Override
            public void run() {
                MMJoinPublicGroupFragment.this.mGroupListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearchDummy.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    private void updateSearchButtons() {
        if (this.mEdtSearch.getText().length() > 0) {
            this.mBtnClearSearchView.setVisibility(0);
            this.mBtnSearch.setVisibility(0);
        } else {
            this.mBtnClearSearchView.setVisibility(8);
            this.mBtnSearch.setVisibility(8);
        }
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    @Override
    public void onItemSelectChange() {
        ArrayList<MMZoomXMPPRoom> groups = this.mGroupListView.getSelectGroups();
        if (groups != null && groups.size() > 0) {
            Intent data = new Intent();
            data.putExtra(RESULT_ARG_SELECTED_ITEMS, groups);
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.setResult(-1, data);
            }
            this.dismiss();
        }
    }
}

