/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.mm.MMImageViewPage;
import com.zipow.videobox.view.mm.MMImageViewPagerAdapter;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMViewPager;

public class MMImageViewPager
extends ZMViewPager {
    private static final String TAG = MMImageViewPager.class.getSimpleName();
    private MMImageViewPagerAdapter mPagerAdapter = null;
    private String mSessionId = null;
    private ImageViewAdapter mImageViewAdapter = null;
    private int mCurPageIndex = 0;

    public MMImageViewPager(Context context) {
        super(context);
        this.initView(context);
    }

    public MMImageViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public void setImageViewAdapter(ImageViewAdapter adapter) {
        this.mImageViewAdapter = adapter;
    }

    private void initView(Context context) {
        if (!(context instanceof ZMActivity)) {
            return;
        }
        this.mPagerAdapter = new MMImageViewPagerAdapter(((ZMActivity)context).getSupportFragmentManager(), this);
        this.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.setOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                MMImageViewPager.this.onPageSelected(position);
            }
        });
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mImageViewAdapter == null || !this.mImageViewAdapter.onInterceptTouchEvent(event)) {
            return super.onTouchEvent(event);
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.mImageViewAdapter == null || !this.mImageViewAdapter.onInterceptTouchEvent(event)) {
            return super.onInterceptTouchEvent(event);
        }
        return false;
    }

    private void onPageSelected(int position) {
        MMImageViewPage page = (MMImageViewPage)this.mPagerAdapter.getItem(position);
        String messageId = page.getMessageId();
        if (messageId == null) {
            this.setCurrentItem(this.mCurPageIndex, true);
            return;
        }
        String prevImageMessageId = this.getPreviousImageMessageId(messageId);
        MMImageViewPage page0 = (MMImageViewPage)this.mPagerAdapter.getItem(position - 1);
        page0.setImageMessage(this.mSessionId, prevImageMessageId);
        String nextImageMessageId = this.getNextImageMessageId(messageId);
        MMImageViewPage page2 = (MMImageViewPage)this.mPagerAdapter.getItem(position + 1);
        page2.setImageMessage(this.mSessionId, nextImageMessageId);
        this.mCurPageIndex = position;
        if (!page.isFullSizeImage() && !StringUtil.isEmptyOrNull((String)messageId)) {
            this.downloadImage(this.mSessionId, messageId);
        }
        if (this.mImageViewAdapter != null) {
            this.mImageViewAdapter.onPageChanged();
        }
    }

    public void downloadImage(String sessionId, String messageId) {
        if (this.mImageViewAdapter != null) {
            this.mImageViewAdapter.downloadImage(sessionId, messageId);
        }
    }

    public void onImageDownloaded(String sessionId, String messageId) {
        if (!StringUtil.isSameString((String)this.mSessionId, (String)sessionId)) {
            return;
        }
        for (int i = this.mCurPageIndex - 1; i <= this.mCurPageIndex + 1; ++i) {
            MMImageViewPage page = (MMImageViewPage)this.mPagerAdapter.getItem(i);
            if (!StringUtil.isSameString((String)page.getMessageId(), (String)messageId)) continue;
            page.loadImage(sessionId, messageId);
            break;
        }
    }

    public void onStartDownloadingImage(String sessionId, String messageId) {
        if (!StringUtil.isSameString((String)this.mSessionId, (String)sessionId)) {
            return;
        }
        for (int i = this.mCurPageIndex - 1; i <= this.mCurPageIndex + 1; ++i) {
            MMImageViewPage page = (MMImageViewPage)this.mPagerAdapter.getItem(i);
            if (!StringUtil.isSameString((String)page.getMessageId(), (String)messageId)) continue;
            page.onStartDownloadingImage();
            break;
        }
    }

    public void onDownloadImageFailed(String sessionId, String messageId) {
        if (!StringUtil.isSameString((String)this.mSessionId, (String)sessionId)) {
            return;
        }
        for (int i = this.mCurPageIndex - 1; i <= this.mCurPageIndex + 1; ++i) {
            MMImageViewPage page = (MMImageViewPage)this.mPagerAdapter.getItem(i);
            if (!StringUtil.isSameString((String)page.getMessageId(), (String)messageId)) continue;
            page.onDownloadImageFailed();
            break;
        }
    }

    public boolean loadImage(String sessionId, String messageId) {
        this.mSessionId = sessionId;
        this.mCurPageIndex = this.mPagerAdapter.getCount() / 2;
        MMImageViewPage page1 = (MMImageViewPage)this.mPagerAdapter.getItem(this.mCurPageIndex);
        boolean ret = page1.loadImage(sessionId, messageId);
        String prevImageMessageId = this.getPreviousImageMessageId(messageId);
        MMImageViewPage page0 = (MMImageViewPage)this.mPagerAdapter.getItem(this.mCurPageIndex - 1);
        page0.setImageMessage(sessionId, prevImageMessageId);
        String nextImageMessageId = this.getNextImageMessageId(messageId);
        MMImageViewPage page2 = (MMImageViewPage)this.mPagerAdapter.getItem(this.mCurPageIndex + 1);
        page2.setImageMessage(sessionId, nextImageMessageId);
        this.setCurrentItem(this.mCurPageIndex, false);
        return ret;
    }

    public String getCurrentImageFilePath() {
        MMImageViewPage page = (MMImageViewPage)this.mPagerAdapter.getItem(this.mCurPageIndex);
        if (page == null) {
            return "";
        }
        return page.getImageFilePath();
    }

    public String getCurrentImageMessageId() {
        MMImageViewPage page = (MMImageViewPage)this.mPagerAdapter.getItem(this.mCurPageIndex);
        if (page == null) {
            return "";
        }
        return page.getMessageId();
    }

    public boolean isCurrentImageFullSize() {
        MMImageViewPage page = (MMImageViewPage)this.mPagerAdapter.getItem(this.mCurPageIndex);
        if (page == null) {
            return false;
        }
        return page.isFullSizeImage();
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        MMImageViewPage page0;
        MMImageViewPage page2;
        if (v instanceof MMImageViewPager && (dx < 0 ? StringUtil.isEmptyOrNull((String)(page2 = (MMImageViewPage)this.mPagerAdapter.getItem(this.mCurPageIndex + 1)).getMessageId()) : StringUtil.isEmptyOrNull((String)(page0 = (MMImageViewPage)this.mPagerAdapter.getItem(this.mCurPageIndex - 1)).getMessageId()))) {
            return true;
        }
        return super.canScroll(v, checkV, dx, x, y);
    }

    private String getPreviousImageMessageId(String curMessageId) {
        int nId;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return null;
        }
        ZoomMessage oldestMessageInMemory = session.getMessageByIndex(0);
        try {
            nId = Integer.parseInt(curMessageId) - 1;
        }
        catch (NumberFormatException e) {
            return null;
        }
        while (nId >= 0) {
            ZoomMessage message = session.getMessageById(String.valueOf(nId));
            if (message == null) {
                if (oldestMessageInMemory == null) break;
                int nOldestId = -1;
                try {
                    nOldestId = Integer.parseInt(oldestMessageInMemory.getMessageID());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                if (nOldestId > nId) {
                    ArrayList<ZoomMessage> messages = new ArrayList<ZoomMessage>();
                    int countNew = session.getMessages(messages, session.getMessageCount(), 10);
                    if (countNew <= 0) break;
                    oldestMessageInMemory = session.getMessageByIndex(0);
                    continue;
                }
                --nId;
                continue;
            }
            switch (message.getMessageType()) {
                case 1: 
                case 5: 
                case 6: {
                    return String.valueOf(nId);
                }
                case 10: {
                    AndroidAppUtil.MimeType mimeType;
                    ZoomMessage.FileInfo fileInfo = message.getFileInfo();
                    if (fileInfo == null || (mimeType = AndroidAppUtil.getMimeTypeOfFile((String)fileInfo.name)) == null || mimeType.fileType != 3 || "image/gif".equals(mimeType.mimeType)) break;
                    return String.valueOf(nId);
                }
            }
            --nId;
        }
        return null;
    }

    private String getNextImageMessageId(String curMessageId) {
        int nId;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return null;
        }
        int maxMessageId = this.getMaxMessageId(session);
        try {
            nId = Integer.parseInt(curMessageId) + 1;
        }
        catch (NumberFormatException e) {
            return null;
        }
        while (nId <= maxMessageId) {
            ZoomMessage message = session.getMessageById(String.valueOf(nId));
            if (message == null) {
                ++nId;
                continue;
            }
            switch (message.getMessageType()) {
                case 1: 
                case 5: 
                case 6: {
                    return String.valueOf(nId);
                }
                case 10: {
                    AndroidAppUtil.MimeType mimeType;
                    ZoomMessage.FileInfo fileInfo = message.getFileInfo();
                    if (fileInfo == null || (mimeType = AndroidAppUtil.getMimeTypeOfFile((String)fileInfo.name)) == null || mimeType.fileType != 3 || "image/gif".equals(mimeType.mimeType)) break;
                    return String.valueOf(nId);
                }
            }
            ++nId;
        }
        return null;
    }

    private int getMaxMessageId(ZoomChatSession session) {
        ZoomMessage message = session.getMessageByIndex(session.getMessageCount() - 1);
        if (message != null) {
            try {
                return Integer.parseInt(message.getMessageID());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static interface ImageViewAdapter {
        public void downloadImage(String var1, String var2);

        public boolean onInterceptTouchEvent(MotionEvent var1);

        public void onPageChanged();
    }
}

