/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageLoader;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.ZMGifView;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.io.File;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMGiphyView
extends AbsMessageView {
    protected AvatarView mAvatarView;
    protected TextView mAvatarName;
    protected ZMGifView mGifView;
    protected TextView mGiphyMsgName;
    protected MMMessageItem mMessageItem;
    protected View mProgress;

    public MMGiphyView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMGiphyView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMGiphyView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mProgress = this.findViewById(R.id.giphy_panel_progress);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.giphy_avatar);
        this.mAvatarName = (TextView)this.findViewById(R.id.giphy_avatar_name);
        this.mGifView = (ZMGifView)this.findViewById(R.id.giphy_gifView);
        this.mGifView.setRadius(UIUtil.dip2px((Context)this.getContext(), (float)10.0f));
        this.mGifView.setmScale(1.2f);
        this.mGiphyMsgName = (TextView)this.findViewById(R.id.giphy_message_name);
        this.mGifView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.mGifView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                AbsMessageView.OnShowContextMenuListener listener = MMGiphyView.this.getOnShowContextMenuListener();
                if (listener != null) {
                    listener.onShowContextMenu(MMGiphyView.this.mMessageItem);
                }
                return true;
            }
        });
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_giphy_from, (ViewGroup)this);
    }

    public void setScreenName(String screenName) {
        if (screenName != null && this.mAvatarName != null) {
            this.mAvatarName.setText((CharSequence)screenName);
        }
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    public void setMessageName(String name) {
        if (this.mGiphyMsgName != null) {
            this.mGiphyMsgName.setText((CharSequence)name);
        }
    }

    public void setMessageItem(MMMessageItem item) {
        this.mProgress.setVisibility(0);
        this.mGifView.setVisibility(8);
        this.mMessageItem = item;
        this.setMessageName(String.valueOf(item.message));
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(item.fromScreenName);
            this.mAvatarView.setBgColorSeedString(item.fromJid);
            this.mAvatarView.setVisibility(0);
        }
        if (this.mAvatarName != null) {
            this.mAvatarName.setVisibility(0);
        }
        this.setScreenName(item.fromScreenName);
        if (!this.isInEditMode()) {
            String fromJid = item.fromJid;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null) {
                PTAppProtos.GiphyMsgInfo info;
                File file;
                String phoneNumber = null;
                ZoomBuddy buddy = null;
                ZoomBuddy myself = messenger.getMyself();
                if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                    buddy = myself;
                } else {
                    buddy = messenger.getBuddyWithJID(fromJid);
                    if (buddy != null) {
                        phoneNumber = buddy.getPhoneNumber();
                    }
                }
                String avatarPath = null;
                if (buddy != null) {
                    avatarPath = buddy.getLocalPicturePath();
                }
                boolean hasAvatarFile = false;
                if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                    this.setAvatar(avatarPath);
                    hasAvatarFile = true;
                }
                if (!hasAvatarFile) {
                    if (item.fromContact == null && phoneNumber != null && buddy != null) {
                        item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                    }
                    if (item.fromContact != null) {
                        this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                    } else {
                        this.setAvatar((String)null);
                    }
                }
                if ((info = messenger.getGiphyInfo(item.giphyID)) != null) {
                    int netWorkType = NetworkUtil.getDataNetworkType((Context)this.getContext());
                    if (netWorkType == 1 || netWorkType == 4 || netWorkType == 3) {
                        ImageLoader.getInstance().displayGif(this.mGifView, this.mProgress, info.getPcUrl());
                    } else {
                        File cacheFile = ImageLoader.getInstance().getCacheFile(info.getPcUrl());
                        if (cacheFile != null && cacheFile.exists()) {
                            ImageLoader.getInstance().displayGif(this.mGifView, this.mProgress, info.getPcUrl());
                        } else {
                            ImageLoader.getInstance().displayGif(this.mGifView, this.mProgress, info.getMobileUrl());
                        }
                    }
                }
            }
        }
    }
}

