/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.zipow.videobox.fragment.MMChatFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.mm.MMContentMessageItem;
import com.zipow.videobox.view.mm.MMContentSearchMessagesAdapter;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.PullDownRefreshListView;

public class MMContentSearchMessagesListView
extends PullDownRefreshListView
implements AbsListView.OnScrollListener,
AdapterView.OnItemClickListener {
    private MMContentSearchMessagesAdapter mAdapter;
    private ZMDialogFragment mParentFragment;
    private static final int MAX_COUNT_PER_PAGE = 50;
    private static final String TAG = MMContentSearchMessagesListView.class.getName();
    private String mFilter;
    private int mPageNum = 1;
    private MemCache<String, Drawable> mAvatarCache = new MemCache(10);
    private RetainedFragment mRetainedFragment;
    private String mSearchMsgReqId;
    private int mResultCode = 1;

    public MMContentSearchMessagesListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMContentSearchMessagesListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMContentSearchMessagesListView(Context context) {
        super(context);
        this.init();
    }

    public void setParentFragment(ZMDialogFragment fragment) {
        this.mParentFragment = fragment;
    }

    public boolean isResultEmpty() {
        if (this.mAdapter == null) {
            return true;
        }
        return this.mAdapter.getCount() <= 0;
    }

    public void setFilter(String filter, String sessionId) {
        if (StringUtil.isEmptyOrNull((String)filter) || filter.trim().length() == 0) {
            return;
        }
        this.mFilter = filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        this.searchMessage(sessionId);
    }

    public void searchMessage(String sessionId) {
        String reqId;
        ZoomChatSession session;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        PTAppProtos.MessageContentSearchFilter.Builder searchFilterBuilder = PTAppProtos.MessageContentSearchFilter.newBuilder();
        searchFilterBuilder.setKeyWord(this.mFilter == null ? "" : this.mFilter);
        searchFilterBuilder.setPageNum(this.mPageNum);
        searchFilterBuilder.setPageSize(50);
        PTAppProtos.MessageSenderFilter.Builder builder = PTAppProtos.MessageSenderFilter.newBuilder();
        if (!TextUtils.isEmpty((CharSequence)sessionId) && (session = messenger.getSessionById(sessionId)) != null) {
            boolean isGroup = session.isGroup();
            if (isGroup) {
                builder.setSessionId(sessionId);
                builder.setType(1);
                builder.setOnlyP2P(false);
            } else {
                builder.setSenderJid(sessionId);
                builder.setOnlyP2P(true);
                builder.setType(2);
            }
            searchFilterBuilder.addSenderInfo(builder.build());
        }
        if (!StringUtil.isEmptyOrNull((String)(reqId = messenger.searchMessageContent(searchFilterBuilder.build())))) {
            this.mSearchMsgReqId = reqId;
            this.mAdapter.clearAll();
            this.mAdapter.notifyDataSetChanged();
        } else {
            this.mResultCode = 1;
        }
    }

    public void Indicate_MessageContentSearchResult(String reqID, int result, PTAppProtos.MessageContentSearchResponse response) {
        if (StringUtil.isSameString((String)this.mSearchMsgReqId, (String)reqID)) {
            this.mSearchMsgReqId = null;
            this.mResultCode = result;
            if (result != 0) {
                return;
            }
            this.mAdapter.addSearchedFiles(response);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public boolean isEmpty() {
        if (this.mAdapter == null) {
            return true;
        }
        return this.mAdapter.getCount() == 0;
    }

    public boolean isLoading() {
        return this.mSearchMsgReqId != null;
    }

    public boolean isLoadSuccess() {
        return this.mSearchMsgReqId == null && this.mResultCode == 0;
    }

    public boolean isSearchResultEmpty() {
        return !this.isRefreshing() && !StringUtil.isEmptyOrNull((String)this.mFilter) && this.mAdapter.getCount() == 0;
    }

    public void reset() {
        this.mSearchMsgReqId = null;
        this.mFilter = null;
        this.mPageNum = 1;
        this.mAdapter.clearAll();
    }

    private void init() {
        this.mAdapter = new MMContentSearchMessagesAdapter(this.getContext());
        this.mAdapter.setAvatarCache(this.mAvatarCache);
        this.setOnScrollListener(this);
        this.setOnItemClickListener(this);
        this.setPullDownRefreshEnabled(false);
        if (!this.isInEditMode()) {
            this.initRetainedFragment();
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putString("mSearchMsgReqId", this.mSearchMsgReqId);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state != null && state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mSearchMsgReqId = bundle.getString("mSearchMsgReqId");
            Parcelable superState = bundle.getParcelable("superState");
            super.onRestoreInstanceState(superState);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public void loadData(boolean isForceLoad) {
    }

    public void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (firstVisibleItem <= 0 || visibleItemCount + firstVisibleItem != totalItemCount || StringUtil.isEmptyOrNull((String)this.mSearchMsgReqId)) {
            // empty if block
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        MMContentMessageItem item = this.mAdapter.getItem(position - this.getHeaderViewsCount());
        if (item == null) {
            return;
        }
        MMContentMessageItem.MMContentMessageAnchorInfo info = new MMContentMessageItem.MMContentMessageAnchorInfo();
        info.setMsgGuid(item.getMsgId());
        info.setSendTime(item.getSendTime());
        if (item.isGroup()) {
            info.setSessionId(item.getSessionId());
        } else {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            if (!StringUtil.isSameString((String)myself.getJid(), (String)item.getSessionId())) {
                info.setSessionId(item.getSessionId());
            } else if (!StringUtil.isSameString((String)myself.getJid(), (String)item.getSenderJid())) {
                info.setSessionId(item.getSenderJid());
            } else {
                return;
            }
        }
        MMChatFragment.showMsgContextInActivity((Fragment)this.mParentFragment, info);
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            this.mRetainedFragment.saveMMContentSearchMessagesAdapter(this.mAdapter);
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        } else {
            MMContentSearchMessagesAdapter adapter = this.mRetainedFragment.restoreMMContentSearchMessagesAdapter();
            if (adapter != null) {
                this.mAdapter = adapter;
            }
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
        return retainedFragment;
    }

    public static class RetainedFragment
    extends ZMFragment {
        private MMContentSearchMessagesAdapter mAdapter = null;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void saveMMContentSearchMessagesAdapter(MMContentSearchMessagesAdapter adapter) {
            this.mAdapter = adapter;
        }

        public MMContentSearchMessagesAdapter restoreMMContentSearchMessagesAdapter() {
            return this.mAdapter;
        }
    }
}

