/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.view.mm.MMContentSearchFilesAdapter;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import com.zipow.videobox.view.mm.OnContentFileOperatorListener;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.PullDownRefreshListView;

public class MMContentSearchFilesListView
extends PullDownRefreshListView
implements AbsListView.OnScrollListener,
AdapterView.OnItemClickListener,
OnContentFileOperatorListener {
    private MMContentSearchFilesAdapter mAdapter;
    private static final int MAX_COUNT_PER_PAGE = 50;
    private static final String TAG = MMContentSearchFilesListView.class.getName();
    private String mFilter;
    private OnContentFileOperatorListener mListener;
    private RetainedFragment mRetainedFragment;
    private String mReqId;
    private boolean mIsOwnerMode;
    private int mPageNum = 1;
    private int mResultCode = 1;

    public MMContentSearchFilesListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMContentSearchFilesListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMContentSearchFilesListView(Context context) {
        super(context);
        this.init();
    }

    public boolean isResultEmpty() {
        if (this.mAdapter == null) {
            return true;
        }
        return this.mAdapter.getCount() <= 0;
    }

    public void setIsOwnerMode(boolean isOwnerMode) {
        this.mIsOwnerMode = isOwnerMode;
    }

    public void setFilter(String filter, String sessionId) {
        if (StringUtil.isEmptyOrNull((String)filter) || filter.trim().length() == 0) {
            return;
        }
        this.mFilter = filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        this.searchContent(sessionId);
    }

    public void searchContent(String sessionId) {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        PTAppProtos.FileSearchFilter.Builder filterBuilder = PTAppProtos.FileSearchFilter.newBuilder();
        filterBuilder.setKeyWord(this.mFilter == null ? "" : this.mFilter);
        filterBuilder.setPageNum(this.mPageNum);
        filterBuilder.setPageSize(50);
        if (!TextUtils.isEmpty((CharSequence)sessionId)) {
            filterBuilder.setSessionId(sessionId);
        }
        String reqId = null;
        reqId = this.mIsOwnerMode ? mgr.searchOwnerFilesContent(filterBuilder.build()) : mgr.searchAllFilesContent(filterBuilder.build());
        if (!StringUtil.isEmptyOrNull((String)reqId)) {
            this.mReqId = reqId;
            this.mAdapter.clearAll();
            this.mAdapter.notifyDataSetChanged();
        } else {
            this.mResultCode = 1;
        }
    }

    public boolean isSearchResultEmpty() {
        return !this.isRefreshing() && !StringUtil.isEmptyOrNull((String)this.mFilter) && this.mAdapter.getCount() == 0;
    }

    public void setListener(OnContentFileOperatorListener listener) {
        this.mListener = listener;
    }

    public void endFileTransfer(String webFileId) {
        this.mAdapter.endFileTransfer(webFileId);
    }

    public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
        if (this.mAdapter.containsFile(webFileID) && result == 0) {
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return;
            }
            ZoomFile file = mgr.getFileWithWebFileID(webFileID);
            if (file == null) {
                return;
            }
            this.mAdapter.Indicate_PreviewDownloaded(MMZoomFile.initWithZoomFile(file, mgr));
        }
    }

    private void init() {
        this.mAdapter = new MMContentSearchFilesAdapter(this.getContext(), this.mIsOwnerMode);
        this.mAdapter.setParentListView(this);
        this.setOnScrollListener(this);
        this.setOnItemClickListener(this);
        this.setPullDownRefreshEnabled(false);
        if (!this.isInEditMode()) {
            this.initRetainedFragment();
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void Indicate_FileDeleted(String reqID, String webFileID, int result) {
        this.mAdapter.Indicate_FileDeleted(reqID, webFileID, result);
    }

    public void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        this.mAdapter.updateZoomFile(webFileID);
    }

    public void Indicate_FileUnshared(String reqId, String webFileID, int result) {
        this.mAdapter.updateZoomFile(webFileID);
    }

    public void Indicate_FileContentSearchResult(String reqID, int result, PTAppProtos.FileFilterSearchResults response) {
        if (StringUtil.isSameString((String)reqID, (String)this.mReqId)) {
            this.mReqId = null;
            this.mResultCode = result;
            if (result != 0 || response == null) {
                return;
            }
            this.mAdapter.addSearchedFiles(response);
            this.mAdapter.notifyDataSetChanged();
            this.downloadImgPreview(response);
        }
    }

    public boolean isEmpty() {
        if (this.mAdapter == null) {
            return true;
        }
        return this.mAdapter.getCount() == 0;
    }

    public boolean isLoading() {
        return this.mReqId != null;
    }

    public boolean isLoadSuccess() {
        return this.mReqId == null && this.mResultCode == 0;
    }

    private void downloadImgPreview(PTAppProtos.FileFilterSearchResults response) {
        if (response == null || response.getSearchResultCount() == 0) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        for (PTAppProtos.FileFilterSearchResult result : response.getSearchResultList()) {
            mgr.downloadImgPreview(result.getFileId());
        }
    }

    public void reset() {
        this.mReqId = null;
        this.mIsOwnerMode = false;
        this.mFilter = null;
        this.mPageNum = 1;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putString("reqId", this.mReqId);
        bundle.putBoolean("ownerMode", this.mIsOwnerMode);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state != null && state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mReqId = bundle.getString("reqId");
            this.mIsOwnerMode = bundle.getBoolean("ownerMode");
            Parcelable superState = bundle.getParcelable("superState");
            super.onRestoreInstanceState(superState);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (firstVisibleItem <= 0 || visibleItemCount + firstVisibleItem != totalItemCount || StringUtil.isEmptyOrNull((String)this.mReqId)) {
            // empty if block
        }
    }

    public void onPullDownRefresh() {
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        MMZoomFile file = this.mAdapter.getItemAtPosition(position - this.getHeaderViewsCount());
        if (file == null) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onZoomFileClick(file.getWebID());
        }
    }

    @Override
    public void onZoomFileShared(String fileId) {
        if (this.mListener != null) {
            this.mListener.onZoomFileShared(fileId);
        }
    }

    @Override
    public void onZoomFileCancelTransfer(String fileId) {
        if (this.mListener != null) {
            this.mListener.onZoomFileCancelTransfer(fileId);
        }
    }

    @Override
    public void onZoomFileSharerAction(String fileId, MMZoomShareAction action) {
        if (this.mListener != null) {
            this.mListener.onZoomFileSharerAction(fileId, action);
        }
    }

    @Override
    public void onZoomFileClick(String fileId) {
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            this.mRetainedFragment.saveMMContentSearchFilesAdapter(this.mAdapter);
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        } else {
            MMContentSearchFilesAdapter adapter = this.mRetainedFragment.restoreMMContentSearchFilesAdapter();
            if (adapter != null) {
                this.mAdapter = adapter;
            }
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
        return retainedFragment;
    }

    public static class RetainedFragment
    extends ZMFragment {
        private MMContentSearchFilesAdapter mAdapter = null;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void saveMMContentSearchFilesAdapter(MMContentSearchFilesAdapter adapter) {
            this.mAdapter = adapter;
        }

        public MMContentSearchFilesAdapter restoreMMContentSearchFilesAdapter() {
            return this.mAdapter;
        }
    }
}

