/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.GroupAvatarDrawable_v2;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.PresenceStateView;
import java.io.File;
import java.io.Serializable;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.videomeetings.R;

public class MMContentMessageItem {
    private String msgId;
    private String sessionId;
    private String senderJid;
    private String senderName;
    private long sendTime;
    private String keyWord;
    private CharSequence content;
    private IMAddrBookItem addrbookItem;
    private boolean isGroup;
    private String screenName;

    public static MMContentMessageItem initWithZoomMessage(ZoomMessage msg, String sessionId, Context context) {
        if (msg == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        MMContentMessageItem item = new MMContentMessageItem();
        item.msgId = msg.getMessageID();
        item.sessionId = sessionId;
        item.senderJid = msg.getSenderID();
        item.senderName = msg.getSenderName();
        item.sendTime = msg.getStamp();
        item.screenName = item.senderName;
        if (!StringUtil.isSameString((String)item.sessionId, (String)item.senderJid)) {
            ZoomChatSession session = messenger.getSessionById(item.sessionId);
            if (session != null && session.isGroup()) {
                item.isGroup = true;
                ZoomGroup group = session.getSessionGroup();
                if (group == null) {
                    return null;
                }
                item.screenName = group.getGroupDisplayName(context);
            } else if (messenger.getBuddyWithJID(item.sessionId) != null) {
                item.isGroup = false;
            } else {
                return null;
            }
        }
        if (!item.isGroup) {
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return null;
            }
            String jid = myself.getJid();
            ZoomBuddy buddy = null;
            if (!StringUtil.isSameString((String)jid, (String)sessionId)) {
                buddy = messenger.getBuddyWithJID(sessionId);
            } else if (!StringUtil.isSameString((String)jid, (String)item.getSenderJid())) {
                buddy = messenger.getBuddyWithJID(item.getSenderJid());
            } else {
                return null;
            }
            if (buddy != null) {
                item.addrbookItem = IMAddrBookItem.fromZoomBuddy(buddy);
            }
        }
        return item;
    }

    public static MMContentMessageItem initWithFileFilterSearchResult(PTAppProtos.MessageSearchResult result, Context context) {
        if (context == null || result == null || StringUtil.isEmptyOrNull((String)result.getMsgId())) {
            return null;
        }
        MMContentMessageItem item = new MMContentMessageItem();
        item.msgId = result.getMsgId();
        item.sessionId = result.getSessionId();
        item.senderJid = result.getSenderJid();
        item.senderName = result.getSenderName();
        item.sendTime = result.getSendTime();
        item.keyWord = result.getKeyWord();
        item.content = result.getContent();
        item.screenName = item.senderName;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        if (!StringUtil.isSameString((String)item.sessionId, (String)item.senderJid)) {
            ZoomChatSession session = messenger.getSessionById(item.sessionId);
            if (session != null && session.isGroup()) {
                item.isGroup = true;
                ZoomGroup group = session.getSessionGroup();
                if (group == null) {
                    return null;
                }
                item.screenName = group.getGroupDisplayName(context);
            } else if (messenger.getBuddyWithJID(item.sessionId) != null) {
                item.isGroup = false;
            } else {
                return null;
            }
        }
        if (!item.isGroup) {
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return item;
            }
            String jid = myself.getJid();
            ZoomBuddy buddy = null;
            if (!StringUtil.isSameString((String)jid, (String)item.getSessionId())) {
                buddy = messenger.getBuddyWithJID(item.getSessionId());
            } else if (!StringUtil.isSameString((String)jid, (String)item.getSenderJid())) {
                buddy = messenger.getBuddyWithJID(item.getSenderJid());
                item.sessionId = item.getSenderJid();
            } else {
                return null;
            }
            if (buddy != null) {
                item.addrbookItem = IMAddrBookItem.fromZoomBuddy(buddy);
            }
        }
        SpannableStringBuilder spBuilder = new SpannableStringBuilder(item.getContent());
        ForegroundColorSpan span = new ForegroundColorSpan(context.getResources().getColor(R.color.zm_highlight));
        for (PTAppProtos.HighlightPositionItem pItem : result.getHighlightPosList()) {
            spBuilder.setSpan((Object)span, pItem.getStart(), pItem.getEnd(), 33);
        }
        item.content = spBuilder;
        return item;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getSenderJid() {
        return this.senderJid;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public CharSequence getContent() {
        return this.content;
    }

    public View getView(Context context, int position, View convertView, ViewGroup parent, String myJid, MemCache<String, Drawable> avatarCache) {
        if (convertView == null) {
            convertView = View.inflate((Context)context, (int)R.layout.zm_mm_chats_list_item, null);
            convertView.setTag((Object)this);
        }
        AvatarView avatarView = (AvatarView)convertView.findViewById(R.id.avatarView);
        TextView txtTitle = (TextView)convertView.findViewById(R.id.txtTitle);
        TextView txtMessage = (TextView)convertView.findViewById(R.id.txtMessage);
        TextView txtTime = (TextView)convertView.findViewById(R.id.txtTime);
        TextView txtNoteBubble = (TextView)convertView.findViewById(R.id.txtNoteBubble);
        PresenceStateView imgPresence = (PresenceStateView)convertView.findViewById(R.id.imgPresence);
        ImageView imgE2EFlag = (ImageView)convertView.findViewById(R.id.imgE2EFlag);
        if (avatarView != null) {
            avatarView.setName(this.getSenderName());
            avatarView.setBgColorSeedString(this.getSessionId());
        }
        if (txtTitle != null) {
            if (!this.isGroup && StringUtil.isSameString((String)myJid, (String)this.getSenderJid())) {
                ZoomBuddy receiver;
                String sessionId = this.getSessionId();
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger != null && (receiver = messenger.getBuddyWithJID(sessionId)) != null) {
                    txtTitle.setText((CharSequence)receiver.getScreenName());
                }
            } else {
                txtTitle.setText((CharSequence)this.getScreenName());
            }
        }
        if (txtMessage != null) {
            if (this.isGroup()) {
                if (StringUtil.isSameString((String)myJid, (String)this.getSenderJid())) {
                    txtMessage.setText(this.getContent());
                } else {
                    txtMessage.setText(TextUtils.concat((CharSequence[])new CharSequence[]{this.senderName, ": ", this.getContent()}));
                }
            } else {
                txtMessage.setText(this.getContent());
            }
        }
        if (txtTime != null && !txtTime.isInEditMode()) {
            long time = this.getSendTime();
            if (time > 0L) {
                txtTime.setText((CharSequence)this.formatTime(context, this.getSendTime()));
            } else {
                txtTime.setText((CharSequence)"");
            }
        }
        if (txtNoteBubble != null) {
            txtNoteBubble.setVisibility(8);
        }
        imgPresence.setVisibility(8);
        imgE2EFlag.setVisibility(8);
        this.loadAvatar(avatarView, context, false, avatarCache);
        return convertView;
    }

    private String getAvatar() {
        if (this.addrbookItem == null) {
            return null;
        }
        return this.addrbookItem.getAvatarPath();
    }

    private boolean loadAvatar(AvatarView avatarView, Context context, boolean fromMemCacheOnly, MemCache<String, Drawable> avatarCache) {
        Bitmap bmp;
        File file;
        Drawable drawable2;
        if (avatarCache != null && (drawable2 = avatarCache.getCachedItem(this.sessionId)) != null) {
            avatarView.setCornerRadiusRatio(0.5f);
            avatarView.setAvatar(drawable2);
            avatarView.setTag(this);
            return true;
        }
        boolean needClearIfNoCache = true;
        Object tag = avatarView.getTag();
        if (tag instanceof MMContentMessageItem) {
            MMContentMessageItem lastItem = (MMContentMessageItem)tag;
            if (StringUtil.isSameString((String)lastItem.sessionId, (String)this.sessionId)) {
                needClearIfNoCache = false;
            }
        }
        avatarView.setTag(this);
        String avatar = this.getAvatar();
        if (!StringUtil.isEmptyOrNull((String)avatar) && (file = new File(avatar)).exists() && file.isFile() && (bmp = ZMBitmapFactory.decodeFile(avatar, fromMemCacheOnly)) != null) {
            avatarView.setCornerRadiusRatio(0.5f);
            BitmapDrawable drawable3 = new BitmapDrawable(context.getResources(), bmp);
            avatarView.setAvatar(avatar);
            if (avatarCache != null) {
                avatarCache.cacheItem(this.sessionId, (Drawable)drawable3);
            }
            return true;
        }
        if (this.addrbookItem != null) {
            Bitmap bmp2 = this.addrbookItem.getAvatarBitmap(context, fromMemCacheOnly);
            if (bmp2 != null) {
                avatarView.setCornerRadiusRatio(0.5f);
                BitmapDrawable drawable4 = new BitmapDrawable(context.getResources(), bmp2);
                avatarView.setAvatar((Drawable)drawable4);
                if (avatarCache != null) {
                    avatarCache.cacheItem(this.sessionId, (Drawable)drawable4);
                }
                return true;
            }
            if (!fromMemCacheOnly || needClearIfNoCache) {
                avatarView.setCornerRadiusRatio(0.5f);
                avatarView.setAvatar((Drawable)null);
            }
        } else {
            if (this.isGroup) {
                avatarView.setAvatar(new GroupAvatarDrawable_v2(this.getSessionId()));
                return true;
            }
            if (!fromMemCacheOnly || needClearIfNoCache) {
                avatarView.setCornerRadiusRatio(0.5f);
                avatarView.setAvatar((Drawable)null);
            }
        }
        return false;
    }

    private String formatTime(Context context, long time) {
        long curTime = System.currentTimeMillis();
        long yesterday = curTime - 86400000L;
        if (TimeUtil.isSameDate((long)time, (long)curTime)) {
            return TimeUtil.formatTime((Context)context, (long)time);
        }
        if (TimeUtil.isSameDate((long)time, (long)yesterday)) {
            return context.getString(R.string.zm_lbl_yesterday);
        }
        return TimeUtil.formatDate((Context)context, (long)time);
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public void setGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public static class HighlightPosition {
        int start;
        int end;
    }

    public static class MMContentMessageAnchorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int TYPE_NORMAL = 0;
        public static final int TYPE_SERVER = 1;
        public int mType = 0;
        private String msgGuid;
        private String sessionId;
        private long sendTime;
        private long serverTime;

        public int getmType() {
            return this.mType;
        }

        public void setmType(int mType) {
            this.mType = mType;
        }

        public long getServerTime() {
            return this.serverTime;
        }

        public void setServerTime(long serverTime) {
            this.serverTime = serverTime;
        }

        public String getMsgGuid() {
            return this.msgGuid;
        }

        public void setMsgGuid(String msgGuid) {
            this.msgGuid = msgGuid;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public long getSendTime() {
            return this.sendTime;
        }

        public void setSendTime(long sendTime) {
            this.sendTime = sendTime;
        }
    }
}

