/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.view.mm.MMContentImagesListview;
import com.zipow.videobox.view.mm.MMZoomFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMSquareImageView;
import us.zoom.videomeetings.R;

public class MMContentImagesAdapter
extends BaseAdapter {
    private static final String TAG_ITEM_LABEL = "TAG_ITEM_LABEL";
    private static final String TAG_ITEM_IMAGES = "TAG_ITEM_IMAGES";
    private List<MMZoomFile> mContentImages = new ArrayList<MMZoomFile>();
    private static final int ITEM_TYPE_LABEL = 0;
    private static final int ITEM_TYPE_IMAGES = 1;
    private MMContentImagesListview mListView;
    private Context mContext;
    private List<DisplayItem> mDisplayItems = new ArrayList<DisplayItem>();
    private int mImagesEachLine;
    private boolean mIsPersonalMode = false;

    public MMContentImagesAdapter(Context context, boolean isPersonalMode) {
        this.mContext = context;
        this.mImagesEachLine = context.getResources().getInteger(R.integer.zm_content_max_images_each_line);
        this.mIsPersonalMode = isPersonalMode;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mImagesEachLine = this.mContext.getResources().getInteger(R.integer.zm_content_max_images_each_line);
        this.notifyDataSetChanged();
    }

    public void addContentImages(List<MMZoomFile> contentImages) {
        if (contentImages == null || contentImages.size() == 0) {
            return;
        }
        for (MMZoomFile file : contentImages) {
            String webId = file.getWebID();
            int idx = this.findFileByWebId(webId);
            if (idx == -1) {
                this.mContentImages.add(file);
                continue;
            }
            this.mContentImages.set(idx, file);
        }
    }

    public void setParentListView(MMContentImagesListview listview) {
        this.mListView = listview;
    }

    public boolean containsFile(String webId) {
        return this.findFileByWebId(webId) != -1;
    }

    private int findFileByWebId(String webId) {
        if (StringUtil.isEmptyOrNull((String)webId)) {
            return -1;
        }
        for (int i = 0; i < this.mContentImages.size(); ++i) {
            MMZoomFile file = this.mContentImages.get(i);
            if (!webId.equals(file.getWebID())) continue;
            return i;
        }
        return -1;
    }

    public void Indicate_FileDeletedByOthers(String fileID) {
        int idx = this.findFileByWebId(fileID);
        if (idx != -1) {
            this.mContentImages.remove(idx);
            this.notifyDataSetChanged();
        }
    }

    public void Indicate_FileDeleted(String reqID, String webFileID, int result) {
        int idx = this.findFileByWebId(webFileID);
        if (idx != -1) {
            this.mContentImages.remove(idx);
            this.notifyDataSetChanged();
        }
    }

    public long getLastTimeStamp() {
        if (this.mContentImages.isEmpty()) {
            return 0L;
        }
        if (this.mIsPersonalMode) {
            long time = this.mContentImages.get(0).getTimeStamp();
            for (MMZoomFile file : this.mContentImages) {
                if (file.getTimeStamp() >= time) continue;
                time = file.getTimeStamp();
            }
            return time;
        }
        long time = this.mContentImages.get(0).getEarliestShareTime();
        for (MMZoomFile file : this.mContentImages) {
            if (file.getEarliestShareTime() >= time) continue;
            time = file.getEarliestShareTime();
        }
        return time;
    }

    public void clearAll() {
        this.mContentImages.clear();
        this.mDisplayItems.clear();
    }

    public void onDownloadByFileIDOnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        int idx = this.findFileByWebId(webFileID);
        if (idx < 0) {
            return;
        }
        MMZoomFile file = this.mContentImages.get(idx);
        file.setPending(true);
        file.setRatio(ratio);
        file.setReqId(reqId);
        file.setCompleteSize(completeSize);
        file.setBitPerSecond(bitPerSecond);
    }

    public void Indicate_PreviewDownloaded(MMZoomFile file) {
        int idx = this.findFileByWebId(file.getWebID());
        if (idx != -1) {
            MMZoomFile local = this.mContentImages.get(idx);
            local.setPicturePreviewPath(file.getPicturePreviewPath());
        }
        this.notifyDataSetChangedWithoutUpdateDisplayData();
    }

    private void updateDisplayItems() {
        this.mDisplayItems.clear();
        Collections.sort(this.mContentImages, new ContentFileComparator(this.mIsPersonalMode));
        MMZoomFile image = null;
        DisplayItem item = null;
        for (int i = 0; i < this.mContentImages.size(); ++i) {
            MMZoomFile imageTemp = this.mContentImages.get(i);
            long timeTmp = this.mIsPersonalMode ? imageTemp.getTimeStamp() : imageTemp.getEarliestShareTime();
            long time = 0L;
            if (image != null) {
                long l = time = this.mIsPersonalMode ? image.getTimeStamp() : image.getEarliestShareTime();
            }
            if (item != null && image != null && TimeUtil.isInSameMonth((long)time, (long)timeTmp)) {
                if (item.mImages.size() < this.mImagesEachLine) {
                    item.mImages.add(imageTemp);
                    continue;
                }
                item = new DisplayItem();
                item.mItemType = 1;
                item.mImages = new ArrayList<MMZoomFile>();
                item.mImages.add(imageTemp);
                this.mDisplayItems.add(item);
                continue;
            }
            image = imageTemp;
            item = new DisplayItem();
            item.mItemType = 0;
            item.mLabel = this.formatTime(timeTmp);
            this.mDisplayItems.add(item);
            item = new DisplayItem();
            item.mItemType = 1;
            item.mImages = new ArrayList<MMZoomFile>();
            item.mImages.add(imageTemp);
            this.mDisplayItems.add(item);
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public void notifyDataSetChanged() {
        this.updateDisplayItems();
        super.notifyDataSetChanged();
    }

    private void notifyDataSetChangedWithoutUpdateDisplayData() {
        super.notifyDataSetChanged();
    }

    private String formatTime(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-M");
        return df.format(new Date(time));
    }

    public int getCount() {
        return this.mDisplayItems == null ? 0 : this.mDisplayItems.size();
    }

    public DisplayItem getItem(int position) {
        if (this.mDisplayItems == null || position < 0 || position > this.getCount()) {
            return null;
        }
        return this.mDisplayItems.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        DisplayItem item = this.getItem(position);
        if (item == null) {
            return 0;
        }
        return item.mItemType;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int type = this.getItemViewType(position);
        switch (type) {
            case 1: {
                return this.createImagesView(position, convertView, parent);
            }
            case 0: {
                return this.createLabelView(position, convertView, parent);
            }
        }
        return null;
    }

    private View createImagesView(int position, View convertView, ViewGroup parent) {
        LinearLayout viewGroup;
        if (convertView == null || !TAG_ITEM_IMAGES.equals(convertView.getTag())) {
            viewGroup = new LinearLayout(this.mContext);
            convertView = viewGroup;
            viewGroup.setOrientation(0);
            int padding = 0;
            if (position < this.getCount() - 1 && this.getItem((int)(position + 1)).mItemType == 1) {
                padding = UIUtil.dip2px((Context)this.mContext, (float)2.0f);
            }
            viewGroup.setPadding(0, 0, 0, padding);
            convertView.setTag((Object)TAG_ITEM_IMAGES);
            viewGroup.setBackgroundColor(this.mContext.getResources().getColor(R.color.zm_white));
        } else {
            viewGroup = (LinearLayout)convertView;
        }
        if (viewGroup.getChildCount() != this.mImagesEachLine) {
            viewGroup.removeAllViews();
            for (int i = 0; i < this.mImagesEachLine; ++i) {
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -2);
                lp.weight = 1.0f;
                lp.rightMargin = UIUtil.dip2px((Context)this.mContext, (float)2.0f);
                ZMSquareImageView imageView = new ZMSquareImageView(this.mContext);
                imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                imageView.setBackgroundColor(this.mContext.getResources().getColor(R.color.zm_white));
                if (i == this.mImagesEachLine - 1) {
                    lp.rightMargin = 0;
                }
                viewGroup.addView((View)imageView, (ViewGroup.LayoutParams)lp);
            }
        }
        ArrayList<ImageView> imageViews = new ArrayList<ImageView>();
        for (int i = 0; i < this.mImagesEachLine; ++i) {
            imageViews.add((ImageView)viewGroup.getChildAt(i));
        }
        DisplayItem item = this.getItem(position);
        if (item == null || item.mItemType != 1) {
            return convertView;
        }
        for (int i = 0; i < imageViews.size(); ++i) {
            ImageView image = (ImageView)imageViews.get(i);
            if (i < item.mImages.size()) {
                final MMZoomFile imageFile = item.mImages.get(i);
                if (!StringUtil.isEmptyOrNull((String)imageFile.getPicturePreviewPath())) {
                    image.setImageDrawable((Drawable)new LazyLoadDrawable(imageFile.getPicturePreviewPath()));
                } else {
                    image.setImageResource(R.drawable.zm_image_placeholder);
                }
                image.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (MMContentImagesAdapter.this.mListView != null) {
                            MMContentImagesAdapter.this.mListView.onZoomFileClicked(imageFile);
                        }
                    }
                });
                image.setVisibility(0);
                continue;
            }
            image.setVisibility(4);
        }
        return convertView;
    }

    private View createLabelView(int position, View convertView, ViewGroup parent) {
        DisplayItem item;
        if (convertView == null || !TAG_ITEM_LABEL.equals(convertView.getTag())) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_listview_label_item, null);
            convertView.setTag((Object)TAG_ITEM_LABEL);
        }
        if ((item = this.getItem(position)) != null && item.mItemType == 0) {
            TextView txtHeaderLabel = (TextView)convertView.findViewById(R.id.txtHeaderLabel);
            txtHeaderLabel.setText((CharSequence)item.mLabel);
        }
        return convertView;
    }

    static class ContentFileComparator
    implements Comparator<MMZoomFile> {
        private boolean mIsPersonalMode;

        public ContentFileComparator(boolean isPersonalMode) {
            this.mIsPersonalMode = isPersonalMode;
        }

        @Override
        public int compare(MMZoomFile lhs, MMZoomFile rhs) {
            long t;
            long l = t = this.mIsPersonalMode ? lhs.getTimeStamp() - rhs.getTimeStamp() : lhs.getEarliestShareTime() - rhs.getEarliestShareTime();
            if (t > 0L) {
                return -1;
            }
            if (t == 0L) {
                return 0;
            }
            return 1;
        }
    }

    static class DisplayItem {
        int mItemType;
        String mLabel;
        List<MMZoomFile> mImages;

        DisplayItem() {
        }
    }
}

