/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.box.BoxFileListAdapter;
import com.zipow.videobox.dialog.ShareAlertDialog;
import com.zipow.videobox.dropbox.DropboxFileListAdapter;
import com.zipow.videobox.dropbox.ZMDropbox;
import com.zipow.videobox.fragment.IMSearchFragment;
import com.zipow.videobox.fragment.MMSelectSessionAndBuddyFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.googledrive.GoogleDrive;
import com.zipow.videobox.googledrive.GoogleDriveFileListAdapter;
import com.zipow.videobox.onedrive.OneDriveBusinessFileListAdapter;
import com.zipow.videobox.onedrive.OneDriveFileListAdapter;
import com.zipow.videobox.onedrive.OneDrivePicker;
import com.zipow.videobox.ptapp.AutoStreamConflictChecker;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.FileInfoChecker;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.IPicker;
import com.zipow.videobox.util.IPickerResult;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.view.IMView;
import com.zipow.videobox.view.mm.MMContentFileViewerFragment;
import com.zipow.videobox.view.mm.MMContentFilesListView;
import com.zipow.videobox.view.mm.MMContentImagesListview;
import com.zipow.videobox.view.mm.MMContentSearchFragment;
import com.zipow.videobox.view.mm.MMShareZoomFileDialogFragment;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import com.zipow.videobox.view.mm.OnContentFileOperatorListener;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import com.zipow.videobox.view.mm.UnshareAlertDialogFragment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFileListActivity;
import us.zoom.androidlib.app.ZMLocalFileListAdapter;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.IDownloadFileListener;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMAsyncURLDownloadFile;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMPopupWindow;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMContentFragment
extends ZMDialogFragment
implements View.OnClickListener,
IMView.OnFragmentShowListener,
OnContentFileOperatorListener {
    private static final String TAG = MMContentFragment.class.getSimpleName();
    public static final int REQUEST_DOCUMENT = 1010;
    public static final int REQUEST_CHOOSE_PICTURE = 1004;
    public static final int REQUEST_DOCUMENT_PICKER = 1014;
    public static final int REQUEST_DOCUMENT_BUSIENSS_PICKER = 1015;
    public static final int REQUEST_GET_SHAREER = 2014;
    public static final int REQUEST_VIEW_FILE_DETAIL = 3001;
    public static final int REQUEST_UPLOAD_FAILED = 3002;
    private static final int REQUEST_PERMISSION_BY_WRITE_EXTERNAL_STORAGE = 10000;
    private static final int UI_MODE_SHARED = 0;
    private static final int UI_MODE_PERSONAL = 1;
    private static final int FILE_TYPE_IMAGES = 1;
    private static final int FILE_TYPE_FILES = 2;
    private static final String EXTRA_UI_MODE = "uiMode";
    private static final String EXTRA_FILE_TYPE = "fileType";
    private static final String EXTRA_UPLOAD_REQUEST_IDS = "requestIds";
    private static final String ARGS_SHARE_FILE_ID = "shareFileId";
    private View mPanelShared;
    private View mPanelPersonal;
    private TextView mTxtLoadingError;
    private int mUIMode = 1;
    private View mEdtSearch;
    private TextView mTxtFileType;
    private ImageButton mBtnUploadFile;
    private ImageButton mBtnSearch;
    private int mFileType = 2;
    private MMContentFilesListView mListViewSharedFiles;
    private MMContentFilesListView mListViewPersonalFiles;
    private MMContentImagesListview mListViewSharedImages;
    private MMContentImagesListview mListViewPersonalImages;
    private IPicker mPicker;
    private ZMAsyncURLDownloadFile mTaskDownloadFile;
    private ProgressDialog mDownloadFileWaitingDialog = null;
    private ArrayList<String> mReqIds = new ArrayList();
    private Handler mHandler = new Handler();
    private View mPanelConnectionAlert;
    private TextView mTxtNetworkAlert;
    private BroadcastReceiver mNetworkStateReceiver;
    private View mPanelEmptyView;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
            MMContentFragment.this.FT_UploadToMyList_OnProgress(reqID, ratio, completeSize, bitPerSecond);
        }

        @Override
        public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
            MMContentFragment.this.FT_DownloadByFileID_OnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
        }

        @Override
        public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
            MMContentFragment.this.Indicate_PreviewDownloaded(reqId, webFileID, result);
        }

        @Override
        public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
            MMContentFragment.this.Indicate_FileDownloaded(reqID, webFileID, result);
        }

        @Override
        public void Indicate_FileDeleted(String reqID, String webFileID, int result) {
            MMContentFragment.this.Indicate_FileDeleted(reqID, webFileID, result);
        }

        @Override
        public void Indicate_FileShared(String reqID, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
            MMContentFragment.this.Indicate_FileShared(reqID, webFileID, sharee, newSession, newMsgXmppID, result);
        }

        @Override
        public void Indicate_FileUnshared(String reqId, String webFileID, int result) {
            MMContentFragment.this.Indicate_FileUnshared(reqId, webFileID, result);
        }

        @Override
        public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
            MMContentFragment.this.Indicate_FileActionStatus(actionType, fileId, actionOwner, fileName, sessionId, msgId);
        }

        @Override
        public void Indicate_NewFileSharedByOthers(String fileID) {
            MMContentFragment.this.Indicate_NewFileSharedByOthers(fileID);
        }

        @Override
        public void Indicate_NewPersonalFile(String fileID) {
            MMContentFragment.this.Indicate_NewPersonalFile(fileID);
        }

        @Override
        public void Indicate_FileStatusUpdated(String fileID) {
            MMContentFragment.this.Indicate_FileStatusUpdated(fileID);
        }

        @Override
        public void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
            MMContentFragment.this.Indicate_UploadToMyFiles_Sent(reqID, webFileID, result);
        }

        @Override
        public void Indicate_QueryMyFilesResponse(String reqID, int result, List<String> arrWebFileID, long queryEndTime) {
            MMContentFragment.this.Indicate_QueryMyFilesResponse(reqID, result, arrWebFileID, queryEndTime);
        }

        @Override
        public void Indicate_QueryFilesSharedWithMeResponse(String reqID, int result, List<String> arrWebFiles, long queryEndTime) {
            MMContentFragment.this.Indicate_QueryFilesSharedWithMeResponse(reqID, result, arrWebFiles, queryEndTime);
        }

        @Override
        public void Indicate_QueryAllFilesResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
            MMContentFragment.this.Indicate_QueryAllFilesResponse(reqId, result, arrWebFiles, queryEndTime);
        }

        @Override
        public void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
            MMContentFragment.this.Indicate_RenameFileResponse(result, reqId, fileId, newName);
        }

        @Override
        public void onBeginConnect() {
            MMContentFragment.this.onBeginConnect();
        }

        @Override
        public void onConnectReturn(int errorCode) {
            MMContentFragment.this.onConnectReturn(errorCode);
        }

        @Override
        public void FT_UploadToMyList_TimeOut(String reqID) {
            MMContentFragment.this.FT_UploadToMyList_TimeOut(reqID);
        }

        @Override
        public void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
            MMContentFragment.this.FT_OnDownloadByFileIDTimeOut(reqID, webFileID);
        }

        @Override
        public void NotifyOutdatedHistoryRemoved(List<String> sessionIDs, long eraseTime) {
            MMContentFragment.this.NotifyOutdatedHistoryRemoved(sessionIDs, eraseTime);
        }
    };

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mListViewPersonalImages != null) {
            this.mListViewPersonalImages.onConfigurationChanged(newConfig);
        }
        if (this.mListViewSharedImages != null) {
            this.mListViewSharedImages.onConfigurationChanged(newConfig);
        }
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_content, container, false);
        this.mPanelShared = view.findViewById(R.id.panelShared);
        this.mPanelPersonal = view.findViewById(R.id.panelPerson);
        this.mEdtSearch = view.findViewById(R.id.edtSearch);
        this.mTxtFileType = (TextView)view.findViewById(R.id.txtFileType);
        this.mBtnUploadFile = (ImageButton)view.findViewById(R.id.btnUploadFile);
        this.mListViewSharedFiles = (MMContentFilesListView)view.findViewById(R.id.listViewSharedFiles);
        this.mListViewPersonalFiles = (MMContentFilesListView)view.findViewById(R.id.listViewPersonalFiles);
        this.mListViewSharedImages = (MMContentImagesListview)view.findViewById(R.id.listViewSharedImages);
        this.mListViewPersonalImages = (MMContentImagesListview)view.findViewById(R.id.listViewPersonalImages);
        this.mTxtLoadingError = (TextView)view.findViewById(R.id.txtLoadingError);
        this.mBtnSearch = (ImageButton)view.findViewById(R.id.btnSearch);
        this.mPanelConnectionAlert = view.findViewById(R.id.panelConnectionAlert);
        this.mTxtNetworkAlert = (TextView)view.findViewById(R.id.txtNetworkAlert);
        this.mPanelEmptyView = view.findViewById(R.id.panelEmptyView);
        this.mListViewSharedFiles.setMode(false);
        this.mListViewPersonalFiles.setMode(true);
        this.mListViewSharedImages.setMode(false);
        this.mListViewPersonalImages.setMode(true);
        this.mListViewSharedFiles.setOnContentFileOperatorListener(this);
        this.mListViewPersonalFiles.setOnContentFileOperatorListener(this);
        this.mListViewSharedImages.setOnContentFileOperatorListener(this);
        this.mListViewPersonalImages.setOnContentFileOperatorListener(this);
        this.mListViewSharedFiles.setupEmptyView(this.mPanelEmptyView);
        this.mListViewPersonalFiles.setupEmptyView(this.mPanelEmptyView);
        this.mEdtSearch.setOnClickListener((View.OnClickListener)this);
        this.mPanelShared.setOnClickListener((View.OnClickListener)this);
        this.mPanelPersonal.setOnClickListener((View.OnClickListener)this);
        this.mTxtFileType.setOnClickListener((View.OnClickListener)this);
        this.mBtnUploadFile.setOnClickListener((View.OnClickListener)this);
        this.mPanelConnectionAlert.setOnClickListener((View.OnClickListener)this);
        this.mTxtLoadingError.setOnClickListener((View.OnClickListener)this);
        this.mBtnSearch.setOnClickListener((View.OnClickListener)this);
        this.mTxtLoadingError.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.zm_lbl_content_load_error)));
        if (savedInstanceState != null) {
            this.mUIMode = savedInstanceState.getInt(EXTRA_UI_MODE, 0);
            this.mFileType = savedInstanceState.getInt(EXTRA_FILE_TYPE, 2);
            ArrayList reqIds = savedInstanceState.getStringArrayList(EXTRA_UPLOAD_REQUEST_IDS);
            if (reqIds != null) {
                this.mReqIds = reqIds;
            }
            this.updateUIMode(this.mUIMode);
            this.selectFileType(this.mFileType);
            if (this.mListViewPersonalFiles.getCount() > 0 || this.mListViewSharedFiles.getCount() > 0) {
                this.refreshData();
            }
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        return view;
    }

    public void onDestroyView() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDestroyView();
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.putInt(EXTRA_FILE_TYPE, this.mFileType);
            outState.putInt(EXTRA_UI_MODE, this.mUIMode);
            outState.putStringArrayList(EXTRA_UPLOAD_REQUEST_IDS, this.mReqIds);
        }
    }

    private void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
        this.mListViewPersonalFiles.FT_UploadToMyList_OnProgress(reqID, ratio, completeSize, bitPerSecond);
        this.mListViewSharedFiles.FT_UploadToMyList_OnProgress(reqID, ratio, completeSize, bitPerSecond);
    }

    public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        this.mListViewPersonalFiles.onDownloadByFileIDOnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
        this.mListViewSharedFiles.onDownloadByFileIDOnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
    }

    public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
        this.mListViewPersonalFiles.Indicate_PreviewDownloaded(reqId, webFileID, result);
        this.mListViewPersonalImages.Indicate_PreviewDownloaded(reqId, webFileID, result);
        this.mListViewSharedFiles.Indicate_PreviewDownloaded(reqId, webFileID, result);
        this.mListViewSharedImages.Indicate_PreviewDownloaded(reqId, webFileID, result);
    }

    public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
        this.mListViewPersonalFiles.Indicate_FileDownloaded(reqID, webFileID, result);
        this.mListViewSharedFiles.Indicate_FileDownloaded(reqID, webFileID, result);
    }

    private void Indicate_FileDeleted(String reqID, String webFileID, int result) {
        this.mListViewPersonalFiles.Indicate_FileDeleted(reqID, webFileID, result);
        this.mListViewPersonalImages.Indicate_FileDeleted(reqID, webFileID, result);
        this.mListViewSharedFiles.Indicate_FileDeleted(reqID, webFileID, result);
        this.mListViewSharedImages.Indicate_FileDeleted(reqID, webFileID, result);
    }

    private void Indicate_FileShared(String reqID, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        this.mListViewPersonalFiles.Indicate_FileShared(reqID, webFileID, sharee, newSession, newMsgXmppID, result);
        this.mListViewSharedFiles.Indicate_FileShared(reqID, webFileID, sharee, newSession, newMsgXmppID, result);
    }

    private void Indicate_FileUnshared(String reqId, String webFileID, int result) {
        this.mListViewPersonalFiles.Indicate_FileUnshared(reqId, webFileID, result);
        this.mListViewSharedFiles.Indicate_FileUnshared(reqId, webFileID, result);
    }

    private void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
        this.mListViewSharedFiles.Indicate_FileActionStatus(actionType, fileId, actionOwner, fileName, sessionId, msgId);
    }

    private void Indicate_NewFileSharedByOthers(String fileID) {
        this.mListViewSharedFiles.Indicate_NewFileSharedByOthers(fileID);
    }

    private void Indicate_NewPersonalFile(String fileID) {
        this.mListViewPersonalFiles.Indicate_NewPersonalFile(fileID);
        this.mListViewSharedFiles.Indicate_NewPersonalFile(fileID);
    }

    private void Indicate_FileStatusUpdated(String fileID) {
        this.mListViewPersonalFiles.Indicate_FileStatusUpdated(fileID);
        this.mListViewSharedFiles.Indicate_FileStatusUpdated(fileID);
    }

    private void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
        EventTaskManager eventTaskManager;
        this.mListViewPersonalFiles.Indicate_UploadToMyFiles_Sent(reqID, webFileID, result);
        this.mListViewSharedFiles.Indicate_UploadToMyFiles_Sent(reqID, webFileID, result);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MMContentFragment.this.updateUploadState();
            }
        });
        if (result != 0 && (eventTaskManager = this.getEventTaskManager()) != null) {
            eventTaskManager.pushLater(new EventAction("MMContentFragment.uploadFailed"){

                public void run(IUIElement ui) {
                    MMContentFragment f = (MMContentFragment)ui;
                    if (f != null) {
                        f.onUploadFileFailed();
                    }
                }
            });
        }
    }

    private void Indicate_QueryMyFilesResponse(String reqID, int result, List<String> arrWebFileID, long queryEndTime) {
        this.mListViewPersonalFiles.Indicate_QueryMyFilesResponse(reqID, result, arrWebFileID, queryEndTime);
        this.mListViewPersonalImages.Indicate_QueryMyFilesResponse(reqID, result, arrWebFileID, queryEndTime);
    }

    private void Indicate_QueryFilesSharedWithMeResponse(String reqID, int result, List<String> arrWebFiles, long queryEndTime) {
        this.mListViewSharedFiles.Indicate_QueryFilesSharedWithMeResponse(reqID, result, arrWebFiles, queryEndTime);
        this.mListViewSharedImages.Indicate_QueryFilesSharedWithMeResponse(reqID, result, arrWebFiles, queryEndTime);
    }

    private void Indicate_QueryAllFilesResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
        this.mListViewSharedFiles.Indicate_QueryAllFilesResponse(reqId, result, arrWebFiles, queryEndTime);
        this.mListViewSharedImages.Indicate_QueryAllFilesResponse(reqId, result, arrWebFiles, queryEndTime);
    }

    public void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
        this.mListViewSharedFiles.Indicate_RenameFileResponse(result, reqId, fileId, newName);
        this.mListViewPersonalFiles.Indicate_RenameFileResponse(result, reqId, fileId, newName);
    }

    private void onBeginConnect() {
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity()) && this.isResumed()) {
            this.updatePanelConnectionAlert();
        }
    }

    private void onUploadFileFailed() {
        UploadFailedAlertDialog.showUploadFailedAlertDialog(this.getFragmentManager(), (Fragment)this, 3002);
    }

    private void onConnectReturn(int errorCode) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && this.isResumed()) {
            this.updatePanelConnectionAlert();
        }
    }

    private void FT_UploadToMyList_TimeOut(String reqID) {
        this.Indicate_UploadToMyFiles_Sent(reqID, reqID, -1);
    }

    private void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
        this.mListViewPersonalFiles.Indicate_FileDownloaded(reqID, webFileID, -1);
        this.mListViewSharedFiles.Indicate_FileDownloaded(reqID, webFileID, -1);
    }

    public void NotifyOutdatedHistoryRemoved(List<String> sessionIDs, long time) {
        this.upateDataListViewWithEraseTime(time, true);
    }

    private void updatePanelConnectionAlert() {
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mPanelConnectionAlert.setVisibility(8);
            return;
        }
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            switch (ZoomMessengerUI.getInstance().getConnectionStatus()) {
                case -1: 
                case 1: 
                case 2: {
                    this.mPanelConnectionAlert.setVisibility(8);
                    break;
                }
                case 0: {
                    this.mPanelConnectionAlert.setVisibility(0);
                    if (this.mTxtNetworkAlert == null) break;
                    this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_stream_conflict);
                }
            }
        } else {
            this.mPanelConnectionAlert.setVisibility(0);
            if (this.mTxtNetworkAlert != null) {
                this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_network_unavailable);
            }
        }
    }

    private void startToListenNetworkEvent() {
        if (this.mNetworkStateReceiver == null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            this.mNetworkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    MMContentFragment.this.updatePanelConnectionAlert();
                }
            };
            context.registerReceiver(this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void stopToListenNetworkEvent() {
        if (this.mNetworkStateReceiver != null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            context.unregisterReceiver(this.mNetworkStateReceiver);
            this.mNetworkStateReceiver = null;
        }
    }

    public void onResume() {
        super.onResume();
        this.startToListenNetworkEvent();
        this.updateUIMode(this.mUIMode);
        this.updatePanelConnectionAlert();
        this.updateUploadState();
        this.upateDataListView();
    }

    private void upateDataListViewWithEraseTime(long eraseTime, boolean erase) {
        this.mListViewPersonalFiles.setEraseTime(eraseTime, erase);
        this.mListViewSharedFiles.setEraseTime(eraseTime, erase);
        this.upateDataListView();
    }

    private void upateDataListView() {
        this.mListViewPersonalFiles.notifyDataSetChanged(true);
        this.mListViewSharedFiles.notifyDataSetChanged(true);
    }

    public void onPause() {
        this.stopToListenNetworkEvent();
        super.onPause();
    }

    private void updateUploadState() {
        if (PendingFileDataHelper.getInstance().getUploadPendingFileSize() >= 5) {
            this.mBtnUploadFile.setEnabled(false);
        } else {
            this.mBtnUploadFile.setEnabled(true);
        }
    }

    private void refreshData() {
        if (this.mListViewSharedFiles == null || this.mListViewPersonalFiles == null) {
            return;
        }
        if (this.mUIMode == 1) {
            if (this.mFileType == 2) {
                this.mListViewPersonalFiles.loadData(false);
            } else {
                this.mListViewPersonalImages.loadData(false);
            }
        } else if (this.mFileType == 2) {
            this.mListViewSharedFiles.loadData(false);
        } else {
            this.mListViewSharedImages.loadData(false);
        }
    }

    private void updateUIMode(int mode) {
        this.mUIMode = mode;
        if (this.mUIMode == 1) {
            this.mPanelShared.setSelected(false);
            this.mPanelPersonal.setSelected(true);
            if (this.mFileType == 2) {
                this.mListViewPersonalFiles.setVisibility(0);
                this.mListViewPersonalImages.setVisibility(8);
                this.mListViewSharedFiles.setVisibility(8);
                this.mListViewSharedImages.setVisibility(8);
            } else {
                this.mListViewPersonalFiles.setVisibility(8);
                this.mListViewPersonalImages.setVisibility(0);
                this.mListViewSharedFiles.setVisibility(8);
                this.mListViewSharedImages.setVisibility(8);
                this.mListViewPersonalImages.notifyDataSetChanged();
            }
        } else if (this.mUIMode == 0) {
            this.mPanelShared.setSelected(true);
            this.mPanelPersonal.setSelected(false);
            if (this.mFileType == 2) {
                this.mListViewPersonalFiles.setVisibility(8);
                this.mListViewPersonalImages.setVisibility(8);
                this.mListViewSharedFiles.setVisibility(0);
                this.mListViewSharedImages.setVisibility(8);
            } else {
                this.mListViewPersonalFiles.setVisibility(8);
                this.mListViewPersonalImages.setVisibility(8);
                this.mListViewSharedFiles.setVisibility(8);
                this.mListViewSharedImages.setVisibility(0);
                this.mListViewSharedImages.notifyDataSetChanged();
            }
        }
        this.selectFileType(this.mFileType);
    }

    public void closeWaitDialog(String tag) {
        Fragment fragment = this.getFragmentManager().findFragmentByTag(tag);
        if (fragment != null && fragment instanceof WaitingDialog) {
            ((WaitingDialog)fragment).dismiss();
        }
    }

    public void showWaitDialog(String tag) {
        this.closeWaitDialog(tag);
        WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_waiting);
        dialog.setCancelable(true);
        dialog.show(this.getFragmentManager(), tag);
    }

    public void onClick(View v) {
        if (v == this.mPanelShared) {
            this.onClickPanelShared();
        } else if (v == this.mPanelPersonal) {
            this.onClickPanelPersonal();
        } else if (v == this.mTxtFileType) {
            this.onClickTxtFileType();
        } else if (v == this.mBtnUploadFile) {
            this.onClickBtnUploadFile();
        } else if (v == this.mPanelConnectionAlert) {
            this.onClickPanelConnectionAlert();
        } else if (v == this.mEdtSearch) {
            this.onClickPanelOperator();
        } else if (v == this.mTxtLoadingError) {
            this.onClickTxtLoadingError();
        } else if (v == this.mBtnSearch) {
            this.onClickBtnSearch();
        }
    }

    public void onClickBtnSearch() {
        IMSearchFragment.showAsFragment((Fragment)this, 0);
    }

    private void onClickTxtLoadingError() {
        if (this.mUIMode == 1) {
            this.mListViewPersonalFiles.loadData(true);
        } else {
            this.mListViewSharedFiles.loadData(true);
        }
    }

    private void onClickPanelOperator() {
        MMContentSearchFragment.showAsFragment(this, this.mUIMode == 1);
    }

    private void onClickPanelConnectionAlert() {
        IMActivity activity = (IMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)activity)) {
            Toast.makeText((Context)activity, (int)R.string.zm_alert_network_disconnected, (int)1).show();
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.isStreamConflict()) {
            AutoStreamConflictChecker.getInstance().showStreamConflictMessage(this.getActivity());
        } else {
            messenger.trySignon();
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.pushLater("MMContentFragmentPermissionResult", new EventAction("MMContentFragmentPermissionResult"){

                public void run(IUIElement ui) {
                    ((MMContentFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
                }
            });
        }
    }

    protected void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        if (requestCode == 10000 && this.checkExternalSoragePermission()) {
            this.uploadFile();
        }
    }

    private boolean checkExternalSoragePermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private void onClickBtnUploadFile() {
        if (this.checkExternalSoragePermission()) {
            this.uploadFile();
        } else {
            ArrayList<String> list = new ArrayList<String>();
            if (this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                list.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            String[] permissions = list.toArray(new String[list.size()]);
            this.zm_requestPermissions(permissions, 10000);
        }
    }

    private void uploadFile() {
        IMActivity activity = (IMActivity)this.getActivity();
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ArrayList<UploadContextMenuItem> items = new ArrayList<UploadContextMenuItem>();
        items.add(new UploadContextMenuItem(this.getString(R.string.zm_btn_share_image), 0));
        items.add(new UploadContextMenuItem(this.getString(R.string.zm_btn_share_all_file), 2));
        items.add(new UploadContextMenuItem(this.getString(R.string.zm_btn_share_box), 4));
        if (activity != null && ZMDropbox.isDropboxLoginSupported((Context)activity)) {
            items.add(new UploadContextMenuItem(this.getString(R.string.zm_btn_share_dropbox), 1));
        }
        if (activity != null && GoogleDrive.canAuthGoogleViaBrowser((Context)activity)) {
            items.add(new UploadContextMenuItem(this.getString(R.string.zm_btn_share_google_drive), 5));
        }
        items.add(new UploadContextMenuItem(this.getString(R.string.zm_btn_share_one_drive), 3));
        menuAdapter.addAll(items);
        TextView titleView = new TextView((Context)this.getActivity());
        if (Build.VERSION.SDK_INT < 23) {
            titleView.setTextAppearance((Context)this.getActivity(), R.style.ZMTextView_Medium);
        } else {
            titleView.setTextAppearance(R.style.ZMTextView_Medium);
        }
        int padding = UIUtil.dip2px((Context)this.getActivity(), (float)20.0f);
        titleView.setPadding(padding, padding, padding, padding / 2);
        titleView.setText(R.string.zm_lbl_content_upload_file);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitleView((View)titleView).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                UploadContextMenuItem mi = (UploadContextMenuItem)((Object)menuAdapter.getItem(which));
                MMContentFragment.this.onSelectContextMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onClickTxtFileType() {
        this.showFileTypePopWindow();
    }

    private void onClickPanelShared() {
        if (this.mUIMode == 0) {
            return;
        }
        this.updateUIMode(0);
        this.refreshData();
    }

    private void onClickPanelPersonal() {
        if (this.mUIMode == 1) {
            return;
        }
        this.updateUIMode(1);
        this.refreshData();
    }

    private void onSelectContextMenuItem(UploadContextMenuItem mi) {
        switch (mi.getAction()) {
            case 4: {
                ZMFileListActivity.startFileListActivity((Fragment)this, BoxFileListAdapter.class, (int)1010, null, null, (int)R.string.zm_btn_upload, (String)this.getString(R.string.zm_mm_msg_upload_file_prompt));
                break;
            }
            case 1: {
                ZMFileListActivity.startFileListActivity((Fragment)this, DropboxFileListAdapter.class, (int)1010, null, null, (int)R.string.zm_btn_upload, (String)this.getString(R.string.zm_mm_msg_upload_file_prompt));
                break;
            }
            case 5: {
                ZMFileListActivity.startFileListActivity((Fragment)this, GoogleDriveFileListAdapter.class, (int)1010, null, null, (int)R.string.zm_btn_upload, (String)this.getString(R.string.zm_mm_msg_upload_file_prompt));
                break;
            }
            case 2: {
                ZMFileListActivity.startFileListActivity((Fragment)this, ZMLocalFileListAdapter.class, (int)1010, null, null, (int)R.string.zm_btn_upload, (String)this.getString(R.string.zm_mm_msg_upload_file_prompt));
                break;
            }
            case 3: 
            case 6: {
                boolean isBusiness;
                boolean bl = isBusiness = mi.getAction() == 6;
                if (OneDrivePicker.hasPicker((Context)this.getActivity(), isBusiness)) {
                    this.mPicker = OneDrivePicker.createPicker((Context)this.getActivity(), isBusiness ? 1015 : 1014, null, isBusiness);
                    if (this.mPicker != null) {
                        this.mPicker.startPicking(this);
                        break;
                    }
                    ZMFileListActivity.startFileListActivity((Fragment)this, isBusiness ? OneDriveBusinessFileListAdapter.class : OneDriveFileListAdapter.class, (int)1010, null, null, (int)R.string.zm_btn_upload, (String)this.getString(R.string.zm_mm_msg_upload_file_prompt));
                    break;
                }
                ZMFileListActivity.startFileListActivity((Fragment)this, isBusiness ? OneDriveBusinessFileListAdapter.class : OneDriveFileListAdapter.class, (int)1010, null, null, (int)R.string.zm_btn_upload, (String)this.getString(R.string.zm_mm_msg_upload_file_prompt));
                break;
            }
            case 0: {
                AndroidAppUtil.selectImageNoDefault((Fragment)this, (int)R.string.zm_select_a_image, (int)1004);
                break;
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1004: {
                Uri uri = null;
                if (data != null) {
                    uri = data.getData();
                }
                if (resultCode != -1 || uri == null) break;
                String path = ImageUtil.getPathFromUri((Context)this.getActivity(), uri);
                if (path == null) {
                    this.alertImageInvalid();
                    return;
                }
                FileInfoChecker checker = PTApp.getInstance().getZoomFileInfoChecker();
                if (checker.isGifFile(path) && !checker.isLegalGif(path)) {
                    SimpleMessageDialog.newInstance(R.string.zm_msg_illegal_image, false).show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
                    return;
                }
                this.uploadFile(path);
                break;
            }
            case 1010: {
                Bundle extras;
                if (resultCode == -1) {
                    Bundle extras2;
                    if (data == null || (extras2 = data.getExtras()) == null) break;
                    String path = extras2.getString("selected_file_path");
                    String fileName = extras2.getString("selected_file_name");
                    if (StringUtil.isEmptyOrNull((String)path) || StringUtil.isEmptyOrNull((String)fileName)) break;
                    this.uploadFile(path, fileName);
                    break;
                }
                if (resultCode != 0 || data == null || (extras = data.getExtras()) == null) break;
                String errPromt = extras.getString("failed_promt");
                if (StringUtil.isEmptyOrNull((String)errPromt)) {
                    errPromt = this.getString(R.string.zm_alert_auth_token_failed_msg);
                }
                ShareAlertDialog.showDialog(this.getFragmentManager(), errPromt, false);
                break;
            }
            case 1014: 
            case 1015: {
                if (resultCode == 0) break;
                if (resultCode != -1) {
                    ShareAlertDialog.showDialog(this.getFragmentManager(), this.getString(R.string.zm_msg_load_file_fail_without_name), false);
                    break;
                }
                if (this.mPicker == null) {
                    this.mPicker = OneDrivePicker.createPicker((Context)this.getActivity(), requestCode, null, requestCode == 1015);
                }
                if (data == null) break;
                IPickerResult result = this.mPicker.getPickerResult(requestCode, resultCode, data);
                if (result == null) {
                    ShareAlertDialog.showDialog(this.getFragmentManager(), this.getString(R.string.zm_msg_load_file_fail_without_name), false);
                    break;
                }
                if (!result.acceptFileType()) {
                    ShareAlertDialog.showDialog(this.getFragmentManager(), this.getString(R.string.zm_alert_unsupported_format), false);
                    break;
                }
                Uri link = result.getLink();
                if (result.isLocal()) {
                    this.uploadFile(link.getPath());
                    break;
                }
                String path = FileUtils.makeNewFilePathWithName((String)AppUtil.getCachePath(), (String)result.getName());
                this.asyncDownloadFile(link, result.getSize(), path);
                break;
            }
            case 2014: {
                if (resultCode != -1 || data == null) break;
                Bundle bundle = data.getExtras();
                if (bundle == null) {
                    return;
                }
                String messageId = bundle.getString(ARGS_SHARE_FILE_ID);
                if (StringUtil.isEmptyOrNull((String)messageId)) {
                    return;
                }
                String jid = data.getStringExtra("selectedItem");
                if (StringUtil.isEmptyOrNull((String)jid)) {
                    return;
                }
                ArrayList<String> sharees = new ArrayList<String>();
                sharees.add(jid);
                if (sharees.size() <= 0) break;
                this.doShareFile(sharees, messageId);
                break;
            }
            case 3001: {
                if (resultCode != -1 || data == null) break;
                int action = data.getIntExtra("action", 0);
                String fileWebId = data.getStringExtra("zoomFileWebId");
                String reqId = data.getStringExtra("reqId");
                this.dealResultForZoomFileViewer(action, fileWebId, reqId);
                break;
            }
            case 3002: {
                ArrayList files;
                if (resultCode != -1 || data == null || (files = data.getStringArrayListExtra("uploadFiles")) == null || files.size() <= 0) break;
                for (String path : files) {
                    this.uploadFile(path);
                }
                break;
            }
        }
    }

    private void dealResultForZoomFileViewer(int action, String fileWebId, String reqId) {
        if (StringUtil.isEmptyOrNull((String)fileWebId)) {
            return;
        }
        switch (action) {
            case 1: {
                this.Indicate_FileDeleted(reqId, fileWebId, 0);
                break;
            }
        }
    }

    private void doShareFile(ArrayList<String> sharees, String fileID) {
        MMShareZoomFileDialogFragment.showShareFileDialog(this.getFragmentManager(), sharees, fileID);
    }

    private void asyncDownloadFile(Uri uri, long totalBytes, String outPath) {
        if (totalBytes >= 0x20000000L) {
            SimpleMessageDialog.newInstance(R.string.zm_msg_file_too_large).show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
            return;
        }
        if (this.mTaskDownloadFile != null) {
            this.mTaskDownloadFile.cancel(true);
            this.mTaskDownloadFile = null;
        }
        this.mTaskDownloadFile = new ZMAsyncURLDownloadFile(uri, totalBytes, outPath, (IDownloadFileListener)new DownloadFileListener(uri, totalBytes, outPath));
        this.showDownloadFileWaitingDialog(this.getString(R.string.zm_msg_download_file_size, new Object[]{FileUtils.toFileSizeString((Context)this.getActivity(), (long)0L)}));
        this.mTaskDownloadFile.execute((Object[])new Void[0]);
    }

    private void showDownloadFileWaitingDialog(String message) {
        if (this.mDownloadFileWaitingDialog != null) {
            return;
        }
        this.mDownloadFileWaitingDialog = new ProgressDialog((Context)this.getActivity());
        this.mDownloadFileWaitingDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (MMContentFragment.this.mTaskDownloadFile != null && !MMContentFragment.this.mTaskDownloadFile.isCancelled()) {
                    MMContentFragment.this.mTaskDownloadFile.cancel(true);
                }
                MMContentFragment.this.mTaskDownloadFile = null;
                MMContentFragment.this.mDownloadFileWaitingDialog = null;
            }
        });
        this.mDownloadFileWaitingDialog.requestWindowFeature(1);
        this.mDownloadFileWaitingDialog.setMessage((CharSequence)message);
        this.mDownloadFileWaitingDialog.setCanceledOnTouchOutside(false);
        this.mDownloadFileWaitingDialog.setCancelable(true);
        this.mDownloadFileWaitingDialog.show();
    }

    private void dismissDownloadFileWaitingDialog() {
        if (this.mDownloadFileWaitingDialog == null) {
            return;
        }
        this.mDownloadFileWaitingDialog.dismiss();
        this.mDownloadFileWaitingDialog = null;
    }

    private void updateProgressWaitingDialog(long totalBytes, long bytes) {
        if (this.mDownloadFileWaitingDialog == null) {
            return;
        }
        if (totalBytes > 0L) {
            long progress = bytes * 100L / totalBytes;
            this.mDownloadFileWaitingDialog.setMessage((CharSequence)this.getString(R.string.zm_msg_download_file_progress, new Object[]{progress}));
        } else {
            this.mDownloadFileWaitingDialog.setMessage((CharSequence)this.getString(R.string.zm_msg_download_file_size, new Object[]{FileUtils.toFileSizeString((Context)this.getActivity(), (long)bytes)}));
        }
    }

    private void uploadFile(String path) {
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        this.uploadFile(path, file.getName());
    }

    private void uploadFile(String path, String fileName) {
        String reqId;
        File newPath;
        File file = new File(path);
        if (StringUtil.isEmptyOrNull((String)fileName) || !file.exists() || !file.isFile()) {
            return;
        }
        if (file.length() >= 0x20000000L) {
            SimpleMessageDialog.newInstance(R.string.zm_msg_file_too_large).show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
            return;
        }
        MMFileContentMgr fileMgr = PTApp.getInstance().getZoomFileContentMgr();
        if (fileMgr == null) {
            return;
        }
        String localName = file.getName();
        if (!StringUtil.isSameString((String)fileName, (String)localName) && (newPath = FileUtils.createUnDuplicateNameFile((String)fileName, (String)file.getParentFile().getAbsolutePath())) != null) {
            file.renameTo(newPath);
            path = newPath.getAbsolutePath();
        }
        if (!StringUtil.isEmptyOrNull((String)(reqId = fileMgr.uploadFile(path)))) {
            this.mListViewPersonalFiles.addUploadFile(reqId, fileName, (int)file.length());
            this.mListViewSharedFiles.addUploadFile(reqId, fileName, (int)file.length());
            PendingFileDataHelper.getInstance().addUploadPendingFile(reqId, fileName, (int)file.length(), path, false);
            this.updateUploadState();
        } else {
            final String filePath = path;
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        PendingFileDataHelper.getInstance().addUploadFailedFile(filePath);
                        UploadFailedAlertDialog.showUploadFailedAlertDialog(MMContentFragment.this.getFragmentManager(), (Fragment)MMContentFragment.this, 3002);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 100L);
        }
    }

    private void alertImageInvalid() {
        String message = this.getString(R.string.zm_alert_invalid_image);
        ShareAlertDialog.showDialog(this.getFragmentManager(), message, true);
    }

    private void selectFileType(int fileType) {
        this.mFileType = fileType;
        switch (fileType) {
            case 2: {
                this.mTxtFileType.setText(R.string.zm_lbl_file_type_files);
                break;
            }
            case 1: {
                this.mTxtFileType.setText(R.string.zm_lbl_file_type_images);
                break;
            }
        }
    }

    private void showFileTypePopWindow() {
        View content = View.inflate((Context)this.getActivity(), (int)R.layout.zm_mm_content_file_type_pop, null);
        View panelTypeFiles = content.findViewById(R.id.panelTypeFiles);
        View panelTypeImages = content.findViewById(R.id.panelTypeImages);
        content.findViewById(R.id.imgTypeFiles).setVisibility(this.mFileType == 2 ? 0 : 8);
        content.findViewById(R.id.imgTypeImages).setVisibility(this.mFileType == 1 ? 0 : 8);
        content.measure(0, 0);
        final ZMPopupWindow popWin = new ZMPopupWindow(content, content.getMeasuredWidth(), content.getMeasuredHeight());
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View v) {
                int id2 = v.getId();
                if (id2 == R.id.panelTypeFiles) {
                    MMContentFragment.this.selectFileType(2);
                } else if (id2 == R.id.panelTypeImages) {
                    MMContentFragment.this.selectFileType(1);
                }
                MMContentFragment.this.updateUIMode(MMContentFragment.this.mUIMode);
                MMContentFragment.this.refreshData();
                popWin.dismiss();
            }
        };
        panelTypeFiles.setOnClickListener(listener);
        panelTypeImages.setOnClickListener(listener);
        int padding = UIUtil.dip2px((Context)this.getActivity(), (float)5.0f);
        popWin.showAsDropDown((View)this.mTxtFileType, padding, padding);
    }

    @Override
    public void onShow() {
        this.refreshData();
    }

    @Override
    public void onZoomFileClick(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        MMContentFileViewerFragment.showAsActivity((Fragment)this, fileId, 3001);
    }

    @Override
    public void onZoomFileShared(String fileId) {
        Bundle bundle = new Bundle();
        bundle.putString(ARGS_SHARE_FILE_ID, fileId);
        MMSelectSessionAndBuddyFragment.showAsFragment((Fragment)this, bundle, false, false, 2014);
    }

    @Override
    public void onZoomFileCancelTransfer(String fileId) {
        boolean res;
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        String reqId = null;
        boolean isUpload = PendingFileDataHelper.getInstance().isFileUploadNow(fileId);
        if (!isUpload) {
            PendingFileDataHelper.PendingFileInfo info = PendingFileDataHelper.getInstance().getDownloadPendingInfoByWebFileId(fileId);
            if (info != null) {
                reqId = info.reqId;
            }
        } else {
            reqId = fileId;
        }
        if (StringUtil.isEmptyOrNull((String)reqId)) {
            this.mListViewPersonalFiles.endFileTransfer(fileId);
            this.mListViewSharedFiles.endFileTransfer(fileId);
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr != null && (res = mgr.cancelFileTransfer(reqId, fileId))) {
            this.mListViewPersonalFiles.endFileTransfer(fileId);
            this.mListViewSharedFiles.endFileTransfer(fileId);
            PendingFileDataHelper.getInstance().removeUploadPendingFile(fileId);
            PendingFileDataHelper.getInstance().removeDownloadPendingFile(fileId);
        }
    }

    @Override
    public void onZoomFileSharerAction(String fileId, MMZoomShareAction action) {
        if (StringUtil.isEmptyOrNull((String)fileId) || action == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showConnectionError();
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)this.getActivity(), false);
        ArrayList<SharerActionContextMenuItem> items = new ArrayList<SharerActionContextMenuItem>();
        items.add(new SharerActionContextMenuItem(this.getString(R.string.zm_btn_jump_group), 0, fileId, action));
        items.add(new SharerActionContextMenuItem(this.getString(R.string.zm_btn_unshare_group), 1, fileId, action));
        menuAdapter.addAll(items);
        TextView titleView = new TextView((Context)this.getActivity());
        if (Build.VERSION.SDK_INT < 23) {
            titleView.setTextAppearance((Context)this.getActivity(), R.style.ZMTextView_Medium);
        } else {
            titleView.setTextAppearance(R.style.ZMTextView_Medium);
        }
        int padding = UIUtil.dip2px((Context)this.getActivity(), (float)20.0f);
        titleView.setPadding(padding, padding, padding, padding / 2);
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(fileId);
        if (file == null) {
            return;
        }
        String name = file.getFileName();
        mgr.destroyFileObject(file);
        titleView.setText((CharSequence)this.getString(R.string.zm_title_sharer_action, new Object[]{name, action.getShareeName((Context)this.getActivity())}));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitleView((View)titleView).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SharerActionContextMenuItem mi = (SharerActionContextMenuItem)((Object)menuAdapter.getItem(which));
                MMContentFragment.this.onSelectSharerActionContextMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectSharerActionContextMenuItem(SharerActionContextMenuItem mi) {
        if (mi == null) {
            return;
        }
        switch (mi.getAction()) {
            case 0: {
                MMChatActivity.showAsGroupChat((ZMActivity)this.getActivity(), mi.mShareAction.getSharee());
                break;
            }
            case 1: {
                UnshareAlertDialogFragment.showUnshareAlertDialog(this.getFragmentManager(), mi.mFileId, mi.mShareAction);
                break;
            }
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)0).show();
    }

    private void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        }
    }

    public static class UploadFailedAlertDialog
    extends ZMDialogFragment {
        private TextView mTxtMsg;
        public static final String RESULT_ARGS_UPLOAD_FILES = "uploadFiles";

        public static void showUploadFailedAlertDialog(FragmentManager fm, Fragment resultFragment, int requestCode) {
            if (fm == null) {
                return;
            }
            UploadFailedAlertDialog dialog = (UploadFailedAlertDialog)fm.findFragmentByTag(UploadFailedAlertDialog.class.getName());
            if (dialog != null) {
                dialog.updateDialogMsg();
                return;
            }
            dialog = new UploadFailedAlertDialog();
            Bundle args = new Bundle();
            dialog.setArguments(args);
            if (resultFragment != null) {
                dialog.setTargetFragment(resultFragment, requestCode);
            }
            dialog.show(fm, UploadFailedAlertDialog.class.getName());
        }

        public UploadFailedAlertDialog() {
            this.setCancelable(true);
        }

        private String getMsg() {
            ArrayList<String> files = PendingFileDataHelper.getInstance().getUploadFailedFiles();
            StringBuffer msgBuffer = new StringBuffer();
            for (String path : files) {
                File file = new File(path);
                if (!file.exists()) continue;
                String name = file.getName();
                msgBuffer.append(name).append("\n");
            }
            if (msgBuffer.length() > 0) {
                return msgBuffer.substring(0, msgBuffer.length() - 1);
            }
            return "";
        }

        public void updateDialogMsg() {
            if (this.mTxtMsg != null) {
                this.mTxtMsg.setText((CharSequence)this.getMsg());
            }
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            this.mTxtMsg = new TextView((Context)this.getActivity());
            this.mTxtMsg.setTextAppearance((Context)this.getActivity(), R.style.ZMTextView_Normal);
            this.mTxtMsg.setGravity(17);
            this.mTxtMsg.setText((CharSequence)this.getMsg());
            int padding = UIUtil.dip2px((Context)this.getActivity(), (float)10.0f);
            this.mTxtMsg.setPadding(padding, 0, padding, 0);
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_upload_files_failed).setView((View)this.mTxtMsg).setPositiveButton(R.string.zm_btn_retry, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    UploadFailedAlertDialog.this.retryUploadFiles();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, null).create();
        }

        public void onDismiss(DialogInterface dialog) {
            super.onDismiss(dialog);
            PendingFileDataHelper.getInstance().clearUploadFailedFiles();
        }

        private void retryUploadFiles() {
            Fragment fragment;
            ArrayList<String> files = PendingFileDataHelper.getInstance().getUploadFailedFiles();
            if (files != null && files.size() > 0 && (fragment = this.getTargetFragment()) != null) {
                Intent intent = new Intent();
                intent.putStringArrayListExtra(RESULT_ARGS_UPLOAD_FILES, files);
                fragment.onActivityResult(this.getTargetRequestCode(), -1, intent);
            }
        }
    }

    public static class SharerActionContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_JUMP = 0;
        public static final int ACTION_UNSHARE = 1;
        private String mFileId;
        private MMZoomShareAction mShareAction;

        public SharerActionContextMenuItem(String label, int action, String fileId, MMZoomShareAction shareAction) {
            super(action, label);
            this.mFileId = fileId;
            this.mShareAction = shareAction;
        }
    }

    public static class UploadContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_PHOTOS = 0;
        public static final int ACTION_DROPBOX = 1;
        public static final int ACTION_NATIVE_FILES = 2;
        public static final int ACTION_ONE_DRIVE = 3;
        public static final int ACTION_BOX = 4;
        public static final int ACTION_GOOGLE_DRIVE = 5;
        public static final int ACTION_ONE_DRIVE_BUSINESS = 6;

        public UploadContextMenuItem(String label, int action) {
            super(action, label);
        }
    }

    private class DownloadFileListener
    implements IDownloadFileListener {
        private Uri mInput;

        public DownloadFileListener(Uri input, long totalBytes, String output) {
            this.mInput = input;
        }

        public void onDownloadCompleted(ZMAsyncURLDownloadFile task, Uri input, String output) {
            if (input == null || input != this.mInput) {
                return;
            }
            MMContentFragment.this.dismissDownloadFileWaitingDialog();
            if (StringUtil.isEmptyOrNull((String)output)) {
                return;
            }
            MMContentFragment.this.uploadFile(output);
        }

        public void onDownloadFailed(ZMAsyncURLDownloadFile task, Uri input) {
            if (input == null || input != this.mInput) {
                return;
            }
            MMContentFragment.this.dismissDownloadFileWaitingDialog();
            String path = input.getPath();
            if (StringUtil.isEmptyOrNull((String)path)) {
                ShareAlertDialog.showDialog(MMContentFragment.this.getFragmentManager(), MMContentFragment.this.getString(R.string.zm_msg_load_file_fail_without_name), false);
            } else {
                String name = AndroidAppUtil.getPathLastName((String)path);
                ShareAlertDialog.showDialog(MMContentFragment.this.getFragmentManager(), MMContentFragment.this.getString(R.string.zm_msg_load_file_fail, new Object[]{name}), false);
            }
        }

        public void onDownloadProgress(ZMAsyncURLDownloadFile task, long totalBytes, long bytesRead) {
            MMContentFragment.this.updateProgressWaitingDialog(totalBytes, bytesRead);
        }

        public void onDownloadCanceled(ZMAsyncURLDownloadFile task, Uri input) {
            if (input == null || input != this.mInput) {
                return;
            }
            MMContentFragment.this.dismissDownloadFileWaitingDialog();
        }
    }
}

