/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.mm.MMContentFilesAdapter;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import com.zipow.videobox.view.mm.OnContentFileOperatorListener;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.PinnedSectionListView;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMContentFilesListView
extends PinnedSectionListView
implements AbsListView.OnScrollListener,
AdapterView.OnItemClickListener,
OnContentFileOperatorListener,
AdapterView.OnItemLongClickListener {
    private MMContentFilesAdapter mAdapter;
    private static final int MAX_COUNT_PER_PAGE = 20;
    private String mSessionId;
    private OnContentFileOperatorListener mListener;
    private boolean mIsOwnerMode = false;
    private String mReqId;
    private View mPanelLoadMoreView;
    private boolean mIsLoadFinish = false;
    private Handler mHandler = new Handler();
    private final String TAG = MMContentFilesListView.class.getSimpleName();
    private View mTxtEmptyView;
    private TextView mTxtLoadingError;
    private View mTxtContentLoading;
    private View mPanelEmptyView;
    private Runnable mRunnableNotifyDataSetChanged = new Runnable(){

        @Override
        public void run() {
            if (MMContentFilesListView.this.mAdapter != null) {
                MMContentFilesListView.this.mAdapter.notifyDataSetChanged();
            }
        }
    };

    public MMContentFilesListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMContentFilesListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void setOnContentFileOperatorListener(OnContentFileOperatorListener listener) {
        this.mListener = listener;
    }

    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
        this.mAdapter.setIsGroupOwner(this.isGroupOwner());
        this.mAdapter.setSessionId(sessionId);
        this.mAdapter.notifyDataSetChanged();
    }

    private void init() {
        View footer = View.inflate((Context)this.getContext(), (int)R.layout.zm_list_load_more_footer, null);
        this.mPanelLoadMoreView = footer.findViewById(R.id.panelLoadMoreView);
        this.addFooterView(footer);
        this.mAdapter = new MMContentFilesAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mAdapter);
        this.mAdapter.setParentListView(this);
        this.setOnScrollListener(this);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
    }

    public void setupEmptyView(View panelEmptyView) {
        if (panelEmptyView == null) {
            return;
        }
        this.mPanelEmptyView = panelEmptyView;
        this.mTxtContentLoading = panelEmptyView.findViewById(R.id.txtContentLoading);
        this.mTxtEmptyView = panelEmptyView.findViewById(R.id.txtEmptyView);
        this.mTxtLoadingError = (TextView)panelEmptyView.findViewById(R.id.txtLoadingError);
    }

    public void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        if (result == 0) {
            this.mAdapter.updateOrAddContentFile(webFileID);
            this.notifyDataSetChanged(false);
            this.updateEmptyViewStatus(false, 0);
        }
    }

    public void Indicate_FileUnshared(String reqId, String webFileID, int result) {
        if (result == 0) {
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return;
            }
            ZoomFile file = mgr.getFileWithWebFileID(webFileID);
            if (file == null) {
                return;
            }
            MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
            if (mmFile == null) {
                return;
            }
            List<MMZoomShareAction> actions = mmFile.getShareAction();
            if (StringUtil.isEmptyOrNull((String)this.mSessionId)) {
                this.mAdapter.updateOrAddContentFile(webFileID);
            } else {
                boolean isContains = false;
                for (MMZoomShareAction action : actions) {
                    if (!StringUtil.isSameString((String)action.getSharee(), (String)this.mSessionId)) continue;
                    isContains = true;
                }
                if (isContains) {
                    this.mAdapter.updateOrAddContentFile(webFileID);
                } else {
                    this.mAdapter.deleteContentFile(webFileID);
                }
            }
            this.notifyDataSetChanged(true);
            this.updateEmptyViewStatus(false, 0);
        }
    }

    public void Indicate_FileStatusUpdated(String fileID) {
        this.mAdapter.updateContentFile(fileID);
        this.notifyDataSetChanged(false);
    }

    public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(fileId);
        if (file == null) {
            if (this.mAdapter.deleteContentFile(fileId) != null) {
                this.notifyDataSetChanged(false);
                this.updateEmptyViewStatus(false, 0);
            }
            return;
        }
        MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
        if (mmFile == null) {
            return;
        }
        if (actionType == 1) {
            this.mAdapter.deleteContentFile(fileId);
        } else if (actionType == 2) {
            List<MMZoomShareAction> actions = mmFile.getShareAction();
            if (StringUtil.isEmptyOrNull((String)this.mSessionId)) {
                this.mAdapter.updateOrAddContentFile(fileId);
            } else {
                boolean isContains = false;
                for (MMZoomShareAction action : actions) {
                    if (!StringUtil.isSameString((String)action.getSharee(), (String)this.mSessionId)) continue;
                    isContains = true;
                }
                if (isContains) {
                    this.mAdapter.updateOrAddContentFile(fileId);
                } else {
                    this.mAdapter.deleteContentFile(fileId);
                }
            }
        } else {
            this.mAdapter.updateContentFile(fileId);
        }
        this.notifyDataSetChanged(false);
        this.updateEmptyViewStatus(false, 0);
    }

    public void Indicate_NewFileSharedByOthers(String fileID) {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        mgr.downloadImgPreview(fileID);
        if (!StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            ZoomFile file = mgr.getFileWithWebFileID(fileID);
            if (file == null) {
                return;
            }
            MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
            if (mmFile == null) {
                return;
            }
            List<MMZoomShareAction> actions = mmFile.getShareAction();
            if (actions != null && actions.size() > 0) {
                boolean isContains = false;
                for (MMZoomShareAction action : actions) {
                    if (!StringUtil.isSameString((String)action.getSharee(), (String)this.mSessionId)) continue;
                    isContains = true;
                }
                if (isContains) {
                    this.mAdapter.updateOrAddContentFile(fileID);
                }
            }
        } else if (!this.mIsOwnerMode) {
            this.mAdapter.updateOrAddContentFile(fileID);
        }
        this.notifyDataSetChanged(false);
        this.updateEmptyViewStatus(false, 0);
    }

    public void Indicate_NewPersonalFile(String fileID) {
        if (!StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        mgr.downloadImgPreview(fileID);
        this.mAdapter.updateOrAddContentFile(fileID);
        this.notifyDataSetChanged(true);
        this.updateEmptyViewStatus(false, 0);
    }

    public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
        if (this.mAdapter.findFileByWebId(webFileID) != null) {
            this.mAdapter.updateContentFile(webFileID);
            this.notifyDataSetChanged(true);
        }
    }

    public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
        if (this.mAdapter.findFileByWebId(webFileID) != null && result == 0) {
            this.mAdapter.updateOrAddContentFile(webFileID);
            this.notifyDataSetChanged(true);
        }
    }

    public void Indicate_FileDeleted(String reqID, String webFileID, int result) {
        this.mAdapter.deleteContentFile(webFileID);
        this.updateEmptyViewStatus(false, 0);
    }

    public void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
        this.mAdapter.deleteContentFile(reqID);
        if (result == 0 && !StringUtil.isEmptyOrNull((String)webFileID)) {
            this.mAdapter.updateOrAddContentFile(webFileID);
        }
        this.notifyDataSetChanged(true);
        this.updateEmptyViewStatus(false, 0);
    }

    public void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
        this.onUploadToMyListOnProgress(reqID, ratio, completeSize, bitPerSecond);
    }

    public void setMode(boolean isOwnerMode) {
        this.mIsOwnerMode = isOwnerMode;
        this.mAdapter.setMode(isOwnerMode);
    }

    public void setEraseTime(long eraseTime, boolean erase) {
        this.mAdapter.setEraseTime(eraseTime, erase);
    }

    public void notifyDataSetChanged(long eraseTime) {
        this.mHandler.removeCallbacks(this.mRunnableNotifyDataSetChanged);
        this.mAdapter.notifyDataSetChanged();
    }

    public void notifyDataSetChanged(boolean noLazy) {
        if (noLazy) {
            this.mHandler.removeCallbacks(this.mRunnableNotifyDataSetChanged);
            this.mAdapter.notifyDataSetChanged();
        } else {
            this.mHandler.removeCallbacks(this.mRunnableNotifyDataSetChanged);
            this.mHandler.postDelayed(this.mRunnableNotifyDataSetChanged, 500L);
        }
    }

    private void insertTimeChatMsg() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        PTAppProtos.LocalStorageTimeInterval interval = messenger.getLocalStorageTimeInterval();
        if (interval != null) {
            this.mAdapter.insertTimedChat();
        }
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putString("reqId", this.mReqId);
        bundle.putString("sessionid", this.mSessionId);
        bundle.putBoolean("isOwnerMode", this.mIsOwnerMode);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state != null && state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mReqId = bundle.getString("reqId");
            this.mSessionId = bundle.getString("sessionid");
            this.mIsOwnerMode = bundle.getBoolean("isOwnerMode", false);
            Parcelable superState = bundle.getParcelable("superState");
            super.onRestoreInstanceState(superState);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public void onUploadFile(String reqId, String fileName) {
        MMZoomFile file = new MMZoomFile();
        file.setWebID(reqId);
        file.setReqId(reqId);
        file.setFileName(fileName);
        this.mAdapter.updateOrAddContentFile(file);
        this.onUploadToMyListOnProgress(reqId, 0, 0, 0);
        this.notifyDataSetChanged(true);
    }

    public void onDownloadByFileIDOnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        MMZoomFile file = this.mAdapter.findFileByWebId(webFileID);
        if (file == null) {
            return;
        }
        file.setPending(true);
        file.setRatio(ratio);
        file.setReqId(reqId);
        file.setFileDownloading(true);
        file.setCompleteSize(completeSize);
        file.setBitPerSecond(bitPerSecond);
        this.notifyDataSetChanged(true);
    }

    public void onUploadToMyListOnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
        MMZoomFile file = this.mAdapter.findFileByWebId(reqID);
        if (file == null) {
            return;
        }
        file.setPending(true);
        file.setRatio(ratio);
        file.setCompleteSize(completeSize);
        file.setBitPerSecond(bitPerSecond);
        this.notifyDataSetChanged(true);
    }

    public void loadData(boolean isForceLoad) {
        if (this.isInEditMode()) {
            return;
        }
        this.loadFiles(isForceLoad, false);
    }

    public void addUploadFile(String reqId, String name, int totalSize) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy self = messenger.getMyself();
        if (self == null) {
            return;
        }
        MMZoomFile file = new MMZoomFile();
        file.setWebID(reqId);
        file.setReqId(reqId);
        file.setFileName(name);
        file.setTimeStamp(System.currentTimeMillis());
        file.setPending(true);
        file.setFileSize(totalSize);
        file.setOwnerJid(self.getJid());
        file.setOwnerName(self.getScreenName());
        this.mAdapter.updateOrAddContentFile(file);
        this.notifyDataSetChanged(true);
        this.updateEmptyViewStatus(false, 0);
    }

    public void Indicate_QueryMyFilesResponse(String reqId, int result, List<String> arrWebFileID, long queryEndTime) {
        if (StringUtil.isSameString((String)this.mReqId, (String)reqId)) {
            this.updateFiles(arrWebFileID, false);
            this.notifyDataSetChanged(true);
            this.showRefreshing(false);
            this.mPanelLoadMoreView.setVisibility(8);
            this.mReqId = null;
            this.updateEmptyViewStatus(false, result);
        }
    }

    public void Indicate_QueryFilesSharedWithMeResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
        if (StringUtil.isSameString((String)this.mReqId, (String)reqId)) {
            this.updateFiles(arrWebFiles, false);
            this.notifyDataSetChanged(true);
            this.showRefreshing(false);
            this.mPanelLoadMoreView.setVisibility(8);
            this.mReqId = null;
            this.updateEmptyViewStatus(false, result);
        }
    }

    public void Indicate_QueryAllFilesResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
        if (StringUtil.isSameString((String)this.mReqId, (String)reqId)) {
            this.updateFiles(arrWebFiles, false);
            this.notifyDataSetChanged(true);
            this.showRefreshing(false);
            this.mPanelLoadMoreView.setVisibility(8);
            this.mReqId = null;
            this.updateEmptyViewStatus(false, result);
        }
    }

    public void Indicate_QuerySessionFilesResponse(String reqId, String session, int result, List<String> arrWebFileID, long queryEndTime) {
        if (StringUtil.isSameString((String)this.mReqId, (String)reqId)) {
            boolean isMuc;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession chatSession = messenger.getSessionById(this.mSessionId);
            boolean bl = isMuc = chatSession != null && chatSession.getSessionGroup() != null && !chatSession.getSessionGroup().isRoom();
            if (!isMuc) {
                this.updateFiles(arrWebFileID, false);
                this.notifyDataSetChanged(true);
                if (arrWebFileID.size() < 20) {
                    this.insertTimeChatMsg();
                }
            }
            this.showRefreshing(false);
            this.mPanelLoadMoreView.setVisibility(8);
            this.mReqId = null;
            if (!isMuc) {
                this.updateEmptyViewStatus(false, result);
            }
        }
    }

    public void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
        if (result == 0) {
            this.mAdapter.updateContentFile(fileId);
            this.notifyDataSetChanged(true);
        }
    }

    private void loadFiles(boolean isForceLoad, boolean doRefresh) {
        String jid;
        boolean isFirstLoad;
        long timeStamp = this.mAdapter.getLastTimeStamp();
        if (timeStamp != 0L && !isForceLoad) {
            this.mPanelEmptyView.setVisibility(8);
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        boolean bl = isFirstLoad = timeStamp == 0L;
        if (doRefresh || timeStamp == 0L) {
            timeStamp = CmmTime.getMMNow();
            this.mIsLoadFinish = false;
        }
        if (StringUtil.isEmptyOrNull((String)(jid = myself.getJid()))) {
            return;
        }
        PTAppProtos.FileQueryResult res = null;
        boolean isMuc = false;
        if (StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            res = this.mIsOwnerMode ? mgr.queryOwnedFiles(jid, timeStamp, 20) : mgr.queryAllFiles(timeStamp, 20);
        } else {
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            isMuc = session != null && session.getSessionGroup() != null && !session.getSessionGroup().isRoom();
            res = mgr.queryFilesForSession(this.mSessionId, timeStamp, 20);
        }
        if (res == null) {
            return;
        }
        this.mReqId = res.getReqid();
        List<String> fileIds = res.getFileIdsList();
        if (res.getWebSearchTriggered()) {
            this.mPanelLoadMoreView.setVisibility(isFirstLoad ? 8 : 0);
            this.showRefreshing(fileIds.size() > 0 && isFirstLoad);
        } else {
            this.showRefreshing(false);
        }
        if (fileIds != null && fileIds.size() != 0) {
            this.updateFiles(fileIds, isFirstLoad || doRefresh);
        }
        this.addUploadPendingFiles();
        this.notifyDataSetChanged(true);
        if (res.getWebSearchTriggered()) {
            if (isMuc) {
                this.updateEmptyViewStatus(false, 0);
            } else {
                this.updateEmptyViewStatus(true, 0);
            }
        } else if (StringUtil.isEmptyOrNull((String)this.mReqId)) {
            this.updateEmptyViewStatus(false, 0);
        } else {
            this.mPanelEmptyView.setVisibility(8);
        }
    }

    private void updateEmptyViewStatus(boolean isLoading, int resultCode) {
        if (this.mPanelEmptyView == null || this.mTxtContentLoading == null || this.mTxtEmptyView == null || this.mTxtLoadingError == null) {
            return;
        }
        if (this.getVisibility() != 0) {
            return;
        }
        this.mPanelEmptyView.setVisibility(this.mAdapter.getCount() == 0 ? 0 : 8);
        if (isLoading) {
            this.mTxtContentLoading.setVisibility(0);
            this.mTxtEmptyView.setVisibility(8);
            this.mTxtLoadingError.setVisibility(8);
        } else {
            this.mTxtContentLoading.setVisibility(8);
            this.mTxtEmptyView.setVisibility(resultCode == 0 ? 0 : 8);
            this.mTxtLoadingError.setVisibility(resultCode != 0 ? 0 : 8);
        }
    }

    private void addUploadPendingFiles() {
        List<PendingFileDataHelper.PendingFileInfo> infos = PendingFileDataHelper.getInstance().getUploadPendingFileInfos();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy self = messenger.getMyself();
        if (self == null) {
            return;
        }
        for (PendingFileDataHelper.PendingFileInfo info : infos) {
            MMZoomFile file = new MMZoomFile();
            file.setBitPerSecond(info.bitPerSecond);
            file.setPending(true);
            file.setCompleteSize(info.completeSize);
            file.setRatio(info.ratio);
            file.setWebID(info.reqId);
            file.setReqId(info.reqId);
            file.setFileName(info.name);
            file.setTimeStamp(info.timestamp);
            file.setFileSize(info.totalSize);
            file.setOwnerJid(self.getJid());
            file.setOwnerName(self.getScreenName());
            this.mAdapter.updateOrAddContentFile(file);
        }
        this.notifyDataSetChanged(true);
    }

    private boolean isGroupOwner() {
        if (StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ZoomGroup group = messenger.getGroupById(this.mSessionId);
        if (group == null || !group.isRoom()) {
            return false;
        }
        return group.isGroupOperatorable();
    }

    private void updateFiles(List<String> fileIds, boolean isFirstLoad) {
        this.mAdapter.setDataInited(true);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        boolean isRoom = session != null && session.getSessionGroup() != null && session.getSessionGroup().isRoom();
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        if (fileIds == null || fileIds.size() == 0) {
            this.mIsLoadFinish = true;
            return;
        }
        ArrayList<MMZoomFile> files = new ArrayList<MMZoomFile>();
        if (fileIds.size() > 0) {
            for (String fileId : fileIds) {
                int fileType;
                MMZoomFile mmFile;
                ZoomFile file = mgr.getFileWithWebFileID(fileId);
                if (file == null || (mmFile = MMZoomFile.initWithZoomFile(file, mgr)) == null || mmFile.isDeletePending() || StringUtil.isEmptyOrNull((String)mmFile.getFileName()) || mmFile.getLastedShareTime() <= 0L || mmFile.getLastedShareTime() <= this.mAdapter.getEraseTime()) continue;
                if (isRoom && !StringUtil.isEmptyOrNull((String)this.mSessionId)) {
                    List<MMZoomShareAction> actions = mmFile.getShareAction();
                    if (actions == null || actions.size() == 0) continue;
                    boolean isShareInSession = false;
                    for (MMZoomShareAction action : actions) {
                        if (!this.mSessionId.equals(action.getSharee())) continue;
                        isShareInSession = true;
                        break;
                    }
                    if (!isShareInSession) continue;
                }
                if (((fileType = mmFile.getFileType()) == 1 || fileType == 1 || fileType == 4) && StringUtil.isEmptyOrNull((String)mmFile.getPicturePreviewPath())) {
                    mgr.downloadImgPreview(mmFile.getWebID());
                }
                files.add(mmFile);
                if (StringUtil.isEmptyOrNull((String)this.mSessionId) && this.mIsOwnerMode || mmFile.getShareAction() != null && mmFile.getShareAction().size() != 0) continue;
                mgr.syncFileInfoByFileID(fileId);
            }
        }
        if (isFirstLoad) {
            this.mAdapter.clearAll();
        }
        this.mAdapter.addContenFiles(files);
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (!this.mIsLoadFinish && firstVisibleItem > 0 && visibleItemCount + firstVisibleItem == totalItemCount && StringUtil.isEmptyOrNull((String)this.mReqId)) {
            this.loadFiles(true, false);
        }
    }

    public void onPullDownRefresh() {
        this.loadFiles(true, true);
    }

    public void endFileTransfer(String webFileId) {
        this.mAdapter.updateOrAddContentFile(webFileId);
        this.notifyDataSetChanged(true);
        this.updateEmptyViewStatus(false, 0);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        MMZoomFile file = this.mAdapter.getItemAtPosition(position - this.getHeaderViewsCount());
        if (file == null) {
            return;
        }
        if (file.isPending() && PendingFileDataHelper.getInstance().isFileUploadNow(file.getReqId())) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile zoomFile = mgr.getFileWithWebFileID(file.getWebID());
        if (zoomFile == null) {
            this.mAdapter.deleteContentFile(file.getWebID());
            this.mAdapter.notifyDataSetChanged();
            return;
        }
        mgr.destroyFileObject(zoomFile);
        if (this.mListener != null) {
            this.mListener.onZoomFileClick(file.getWebID());
        }
    }

    @Override
    public void onZoomFileClick(String fileId) {
    }

    @Override
    public void onZoomFileShared(String fileId) {
        if (this.mListener != null) {
            this.mListener.onZoomFileShared(fileId);
        }
    }

    @Override
    public void onZoomFileCancelTransfer(String fileId) {
        if (this.mListener != null) {
            this.mListener.onZoomFileCancelTransfer(fileId);
        }
    }

    @Override
    public void onZoomFileSharerAction(String fileId, MMZoomShareAction action) {
        if (this.mListener != null) {
            this.mListener.onZoomFileSharerAction(fileId, action);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        MoreContextMenuItem item;
        MMZoomFile file = this.mAdapter.getItemAtPosition(position - this.getHeaderViewsCount());
        if (file == null) {
            return false;
        }
        if (file.isPending() && PendingFileDataHelper.getInstance().isFileUploadNow(file.getReqId())) {
            return false;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return false;
        }
        ZoomFile zoomFile = mgr.getFileWithWebFileID(file.getWebID());
        if (zoomFile == null) {
            this.mAdapter.deleteContentFile(file.getWebID());
            this.mAdapter.notifyDataSetChanged();
            return false;
        }
        mgr.destroyFileObject(zoomFile);
        boolean isFileTransferDisable = PTApp.getInstance().isFileTransferDisabled();
        if (isFileTransferDisable) {
            return false;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter(this.getContext(), false);
        ArrayList<MoreContextMenuItem> items = new ArrayList<MoreContextMenuItem>();
        if (!StringUtil.isEmptyOrNull((String)file.getWebID())) {
            item = new MoreContextMenuItem(this.getContext().getString(R.string.zm_btn_share), 5);
            item.fileId = file.getWebID();
            items.add(item);
        }
        if (!StringUtil.isEmptyOrNull((String)file.getWebID()) && StringUtil.isSameString((String)myself.getJid(), (String)file.getOwnerJid())) {
            item = new MoreContextMenuItem(this.getContext().getString(R.string.zm_btn_delete), 1);
            item.fileId = file.getWebID();
            items.add(item);
        }
        if (items.size() == 0) {
            return false;
        }
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder(this.getContext()).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MoreContextMenuItem mi = (MoreContextMenuItem)((Object)menuAdapter.getItem(which));
                MMContentFilesListView.this.onSelectContextMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
        return true;
    }

    private void onSelectContextMenuItem(MoreContextMenuItem mi) {
        String fileId = mi.fileId;
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        switch (mi.getAction()) {
            case 1: {
                this.onSelectContextMenuItemDeleteFile(fileId);
                break;
            }
            case 5: {
                this.onZoomFileShared(fileId);
            }
        }
    }

    private void onSelectContextMenuItemDeleteFile(String fileId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile zoomFile = mgr.getFileWithWebFileID(fileId);
        if (zoomFile == null) {
            return;
        }
        final MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        if (file == null) {
            return;
        }
        String fileName = FileUtils.shrinkFileName((String)file.getFileName(), (int)30);
        if (fileName == null) {
            fileName = "";
        }
        String title = this.getContext().getString(R.string.zm_msg_delete_file_confirm, new Object[]{fileName});
        if (TextUtils.isEmpty((CharSequence)this.mSessionId)) {
            ZMAlertDialog dlg = new ZMAlertDialog.Builder(this.getContext()).setTitle(title).setMessage(R.string.zm_msg_delete_file_warning).setNegativeButton(R.string.zm_btn_cancel, null).setPositiveButton(R.string.zm_btn_delete, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MMContentFilesListView.this.deleteFile(file);
                }
            }).create();
            dlg.show();
        } else {
            this.deleteFile(file);
        }
    }

    private void deleteFile(MMZoomFile file) {
        if (file == null) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        String reqId = mgr.deleteFile(file, this.mSessionId);
        if (!StringUtil.isEmptyOrNull((String)reqId)) {
            this.Indicate_FileDeleted(reqId, file.getWebID(), 0);
        } else {
            Context context = this.getContext();
            if (context instanceof FragmentActivity) {
                ErrorMsgDialog.newInstance(this.getResources().getString(R.string.zm_alert_unshare_file_failed), -1).show(((FragmentActivity)context).getSupportFragmentManager(), ErrorMsgDialog.class.getName());
            }
        }
    }

    private void showConnectionError() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)0).show();
    }

    public static class MoreContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_DELETE = 1;
        public static final int ACTION_SHARE = 5;
        public String fileId;

        public MoreContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

