/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.fragment.MMSelectSessionAndBuddyFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.pdf.PDFView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.ZMGifView;
import com.zipow.videobox.view.mm.MMMessageItem;
import com.zipow.videobox.view.mm.MMShareZoomFileDialogFragment;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.TouchImageView;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMContentFileViewerFragment
extends ZMDialogFragment
implements View.OnClickListener,
TouchImageView.OnSingleTapConfirmedListener {
    private static final int REQUEST_CODE_SAVE_IMAGE = 3101;
    protected static final int DISPLAY_ANIM_DURATION = 200;
    private static final String ARGS_ZOOM_FILE_WEB_ID = "zoomFileWebId";
    private static final String ARGS_ZOOM_MESSAGE_ID = "messageId";
    private static final String ARGS_ZOOM_SESSION_ID = "sessionId";
    private static final String ARGS_ZOOM_MESSAGE_XMPP_ID = "messageXPPId";
    public static final String RESULT_ACTION = "action";
    public static final String RESULT_FILE_WEB_ID = "zoomFileWebId";
    public static final String RESULT_REQ_ID = "reqId";
    private static final String ARGS_SHARE_FILE_ID = "shareFileId";
    private static final String TAG = MMContentFileViewerFragment.class.getSimpleName();
    public static final int REQUEST_GET_SHAREER = 1;
    public static final int ACTION_DELETE = 1;
    private static final int MAX_IMAGE_SIZE_IN_AREA = 1000000;
    private TextView mTxtFileNameTtile;
    private TextView mTxtFileDes;
    private TextView mTxtFileSharees;
    private TextView mTxtTranslateSpeed;
    private ProgressBar mUploadProgressBar;
    private ImageButton mBtnShare;
    private View mPanelNormalFile;
    private ZMGifView mImgGifView;
    private TouchImageView mImageview;
    private ImageView mImgFileType;
    private String mFileWebId;
    private Button mBtnDownload;
    private Button mBtnViewFile;
    private PDFView mPdfView;
    private TextView mTxtNotSupportPreview;
    private View mPanelTitleBar;
    private ProgressDialog mWaitingSaveDialog;
    private View mPanelBottomBar;
    private View mViewPlaceHolder;
    private TextView mTxtMessage;
    private ImageButton mBtnMore;
    private boolean mIsE2EFile;
    private String mSessionId;
    private String mMessageXMPPID;
    private String mMessageID;
    private View mPanelContent;
    private Handler mHandler = new Handler();
    private ZoomMessengerUI.IZoomMessengerUIListener mMessengerListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
            MMContentFileViewerFragment.this.Indicate_FileDownloaded(reqID, webFileID, result);
        }

        @Override
        public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
            MMContentFileViewerFragment.this.FT_DownloadByFileID_OnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
        }

        @Override
        public void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
            MMContentFileViewerFragment.this.Indicate_RenameFileResponse(result, reqId, fileId, newName);
        }

        @Override
        public void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
            MMContentFileViewerFragment.this.Indicate_FileShared(reqId, webFileID, sharee, newSession, newMsgXmppID, result);
        }

        @Override
        public void Indicate_FileUnshared(String reqId, String webFileID, int result) {
            MMContentFileViewerFragment.this.Indicate_FileUnshared(reqId, webFileID, result);
        }

        @Override
        public void Indicate_FileStatusUpdated(String fileID) {
            MMContentFileViewerFragment.this.Indicate_FileStatusUpdated(fileID);
        }

        @Override
        public void onConnectReturn(int errorCode) {
            MMContentFileViewerFragment.this.onConnectReturn(errorCode);
        }

        @Override
        public void FT_OnProgress(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
            MMContentFileViewerFragment.this.FT_OnProgress(sessionID, messageID, ratio, completeSize, bitPerSecond);
        }

        @Override
        public void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
            MMContentFileViewerFragment.this.onConfirmFileDownloaded(sessionId, messageId, result);
        }

        @Override
        public void FT_OnDownloadByMsgIDTimeOut(String sessionID, String messageID) {
            MMContentFileViewerFragment.this.FT_OnDownloadByMsgIDTimeOut(sessionID, messageID);
        }

        @Override
        public void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
            MMContentFileViewerFragment.this.FT_OnDownloadByFileIDTimeOut(reqID, webFileID);
        }
    };

    public static void showAsActivity(Fragment fragment, String fileWebId, int requestCode) {
        Bundle args = new Bundle();
        args.putString("zoomFileWebId", fileWebId);
        SimpleActivity.show(fragment, MMContentFileViewerFragment.class.getName(), args, requestCode, true, 1);
    }

    public static void showAsActivity(ZMActivity activity, String fileWebId, int requestCode) {
        Bundle args = new Bundle();
        args.putString("zoomFileWebId", fileWebId);
        SimpleActivity.show(activity, MMContentFileViewerFragment.class.getName(), args, requestCode, true, 1);
    }

    public static void showAsActivity(ZMActivity activity, String sessionId, String messageId, String messageXmppId, String fileWebId, int requestCode) {
        if (StringUtil.isEmptyOrNull((String)messageId) || StringUtil.isEmptyOrNull((String)messageId) || activity == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putString(ARGS_ZOOM_MESSAGE_ID, messageId);
        args.putString(ARGS_ZOOM_SESSION_ID, sessionId);
        args.putString(ARGS_ZOOM_MESSAGE_XMPP_ID, messageXmppId);
        if (!StringUtil.isEmptyOrNull((String)fileWebId)) {
            args.putString("zoomFileWebId", fileWebId);
        }
        SimpleActivity.show(activity, MMContentFileViewerFragment.class.getName(), args, requestCode, true, 1);
    }

    public static void showAsActivity(Fragment fragment, String sessionId, String messageId, String messageXmppId, String fileWebId, int requestCode) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putString(ARGS_ZOOM_MESSAGE_ID, messageId);
        args.putString(ARGS_ZOOM_SESSION_ID, sessionId);
        args.putString(ARGS_ZOOM_MESSAGE_XMPP_ID, messageXmppId);
        if (!StringUtil.isEmptyOrNull((String)fileWebId)) {
            args.putString("zoomFileWebId", fileWebId);
        }
        SimpleActivity.show(fragment, MMContentFileViewerFragment.class.getName(), args, requestCode, true, 1);
    }

    public static MMContentFileViewerFragment findMyProfileFragment(FragmentManager fm) {
        MMContentFileViewerFragment f = (MMContentFileViewerFragment)fm.findFragmentByTag(MMContentFileViewerFragment.class.getName());
        return f;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_content_file_viewer, container, false);
        this.mTxtFileNameTtile = (TextView)view.findViewById(R.id.txtFileNameTitle);
        this.mTxtFileDes = (TextView)view.findViewById(R.id.txtFileDes);
        this.mImgGifView = (ZMGifView)view.findViewById(R.id.imgGifView);
        this.mImageview = (TouchImageView)view.findViewById(R.id.imageview);
        this.mPanelNormalFile = view.findViewById(R.id.panelNormalFile);
        this.mTxtFileSharees = (TextView)view.findViewById(R.id.txtFileSharees);
        this.mImgFileType = (ImageView)view.findViewById(R.id.imgFileType);
        this.mBtnDownload = (Button)view.findViewById(R.id.btnDownload);
        this.mBtnViewFile = (Button)view.findViewById(R.id.btnViewFile);
        this.mPdfView = (PDFView)view.findViewById(R.id.pdfView);
        this.mTxtTranslateSpeed = (TextView)view.findViewById(R.id.txtTranslateSpeed);
        this.mUploadProgressBar = (ProgressBar)view.findViewById(R.id.uploadProgressBar);
        this.mTxtNotSupportPreview = (TextView)view.findViewById(R.id.txtNotSupportPreview);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mPanelBottomBar = view.findViewById(R.id.panelBottomBar);
        this.mBtnShare = (ImageButton)view.findViewById(R.id.btnShare);
        this.mViewPlaceHolder = view.findViewById(R.id.viewPlaceHolder);
        this.mTxtMessage = (TextView)view.findViewById(R.id.txtMessage);
        this.mBtnMore = (ImageButton)view.findViewById(R.id.btnMore);
        this.mPanelContent = view.findViewById(R.id.panelContent);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mFileWebId = args.getString("zoomFileWebId");
            this.mSessionId = args.getString(ARGS_ZOOM_SESSION_ID);
            this.mMessageXMPPID = args.getString(ARGS_ZOOM_MESSAGE_XMPP_ID);
            this.mMessageID = args.getString(ARGS_ZOOM_MESSAGE_ID);
        }
        view.findViewById(R.id.btnClose).setOnClickListener((View.OnClickListener)this);
        this.mBtnShare.setOnClickListener((View.OnClickListener)this);
        this.mBtnMore.setOnClickListener((View.OnClickListener)this);
        this.mPanelContent.setOnClickListener((View.OnClickListener)this);
        this.mBtnViewFile.setOnClickListener((View.OnClickListener)this);
        this.mBtnDownload.setOnClickListener((View.OnClickListener)this);
        this.mImageview.setOnSingleTapConfirmedListener((TouchImageView.OnSingleTapConfirmedListener)this);
        this.mViewPlaceHolder.setOnClickListener((View.OnClickListener)this);
        this.mPanelBottomBar.setOnClickListener((View.OnClickListener)this);
        this.mPanelTitleBar.setOnClickListener((View.OnClickListener)this);
        this.mPdfView.setListener(new PDFView.PDFViewListener(){

            @Override
            public void onPDFViewPageChanged() {
            }

            @Override
            public void onPDFViewClicked() {
                MMContentFileViewerFragment.this.onTapContent();
            }
        });
        if (StringUtil.isEmptyOrNull((String)this.mFileWebId)) {
            this.mTxtFileDes.setVisibility(4);
            this.mTxtFileSharees.setVisibility(4);
            this.mBtnShare.setVisibility(4);
        }
        this.autoDownloadIfNeeded();
        this.checkIsE2EFile();
        return view;
    }

    public void onStop() {
        this.mPdfView.closeFile();
        super.onStop();
    }

    public void onResume() {
        super.onResume();
        ZoomMessengerUI.getInstance().addListener(this.mMessengerListener);
        this.mPdfView.setSeekBarBottomPadding(UIUtil.dip2px((Context)this.getActivity(), (float)40.0f));
        this.refreshUI();
    }

    private void checkIsE2EFile() {
        if (!StringUtil.isEmptyOrNull((String)this.mMessageXMPPID) && !StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            if (session == null) {
                return;
            }
            ZoomMessage msg = session.getMessageByXMPPGuid(this.mMessageXMPPID);
            if (msg == null) {
                return;
            }
            this.mIsE2EFile = msg.isE2EMessage();
        }
    }

    private boolean checkIsGroupOpt() {
        if (!TextUtils.isEmpty((CharSequence)this.mSessionId)) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return false;
            }
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            if (session == null) {
                return false;
            }
            ZoomGroup group = session.getSessionGroup();
            if (group != null) {
                return group.isGroupOperatorable();
            }
        }
        return false;
    }

    private void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
        if (StringUtil.isSameString((String)webFileID, (String)this.mFileWebId) && this.isResumed()) {
            this.refreshUI();
        }
    }

    private void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
        if (StringUtil.isSameString((String)fileId, (String)this.mFileWebId)) {
            this.dismissWaitingDialog();
            this.refreshUI();
        }
    }

    private void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        if (StringUtil.isSameString((String)webFileID, (String)this.mFileWebId) && this.isResumed()) {
            this.refreshUI();
        }
    }

    private void Indicate_FileUnshared(String reqId, String webFileID, int result) {
        if (StringUtil.isSameString((String)webFileID, (String)this.mFileWebId) && this.isResumed()) {
            this.refreshUI();
        }
    }

    private void Indicate_FileStatusUpdated(String fileID) {
        if (StringUtil.isSameString((String)fileID, (String)this.mFileWebId) && this.isResumed()) {
            this.refreshUI();
        }
    }

    public void onConnectReturn(int errorCode) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.isConnectionGood() && this.isResumed()) {
            this.refreshUI();
        }
    }

    private void FT_OnDownloadByMsgIDTimeOut(String sessionID, String messageID) {
        if (StringUtil.isSameString((String)sessionID, (String)this.mSessionId) && StringUtil.isSameString((String)messageID, (String)this.mMessageID)) {
            this.refreshUI();
        }
    }

    private void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
        if (StringUtil.isSameString((String)webFileID, (String)this.mFileWebId)) {
            this.refreshUI();
        }
    }

    private void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
        if (StringUtil.isSameString((String)sessionId, (String)this.mSessionId) && StringUtil.isSameString((String)messageId, (String)this.mMessageID)) {
            this.refreshUI();
        }
    }

    private void FT_OnProgress(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
        if (StringUtil.isSameString((String)sessionID, (String)this.mSessionId) && StringUtil.isSameString((String)messageID, (String)this.mMessageID)) {
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return;
            }
            ZoomFile file = mgr.getFileWithMessageID(sessionID, this.mMessageXMPPID);
            if (file == null) {
                return;
            }
            String completeSizeStr = FileUtils.toFileSizeString((Context)this.getActivity(), (long)completeSize);
            String totalSizeStr = FileUtils.toFileSizeString((Context)this.getActivity(), (long)file.getFileSize());
            String speedStr = FileUtils.toFileSizeString((Context)this.getActivity(), (long)bitPerSecond);
            this.mTxtTranslateSpeed.setText((CharSequence)this.getActivity().getString(R.string.zm_lbl_translate_speed, new Object[]{completeSizeStr, totalSizeStr, speedStr}));
            this.mTxtTranslateSpeed.setVisibility(0);
            this.mUploadProgressBar.setProgress(ratio);
            this.mUploadProgressBar.setVisibility(0);
            this.mBtnDownload.setVisibility(8);
            this.mBtnViewFile.setVisibility(8);
            if (ratio == 100) {
                this.refreshUI();
            }
        }
    }

    public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        if (StringUtil.isSameString((String)webFileID, (String)this.mFileWebId)) {
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return;
            }
            ZoomFile file = mgr.getFileWithWebFileID(webFileID);
            if (file == null) {
                return;
            }
            String completeSizeStr = FileUtils.toFileSizeString((Context)this.getActivity(), (long)completeSize);
            String totalSizeStr = FileUtils.toFileSizeString((Context)this.getActivity(), (long)file.getFileSize());
            String speedStr = FileUtils.toFileSizeString((Context)this.getActivity(), (long)bitPerSecond);
            this.mTxtTranslateSpeed.setText((CharSequence)this.getActivity().getString(R.string.zm_lbl_translate_speed, new Object[]{completeSizeStr, totalSizeStr, speedStr}));
            this.mTxtTranslateSpeed.setVisibility(0);
            this.mUploadProgressBar.setProgress(ratio);
            this.mUploadProgressBar.setVisibility(0);
            this.mBtnDownload.setVisibility(8);
            this.mBtnViewFile.setVisibility(8);
            mgr.destroyFileObject(file);
        }
    }

    private void onTapContent() {
        boolean show;
        TranslateAnimation topAnim = null;
        TranslateAnimation bottomAnim = null;
        boolean bl = show = this.mPanelTitleBar.getVisibility() != 0;
        if (show) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelBottomBar.setVisibility(0);
            topAnim = new TranslateAnimation(0.0f, 0.0f, (float)(-this.mPanelTitleBar.getHeight()), 0.0f);
            bottomAnim = new TranslateAnimation(0.0f, 0.0f, (float)this.mPanelBottomBar.getHeight(), 0.0f);
        } else {
            topAnim = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-this.mPanelTitleBar.getHeight()));
            bottomAnim = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)this.mPanelBottomBar.getHeight());
            Animation.AnimationListener listener = new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    MMContentFileViewerFragment.this.mPanelTitleBar.setVisibility(4);
                    MMContentFileViewerFragment.this.mPanelBottomBar.setVisibility(4);
                }
            };
            topAnim.setAnimationListener(listener);
            bottomAnim.setAnimationListener(listener);
        }
        topAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
        topAnim.setDuration(200L);
        this.mPanelTitleBar.startAnimation((Animation)topAnim);
        bottomAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
        bottomAnim.setDuration(200L);
        this.mPanelBottomBar.startAnimation((Animation)bottomAnim);
    }

    public void onPause() {
        ZoomMessengerUI.getInstance().removeListener(this.mMessengerListener);
        super.onPause();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                if (resultCode != -1 || data == null) break;
                Bundle bundle = data.getExtras();
                if (bundle == null) {
                    return;
                }
                String messageId = bundle.getString(ARGS_SHARE_FILE_ID);
                if (StringUtil.isEmptyOrNull((String)messageId)) {
                    return;
                }
                String jid = data.getStringExtra("selectedItem");
                if (StringUtil.isEmptyOrNull((String)jid)) {
                    return;
                }
                ArrayList<String> sharees = new ArrayList<String>();
                sharees.add(jid);
                if (sharees.size() <= 0) break;
                this.doShareFile(sharees, messageId);
                break;
            }
        }
    }

    private void doShareFile(ArrayList<String> sharees, String fileID) {
        if (TextUtils.isEmpty((CharSequence)this.mSessionId) || TextUtils.isEmpty((CharSequence)this.mMessageXMPPID)) {
            MMShareZoomFileDialogFragment.showShareFileDialog(this.getFragmentManager(), sharees, fileID);
        } else {
            MMShareZoomFileDialogFragment.showShareFileDialog(this.getFragmentManager(), sharees, fileID, this.mMessageXMPPID, this.mSessionId, null, 0);
        }
    }

    private void autoDownloadIfNeeded() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile zoomFile = this.getZoomFile(mgr);
        if (zoomFile == null) {
            return;
        }
        MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        if (file.isFileDownloading()) {
            this.FT_DownloadByFileID_OnProgress(null, this.mFileWebId, 0, 0, 0);
            return;
        }
        if (!file.isFileDownloaded() || StringUtil.isEmptyOrNull((String)file.getLocalPath()) || !new File(file.getLocalPath()).exists()) {
            this.FT_DownloadByFileID_OnProgress(null, this.mFileWebId, 0, 0, 0);
            if (!StringUtil.isEmptyOrNull((String)this.mMessageID)) {
                ZoomChatSession session = messenger.getSessionById(this.mSessionId);
                if (session == null) {
                    return;
                }
                ZoomMessage message = session.getMessageById(this.mMessageID);
                if (message == null) {
                    return;
                }
                ZoomMessage.FileTransferInfo info = message.getFileTransferInfo();
                if (info == null) {
                    return;
                }
                if (info.state != 13) {
                    session.downloadFileForMessage(this.mMessageID);
                }
            } else {
                String reqId = mgr.downloadFile(this.mFileWebId, PendingFileDataHelper.getContenFilePath(this.mFileWebId, file.getFileName()));
                if (!StringUtil.isEmptyOrNull((String)reqId)) {
                    this.mTxtTranslateSpeed.setVisibility(0);
                    this.mUploadProgressBar.setVisibility(0);
                    this.mBtnDownload.setVisibility(8);
                    this.mBtnViewFile.setVisibility(8);
                    this.FT_DownloadByFileID_OnProgress(reqId, this.mFileWebId, 0, 0, 0);
                    this.mViewPlaceHolder.setVisibility(8);
                } else {
                    this.showDownloadErrorUI();
                }
            }
        }
    }

    private boolean isImageFile(String imagePath) {
        if (!StringUtil.isEmptyOrNull((String)imagePath)) {
            return (imagePath = imagePath.toLowerCase(CompatUtils.getLocalDefault())).endsWith(".jpg") || imagePath.endsWith(".jpeg") || imagePath.endsWith(".png") || imagePath.endsWith(".gif");
        }
        return false;
    }

    private boolean isPdfFile(String fileName) {
        if (!StringUtil.isEmptyOrNull((String)fileName)) {
            fileName = fileName.toLowerCase(CompatUtils.getLocalDefault());
            return fileName.endsWith(".pdf");
        }
        return false;
    }

    private void showDownloadErrorUI() {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile zoomFile = this.getZoomFile(mgr);
        if (zoomFile == null) {
            return;
        }
        MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        if (file == null) {
            return;
        }
        this.mViewPlaceHolder.setVisibility(0);
        this.mTxtMessage.setText(ZmPtUtils.isImageFile(file.getFileType()) ? R.string.zm_mm_msg_download_image_failed : R.string.zm_mm_msg_download_other_failed);
        this.mTxtTranslateSpeed.setVisibility(4);
        this.mUploadProgressBar.setVisibility(4);
        this.mBtnDownload.setVisibility(8);
    }

    private void refreshUI() {
        boolean isDownloadError;
        ZoomFile zoomFile = null;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        zoomFile = this.getZoomFile(mgr);
        if (zoomFile == null) {
            return;
        }
        MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        if (CollectionsUtil.isListEmpty(this.getMoreContextMenuItems())) {
            this.mBtnMore.setVisibility(8);
        } else {
            this.mBtnMore.setVisibility(0);
        }
        this.mTxtFileNameTtile.setText((CharSequence)file.getFileName());
        String timeStr = this.formatSharedTime(file.getTimeStamp());
        String ownerName = StringUtil.isSameString((String)file.getOwnerJid(), (String)myJid) ? this.getString(R.string.zm_lbl_content_me) : file.getOwnerName();
        this.mTxtFileDes.setText((CharSequence)(FileUtils.toFileSizeString((Context)this.getActivity(), (long)file.getFileSize()) + "|" + ownerName + "," + timeStr));
        String sharedInStr = "";
        List<MMZoomShareAction> actions = file.getShareAction();
        if (actions != null) {
            StringBuffer buff = new StringBuffer();
            for (MMZoomShareAction action : actions) {
                if (!action.isGroup() || action.isMUC()) continue;
                buff.append(action.getShareeName((Context)this.getActivity()));
                buff.append(",");
            }
            sharedInStr = buff.length() == 0 ? (StringUtil.isSameString((String)file.getOwnerJid(), (String)myJid) ? "" : this.getString(R.string.zm_lbl_content_share_in_buddy, new Object[]{ownerName})) : this.getString(R.string.zm_lbl_content_share_in_group, new Object[]{buff.subSequence(0, buff.length() - 1)});
        }
        if (sharedInStr.length() > 0) {
            this.mTxtFileSharees.setText((CharSequence)sharedInStr);
        } else {
            this.mTxtFileSharees.setText((CharSequence)this.getString(R.string.zm_lbl_content_no_share));
        }
        if (file.isFileDownloading()) {
            this.mTxtTranslateSpeed.setVisibility(0);
            this.mUploadProgressBar.setVisibility(0);
            this.mBtnDownload.setVisibility(8);
            this.mBtnViewFile.setVisibility(8);
            this.mTxtNotSupportPreview.setVisibility(8);
        } else if (StringUtil.isEmptyOrNull((String)file.getLocalPath()) || !file.isFileDownloaded()) {
            this.mBtnDownload.setVisibility(8);
            this.mBtnViewFile.setVisibility(8);
        } else {
            this.mBtnDownload.setVisibility(8);
            this.mBtnViewFile.setVisibility(0);
        }
        if (file.isFileDownloaded()) {
            this.mTxtTranslateSpeed.setVisibility(8);
            this.mUploadProgressBar.setVisibility(8);
            this.mTxtNotSupportPreview.setVisibility(8);
        }
        if (!StringUtil.isEmptyOrNull((String)file.getPicturePreviewPath()) && new File(file.getPicturePreviewPath()).exists()) {
            this.mImgFileType.setImageDrawable((Drawable)new LazyLoadDrawable(file.getPicturePreviewPath()));
        } else {
            this.mImgFileType.setImageResource(AndroidAppUtil.getIconForFile((String)file.getFileName()));
        }
        if (file.getFileType() == 100 && !StringUtil.isEmptyOrNull((String)file.getLocalPath()) && new File(file.getLocalPath()).exists() && ImageUtil.isValidImageFile(file.getLocalPath())) {
            if ("image/gif".equals(ImageUtil.getImageMimeType(file.getLocalPath()))) {
                file.setFileType(5);
            } else {
                file.setFileType(1);
            }
        }
        if (file.getFileType() == 5 && !"image/gif".equals(ImageUtil.getImageMimeType(file.getLocalPath()))) {
            file.setFileType(1);
        }
        switch (file.getFileType()) {
            case 100: {
                this.mImageview.setVisibility(8);
                this.mImgGifView.setVisibility(8);
                if (file.isFileDownloaded() && this.isPdfFile(file.getFileName()) && !StringUtil.isEmptyOrNull((String)file.getLocalPath())) {
                    this.mPdfView.setPdfFile(file.getLocalPath(), null);
                    this.mPdfView.setVisibility(0);
                    this.mPanelNormalFile.setVisibility(8);
                    this.mPanelContent.setOnClickListener(null);
                } else {
                    this.mPanelNormalFile.setVisibility(0);
                }
                if (!this.isImageFile(file.getFileName()) && !this.isPdfFile(file.getFileName())) break;
                this.mTxtNotSupportPreview.setVisibility(8);
                break;
            }
            case 5: {
                this.mImageview.setVisibility(8);
                this.mPdfView.setVisibility(8);
                this.mImgGifView.setGifResourse(file.getLocalPath());
                if (!StringUtil.isEmptyOrNull((String)file.getLocalPath()) && new File(file.getLocalPath()).exists()) {
                    this.mPanelNormalFile.setVisibility(8);
                    this.mImgGifView.setVisibility(0);
                    this.setSensorOrientation();
                    break;
                }
                this.mPanelNormalFile.setVisibility(0);
                this.mImgGifView.setVisibility(8);
                this.mBtnDownload.setVisibility(8);
                this.mBtnViewFile.setVisibility(8);
                this.mUploadProgressBar.setVisibility(0);
                this.mTxtNotSupportPreview.setVisibility(8);
                break;
            }
            case 1: 
            case 4: {
                if (!StringUtil.isEmptyOrNull((String)file.getLocalPath())) {
                    Bitmap bmp = ZMBitmapFactory.decodeFile(file.getLocalPath(), 1000000, false, false);
                    this.mImageview.setImageBitmap(bmp);
                    this.setSensorOrientation();
                }
                this.mImgGifView.setVisibility(8);
                this.mPdfView.setVisibility(8);
                if (!StringUtil.isEmptyOrNull((String)file.getLocalPath()) && new File(file.getLocalPath()).exists()) {
                    this.mPanelNormalFile.setVisibility(8);
                    this.mImageview.setVisibility(0);
                    break;
                }
                this.mPanelNormalFile.setVisibility(0);
                this.mImageview.setVisibility(8);
                this.mBtnDownload.setVisibility(8);
                this.mBtnViewFile.setVisibility(8);
                this.mUploadProgressBar.setVisibility(0);
                this.mTxtNotSupportPreview.setVisibility(8);
                break;
            }
            case 2: 
            case 3: {
                this.mPanelNormalFile.setVisibility(0);
                this.mImageview.setVisibility(8);
                this.mImgGifView.setVisibility(8);
                this.mPdfView.setVisibility(8);
                break;
            }
        }
        int tranState = file.getFileTransferState();
        boolean bl = isDownloadError = tranState == 11;
        if (!isDownloadError && !NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            boolean bl2 = isDownloadError = tranState != 13;
        }
        if (isDownloadError) {
            this.mViewPlaceHolder.setVisibility(0);
            this.mTxtMessage.setText(ZmPtUtils.isImageFile(file.getFileType()) ? R.string.zm_mm_msg_download_image_failed : R.string.zm_mm_msg_download_other_failed);
            this.mTxtTranslateSpeed.setVisibility(4);
            this.mUploadProgressBar.setVisibility(4);
            this.mBtnDownload.setVisibility(8);
        } else {
            this.mViewPlaceHolder.setVisibility(8);
        }
    }

    private void setSensorOrientation() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.setRequestedOrientation(4);
        }
    }

    private String formatSharedTime(long timeStamp) {
        int dayDiff = TimeUtil.dateDiff((long)timeStamp, (long)System.currentTimeMillis());
        SimpleDateFormat df = new SimpleDateFormat("h:mm a", CompatUtils.getLocalDefault());
        Date time = new Date(timeStamp);
        String timeStr = df.format(time);
        if (dayDiff == 1) {
            return this.getString(R.string.zm_lbl_content_time_today_format, new Object[]{timeStr});
        }
        df = new SimpleDateFormat("MMM d", CompatUtils.getLocalDefault());
        String dayStr = df.format(time);
        return this.getString(R.string.zm_lbl_content_time_other_day_format, new Object[]{dayStr, timeStr});
    }

    private void downloadFile() {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile zoomFile = this.getZoomFile(mgr);
        if (zoomFile == null) {
            return;
        }
        MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        if (file == null) {
            return;
        }
        if (file.isFileDownloading()) {
            return;
        }
        if (!file.isFileDownloaded() || StringUtil.isEmptyOrNull((String)file.getLocalPath())) {
            boolean result = false;
            if (!StringUtil.isEmptyOrNull((String)this.mMessageID)) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                ZoomChatSession session = messenger.getSessionById(this.mSessionId);
                if (session == null) {
                    return;
                }
                result = session.downloadFileForMessage(this.mMessageID);
            } else {
                String reqId = mgr.downloadFile(this.mFileWebId, PendingFileDataHelper.getContenFilePath(this.mFileWebId, file.getFileName()));
                boolean bl = result = !StringUtil.isEmptyOrNull((String)reqId);
            }
            if (result) {
                this.mTxtTranslateSpeed.setVisibility(0);
                this.mUploadProgressBar.setVisibility(0);
                this.mBtnDownload.setVisibility(8);
                this.mBtnViewFile.setVisibility(8);
                this.FT_DownloadByFileID_OnProgress("", file.getWebID(), 0, 0, 0);
                this.mViewPlaceHolder.setVisibility(8);
            } else {
                this.showDownloadErrorUI();
            }
        }
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnClose) {
            this.onClickBtnClose();
        } else if (id2 == R.id.btnMore) {
            this.onClickBtnMore();
        } else if (id2 == R.id.btnViewFile) {
            this.onClickBtnViewFile();
        } else if (id2 == R.id.btnDownload) {
            this.onClickBtnDownload();
        } else if (id2 == R.id.btnShare) {
            this.onClickBtnShare();
        } else if (id2 == R.id.panelContent) {
            this.onClickPanelContent();
        } else if (id2 == R.id.viewPlaceHolder) {
            this.onClickViewPlaceHolder();
        }
    }

    private void onClickViewPlaceHolder() {
        this.mViewPlaceHolder.setVisibility(8);
        this.downloadFile();
    }

    private void onClickPanelContent() {
        this.onTapContent();
    }

    private void onClickBtnShare() {
        Bundle bundle = new Bundle();
        bundle.putString(ARGS_SHARE_FILE_ID, this.mFileWebId);
        MMSelectSessionAndBuddyFragment.showAsFragment((Fragment)this, bundle, false, false, 1);
    }

    private void onClickBtnDownload() {
        this.downloadFile();
    }

    private void onClickBtnViewFile() {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile zoomFile = this.getZoomFile(mgr);
        if (zoomFile == null) {
            return;
        }
        MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        if (file == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)file.getLocalPath())) {
            return;
        }
        boolean res = false;
        AndroidAppUtil.MimeType mimeType = AndroidAppUtil.getMimeTypeOfFile((String)file.getFileName());
        if (mimeType != null) {
            res = mimeType.fileType == 7 ? AndroidAppUtil.openFile((Context)this.getActivity(), (File)new File(file.getLocalPath()), (boolean)true) : AndroidAppUtil.openFile((Context)this.getActivity(), (File)new File(file.getLocalPath()));
        }
        if (!res) {
            new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.zm_lbl_system_not_support_preview).setPositiveButton(R.string.zm_btn_ok, null).show();
        }
    }

    private void onClickBtnMore() {
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)this.getActivity(), false);
        List<MoreContextMenuItem> items = this.getMoreContextMenuItems();
        if (items == null || items.size() == 0) {
            return;
        }
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MoreContextMenuItem mi = (MoreContextMenuItem)((Object)menuAdapter.getItem(which));
                MMContentFileViewerFragment.this.onSelectContextMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private List<MoreContextMenuItem> getMoreContextMenuItems() {
        ArrayList<MoreContextMenuItem> items = new ArrayList<MoreContextMenuItem>();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return null;
        }
        ZoomFile zoomFile = this.getZoomFile(mgr);
        if (zoomFile == null) {
            return null;
        }
        MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        if (file == null) {
            return null;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return null;
        }
        boolean enabelE2E = messenger.e2eGetMyOption() == 2;
        boolean isFileTransferDisable = PTApp.getInstance().isFileTransferDisabled();
        if (!(enabelE2E || this.mIsE2EFile || isFileTransferDisable || StringUtil.isEmptyOrNull((String)this.mFileWebId))) {
            items.add(new MoreContextMenuItem(this.getString(R.string.zm_btn_share), 5));
        }
        if (ZmPtUtils.isImageFile(file.getFileType())) {
            String localPath = file.getLocalPath();
            if (!StringUtil.isEmptyOrNull((String)localPath) && new File(localPath).exists() && ImageUtil.isValidImageFile(localPath)) {
                items.add(new MoreContextMenuItem(this.getString(R.string.zm_mm_btn_save_image), 4));
            }
            if (!(enabelE2E || this.mIsE2EFile || isFileTransferDisable)) {
                items.add(new MoreContextMenuItem(this.getString(R.string.zm_mm_lbl_save_emoji), 6));
            }
        }
        if (this.isPdfFile(file.getFileName()) && file.isFileDownloaded() && AndroidAppUtil.hasActivityToOpenFile((Context)this.getActivity(), (File)new File(file.getLocalPath()))) {
            items.add(new MoreContextMenuItem(this.getString(R.string.zm_btn_open_with_app_14906), 7));
        }
        if (!isFileTransferDisable && !StringUtil.isEmptyOrNull((String)this.mFileWebId) && (this.checkIsGroupOpt() && !enabelE2E || TextUtils.equals((CharSequence)myself.getJid(), (CharSequence)file.getOwnerJid()))) {
            items.add(new MoreContextMenuItem(this.getString(R.string.zm_btn_delete), 1));
        }
        return items;
    }

    private void onSelectContextMenuItem(MoreContextMenuItem mi) {
        switch (mi.getAction()) {
            case 1: {
                this.onSelectContextMenuItemDeleteFile();
                break;
            }
            case 3: {
                this.onSelectContextMenuItemRenameFile();
                break;
            }
            case 4: {
                this.onSelectContextMenuItemSaveImageFile();
                break;
            }
            case 5: {
                this.onClickBtnShare();
                break;
            }
            case 6: {
                this.saveEmoji();
                break;
            }
            case 7: {
                this.openWithOtherAPP();
            }
        }
    }

    private void openWithOtherAPP() {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile zoomFile = this.getZoomFile(mgr);
        if (zoomFile == null) {
            return;
        }
        MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        if (file == null) {
            return;
        }
        AndroidAppUtil.openFile((Context)this.getActivity(), (File)new File(file.getLocalPath()));
    }

    private void saveEmoji() {
        MMPrivateStickerMgr mgr = PTApp.getInstance().getZoomPrivateStickerMgr();
        if (mgr == null) {
            return;
        }
        String fileId = this.mFileWebId;
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            MMFileContentMgr contentMgr = PTApp.getInstance().getZoomFileContentMgr();
            if (contentMgr == null) {
                return;
            }
            ZoomFile file = contentMgr.getFileWithMessageID(this.mSessionId, this.mMessageXMPPID);
            if (file != null) {
                fileId = file.getWebFileID();
                long size = file.getFileSize();
                contentMgr.destroyFileObject(file);
                if (size > 0x800000L) {
                    SimpleMessageDialog.newInstance(R.string.zm_msg_sticker_too_large, false).show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
                    return;
                }
            }
        }
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        int result = mgr.makePrivateSticker(this.mFileWebId);
        switch (result) {
            case 0: 
            case 5: {
                Toast.makeText((Context)this.getActivity(), (int)R.string.zm_mm_msg_save_emoji_failed, (int)1).show();
                break;
            }
            case 2: 
            case 4: {
                Toast.makeText((Context)this.getActivity(), (int)R.string.zm_msg_duplicate_emoji, (int)1).show();
                break;
            }
        }
    }

    private ZoomFile getZoomFile(MMFileContentMgr mgr) {
        if (mgr == null) {
            return null;
        }
        if (!StringUtil.isEmptyOrNull((String)this.mMessageXMPPID) && !StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            return mgr.getFileWithMessageID(this.mSessionId, this.mMessageXMPPID);
        }
        return mgr.getFileWithWebFileID(this.mFileWebId);
    }

    private void saveImage() {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = this.getZoomFile(mgr);
        if (file == null) {
            return;
        }
        final String filePath = file.getLocalPath();
        mgr.destroyFileObject(file);
        if (StringUtil.isEmptyOrNull((String)filePath) || !new File(filePath).exists() || !ImageUtil.isValidImageFile(filePath)) {
            return;
        }
        Thread thread = new Thread("SaveImage"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block33: {
                    if (StringUtil.isEmptyOrNull((String)filePath)) {
                        return;
                    }
                    File file = new File(filePath);
                    if (!file.exists()) {
                        return;
                    }
                    File path = ImageUtil.getZoomGalleryPath();
                    if (path == null) {
                        return;
                    }
                    String destFilePath = path.getPath() + File.separator + file.getName();
                    File destFile = new File(destFilePath);
                    if (destFile.exists() && destFile.length() > 0L) {
                        this._onSaveImageDone(true);
                        return;
                    }
                    FileChannel inputChannel = null;
                    AbstractInterruptibleChannel outputChannel = null;
                    try {
                        inputChannel = new FileInputStream(file).getChannel();
                        outputChannel = new FileOutputStream(destFile).getChannel();
                        long size = ((FileChannel)outputChannel).transferFrom(inputChannel, 0L, inputChannel.size());
                        if (size <= 0L) break block33;
                        FragmentActivity context = MMContentFileViewerFragment.this.getActivity();
                        if (context == null) {
                            return;
                        }
                        AndroidAppUtil.addImageToGallery((Context)context, (String)destFilePath, (String)ImageUtil.getImageMimeType(destFilePath));
                        this._onSaveImageDone(true);
                    }
                    catch (Exception exception) {
                        break block33;
                    }
                    finally {
                        try {
                            if (inputChannel != null) {
                                inputChannel.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (outputChannel != null) {
                                outputChannel.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                }
                this._onSaveImageDone(false);
            }

            private void _onSaveImageDone(final boolean success) {
                MMContentFileViewerFragment.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        MMContentFileViewerFragment.this.onSaveImageDone(success);
                    }
                });
            }
        };
        this.showWaitingDialog();
        thread.start();
    }

    private void onSaveImageDone(boolean success) {
        this.dismissWaitingDialog();
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_mm_msg_saved_to_album, (int)0).show();
    }

    private void onSelectContextMenuItemSaveImageFile() {
        if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.saveImage();
        } else {
            this.zm_requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 3101);
        }
    }

    private void onSelectContextMenuItemRenameFile() {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = this.getZoomFile(mgr);
        if (file == null) {
            return;
        }
        SetFileNameDialog.showSetNameDialog(this.getFragmentManager(), file.getFileName());
        mgr.destroyFileObject(file);
    }

    private void setFileName(String name) {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        String reqId = mgr.renameFileByWebFileID(this.mFileWebId, name);
        if (!StringUtil.isEmptyOrNull((String)reqId)) {
            this.showWaitingDialog();
        }
    }

    private void showWaitingDialog() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (this.mWaitingSaveDialog != null) {
            this.mWaitingSaveDialog.dismiss();
        }
        this.mWaitingSaveDialog = new ProgressDialog((Context)activity);
        this.mWaitingSaveDialog.requestWindowFeature(1);
        this.mWaitingSaveDialog.setMessage((CharSequence)activity.getString(R.string.zm_msg_waiting));
        this.mWaitingSaveDialog.setCanceledOnTouchOutside(false);
        this.mWaitingSaveDialog.setCancelable(true);
        this.mWaitingSaveDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                MMContentFileViewerFragment.this.mWaitingSaveDialog = null;
            }
        });
        this.mWaitingSaveDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                MMContentFileViewerFragment.this.mWaitingSaveDialog = null;
            }
        });
        this.mWaitingSaveDialog.show();
    }

    private void dismissWaitingDialog() {
        if (this.mWaitingSaveDialog == null) {
            return;
        }
        try {
            this.mWaitingSaveDialog.dismiss();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onSelectContextMenuItemDeleteFile() {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mMessageID)) {
            if (StringUtil.isEmptyOrNull((String)this.mFileWebId)) {
                return;
            }
            ZoomFile zoomFile = this.getZoomFile(mgr);
            if (zoomFile == null) {
                return;
            }
            final MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
            if (file == null) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mSessionId)) {
                String fileName = FileUtils.shrinkFileName((String)file.getFileName(), (int)30);
                if (fileName == null) {
                    fileName = "";
                }
                String title = this.getString(R.string.zm_msg_delete_file_confirm, new Object[]{fileName});
                ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setMessage(R.string.zm_msg_delete_file_warning).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).setPositiveButton(R.string.zm_btn_delete, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        MMContentFileViewerFragment.this.deleteFile(file);
                    }
                }).create();
                dlg.show();
            } else {
                this.deleteFile(file);
            }
        } else {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomChatSession session = messenger.getSessionById(this.mSessionId);
            if (session == null) {
                return;
            }
            ZoomMessage zoomMsg = session.getMessageById(this.mMessageID);
            if (zoomMsg == null) {
                return;
            }
            ZoomBuddy buddy = messenger.getMyself();
            if (buddy == null) {
                return;
            }
            boolean isOutMessage = StringUtil.isSameString((String)zoomMsg.getSenderID(), (String)buddy.getJid());
            MMMessageItem mMessageItem = MMMessageItem.initWithZoomMessage(zoomMsg, this.mSessionId, messenger, session.isGroup(), isOutMessage, (Context)this.getActivity(), IMAddrBookItem.fromZoomBuddy(session.getSessionBuddy()), mgr);
            if (mMessageItem != null && mMessageItem.deleteMessage((Context)this.getActivity())) {
                this.dismiss();
            }
        }
    }

    private void deleteFile(MMZoomFile file) {
        if (file == null) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        String reqId = mgr.deleteFile(file, this.mSessionId);
        if (!StringUtil.isEmptyOrNull((String)reqId)) {
            FragmentActivity actvity = this.getActivity();
            if (actvity == null) {
                return;
            }
            Intent intent = new Intent();
            intent.putExtra(RESULT_ACTION, 1);
            intent.putExtra("zoomFileWebId", file.getWebID());
            intent.putExtra(RESULT_REQ_ID, reqId);
            actvity.setResult(-1, intent);
            this.dismiss();
        } else if (StringUtil.isEmptyOrNull((String)reqId)) {
            ErrorMsgDialog.newInstance(this.getString(R.string.zm_alert_unshare_file_failed), -1).show(this.getFragmentManager(), ErrorMsgDialog.class.getName());
        }
    }

    private void onClickBtnClose() {
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.pushLater(new EventAction("MMContentFileViewerFragmentPermissionResult"){

                public void run(IUIElement ui) {
                    ((MMContentFileViewerFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
                }
            });
        }
    }

    public void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 3101 && (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0)) {
            this.saveImage();
        }
    }

    public void onSingleTapConfirmed() {
        this.onTapContent();
    }

    public static class MoreContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_DELETE = 1;
        public static final int ACTION_COPY = 2;
        public static final int ACTION_RENAME = 3;
        public static final int ACTION_SAVE_IMAGE = 4;
        public static final int ACTION_SHARE = 5;
        public static final int ACTION_SAVE_EMOJI = 6;
        public static final int ACTION_OTHER_APP = 7;

        public MoreContextMenuItem(String label, int action) {
            super(action, label);
        }
    }

    public static class SetFileNameDialog
    extends ZMDialogFragment
    implements TextWatcher,
    TextView.OnEditorActionListener {
        private static final String ARG_FILE_NAME = "fileName";
        private EditText mEdtFileName = null;
        private Button mBtnOK = null;

        public static void showSetNameDialog(FragmentManager fm, String defFileName) {
            SetFileNameDialog dialog = new SetFileNameDialog();
            Bundle args = new Bundle();
            args.putString(ARG_FILE_NAME, defFileName);
            dialog.setArguments(args);
            dialog.show(fm, SetFileNameDialog.class.getName());
        }

        public SetFileNameDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            String fileName = "";
            Bundle args = this.getArguments();
            if (args != null) {
                fileName = args.getString(ARG_FILE_NAME);
            }
            View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_content_set_file_name, null, false);
            this.mEdtFileName = (EditText)view.findViewById(R.id.edtFileName);
            if (fileName != null) {
                this.mEdtFileName.setText((CharSequence)fileName);
            }
            this.mEdtFileName.setImeOptions(2);
            this.mEdtFileName.setOnEditorActionListener((TextView.OnEditorActionListener)this);
            this.mEdtFileName.addTextChangedListener((TextWatcher)this);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            return dialog;
        }

        public void onResume() {
            super.onResume();
            this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
            this.mBtnOK.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!SetFileNameDialog.this.checkInput()) {
                        return;
                    }
                    SetFileNameDialog.this.onClickBtnOK();
                }
            });
            this.updateButtons();
        }

        public void onCancel(DialogInterface dialog) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
        }

        private void onClickBtnOK() {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
            String fileName = this.mEdtFileName.getText().toString().trim();
            if (fileName.length() == 0) {
                this.mEdtFileName.requestFocus();
                return;
            }
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            FragmentManager fm = activity.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            MMContentFileViewerFragment f = MMContentFileViewerFragment.findMyProfileFragment(fm);
            if (f == null) {
                return;
            }
            f.setFileName(fileName);
            this.dismissAllowingStateLoss();
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            this.updateButtons();
        }

        private void updateButtons() {
            if (this.mBtnOK != null) {
                this.mBtnOK.setEnabled(this.checkInput());
            }
        }

        private boolean checkInput() {
            String fileName = this.mEdtFileName.getText().toString().trim();
            return !StringUtil.isEmptyOrNull((String)fileName);
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            switch (actionId) {
                case 2: {
                    this.onClickBtnOK();
                    return true;
                }
            }
            return false;
        }
    }
}

