/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.PresenceStateView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class MMContactsRoomAdapter
extends QuickSearchListView.QuickSearchListDataAdapter {
    private List<IMAddrBookItem> mDisplayDatas = new ArrayList<IMAddrBookItem>();
    private Context mContext;
    private List<IMAddrBookItem> mCacheDatas = new ArrayList<IMAddrBookItem>();
    private List<String> mWaitRefreshJids = new ArrayList<String>();
    private String mFilter;

    public MMContactsRoomAdapter(Context context) {
        this.mContext = context;
    }

    public void clearAll() {
        this.mCacheDatas.clear();
    }

    public void addOrUpdateItem(IMAddrBookItem item) {
        if (item == null) {
            return;
        }
        int idx = this.findGroup(item);
        if (idx == -1) {
            this.mCacheDatas.add(item);
        } else {
            this.mCacheDatas.set(idx, item);
        }
    }

    public List<String> getWaitRefreshJids() {
        return this.mWaitRefreshJids;
    }

    public void clearWaitRefreshJids() {
        this.mWaitRefreshJids.clear();
    }

    public void filter(String key) {
        if (StringUtil.isSameString((String)key, (String)this.mFilter)) {
            return;
        }
        this.mFilter = key == null ? null : key.toLowerCase(CompatUtils.getLocalDefault());
        this.notifyDataSetChanged();
    }

    public void addAllItems(List<IMAddrBookItem> items) {
        this.mCacheDatas.clear();
        this.mCacheDatas.addAll(items);
    }

    public void removeItem(IMAddrBookItem item) {
        if (item == null) {
            return;
        }
        int idx = this.findGroup(item);
        if (idx != -1) {
            this.mCacheDatas.remove(idx);
        }
    }

    public boolean isContainRoom(String jid) {
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        for (int i = 0; i < this.mCacheDatas.size(); ++i) {
            IMAddrBookItem data = this.mCacheDatas.get(i);
            if (!StringUtil.isSameString((String)data.getJid(), (String)jid)) continue;
            return true;
        }
        return false;
    }

    private int findGroup(IMAddrBookItem item) {
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < this.mCacheDatas.size(); ++i) {
            IMAddrBookItem data = this.mCacheDatas.get(i);
            if (!StringUtil.isSameString((String)data.getJid(), (String)item.getJid())) continue;
            return i;
        }
        return -1;
    }

    public boolean hasRooms() {
        return !this.mCacheDatas.isEmpty();
    }

    public int getCount() {
        return this.mDisplayDatas.size();
    }

    private void updateDisplayDatas() {
        boolean isFilterEmpty;
        this.mDisplayDatas.clear();
        boolean showOfflineBuddies = true;
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            showOfflineBuddies = settingHelper.getShowOfflineBuddies();
        }
        if (isFilterEmpty = StringUtil.isEmptyOrNull((String)this.mFilter)) {
            if (showOfflineBuddies) {
                this.mDisplayDatas.addAll(this.mCacheDatas);
            } else {
                for (IMAddrBookItem item : this.mCacheDatas) {
                    if (!item.getIsDesktopOnline()) continue;
                    this.mDisplayDatas.add(item);
                }
            }
        } else {
            Locale locale = CompatUtils.getLocalDefault();
            for (IMAddrBookItem item : this.mCacheDatas) {
                if (!item.getScreenName().toLowerCase(locale).contains(this.mFilter)) continue;
                if (showOfflineBuddies) {
                    this.mDisplayDatas.add(item);
                    continue;
                }
                if (!item.getIsDesktopOnline()) continue;
                this.mDisplayDatas.add(item);
            }
        }
    }

    public void notifyDataSetChanged() {
        this.updateDisplayDatas();
        super.notifyDataSetChanged();
    }

    public int getViewTypeCount() {
        return 1;
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.mDisplayDatas.size()) {
            return null;
        }
        return this.mDisplayDatas.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createGroupsItem(position, convertView, parent);
    }

    private View createGroupsItem(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_contact_room_item, null);
        }
        IMAddrBookItem room = (IMAddrBookItem)this.getItem(position);
        this.mWaitRefreshJids.add(room.getJid());
        TextView txtRoomName = (TextView)convertView.findViewById(R.id.txtRoomName);
        txtRoomName.setText((CharSequence)room.getScreenName());
        PresenceStateView presenceStateView = (PresenceStateView)convertView.findViewById(R.id.presenceStateView);
        presenceStateView.setState(room);
        return convertView;
    }

    public String getItemSortKey(Object item) {
        if (item instanceof IMAddrBookItem) {
            IMAddrBookItem abItem = (IMAddrBookItem)item;
            String key = abItem.getSortKey();
            if (key == null) {
                key = "";
            }
            return key;
        }
        return "*";
    }

    static class RoomComparator
    implements Comparator<IMAddrBookItem> {
        private Collator mCollator;

        public RoomComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(IMAddrBookItem lhs, IMAddrBookItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            String str1 = lhs.getSortKey();
            String str2 = rhs.getSortKey();
            return this.mCollator.compare(str1, str2);
        }
    }
}

