/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.fragment.IMAddrBookListFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMView;
import com.zipow.videobox.view.mm.MMChatsListView;
import com.zipow.videobox.view.mm.MMContactsGroupAdapter;
import com.zipow.videobox.view.mm.MMZoomGroup;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMContactsGroupListView
extends ListView
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener {
    private static final String TAG = MMContactsGroupListView.class.getSimpleName();
    private MMContactsGroupAdapter mAdapter;
    private IMAddrBookListFragment mParentFragment;

    private static void startGroupChat(ZMActivity activity, String groupId) {
        MMChatActivity.showAsGroupChat(activity, groupId);
    }

    public MMContactsGroupListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMContactsGroupListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMContactsGroupListView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mAdapter = new MMContactsGroupAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
    }

    public void filter(String key) {
        this.mAdapter.filter(key);
    }

    public void refreshAllData() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.mAdapter.clearAll();
        int groupCount = messenger.getGroupCount();
        for (int i = 0; i <= groupCount; ++i) {
            ZoomGroup group = messenger.getGroupAt(i);
            MMZoomGroup mmGroup = MMZoomGroup.initWithZoomGroup(group);
            if (mmGroup == null || !mmGroup.isRoom()) continue;
            this.mAdapter.addOrUpdateItem(mmGroup);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void setParentFragment(IMAddrBookListFragment fragment) {
        this.mParentFragment = fragment;
    }

    public boolean isParentFragmentResumed() {
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.isResumed();
    }

    public void onZoomMessengerMUCGroupInfoUpdated(String groupId) {
        this.addOrUpdateGroup(groupId);
    }

    private void addOrUpdateGroup(String groupId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(groupId);
        MMZoomGroup mmGroup = MMZoomGroup.initWithZoomGroup(group);
        if (mmGroup == null || mmGroup.getMemberCount() <= 0 || !mmGroup.isRoom()) {
            this.mAdapter.removeItem(groupId);
            if (this.isParentFragmentResumed()) {
                this.mAdapter.notifyDataSetChanged();
            }
            return;
        }
        this.mAdapter.addOrUpdateItem(mmGroup);
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onGroupAction(int result, GroupAction action, String msgId) {
        this.addOrUpdateGroup(action.getGroupId());
    }

    public void onGroupDestory(String groupid) {
        if (this.mAdapter != null) {
            this.mAdapter.removeItem(groupid);
            if (this.isParentFragmentResumed()) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onGroupMemberInfoUpdate(String groupid) {
        this.addOrUpdateGroup(groupid);
    }

    private void onItemClickGroup(MMZoomGroup group) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.imChatGetOption() == 2) {
            this.showGroupConferenceOption(group);
        } else {
            MMContactsGroupListView.startGroupChat((ZMActivity)this.getContext(), group.getGroupId());
        }
    }

    public void jump2Group(String groupid) {
        if (TextUtils.isEmpty((CharSequence)groupid)) {
            return;
        }
        if (this.mAdapter == null) {
            return;
        }
        MMZoomGroup zoomGroup = this.mAdapter.findGroup(groupid);
        if (zoomGroup != null) {
            this.onItemClickGroup(zoomGroup);
        }
    }

    private void showGroupConferenceOption(final MMZoomGroup group) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (PTApp.getInstance().getCallStatus() == 2) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter(context, false);
        ArrayList<GroupContextMenuItem> items = new ArrayList<GroupContextMenuItem>();
        String title = group.getGroupName();
        items.add(new GroupContextMenuItem(context.getString(R.string.zm_btn_video_call), 0));
        items.add(new GroupContextMenuItem(context.getString(R.string.zm_btn_audio_call), 1));
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder(context).setTitle(title).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                GroupContextMenuItem mi = (GroupContextMenuItem)((Object)menuAdapter.getItem(which));
                MMContactsGroupListView.this.onSelectConferenceMenuItem(group, mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectConferenceMenuItem(MMZoomGroup group, GroupContextMenuItem mi) {
        int callStatus;
        if (mi.getAction() == 1) {
            int callStatus2 = PTApp.getInstance().getCallStatus();
            if (callStatus2 == 0) {
                this.startVoiceCall(group);
            }
        } else if (mi.getAction() == 0 && (callStatus = PTApp.getInstance().getCallStatus()) == 0) {
            this.startVideoCall(group);
        }
    }

    private void startVoiceCall(MMZoomGroup group) {
        int callStatus = PTApp.getInstance().getCallStatus();
        if (callStatus == 0) {
            this.startConference(group, 6);
        } else {
            this.alertAlreadyInMeeting();
        }
    }

    private void startVideoCall(MMZoomGroup group) {
        int callStatus = PTApp.getInstance().getCallStatus();
        if (callStatus == 0) {
            this.startConference(group, 3);
        } else {
            this.alertAlreadyInMeeting();
        }
    }

    private void alertAlreadyInMeeting() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_cannot_start_call_while_in_another_meeting, (int)1).show();
    }

    private void startConference(final MMZoomGroup group, final int abCallType) {
        new ZMAlertDialog.Builder(this.getContext()).setTitle(R.string.zm_title_start_group_call).setMessage(R.string.zm_msg_confirm_group_call).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMContactsGroupListView.this.callABContact(group, abCallType);
            }
        }).setNegativeButton(R.string.zm_btn_no, null).show();
    }

    private void callABContact(MMZoomGroup mmGroup, int abCallType) {
        int ret = 0;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<String> jids = new ArrayList<String>();
        ZoomGroup group = messenger.getGroupById(mmGroup.getGroupId());
        if (group == null) {
            return;
        }
        int count = group.getBuddyCount();
        for (int i = 0; i < count; ++i) {
            String jid;
            ZoomBuddy buddy = group.getBuddyAt(i);
            if (buddy == null || StringUtil.isEmptyOrNull((String)(jid = buddy.getJid()))) continue;
            jids.add(jid);
        }
        if (jids.size() == 0) {
            return;
        }
        String[] arrJids = new String[jids.size()];
        jids.toArray(arrJids);
        ret = ConfActivity.startGroupCall(this.getContext(), arrJids, abCallType);
        if (ret != 0) {
            IMView.StartHangoutFailedDialog.show(((ZMActivity)this.getContext()).getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.mAdapter.getItem(position);
        if (oItem instanceof MMZoomGroup) {
            this.onItemClickGroup((MMZoomGroup)oItem);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.mAdapter.getItem(position);
        if (oItem instanceof MMZoomGroup) {
            final MMZoomGroup group = (MMZoomGroup)oItem;
            ZMActivity activity = (ZMActivity)this.getContext();
            if (activity == null) {
                return false;
            }
            final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
            ArrayList<MMChatsListView.ChatsListContextMenuItem> items = new ArrayList<MMChatsListView.ChatsListContextMenuItem>();
            String title = activity.getString(R.string.zm_mm_title_chatslist_context_menu_group_chat);
            String label = activity.getString(R.string.zm_mm_lbl_delete_group_chat_20762);
            items.add(new MMChatsListView.ChatsListContextMenuItem(label, 0));
            menuAdapter.addAll(items);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(title).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MMChatsListView.ChatsListContextMenuItem mi = (MMChatsListView.ChatsListContextMenuItem)((Object)menuAdapter.getItem(which));
                    MMContactsGroupListView.this.onSelectContextMenuItem(group, mi);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            dialog.show();
            return true;
        }
        return false;
    }

    private void onSelectContextMenuItem(MMZoomGroup group, MMChatsListView.ChatsListContextMenuItem mi) {
        if (mi.getAction() == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            boolean deleteFlag = messenger.deleteSession(group.getGroupId());
            if (deleteFlag) {
                this.mParentFragment.onGroupDelete(group.getGroupId());
            }
        }
    }

    public static class GroupContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_VIDEO_CALL = 0;
        public static final int ACTION_AUDIO_CALL = 1;

        public GroupContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

