/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.GroupAvatarDrawable_v2;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.PresenceStateView;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.videomeetings.R;

public class MMChatsListItem {
    private static final String TAG = MMChatsListItem.class.getSimpleName();
    public static final String EXTRA_SESSION_PRE = "######";
    public static final String SYSTEM_NOTIFICATION_SESSION = "######SYSTEM_NOTIFICATION_SESSION";
    private String sessionId;
    private String title;
    private String avatar;
    private CharSequence latestMessage;
    private boolean isGroup;
    private boolean isNotifyOff;
    private long timeStamp;
    private int unreadMessageCount;
    private IMAddrBookItem fromContact;
    private boolean mIsE2E;
    private Handler mHandler = new Handler();

    public static MMChatsListItem fromZoomChatSession(ZoomChatSession session, ZoomMessenger messenger, Context context) {
        NotificationSettingMgr notificationSettingMgr;
        if (context == null) {
            return null;
        }
        String title = "";
        boolean isGroup = session.isGroup();
        boolean isE2E = false;
        ZoomGroup group = null;
        ZoomBuddy buddy = null;
        if (isGroup) {
            group = session.getSessionGroup();
            if (group == null) {
                return null;
            }
            title = group.getGroupDisplayName(context);
            isE2E = group.isForceE2EGroup();
        } else {
            buddy = session.getSessionBuddy();
            if (buddy == null) {
                return null;
            }
            title = BuddyNameUtil.getBuddyDisplayName(buddy, null);
        }
        MMChatsListItem item = new MMChatsListItem();
        item.setSessionId(session.getSessionId());
        item.setE2E(isE2E);
        item.setTitle(title);
        item.setIsGroup(isGroup);
        item.setUnreadMessageCount(session.getUnreadMessageCount() + session.getMarkUnreadMessageCount());
        String avatar = null;
        if (!isGroup) {
            avatar = buddy.getLocalPicturePath();
            item.setAvatar(avatar);
            IMAddrBookItem abItem = IMAddrBookItem.fromZoomBuddy(buddy);
            if (abItem != null) {
                abItem.setJid(buddy.getJid());
                item.setFromContact(abItem);
            }
        }
        boolean isBlocked = (notificationSettingMgr = PTApp.getInstance().getNotificationSettingMgr()) != null && notificationSettingMgr.isSessionBlocked(session.getSessionId());
        item.setNotifyOff(isBlocked);
        ZoomMessage message = session.getLastMessage();
        if (message == null) {
            item.setTimeStamp(0L);
            item.setLatestMessage("");
            if (!session.isGroup()) {
                return null;
            }
            return item;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return null;
        }
        String senderName = "";
        String senderId = message.getSenderID();
        ZoomBuddy sender = messenger.getBuddyWithJID(senderId);
        boolean senderIsMe = false;
        if (StringUtil.isSameString((String)senderId, (String)myself.getJid())) {
            sender = myself;
            senderIsMe = true;
            senderName = BuddyNameUtil.getBuddyDisplayName(sender, null, false);
        } else if (sender != null) {
            senderName = BuddyNameUtil.getBuddyDisplayName(sender, null);
        }
        CharSequence body = null;
        item.setTimeStamp(message.getStamp());
        if (message.isSupportedMessage()) {
            switch (message.getMessageType()) {
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    Resources res = context.getResources();
                    if (res == null) break;
                    body = res.getString(R.string.zm_mm_call_session_list_format, new Object[]{message.getBody()});
                    item.setLatestMessage(body);
                    break;
                }
                case 0: {
                    if (senderIsMe || !isGroup) {
                        body = message.getBody();
                    } else {
                        body = TextUtils.concat((CharSequence[])new CharSequence[]{senderName, ": ", message.getBody()});
                        if (session.hasUnreadMessageAtMe() || session.hasUnreadedMessageAtAllMembers()) {
                            String atMe = context.getString(session.hasUnreadMessageAtMe() ? R.string.zm_mm_lbl_message_mentioned_me : R.string.zm_mm_lbl_message_mentioned_all);
                            SpannableString ss = new SpannableString(TextUtils.concat((CharSequence[])new CharSequence[]{atMe, " ", body}));
                            ForegroundColorSpan span = new ForegroundColorSpan(context.getResources().getColor(R.color.zm_im_mentioned));
                            ss.setSpan((Object)span, 0, atMe.length(), 33);
                            body = ss;
                        }
                    }
                    if (message.isE2EMessage() && !senderIsMe && message.getMessageState() != 7) {
                        body = senderName + ": " + context.getResources().getString(R.string.zm_msg_e2e_chatslist_decrypt_failed);
                    }
                    item.setLatestMessage(body);
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 12: {
                    body = senderIsMe || !isGroup ? context.getString(R.string.zm_mm_lbl_message_picture) : senderName + ": " + context.getString(R.string.zm_mm_lbl_message_picture);
                    item.setLatestMessage(body);
                    break;
                }
                case 2: {
                    body = senderIsMe || !isGroup ? context.getString(R.string.zm_mm_lbl_message_voice) : senderName + ": " + context.getString(R.string.zm_mm_lbl_message_voice);
                    item.setLatestMessage(body);
                    break;
                }
                case 13: {
                    body = senderIsMe || !isGroup ? context.getString(R.string.zm_mm_lbl_message_code_snippet_31945) : senderName + ": " + context.getString(R.string.zm_mm_lbl_message_code_snippet_31945);
                    item.setLatestMessage(body);
                    break;
                }
                case 4: {
                    if (senderIsMe || !isGroup) {
                        body = context.getString(R.string.zm_mm_lbl_message_meeting_invitation);
                        break;
                    }
                    body = senderName + ": " + context.getString(R.string.zm_mm_lbl_message_meeting_invitation);
                    break;
                }
                case 10: {
                    ZoomMessage.FileInfo fileInfo = message.getFileInfo();
                    if (fileInfo != null) {
                        body = senderIsMe || !isGroup ? context.getString(R.string.zm_mm_lbl_message_file, new Object[]{fileInfo.name}) : senderName + ": " + context.getString(R.string.zm_mm_lbl_message_file, new Object[]{fileInfo.name});
                    }
                    item.setLatestMessage(body);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    body = message.getBody();
                    GroupAction action = GroupAction.loadFromString(body == null ? null : body.toString());
                    if (action != null) {
                        body = action.toMessage(context);
                    }
                    item.setLatestMessage(body);
                    break;
                }
                case 71: {
                    body = context.getString(R.string.zm_msg_e2e_invite_accepted, new Object[]{senderName});
                    item.setLatestMessage(body);
                    break;
                }
                case 70: {
                    body = context.getString(R.string.zm_msg_e2e_get_invite, new Object[]{senderName});
                    item.setLatestMessage(body);
                    break;
                }
                case 88: {
                    body = message.getBody();
                    item.setLatestMessage(body);
                    break;
                }
                case 80: {
                    ZoomBuddy actionOwner;
                    String actionOwnerId = (String)message.getBody();
                    if (StringUtil.isSameString((String)actionOwnerId, (String)myself.getJid())) {
                        body = context.getString(R.string.zm_msg_delete_by_me_24679);
                    } else if (!StringUtil.isEmptyOrNull((String)actionOwnerId) && (actionOwner = messenger.getBuddyWithJID(actionOwnerId)) != null) {
                        senderName = BuddyNameUtil.getBuddyDisplayName(actionOwner, null);
                        body = context.getString(R.string.zm_msg_delete_by_other_24679, new Object[]{senderName});
                    }
                    item.setLatestMessage(body);
                    break;
                }
                case 11: 
                case 14: {
                    body = context.getString(R.string.zm_msg_webhoot_new_notification, new Object[]{senderName});
                    item.setLatestMessage(body);
                    break;
                }
                default: {
                    item.setLatestMessage("");
                    break;
                }
            }
        } else {
            body = senderIsMe ? context.getString(R.string.zm_msg_unsupport_message_13802) : senderName + ": " + context.getString(R.string.zm_msg_unsupport_message_13802);
            item.setLatestMessage(body);
        }
        return item;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public CharSequence getLatestMessage() {
        return this.latestMessage;
    }

    public void setLatestMessage(CharSequence latestMessage) {
        this.latestMessage = latestMessage;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public void setIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getUnreadMessageCount() {
        return this.unreadMessageCount;
    }

    public void setUnreadMessageCount(int unreadMessageCount) {
        this.unreadMessageCount = unreadMessageCount;
    }

    public IMAddrBookItem getFromContact() {
        return this.fromContact;
    }

    public void setFromContact(IMAddrBookItem fromContact) {
        this.fromContact = fromContact;
    }

    public boolean isBuddyWithPhoneNumberInSession(String phoneNumber) {
        if (phoneNumber == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        if (this.isGroup) {
            ZoomGroup group = messenger.getGroupById(this.sessionId);
            if (group == null) {
                return false;
            }
            int count = group.getBuddyCount();
            for (int i = 0; i < count; ++i) {
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null || !StringUtil.isSameString((String)phoneNumber, (String)buddy.getPhoneNumber())) continue;
                return true;
            }
        } else {
            ZoomBuddy buddy = messenger.getBuddyWithPhoneNumber(phoneNumber);
            if (buddy == null) {
                return false;
            }
            return StringUtil.isSameString((String)phoneNumber, (String)buddy.getPhoneNumber());
        }
        return false;
    }

    public boolean isBuddyWithJIDInSession(String jid) {
        if (jid == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        if (this.isGroup) {
            return messenger.isBuddyWithJIDInGroup(jid, this.sessionId);
        }
        return StringUtil.isSameString((String)this.sessionId, (String)jid);
    }

    public View getView(Context context, View convertView, ViewGroup parent, MemCache<String, Drawable> avatarCache, boolean disableLazyLoadAvatar) {
        IMAddrBookItem addrItem;
        if (context == null) {
            return null;
        }
        View view = null;
        String tag = "MMChatsListItem";
        if (convertView != null && "MMChatsListItem".equals(convertView.getTag())) {
            view = convertView;
        } else {
            LayoutInflater factory = LayoutInflater.from((Context)context);
            if (factory == null) {
                return null;
            }
            view = factory.inflate(R.layout.zm_mm_chats_list_item, parent, false);
            view.setTag((Object)"MMChatsListItem");
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return view;
        }
        AvatarView avatarView = (AvatarView)view.findViewById(R.id.avatarView);
        TextView txtTitle = (TextView)view.findViewById(R.id.txtTitle);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        TextView txtTime = (TextView)view.findViewById(R.id.txtTime);
        TextView txtNoteBubble = (TextView)view.findViewById(R.id.txtNoteBubble);
        PresenceStateView imgPresence = (PresenceStateView)view.findViewById(R.id.imgPresence);
        ImageView imgE2EFlag = (ImageView)view.findViewById(R.id.imgE2EFlag);
        if (avatarView != null) {
            if (StringUtil.isSameString((String)SYSTEM_NOTIFICATION_SESSION, (String)this.sessionId)) {
                avatarView.setAvatar(R.drawable.zm_launcher);
            } else {
                if (!this.isGroup) {
                    avatarView.setName(this.title);
                    addrItem = this.getFromContact();
                    if (addrItem != null) {
                        avatarView.setBgColorSeedString(addrItem.getJid());
                    }
                }
                if (disableLazyLoadAvatar) {
                    this.loadAvatar(avatarView, context, false, avatarCache);
                } else if (!this.loadAvatar(avatarView, context, true, avatarCache)) {
                    this.lazyLoadAvatar(avatarView, context, avatarCache);
                }
            }
        }
        if (txtTitle != null && this.title != null) {
            txtTitle.setText((CharSequence)this.title);
        }
        if (txtMessage != null) {
            txtMessage.setText(this.latestMessage != null ? this.latestMessage : "");
            txtMessage.setTextColor(context.getResources().getColor(this.unreadMessageCount <= 0 ? R.color.zm_chats_list_time_normal : R.color.zm_chats_list_time_unread));
        }
        if (txtTime != null && !txtTime.isInEditMode()) {
            long time = this.getTimeStamp();
            if (time > 0L) {
                txtTime.setText((CharSequence)this.formatTime(context, this.getTimeStamp()));
            } else {
                txtTime.setText((CharSequence)"");
            }
            txtTime.setTextColor(context.getResources().getColor(this.unreadMessageCount <= 0 ? R.color.zm_chats_list_time_normal : R.color.zm_chats_list_time_unread));
        }
        if (txtNoteBubble != null) {
            if (this.unreadMessageCount <= 0) {
                txtNoteBubble.setVisibility(8);
            } else {
                txtNoteBubble.setText((CharSequence)(this.unreadMessageCount > 99 ? "99+" : String.valueOf(this.unreadMessageCount)));
                txtNoteBubble.setVisibility(0);
            }
        }
        if (!this.isGroup) {
            addrItem = this.getFromContact();
            if (addrItem == null) {
                return view;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(addrItem.getJid());
            if (buddy == null) {
                return view;
            }
            IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
            imgPresence.setVisibility(0);
            imgPresence.setState(item);
            imgPresence.setmTxtDeviceTypeGone();
            imgE2EFlag.setVisibility(8);
        } else {
            imgPresence.setVisibility(8);
            imgE2EFlag.setVisibility(this.mIsE2E ? 0 : 8);
        }
        if (txtTitle != null) {
            txtTitle.setCompoundDrawablesWithIntrinsicBounds(0, 0, this.isNotifyOff ? R.drawable.zm_notifications_off : 0, 0);
        }
        return view;
    }

    private void loadPresenceStatus(ZoomMessenger messenger, ImageView mImgPresence, IMAddrBookItem mItem) {
        if (mItem.isBlocked()) {
            mImgPresence.setVisibility(0);
            mImgPresence.setImageResource(R.drawable.zm_ic_buddy_blocked);
            mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_block));
            return;
        }
        if (messenger.isConnectionGood() && (mItem.getIsDesktopOnline() || mItem.getIsMobileOnline() || mItem.getIsRobot())) {
            switch (mItem.getPresence()) {
                case 3: {
                    int imgRes = R.drawable.zm_status_available;
                    if (!(mItem.isZoomRoomContact() || mItem.getIsDesktopOnline() || mItem.getIsRobot())) {
                        imgRes = R.drawable.zm_status_mobileonline;
                    }
                    mImgPresence.setVisibility(0);
                    mImgPresence.setImageResource(imgRes);
                    mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_presence_available));
                    break;
                }
                case 1: {
                    mImgPresence.setVisibility(0);
                    mImgPresence.setImageResource(R.drawable.zm_status_idle);
                    mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_presence_idle));
                    break;
                }
                case 2: {
                    mImgPresence.setVisibility(0);
                    mImgPresence.setImageResource(R.drawable.zm_status_dnd);
                    mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_presence_dnd_19903));
                    break;
                }
                case 4: {
                    mImgPresence.setVisibility(0);
                    mImgPresence.setImageResource(R.drawable.zm_status_dnd);
                    mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_presence_xa_19903));
                    break;
                }
                default: {
                    if (mItem.getIsMobileOnline()) {
                        mImgPresence.setVisibility(0);
                        mImgPresence.setImageResource(R.drawable.zm_status_mobileonline);
                        mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_presence_available));
                        break;
                    }
                    mImgPresence.setVisibility(0);
                    mImgPresence.setImageResource(R.drawable.zm_offline);
                    mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_presence_offline));
                    break;
                }
            }
        } else if (!messenger.isConnectionGood() && mItem.getIsMobileOnline()) {
            mImgPresence.setVisibility(0);
            mImgPresence.setImageResource(R.drawable.zm_offline);
            mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_presence_offline));
        } else {
            mImgPresence.setVisibility(0);
            mImgPresence.setImageResource(R.drawable.zm_offline);
            mImgPresence.setContentDescription((CharSequence)mImgPresence.getResources().getString(R.string.zm_description_mm_presence_offline));
        }
    }

    private void lazyLoadAvatar(final AvatarView avatarView, final Context context, final MemCache<String, Drawable> avatarCache) {
        avatarView.setCornerRadiusRatio(0.5f);
        avatarView.setAvatar((Drawable)null);
        avatarView.setTag(this);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Object tag = avatarView.getTag();
                if (tag != MMChatsListItem.this) {
                    return;
                }
                MMChatsListItem.this.loadAvatar(avatarView, context, false, avatarCache);
            }
        }, 300L);
    }

    private boolean loadAvatar(AvatarView avatarView, Context context, boolean fromMemCacheOnly, MemCache<String, Drawable> avatarCache) {
        Bitmap bmp;
        File file;
        Drawable drawable2;
        if (avatarCache != null && (drawable2 = avatarCache.getCachedItem(this.sessionId)) != null) {
            avatarView.setCornerRadiusRatio(this.isGroup ? 0.0f : 0.5f);
            avatarView.setAvatar(drawable2);
            avatarView.setTag(this);
            return true;
        }
        boolean needClearIfNoCache = true;
        Object tag = avatarView.getTag();
        if (tag instanceof MMChatsListItem) {
            MMChatsListItem lastItem = (MMChatsListItem)tag;
            if (StringUtil.isSameString((String)lastItem.sessionId, (String)this.sessionId)) {
                needClearIfNoCache = false;
            }
        }
        avatarView.setTag(this);
        String avatar = this.getAvatar();
        if (!StringUtil.isEmptyOrNull((String)avatar) && (file = new File(avatar)).exists() && file.isFile() && (bmp = ZMBitmapFactory.decodeFile(avatar, fromMemCacheOnly)) != null) {
            avatarView.setCornerRadiusRatio(0.5f);
            BitmapDrawable drawable3 = new BitmapDrawable(context.getResources(), bmp);
            avatarView.setAvatar(avatar);
            if (avatarCache != null) {
                avatarCache.cacheItem(this.sessionId, (Drawable)drawable3);
            }
            return true;
        }
        if (this.fromContact != null) {
            Bitmap bmp2 = this.fromContact.getAvatarBitmap(context, fromMemCacheOnly);
            if (bmp2 != null) {
                avatarView.setCornerRadiusRatio(0.5f);
                BitmapDrawable drawable4 = new BitmapDrawable(context.getResources(), bmp2);
                avatarView.setAvatar((Drawable)drawable4);
                if (avatarCache != null) {
                    avatarCache.cacheItem(this.sessionId, (Drawable)drawable4);
                }
                return true;
            }
            if (!fromMemCacheOnly || needClearIfNoCache) {
                avatarView.setCornerRadiusRatio(0.5f);
                avatarView.setAvatar((Drawable)null);
            }
        } else {
            if (this.isGroup) {
                avatarView.setAvatar(new GroupAvatarDrawable_v2(this.getSessionId()));
                return true;
            }
            if (!fromMemCacheOnly || needClearIfNoCache) {
                avatarView.setCornerRadiusRatio(0.5f);
                avatarView.setAvatar((Drawable)null);
            }
        }
        return false;
    }

    private String formatTime(Context context, long time) {
        long curTime = System.currentTimeMillis();
        long yesterday = curTime - 86400000L;
        if (TimeUtil.isSameDate((long)time, (long)curTime)) {
            return TimeUtil.formatTime((Context)context, (long)time);
        }
        if (TimeUtil.isSameDate((long)time, (long)yesterday)) {
            return context.getString(R.string.zm_lbl_yesterday);
        }
        return TimeUtil.formatDate((Context)context, (long)time);
    }

    public boolean isNotifyOff() {
        return this.isNotifyOff;
    }

    public void setNotifyOff(boolean isNotifyOff) {
        this.isNotifyOff = isNotifyOff;
    }

    public boolean isE2E() {
        return this.mIsE2E;
    }

    public void setE2E(boolean mIsE2E) {
        this.mIsE2E = mIsE2E;
    }
}

