/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.mm.MMChatsListItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;

public class MMChatsListAdapter
extends BaseAdapter {
    private static final String TAG = MMChatsListAdapter.class.getSimpleName();
    private static final int ITEM_TYPE_NORMAL = 0;
    private List<MMChatsListItem> items = new ArrayList<MMChatsListItem>();
    private List<MMChatsListItem> filteredItems = new ArrayList<MMChatsListItem>();
    private Context mContext;
    private String mFilter;
    private MemCache<String, Drawable> mAvatarCache;
    private boolean mLazyLoadAvatarDisabled = false;
    private List<String> mLoadedItems = new ArrayList<String>();

    public MMChatsListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void clearLoadedItemCache() {
        this.mLoadedItems.clear();
    }

    public List<String> getLoadedItems() {
        return this.mLoadedItems;
    }

    public void setAvatarCache(MemCache<String, Drawable> avatarCache) {
        this.mAvatarCache = avatarCache;
    }

    public void clear() {
        this.items.clear();
        this.filteredItems.clear();
    }

    public void addItem(MMChatsListItem item) {
        assert (item != null);
        int oldIdx = this.findItem(item.getSessionId());
        if (oldIdx >= 0) {
            this.items.set(oldIdx, item);
        } else {
            this.items.add(item);
        }
    }

    public boolean removeItem(String sessionId) {
        int pos = this.findItem(sessionId);
        if (pos >= 0) {
            this.items.remove(pos);
            return true;
        }
        if (this.mFilter != null) {
            for (int i = 0; i < this.filteredItems.size(); ++i) {
                MMChatsListItem item = this.filteredItems.get(i);
                if (!sessionId.equals(item.getSessionId())) continue;
                this.filteredItems.remove(i);
                break;
            }
        }
        return false;
    }

    private int findItem(String sessionId) {
        if (sessionId == null) {
            return -1;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            MMChatsListItem item = this.items.get(i);
            if (!sessionId.equals(item.getSessionId())) continue;
            return i;
        }
        return -1;
    }

    public MMChatsListItem getItemBySessionId(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            MMChatsListItem item = this.items.get(i);
            if (!sessionId.equals(item.getSessionId())) continue;
            return item;
        }
        return null;
    }

    public int getCount() {
        if (this.mFilter != null) {
            return this.filteredItems.size();
        }
        return this.items.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        if (this.mFilter != null) {
            return this.filteredItems.get(position);
        }
        return this.items.get(position);
    }

    public int getChatsItemsCount() {
        return this.items.size();
    }

    public MMChatsListItem getChatsItem(int position) {
        if (position < 0 || position >= this.getChatsItemsCount()) {
            return null;
        }
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public void setLazyLoadAvatarDisabled(boolean disabled) {
        this.mLazyLoadAvatarDisabled = disabled;
    }

    private void sort() {
        ArrayList<MMChatsListItem> extrasItems = new ArrayList<MMChatsListItem>();
        for (int i = 0; i < this.items.size(); ++i) {
            MMChatsListItem item = this.items.get(i);
            if (TextUtils.isEmpty((CharSequence)item.getSessionId()) || !item.getSessionId().startsWith("######")) continue;
            extrasItems.add(item);
            this.items.remove(i);
            --i;
        }
        if (extrasItems.size() > 0) {
            for (MMChatsListItem extraItem : extrasItems) {
                boolean isAdded = false;
                for (int i = 0; i < this.items.size(); ++i) {
                    MMChatsListItem item = this.items.get(i);
                    if (extraItem.getUnreadMessageCount() > 0) {
                        if (item.getUnreadMessageCount() > 0) {
                            if (extraItem.getTimeStamp() <= item.getTimeStamp()) continue;
                            this.items.add(i, extraItem);
                            isAdded = true;
                            break;
                        }
                        this.items.add(i, extraItem);
                        isAdded = true;
                        break;
                    }
                    if (item.getUnreadMessageCount() != 0 || extraItem.getTimeStamp() <= item.getTimeStamp()) continue;
                    this.items.add(i, extraItem);
                    isAdded = true;
                    break;
                }
                if (isAdded) continue;
                this.items.add(extraItem);
            }
        }
    }

    public void notifyDataSetChanged() {
        this.sort();
        if (this.mFilter != null) {
            this.forceFilter(this.mFilter);
        }
        super.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        Object item = this.getItem(position);
        if (item == null) {
            return null;
        }
        if (item instanceof MMChatsListItem) {
            MMChatsListItem sessionItem = (MMChatsListItem)item;
            this.mLoadedItems.remove(sessionItem.getSessionId());
            this.mLoadedItems.add(sessionItem.getSessionId());
            return sessionItem.getView(this.mContext, convertView, parent, this.mAvatarCache, this.mLazyLoadAvatarDisabled);
        }
        return null;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        Object item = this.getItem(position);
        if (item == null) {
            return false;
        }
        return item instanceof MMChatsListItem;
    }

    public void filter(String filter) {
        if (StringUtil.isSameString((String)this.mFilter, (String)(filter = StringUtil.isEmptyOrNull((String)filter) ? null : filter.trim().toLowerCase(CompatUtils.getLocalDefault())))) {
            return;
        }
        this.forceFilter(filter);
        super.notifyDataSetChanged();
    }

    private void forceFilter(String filter) {
        this.mFilter = filter;
        this.filteredItems.clear();
        if (this.mFilter == null) {
            return;
        }
        Locale locale = CompatUtils.getLocalDefault();
        for (MMChatsListItem item : this.items) {
            String title = item.getTitle();
            if (title == null || title.toLowerCase(locale).indexOf(filter) < 0) continue;
            this.filteredItems.add(item);
        }
    }

    static class MMChatsListItemComparator
    implements Comparator<MMChatsListItem> {
        MMChatsListItemComparator() {
        }

        @Override
        public int compare(MMChatsListItem lhs, MMChatsListItem rhs) {
            if (lhs.getUnreadMessageCount() > 0 && rhs.getUnreadMessageCount() <= 0) {
                return -1;
            }
            if (lhs.getUnreadMessageCount() <= 0 && rhs.getUnreadMessageCount() > 0) {
                return 1;
            }
            if (lhs.getTimeStamp() > rhs.getTimeStamp()) {
                return -1;
            }
            if (lhs.getTimeStamp() < rhs.getTimeStamp()) {
                return 1;
            }
            return 0;
        }
    }
}

