/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMChatMessageBgDrawable
extends StateListDrawable {
    public static final int MSG_STATE_PLAIN = 0;
    public static final int MSG_STATE_E2E_SUCCESS = 1;
    public static final int MSG_STATE_E2E_PENDING = 2;
    public static final int MSG_STATE_E2E_WARN = 3;
    public static final int MSG_STATE_IMAGE_PENDING = 4;
    private int mMsgType;
    private boolean mNoTitle;
    private boolean mIsFrom;
    private Context mContext;
    private boolean mBottomCorner;

    public MMChatMessageBgDrawable(Context context, int msgState, boolean noTitle, boolean isFrom) {
        this(context, msgState, noTitle, isFrom, true);
    }

    public MMChatMessageBgDrawable(Context context, int msgState, boolean noTitle, boolean isFrom, boolean bottomCorner) {
        this.mMsgType = msgState;
        this.mNoTitle = noTitle;
        this.mContext = context;
        this.mIsFrom = isFrom;
        int topPadding = UIUtil.dip2px((Context)this.mContext, (float)10.0f);
        int leftPadding = UIUtil.dip2px((Context)this.mContext, (float)16.0f);
        this.mBottomCorner = bottomCorner;
        this.init(leftPadding, topPadding, leftPadding, topPadding);
    }

    public MMChatMessageBgDrawable(Context context, int msgState, boolean noTitle, boolean isFrom, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        this.mMsgType = msgState;
        this.mNoTitle = noTitle;
        this.mContext = context;
        this.mIsFrom = isFrom;
        this.mBottomCorner = true;
        this.init(leftPadding, topPadding, rightPadding, bottomPadding);
    }

    private void init(int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        if (this.mContext == null) {
            return;
        }
        Resources res = this.mContext.getResources();
        if (res == null) {
            return;
        }
        int colorNormal = -1;
        int colorPress = -1;
        switch (this.mMsgType) {
            case 0: {
                if (this.mIsFrom) {
                    colorNormal = res.getColor(R.color.zm_chat_msg_bg_plain_normal_19884);
                    colorPress = res.getColor(R.color.zm_chat_msg_bg_plain_press);
                    break;
                }
                colorNormal = res.getColor(R.color.zm_chat_msg_bg_e2e_success_normal_19884);
                colorPress = res.getColor(R.color.zm_chat_msg_bg_e2e_success_press);
                break;
            }
            case 1: {
                colorNormal = res.getColor(R.color.zm_chat_msg_bg_e2e_success_normal_19884);
                colorPress = res.getColor(R.color.zm_chat_msg_bg_e2e_success_press);
                break;
            }
            case 2: {
                colorNormal = res.getColor(R.color.zm_chat_msg_bg_e2e_pending_normal);
                colorPress = res.getColor(R.color.zm_chat_msg_bg_e2e_pending_press);
                break;
            }
            case 3: {
                colorNormal = res.getColor(R.color.zm_chat_msg_bg_e2e_warn_normal);
                colorPress = res.getColor(R.color.zm_chat_msg_bg_e2e_warn_press);
                break;
            }
            case 4: {
                colorNormal = res.getColor(R.color.zm_chat_msg_bg_plain_normal_19884);
                colorPress = res.getColor(R.color.zm_chat_msg_bg_plain_press);
                break;
            }
            default: {
                return;
            }
        }
        int radius = UIUtil.dip2px((Context)this.mContext, (float)10.0f);
        float[] radii = new float[8];
        if (this.mBottomCorner) {
            radii[4] = radius;
            radii[5] = radius;
            radii[6] = radius;
            radii[7] = radius;
        } else {
            radii[4] = 0.0f;
            radii[5] = 0.0f;
            radii[6] = 0.0f;
            radii[7] = 0.0f;
        }
        if (this.mNoTitle) {
            radii[0] = radius;
            radii[1] = radius;
            radii[2] = radius;
            radii[3] = radius;
        } else if (this.mIsFrom) {
            radii[2] = radius;
            radii[3] = radius;
        } else {
            radii[0] = radius;
            radii[1] = radius;
        }
        RoundRectShape shape = new RoundRectShape(radii, null, null);
        ShapeDrawable normalDraw = new ShapeDrawable((Shape)shape);
        normalDraw.getPaint().setColor(colorNormal);
        normalDraw.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        ShapeDrawable pressDraw = new ShapeDrawable((Shape)shape);
        pressDraw.getPaint().setColor(colorPress);
        normalDraw.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        this.addState(new int[]{16842919}, (Drawable)pressDraw);
        this.addState(new int[0], (Drawable)normalDraw);
    }
}

