/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.view.AvatarView;
import us.zoom.videomeetings.R;

public class MMChatBuddyItemView
extends LinearLayout {
    private TextView mTxtScreenName;
    private AvatarView mImgAvatar;
    private View mImgRemove;
    private TextView mTxtRole;
    private View mViewContent;
    private View.OnClickListener mOnButtonRemoveClickListener;
    private View.OnClickListener mOnAvatarClickListener;

    public MMChatBuddyItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMChatBuddyItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mImgAvatar = (AvatarView)this.findViewById(R.id.imgAvatar);
        this.mImgRemove = this.findViewById(R.id.imgRemove);
        this.mTxtRole = (TextView)this.findViewById(R.id.txtRole);
        this.mViewContent = this.findViewById(R.id.viewContent);
        this.mImgRemove.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MMChatBuddyItemView.this.mOnButtonRemoveClickListener != null) {
                    MMChatBuddyItemView.this.mOnButtonRemoveClickListener.onClick(v);
                }
            }
        });
        this.mImgAvatar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MMChatBuddyItemView.this.mOnAvatarClickListener != null) {
                    MMChatBuddyItemView.this.mOnAvatarClickListener.onClick(v);
                }
            }
        });
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_chat_buddy_item, (ViewGroup)this);
    }

    public void setOnButtonRemoveClickListener(View.OnClickListener l) {
        this.mOnButtonRemoveClickListener = l;
    }

    public void setOnAvatarClickListener(View.OnClickListener l) {
        this.mOnAvatarClickListener = l;
    }

    public void setScreenName(CharSequence name) {
        if (name != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText(name);
        }
        this.mImgAvatar.setName(name);
    }

    public void setJid(String jid) {
        this.mImgAvatar.setBgColorSeedString(jid);
    }

    public void setAvatar(String imgPathName) {
        this.mImgAvatar.setAvatar(imgPathName);
    }

    public void setAvatar(Bitmap bitmap) {
        this.mImgAvatar.setAvatar(bitmap);
    }

    public void setRemoveEnabled(boolean enabled) {
        if (this.mImgRemove != null) {
            this.mImgRemove.setVisibility(enabled ? 0 : 8);
        }
    }

    public void setContentDes(CharSequence name, boolean isAdmin) {
        if (this.mViewContent != null) {
            this.mViewContent.setContentDescription((CharSequence)(name + (isAdmin ? this.getContext().getResources().getString(R.string.zm_mm_lbl_group_owner) : "")));
        }
    }

    public boolean isRemoveEnabled() {
        if (this.mImgRemove != null) {
            return this.mImgRemove.getVisibility() == 0;
        }
        return false;
    }

    public void setIsGroupAdmin(boolean isAdmin) {
        if (isAdmin) {
            this.mTxtRole.setText(R.string.zm_mm_lbl_group_owner);
            this.mTxtRole.setVisibility(0);
        } else {
            this.mTxtRole.setVisibility(4);
        }
    }
}

