/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.fragment.MMChatInfoFragment;
import com.zipow.videobox.view.mm.MMBuddyItem;
import com.zipow.videobox.view.mm.MMBuddyItemComparator;
import com.zipow.videobox.view.mm.MMChatBuddiesGridView;
import com.zipow.videobox.view.mm.MMChatBuddyItemView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

class MMChatBuddiesGridViewAdapter
extends BaseAdapter {
    private static final int ITEM_TYPE_BUDDY = 0;
    private static final int ITEM_TYPE_BTN_ADD = 1;
    private static final int ITEM_TYPE_BTN_REMOVE = 2;
    private static final String BTN_ADD = "Add";
    private static final String BTN_REMOVE = "Remove";
    private List<MMBuddyItem> items = new ArrayList<MMBuddyItem>();
    private Context mContext;
    private MMChatBuddiesGridView mChatBuddiesGridView;
    private boolean mIsRemoveMode = false;
    private boolean isGroupOperatorable = false;
    private List<String> admins;
    private int max = 0;

    public MMChatBuddiesGridViewAdapter(Context context, MMChatBuddiesGridView chatBuddiesGridView) {
        assert (context != null);
        this.mContext = context;
        this.mChatBuddiesGridView = chatBuddiesGridView;
    }

    public void setGroupOperatorable(boolean groupOperatorable) {
        this.isGroupOperatorable = groupOperatorable;
    }

    public void setGroupAdmin(List<String> admins) {
        this.admins = admins;
    }

    public void setIsRemoveMode(boolean isRemoveMode) {
        this.mIsRemoveMode = isRemoveMode;
    }

    public boolean isRemoveMode() {
        return this.mIsRemoveMode;
    }

    public List<MMBuddyItem> getBuddyItems() {
        ArrayList<MMBuddyItem> items = new ArrayList<MMBuddyItem>();
        items.addAll(this.items);
        return items;
    }

    public void clear() {
        this.items.clear();
    }

    public void addItem(MMBuddyItem item) {
        assert (item != null);
        this.items.add(item);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public int getCount() {
        if (this.max > 0) {
            if (this.isGroupOperatorable) {
                if (this.mIsRemoveMode) {
                    return this.items.size() <= MMChatInfoFragment.MAX - 2 ? this.items.size() : MMChatInfoFragment.MAX - 2;
                }
                return this.items.size() <= MMChatInfoFragment.MAX - 2 ? this.items.size() + 2 : MMChatInfoFragment.MAX;
            }
            if (this.mIsRemoveMode) {
                return this.items.size() <= MMChatInfoFragment.MAX - 1 ? this.items.size() : MMChatInfoFragment.MAX - 1;
            }
            return this.items.size() <= MMChatInfoFragment.MAX - 1 ? this.items.size() + 1 : MMChatInfoFragment.MAX;
        }
        if (this.mIsRemoveMode) {
            return this.items.size();
        }
        if (this.isGroupOperatorable) {
            return this.items.size() + 2;
        }
        return this.items.size() + 1;
    }

    public Object getItem(int position) {
        int count = this.getCount();
        if (position < 0 || position >= count) {
            return null;
        }
        if (this.mIsRemoveMode) {
            return this.items.get(position);
        }
        if (this.isGroupOperatorable) {
            if (position == count - 2) {
                return BTN_ADD;
            }
            if (position == count - 1) {
                return BTN_REMOVE;
            }
            return this.items.get(position);
        }
        if (position == count - 1) {
            return BTN_ADD;
        }
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        int type = 0;
        Object item = this.getItem(position);
        if (item instanceof MMBuddyItem) {
            type = 0;
        } else if (BTN_ADD.equals(item)) {
            type = 1;
        } else if (BTN_REMOVE.equals(item)) {
            type = 2;
        }
        return type;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        int type = this.getItemViewType(position);
        return type != 0;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        Object item = this.getItem(position);
        if (item instanceof MMBuddyItem) {
            return this.getBuddyView((MMBuddyItem)item, convertView);
        }
        if (BTN_ADD.equals(item)) {
            return this.getBtnAddView(convertView, parent);
        }
        if (BTN_REMOVE.equals(item)) {
            return this.getBtnRemoveView(convertView, parent);
        }
        return null;
    }

    public void sort() {
        Collections.sort(this.items, new MMBuddyItemComparator(CompatUtils.getLocalDefault()));
    }

    private View getBuddyView(final MMBuddyItem item, View convertView) {
        MMChatBuddyItemView itemView = null;
        itemView = convertView instanceof MMChatBuddyItemView ? (MMChatBuddyItemView)convertView : new MMChatBuddyItemView(this.mContext);
        itemView.setScreenName(item.getScreenName());
        itemView.setJid(item.buddyJid);
        itemView.setIsGroupAdmin(this.admins != null && this.admins.size() > 0 && this.admins.get(0).equals(item.buddyJid));
        itemView.setContentDes(item.getScreenName(), this.admins != null && this.admins.size() > 0 && this.admins.get(0).equals(item.buddyJid));
        itemView.setRemoveEnabled(this.mIsRemoveMode && !item.isMySelf() && !item.isRobot);
        itemView.setOnButtonRemoveClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MMChatBuddiesGridViewAdapter.this.mChatBuddiesGridView.onClickBuddyRemoveBtn(item);
            }
        });
        itemView.setOnAvatarClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MMChatBuddiesGridViewAdapter.this.mChatBuddiesGridView.onClickBuddyItem(item);
            }
        });
        if (!itemView.isInEditMode()) {
            File file;
            String avatarPath = item.getAvatar();
            boolean hasAvatarFile = false;
            if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                itemView.setAvatar(avatarPath);
                hasAvatarFile = true;
            }
            if (!hasAvatarFile) {
                if (item.localContact != null) {
                    itemView.setAvatar(item.localContact.getAvatarBitmap(this.mContext));
                } else {
                    itemView.setAvatar((String)null);
                }
            }
        }
        return itemView;
    }

    private View getBtnAddView(View convertView, ViewGroup parent) {
        View view;
        if (convertView != null && BTN_ADD.equals(convertView.getTag())) {
            view = convertView;
        } else {
            LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
            view = factory.inflate(R.layout.zm_mm_chat_add_buddy_btn, parent, false);
            view.setTag((Object)BTN_ADD);
        }
        View btn = view.findViewById(R.id.imageButton);
        if (btn != null) {
            btn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MMChatBuddiesGridViewAdapter.this.mChatBuddiesGridView.onClickAddBtn();
                }
            });
        }
        return view;
    }

    private View getBtnRemoveView(View convertView, ViewGroup parent) {
        View view;
        if (convertView != null && BTN_REMOVE.equals(convertView.getTag())) {
            view = convertView;
        } else {
            LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
            view = factory.inflate(R.layout.zm_mm_chat_remove_buddy_btn, parent, false);
            view.setTag((Object)BTN_REMOVE);
        }
        View btn = view.findViewById(R.id.imageButton);
        if (btn != null) {
            btn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MMChatBuddiesGridViewAdapter.this.mChatBuddiesGridView.onClickRemoveBtn();
                }
            });
        }
        return view;
    }
}

