/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddySearchData;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.mm.AddCompanyContactsItem;
import com.zipow.videobox.view.mm.AddCompanyContactsItemComparator;
import com.zipow.videobox.view.mm.AddCompanyContactsListAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.CompatUtils;

public class AddCompanyContactsListView
extends ListView
implements AdapterView.OnItemClickListener {
    private static final String TAG = AddCompanyContactsListView.class.getSimpleName();
    private AddCompanyContactsListAdapter mAdapter;
    private Listener mListener;
    private String mFilter;
    private List<AddCompanyContactsItem> mSelectedItems = new ArrayList<AddCompanyContactsItem>();
    private RetainedFragment mRetainedFragment;
    private int mLastTopPosition = 0;

    public AddCompanyContactsListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public AddCompanyContactsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public AddCompanyContactsListView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mAdapter = new AddCompanyContactsListAdapter(this.getContext());
        this.setOnItemClickListener(this);
        if (!this.isInEditMode()) {
            this.initRetainedFragment();
        }
    }

    private void _editmode_loadAllBuddyItems(AddCompanyContactsListAdapter adapter) {
        for (int i = 0; i < 20; ++i) {
            AddCompanyContactsItem item = new AddCompanyContactsItem();
            item.setJid(String.valueOf(i));
            item.setScreenName("Test " + i);
            item.setChecked(i % 2 == 0);
            adapter.addItem(item);
        }
    }

    private void loadAllBuddyItems(AddCompanyContactsListAdapter adapter) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddySearchData data = messenger.getBuddySearchData();
        if (data == null) {
            return;
        }
        int count = data.getBuddyCount();
        for (int i = 0; i < count; ++i) {
            ZoomBuddy buddy = data.getBuddyAt(i);
            if (buddy == null) continue;
            AddCompanyContactsItem item = new AddCompanyContactsItem(buddy);
            item.setChecked(this.isItemSelected(item.getJid()));
            adapter.addItem(item);
        }
        adapter.sort();
    }

    private boolean isItemSelected(String jid) {
        if (jid == null) {
            return false;
        }
        for (AddCompanyContactsItem item : this.mSelectedItems) {
            if (!jid.equals(item.getJid())) continue;
            return true;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            this._editmode_loadAllBuddyItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        if (this.mLastTopPosition >= 0) {
            this.setSelectionFromTop(this.mLastTopPosition, 0);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("AddFavoriteListView.superState");
            this.mFilter = allState.getString("AddFavoriteListView.mFilter");
            this.mLastTopPosition = allState.getInt("AddFavoriteListView.topPosition", -1);
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("AddFavoriteListView.superState", superState);
        bundle.putString("AddFavoriteListView.mFilter", this.mFilter);
        bundle.putInt("AddFavoriteListView.topPosition", this.pointToPosition(10, 10));
        return bundle;
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public void reloadAllBuddyItems() {
        long timeStart = System.currentTimeMillis();
        this.mAdapter.clear();
        this.loadAllBuddyItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void clearSelection() {
        this.mSelectedItems.clear();
        for (int index = 0; index < this.mAdapter.getCount(); ++index) {
            AddCompanyContactsItem item = (AddCompanyContactsItem)this.mAdapter.getItem(index);
            if (item != null) {
                item.setChecked(false);
            }
            this.mAdapter.notifyDataSetChanged();
        }
        if (this.mListener != null) {
            this.mListener.onSelectionChanged();
        }
    }

    public List<AddCompanyContactsItem> getSelectedBuddies() {
        return this.mSelectedItems;
    }

    public void unselectBuddy(AddCompanyContactsItem item) {
        if (item != null) {
            AddCompanyContactsItem listItem = this.mAdapter.getItemByJid(item.getJid());
            if (listItem != null) {
                listItem.setChecked(false);
                this.mAdapter.notifyDataSetChanged();
            }
            this.removeSelectedItem(item);
            if (this.mListener != null) {
                this.mListener.onSelectionChanged();
            }
        }
    }

    public void updateBuddy(String jid) {
    }

    public void filter(String filter) {
        this.mFilter = filter;
        this.reloadAllBuddyItems();
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        AddCompanyContactsItem item = (AddCompanyContactsItem)this.mAdapter.getItem(position);
        if (item != null) {
            item.setChecked(!item.isChecked());
            this.mAdapter.notifyDataSetChanged();
            if (item.isChecked()) {
                this.addSelectedItem(item);
            } else {
                this.removeSelectedItem(item);
            }
            if (this.mListener != null) {
                this.mListener.onSelectionChanged();
            }
        }
    }

    private void removeSelectedItem(AddCompanyContactsItem item) {
        for (int i = this.mSelectedItems.size() - 1; i >= 0; --i) {
            AddCompanyContactsItem tmpItem = this.mSelectedItems.get(i);
            if (item.getJid() == null || !item.getJid().equals(tmpItem.getJid())) continue;
            this.mSelectedItems.remove(i);
            break;
        }
    }

    private void addSelectedItem(AddCompanyContactsItem item) {
        item.setChecked(true);
        for (int i = this.mSelectedItems.size() - 1; i >= 0; --i) {
            AddCompanyContactsItem tmpItem = this.mSelectedItems.get(i);
            if (item.getJid() == null || !item.getJid().equals(tmpItem.getJid())) continue;
            this.mSelectedItems.set(i, item);
            Collections.sort(this.mSelectedItems, new AddCompanyContactsItemComparator(CompatUtils.getLocalDefault()));
            return;
        }
        this.mSelectedItems.add(item);
        Collections.sort(this.mSelectedItems, new AddCompanyContactsItemComparator(CompatUtils.getLocalDefault()));
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            this.mRetainedFragment.saveSelectedItems(this.mSelectedItems);
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        } else {
            List<AddCompanyContactsItem> oldItems = this.mRetainedFragment.restoreSelectedItems();
            if (oldItems != null) {
                this.mSelectedItems = oldItems;
            }
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
        return retainedFragment;
    }

    public static class RetainedFragment
    extends ZMFragment {
        private List<AddCompanyContactsItem> mSelectedItems = null;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void saveSelectedItems(List<AddCompanyContactsItem> items) {
            this.mSelectedItems = items;
        }

        public List<AddCompanyContactsItem> restoreSelectedItems() {
            return this.mSelectedItems;
        }
    }

    public static interface Listener {
        public void onSelectionChanged();
    }
}

