/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.bookmark;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.view.bookmark.BookmarkAddViewFragment;
import com.zipow.videobox.view.bookmark.BookmarkEditViewFragment;
import com.zipow.videobox.view.bookmark.BookmarkItem;
import com.zipow.videobox.view.bookmark.BookmarkListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class BookmarkListViewFragment
extends ZMDialogFragment
implements View.OnClickListener,
BookmarkListView.onChangeListener {
    public static final int REQUEST_BOOKMARK_EDIT = 1200;
    private static final String BOOKMARK_EDIT_MODE = "bk_edit";
    private BookmarkListView mBookmarkListView;
    private View mBtnAdd;
    private View mBtnDone;
    private View mBtnEdit;
    private View mNoBookmarkPromt;
    private String mCurPageTitle;
    private String mCurPageUrl;
    private boolean bEditMode = false;

    public static void showAsActivity(ZMActivity activity, Bundle args, int requestCode) {
        if (activity == null) {
            return;
        }
        if (args == null) {
            args = new Bundle();
        }
        SimpleActivity.show(activity, BookmarkListViewFragment.class.getName(), args, requestCode);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putBoolean(BOOKMARK_EDIT_MODE, this.bEditMode);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.bEditMode = savedInstanceState.getBoolean(BOOKMARK_EDIT_MODE, false);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_bookmark_list_view, container, false);
        this.mNoBookmarkPromt = view.findViewById(R.id.txtNoBookmark);
        this.mBtnAdd = view.findViewById(R.id.btnAdd);
        this.mBtnDone = view.findViewById(R.id.btnDone);
        this.mBtnEdit = view.findViewById(R.id.btnEdit);
        this.mBookmarkListView = (BookmarkListView)view.findViewById(R.id.bookmarkListView);
        this.mNoBookmarkPromt.setVisibility(8);
        this.mBtnAdd.setOnClickListener((View.OnClickListener)this);
        this.mBtnDone.setOnClickListener((View.OnClickListener)this);
        this.mBtnEdit.setOnClickListener((View.OnClickListener)this);
        this.mBookmarkListView.registerListener(this);
        Bundle arg = this.getArguments();
        if (arg != null) {
            this.mCurPageTitle = arg.getString("bookmark_title");
            this.mCurPageUrl = arg.getString("bookmark_url");
        }
        return view;
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
        this.mBookmarkListView.reloadAllItems();
        this.updateUI();
    }

    public void onClick(View v) {
        if (v == this.mBtnAdd) {
            this.onClickBtnAdd();
        } else if (v == this.mBtnDone) {
            this.onClickBtnCancel();
        } else if (v == this.mBtnEdit) {
            this.onClickBtnEdit();
        }
    }

    private void onClickBtnAdd() {
        Bundle bundle = new Bundle();
        if (!StringUtil.isEmptyOrNull((String)this.mCurPageTitle)) {
            bundle.putString("bookmark_title", this.mCurPageTitle);
        }
        if (!StringUtil.isEmptyOrNull((String)this.mCurPageUrl)) {
            bundle.putString("bookmark_url", this.mCurPageUrl);
        }
        BookmarkAddViewFragment.showAsActivity((Fragment)this, bundle);
    }

    private void onClickBtnCancel() {
        this.dismiss();
    }

    private void showEditStatus() {
        Button btnEdit = (Button)this.mBtnEdit;
        btnEdit.setText(R.string.zm_btn_done);
        this.mBtnAdd.setVisibility(8);
        this.mBtnDone.setVisibility(8);
    }

    private void showListStatus() {
        Button btnEdit = (Button)this.mBtnEdit;
        btnEdit.setText(R.string.zm_btn_edit);
        this.mBtnAdd.setVisibility(0);
        this.mBtnDone.setVisibility(0);
    }

    private void onClickBtnEdit() {
        this.bEditMode = this.mBookmarkListView.getItemCount() > 0 ? !this.bEditMode : false;
        this.updateUI();
    }

    private void updateUI() {
        if (this.mBookmarkListView.getItemCount() <= 0) {
            this.mNoBookmarkPromt.setVisibility(0);
            this.mBtnEdit.setVisibility(8);
        } else {
            this.mNoBookmarkPromt.setVisibility(8);
            this.mBtnEdit.setVisibility(0);
        }
        if (!this.bEditMode) {
            this.showListStatus();
        } else {
            this.showEditStatus();
        }
        this.mBookmarkListView.setMode(this.bEditMode);
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    @Override
    public void onSelectItem(BookmarkItem item) {
        if (this.getShowsDialog()) {
            super.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                Intent intent = new Intent();
                if (item != null) {
                    intent.putExtra("bookmark_url", item.getItemUrl());
                }
                activity.setResult(-1, intent);
                activity.finish();
            }
        }
    }

    @Override
    public void onEditItem(int index) {
        Bundle bundle = new Bundle();
        if (index >= 0) {
            bundle.putInt("bookmark_pos", index);
        }
        BookmarkEditViewFragment.showAsActivity((Fragment)this, bundle, 1200);
    }

    @Override
    public void onDataChange() {
        if (this.mBookmarkListView.getItemCount() <= 0) {
            this.bEditMode = false;
        }
        this.updateUI();
    }
}

