/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.bookmark;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.view.bookmark.BookmarkItem;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class BookmarkListItemView
extends LinearLayout
implements View.OnClickListener {
    private TextView mTextName;
    private ImageView mDelIcon;
    private ImageView mEditIcon;
    private BookmarkItem mItem;
    private boolean bEditMode = false;
    private onBookmarkItemNotify mListener;

    public BookmarkListItemView(Context context) {
        super(context);
        this.initView(context);
    }

    public BookmarkListItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (inflater == null) {
            return;
        }
        View view = inflater.inflate(R.layout.zm_bookmark_item_view, (ViewGroup)this, true);
        this.mTextName = (TextView)view.findViewById(R.id.txtName);
        this.mDelIcon = (ImageView)view.findViewById(R.id.ImageDelIcon);
        this.mEditIcon = (ImageView)view.findViewById(R.id.ImageEditIcon);
        this.mDelIcon.setVisibility(8);
        this.mEditIcon.setVisibility(8);
        this.mDelIcon.setOnClickListener((View.OnClickListener)this);
        this.mListener = null;
    }

    public void setBookmarkListItem(BookmarkItem item) {
        this.mItem = item;
        if (this.isInEditMode()) {
            return;
        }
        if (this.mItem == null) {
            return;
        }
        String name = this.mItem.getItemName();
        String url = this.mItem.getItemUrl();
        if (StringUtil.isEmptyOrNull((String)url)) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)name)) {
            name = url;
        }
        this.mTextName.setText((CharSequence)name);
    }

    public void setMode(boolean edit) {
        if (this.bEditMode != edit) {
            this.bEditMode = edit;
            if (edit) {
                this.mDelIcon.setVisibility(0);
                this.mEditIcon.setVisibility(0);
            } else {
                this.mDelIcon.setVisibility(8);
                this.mEditIcon.setVisibility(8);
            }
        }
    }

    public void onClick(View v) {
        if (this.mListener == null) {
            return;
        }
        if (v == this.mDelIcon) {
            this.mListener.onDelete(this.mItem);
        }
    }

    public void registerListener(onBookmarkItemNotify l) {
        this.mListener = l;
    }

    public void unRegisterListener() {
        this.mListener = null;
    }

    public String getItemTitle() {
        if (this.mItem == null) {
            return null;
        }
        return this.mItem.getItemName();
    }

    public String getItemUrl() {
        if (this.mItem == null) {
            return null;
        }
        return this.mItem.getItemUrl();
    }

    public static interface onBookmarkItemNotify {
        public void onDelete(BookmarkItem var1);
    }
}

