/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.bookmark;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.view.bookmark.BookmarkItem;
import com.zipow.videobox.view.bookmark.BookmarkListItemView;
import java.util.ArrayList;
import java.util.Collection;

class BookmarkAdapter
extends BaseAdapter {
    private Context mContext;
    private ArrayList<BookmarkItem> mItems = new ArrayList();
    private boolean bEditMode = false;
    private BookmarkListItemView.onBookmarkItemNotify mObserver;

    public BookmarkAdapter(Context context, BookmarkListItemView.onBookmarkItemNotify l) {
        this.mContext = context;
        this.mObserver = l;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void addItem(BookmarkItem item) {
        if (item != null) {
            this.mItems.add(item);
        }
    }

    public boolean addAll(Collection<? extends BookmarkItem> collection) {
        if (collection == null) {
            return false;
        }
        return this.mItems.addAll(collection);
    }

    public boolean remove(BookmarkItem item) {
        if (item == null) {
            return false;
        }
        return this.mItems.remove(item);
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Object oItem = this.getItem(position);
        if (oItem == null) {
            return null;
        }
        BookmarkItem item = (BookmarkItem)oItem;
        BookmarkListItemView view = null;
        if (convertView instanceof BookmarkListItemView) {
            view = (BookmarkListItemView)convertView;
        } else {
            view = new BookmarkListItemView(this.mContext);
            view.registerListener(this.mObserver);
        }
        view.setMode(this.bEditMode);
        view.setBookmarkListItem(item);
        return view;
    }

    public void setMode(boolean bEdit) {
        this.bEditMode = bEdit;
    }
}

