/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.videomeetings.R;

public class ZMLatestMeetingAdapter
extends BaseAdapter
implements View.OnClickListener {
    public static final long UPCOMING_MEETING_CHECK_INTERVAL = 600000L;
    private List<ScheduledMeetingItem> mScheduledMeetingItems;
    private final Context mContext;
    private final InnerItemOnclickListener mInnerItemOnclickListener;

    public ZMLatestMeetingAdapter(Context context, InnerItemOnclickListener innerItemOnclickListener) {
        this.mContext = context;
        this.mInnerItemOnclickListener = innerItemOnclickListener;
    }

    public void refresh(List<ScheduledMeetingItem> scheduledMeetingItems) {
        this.mScheduledMeetingItems = scheduledMeetingItems;
        this.notifyDataSetChanged();
    }

    public List<ScheduledMeetingItem> getmScheduledMeetingItems() {
        return this.mScheduledMeetingItems;
    }

    public int getCount() {
        return this.mScheduledMeetingItems == null ? 0 : this.mScheduledMeetingItems.size();
    }

    public ScheduledMeetingItem getItem(int i) {
        return this.mScheduledMeetingItems.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View convertView, ViewGroup viewGroup) {
        View view = null;
        String tag = "ZMLatestMeetingAdapter";
        if (convertView != null && "ZMLatestMeetingAdapter".equals(convertView.getTag())) {
            view = convertView;
        } else {
            LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
            if (factory == null) {
                return null;
            }
            view = factory.inflate(R.layout.zm_item_latest_upcoming_meeting, viewGroup, false);
            view.setTag((Object)"ZMLatestMeetingAdapter");
        }
        ScheduledMeetingItem scheduledMeetingItem = this.getItem(i);
        if (scheduledMeetingItem == null) {
            return view;
        }
        TextView txtUpcomingmeetingtitle = (TextView)view.findViewById(R.id.txt_upcoming_meeting_title);
        TextView txtUpcomingMeetingDesc = (TextView)view.findViewById(R.id.txt_upcoming_meeting_desc);
        TextView txtUpcomingTime = (TextView)view.findViewById(R.id.txt_upcoming_time);
        Button btnUpcomingAction = (Button)view.findViewById(R.id.btnUpcomingAction);
        txtUpcomingTime.setText((CharSequence)TimeUtil.formatTime((Context)this.mContext, (long)scheduledMeetingItem.getStartTime()));
        txtUpcomingmeetingtitle.setText((CharSequence)scheduledMeetingItem.getTopic());
        txtUpcomingMeetingDesc.setText((CharSequence)(this.mContext.getText(R.string.zm_lbl_meeting_id) + " " + StringUtil.formatConfNumber((long)scheduledMeetingItem.getMeetingNo())));
        if (ConfLocalHelper.isSameActiveCall(scheduledMeetingItem)) {
            btnUpcomingAction.setText(R.string.zm_btn_back);
        } else {
            btnUpcomingAction.setText(scheduledMeetingItem.ismIsCanStartMeetingForMySelf() ? R.string.zm_btn_start : R.string.zm_btn_join);
        }
        btnUpcomingAction.setTag((Object)scheduledMeetingItem);
        btnUpcomingAction.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onClick(View view) {
        this.mInnerItemOnclickListener.itemClick(view);
    }

    public static interface InnerItemOnclickListener {
        public void itemClick(View var1);
    }
}

