/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.Touch;
import android.text.style.ReplacementSpan;
import android.view.MotionEvent;
import android.widget.TextView;
import us.zoom.androidlib.widget.ZMEditText;

public class ZMReplaceSpanMovementMethod
extends ArrowKeyMovementMethod {
    private static ZMReplaceSpanMovementMethod mInstance = null;
    private float mDownX = -1.0f;
    private float mDownY = -1.0f;

    public static ZMReplaceSpanMovementMethod getInstance() {
        if (mInstance == null) {
            mInstance = new ZMReplaceSpanMovementMethod();
        }
        return mInstance;
    }

    public boolean onTouchEvent(final TextView widget, Spannable buffer, MotionEvent event) {
        int line;
        int off;
        if (widget == null || buffer == null) {
            return super.onTouchEvent(widget, buffer, event);
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= widget.getTotalPaddingLeft();
        y -= widget.getTotalPaddingTop();
        Layout layout2 = widget.getLayout();
        float xLeft = layout2.getPrimaryHorizontal(off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX())));
        off = xLeft < (float)x ? ++off : --off;
        ReplacementSpan[] spans = (ReplacementSpan[])buffer.getSpans(off, off, ReplacementSpan.class);
        if (spans.length > 0) {
            final int end = buffer.getSpanEnd((Object)spans[0]);
            int action = event.getAction();
            if (action == 0) {
                this.mDownX = event.getX();
                this.mDownY = event.getY();
                widget.setCursorVisible(false);
            } else if (action == 1) {
                float upY;
                float upX = event.getX();
                float value = (this.mDownX - upX) * (this.mDownX - upX) + (this.mDownY - (upY = event.getY())) * (this.mDownY - upY);
                if (value < 80.0f) {
                    widget.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            if (widget instanceof ZMEditText) {
                                ((ZMEditText)widget).setSelection(end);
                            }
                            widget.setCursorVisible(true);
                        }
                    });
                } else {
                    widget.setCursorVisible(true);
                }
                this.mDownX = -1.0f;
                this.mDownY = -1.0f;
            }
        }
        return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
    }
}

