/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zipow.videobox.view.IFeccListener;
import com.zipow.videobox.view.ZMFeccEventTimeRunnable;
import com.zipow.videobox.view.ZMPieView;
import us.zoom.videomeetings.R;

public class ZMFeccView
extends LinearLayout
implements IFeccListener,
View.OnClickListener,
View.OnTouchListener {
    private FeccListener mListener;
    private ZMPieView mPieView;
    private ImageView mSwitch;
    private ImageView mClose;
    private ImageView mZoomIn;
    private ImageView mZoomOut;
    private ZMFeccEventTimeRunnable mTimeRunnable;
    private Handler mHandler;

    @SuppressLint(value={"NewApi"})
    public ZMFeccView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public ZMFeccView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public ZMFeccView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        this.inflateLayout();
        this.mPieView = (ZMPieView)this.findViewById(R.id.pieView);
        this.mSwitch = (ImageView)this.findViewById(R.id.btnSwitch);
        this.mClose = (ImageView)this.findViewById(R.id.btnClose);
        this.mZoomIn = (ImageView)this.findViewById(R.id.btnZoomIn);
        this.mZoomOut = (ImageView)this.findViewById(R.id.btnZoomOut);
        this.mPieView.setListener(this);
        this.mSwitch.setOnClickListener((View.OnClickListener)this);
        this.mClose.setOnClickListener((View.OnClickListener)this);
        this.mZoomIn.setOnTouchListener((View.OnTouchListener)this);
        this.mZoomOut.setOnTouchListener((View.OnTouchListener)this);
        this.mHandler = new Handler();
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_fecc_view, (ViewGroup)this);
    }

    public void setListener(FeccListener l) {
        this.mListener = l;
    }

    public void showPieView(boolean show) {
        if (show) {
            this.mPieView.setVisibility(0);
            this.mZoomIn.setVisibility(0);
            this.mZoomOut.setVisibility(0);
        } else {
            this.mPieView.setVisibility(4);
            this.mZoomIn.setVisibility(4);
            this.mZoomOut.setVisibility(4);
        }
    }

    public void onClick(View v) {
        if (v == this.mSwitch) {
            this.onClickSwitchCam();
        } else if (v == this.mClose) {
            this.onClickClose();
        }
    }

    private void onClickClose() {
        if (this.mListener != null) {
            this.mListener.onFeccClose();
        }
    }

    private void onClickSwitchCam() {
        if (this.mListener != null) {
            this.mListener.onFeccSwitchCam();
        }
    }

    @Override
    public void onFeccClick(int action, int event) {
        if (this.mListener != null) {
            this.mListener.onFeccClick(action, event);
        }
    }

    private void updateEvent(int event) {
        if (this.mTimeRunnable != null) {
            this.mTimeRunnable.updateEvent(event);
        }
    }

    public boolean onTouch(View v, MotionEvent e) {
        int event = 0;
        ImageView imageView = null;
        if (v == this.mZoomIn) {
            event = 5;
            imageView = this.mZoomIn;
        } else if (v == this.mZoomOut) {
            event = 6;
            imageView = this.mZoomOut;
        }
        this.updateEvent(event);
        int action = e.getAction();
        if (action == 0) {
            Drawable drawable2;
            if (imageView != null && (drawable2 = imageView.getDrawable()) != null) {
                drawable2.setState(new int[]{16842910, 16842908, 16842919});
                imageView.invalidate();
            }
            if (this.mListener != null && event != 0) {
                this.mListener.onFeccClick(1, event);
            }
            if (this.mTimeRunnable == null) {
                this.mTimeRunnable = new ZMFeccEventTimeRunnable();
            }
            this.mTimeRunnable.initial(event, this.mHandler, this.mListener);
            this.mHandler.postDelayed((Runnable)this.mTimeRunnable, 300L);
        } else if (action == 1) {
            Drawable drawable3;
            if (imageView != null && (drawable3 = imageView.getDrawable()) != null) {
                drawable3.setState(new int[0]);
                imageView.invalidate();
            }
            if (this.mTimeRunnable != null) {
                this.mHandler.removeCallbacks((Runnable)this.mTimeRunnable);
            }
            if (this.mListener != null) {
                this.mListener.onFeccClick(3, event);
            }
            if (imageView != null) {
                imageView.playSoundEffect(0);
            }
            this.updateEvent(0);
        }
        return true;
    }

    public static interface FeccListener
    extends IFeccListener {
        public void onFeccSwitchCam();

        public void onFeccClose();
    }
}

