/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class ZMCodeView
extends WebView {
    private String content;
    private boolean zoomSupport = false;
    private OnContentChangedListener onContentChangedListener;

    public ZMCodeView(Context context) {
        super(context);
        this.initView(context);
    }

    public ZMCodeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public ZMCodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @TargetApi(value=21)
    public ZMCodeView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.loadUrl("about:blank");
        WebSettings settings = this.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setBuiltInZoomControls(true);
        settings.setSupportZoom(this.zoomSupport);
        if (Build.VERSION.SDK_INT >= 11) {
            settings.setDisplayZoomControls(false);
        }
        this.setScrollBarStyle(0);
        this.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress >= 100) {
                    ZMCodeView.this.injectCodeCss();
                    ZMCodeView.this.injectCodeJs();
                }
            }
        });
        this.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
            }
        });
    }

    private void changeZoomSettings(boolean enable) {
        this.zoomSupport = enable;
        this.getSettings().setSupportZoom(enable);
    }

    public void setOnContentChangedListener(OnContentChangedListener onContentChangedListener) {
        this.onContentChangedListener = onContentChangedListener;
    }

    public void setSource(String source) {
        if (source != null && source.length() != 0) {
            this.content = source;
            this.loadDataWithBaseURL("file:///android_asset/", this.content, "text/html", "utf-8", null);
            if (this.onContentChangedListener != null) {
                this.onContentChangedListener.onContentChanged();
            }
        } else {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Source can't be null or empty.");
        }
    }

    private void injectCodeJs() {
        String injectJs = "javascript:try{if(document.head && !document.getElementById('injectScript')) {var injectScript = document.createElement('script');injectScript.src='file:///android_asset/zm_code.js';injectScript.onload=function(){documentReady();};injectScript.id='injectScript';document.head.appendChild(injectScript);}}catch(e) {}";
        this.loadUrl(injectJs);
    }

    private void injectCodeCss() {
        String injectCss = "javascript:try{if(document.head && !document.getElementById('injectCss')) {var injectCss = document.createElement('link');injectCss.setAttribute('rel', 'stylesheet');injectCss.setAttribute('href', 'styles/zm_style.css');injectCss.id='injectCss';document.head.appendChild(injectCss);}}catch(e) {}";
        this.loadUrl(injectCss);
    }

    public void setSource(File source) {
        String encSource = null;
        try {
            String line;
            FileInputStream fileInputStream = new FileInputStream(source);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
                if (!line.endsWith("<br />")) continue;
                stringBuilder.append("\n");
            }
            fileInputStream.close();
            encSource = stringBuilder.toString();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (encSource == null) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Unable to encode file: " + source.getAbsolutePath()));
        } else {
            this.setSource(encSource);
        }
    }

    public void setSource(URL url) {
        new NetworkLoader(url).execute(new Void[0]);
    }

    public void refresh() {
        if (this.content != null) {
            this.loadUrl("about:blank");
            this.setSource(this.content);
        }
    }

    public void setZoomSupportEnabled(boolean supportZoom) {
        this.changeZoomSettings(supportZoom);
    }

    private class NetworkLoader
    extends AsyncTask<Void, Void, String> {
        private final URL url;

        private NetworkLoader(URL url) {
            this.url = url;
        }

        protected String doInBackground(Void ... params) {
            try {
                String line;
                URLConnection urlConnection = this.url.openConnection();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line).append("\n");
                }
                bufferedReader.close();
                return stringBuilder.toString();
            }
            catch (IOException io) {
                io.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(String s) {
            ZMCodeView.this.setSource(s);
        }
    }

    public static interface OnContentChangedListener {
        public void onContentChanged();
    }
}

