/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.fragment.PAttendeeListActionDialog;
import com.zipow.videobox.fragment.PListItemActionDialog;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import com.zipow.videobox.view.WebinarRaiseHandListItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.videomeetings.R;

public class WebinarRaiseHandListView
extends ListView
implements AdapterView.OnItemClickListener {
    private WebinarRaiseHandAdapter mAdapter;

    public WebinarRaiseHandListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public WebinarRaiseHandListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public WebinarRaiseHandListView(Context context) {
        super(context);
        this.initView();
    }

    public int getRaiseHandCount() {
        return this.mAdapter.getRaiseHandCount();
    }

    private void initView() {
        this.mAdapter = new WebinarRaiseHandAdapter(this.getContext());
        if (!this.isInEditMode()) {
            this.loadAllItems(this.mAdapter);
        }
        this.setOnItemClickListener(this);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private void loadAllItems(WebinarRaiseHandAdapter adapter) {
        this.loadAllWebinarPanelistRaiseHand();
        this.loadAllWebinarAttendeeRaiseHand();
    }

    private void loadAllWebinarPanelistRaiseHand() {
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return;
        }
        boolean isInBOMeeting = false;
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr != null) {
            isInBOMeeting = boMgr.isInBOMeeting();
        }
        int count = userList.getUserCount();
        ArrayList<WebinarRaiseHandListItem> webinarRaiseHandListItems = this.mAdapter.getmPanelistItems();
        webinarRaiseHandListItems.clear();
        for (int i = 0; i < count; ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user.isMMRUser() || !isInBOMeeting && user.isInBOMeeting() || !user.getRaiseHandState() || user.isViewOnlyUserCanTalk()) continue;
            webinarRaiseHandListItems.add(new WebinarRaiseHandListItem(user));
        }
        if (!webinarRaiseHandListItems.isEmpty()) {
            Collections.sort(webinarRaiseHandListItems, new WebinarRaiseHandListItem.WebinarAttendeeItemComparator(CompatUtils.getLocalDefault()));
        }
    }

    private void loadAllWebinarAttendeeRaiseHand() {
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar == null) {
            return;
        }
        List<ZoomQABuddy> buddies = raiseHandInWebinar.getRaisedHandAttendees();
        ArrayList<WebinarRaiseHandListItem> webinarRaiseHandListItems = this.mAdapter.getmAttendeeItems();
        webinarRaiseHandListItems.clear();
        if (buddies != null) {
            for (ZoomQABuddy buddy : buddies) {
                webinarRaiseHandListItems.add(new WebinarRaiseHandListItem(buddy));
            }
            if (!webinarRaiseHandListItems.isEmpty()) {
                Collections.sort(webinarRaiseHandListItems, new WebinarRaiseHandListItem.WebinarAttendeeItemComparator(CompatUtils.getLocalDefault()));
            }
        }
    }

    public void reloadAllAttendees() {
        this.loadAllWebinarAttendeeRaiseHand();
        this.mAdapter.notifyDataSetChanged();
    }

    public void reloadAllPanelist() {
        this.loadAllWebinarPanelistRaiseHand();
        this.mAdapter.notifyDataSetChanged();
    }

    public void onConfAllowRaiseHandStatusChanged() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (!ConfLocalHelper.isHostCoHost() || confStatus == null || !confStatus.isAllowRaiseHand()) {
            this.mAdapter.clear();
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.mAdapter.getItem(position);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof WebinarRaiseHandListItem)) {
            return;
        }
        WebinarRaiseHandListItem item = (WebinarRaiseHandListItem)obj;
        int itemType = item.getItemType();
        if (itemType == WebinarRaiseHandListItem.ITEM_TYPE_PANELIST) {
            PListItemActionDialog.show(((ZMActivity)this.getContext()).getSupportFragmentManager(), item.getUserId());
        } else if (itemType == WebinarRaiseHandListItem.ITEM_TYPE_ATTENDEE) {
            ZMActivity activity = (ZMActivity)this.getContext();
            if (activity == null) {
                return;
            }
            if (!ConfLocalHelper.isNeedShowAttendeeActionList()) {
                return;
            }
            ConfChatAttendeeItem confChatAttendeeItem = item.getConfChatAttendeeItem();
            if (confChatAttendeeItem != null) {
                PAttendeeListActionDialog.show(activity.getSupportFragmentManager(), confChatAttendeeItem);
            }
        }
    }

    static class WebinarRaiseHandAdapter
    extends BaseAdapter {
        private final ArrayList<WebinarRaiseHandListItem> mPanelistItems = new ArrayList();
        private final ArrayList<WebinarRaiseHandListItem> mAttendeeItems = new ArrayList();
        private final Context mContext;

        public WebinarRaiseHandAdapter(Context context) {
            this.mContext = context;
        }

        public ArrayList<WebinarRaiseHandListItem> getmAttendeeItems() {
            return this.mAttendeeItems;
        }

        public ArrayList<WebinarRaiseHandListItem> getmPanelistItems() {
            return this.mPanelistItems;
        }

        public void clear() {
            this.mAttendeeItems.clear();
            this.mPanelistItems.clear();
        }

        public int getRaiseHandCount() {
            return this.mPanelistItems.size() + this.mAttendeeItems.size();
        }

        public int getCount() {
            int count = 0;
            if (this.mPanelistItems.size() > 0) {
                count += this.mPanelistItems.size() + 1;
            }
            if (this.mAttendeeItems.size() > 0) {
                count += this.mAttendeeItems.size() + 1;
            }
            return count;
        }

        public Object getItem(int position) {
            int plistCount = this.mPanelistItems.size();
            int attendeeCount = this.mAttendeeItems.size();
            if (position == 0 || this.getCount() == 0 || position >= this.getCount()) {
                return null;
            }
            WebinarRaiseHandListItem item = null;
            if (plistCount > 0 && position < plistCount + 1) {
                item = this.mPanelistItems.get(position - 1);
            } else if (plistCount > 0 && position > plistCount + 1) {
                int index = position - (plistCount + 1) - 1;
                item = this.mAttendeeItems.get(index);
            } else if (plistCount == 0 && position < attendeeCount + 1) {
                item = this.mAttendeeItems.get(position - 1);
            }
            return item;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (this.mPanelistItems.size() > 0 && position == 0) {
                String content = this.mContext.getString(R.string.zm_webinar_txt_panelists, new Object[]{this.mPanelistItems.size()});
                return this.getGroupTitleView(position, convertView, content);
            }
            if (this.mPanelistItems.size() == 0 && position == 0 || this.mPanelistItems.size() > 0 && position == this.mPanelistItems.size() + 1) {
                String content = this.mContext.getString(R.string.zm_webinar_txt_attendees, new Object[]{this.mAttendeeItems.size()});
                return this.getGroupTitleView(position, convertView, content);
            }
            Object obj = this.getItem(position);
            if (obj == null || !(obj instanceof WebinarRaiseHandListItem)) {
                return null;
            }
            return ((WebinarRaiseHandListItem)obj).getView(this.mContext, convertView);
        }

        private View getGroupTitleView(int position, View convertView, String name) {
            View view = convertView;
            if (view == null || !"groupname".equals(view.getTag())) {
                view = View.inflate((Context)this.mContext, (int)R.layout.zm_listview_label_item, null);
                view.setTag((Object)"groupname");
            }
            TextView txtName = (TextView)view.findViewById(R.id.txtHeaderLabel);
            txtName.setText((CharSequence)name);
            return view;
        }
    }
}

