/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.dialog.LeaveAlertDialog;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.util.LazyLoadDrawable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class WaitingRoomView
extends LinearLayout
implements View.OnClickListener {
    private View mBtnLeave = null;
    private TextView mTxtMeetingNumber = null;
    private TextView mTxtMeetingTitle = null;
    private TextView mTxtTopic = null;
    private TextView mTxtDescription = null;
    private ImageView mTopicImage = null;
    private View mTitleBar = null;
    private View mPanelDescriptionView;

    public WaitingRoomView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public WaitingRoomView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        this.inflateLayout();
        this.mPanelDescriptionView = this.findViewById(R.id.panelDescriptionView);
        this.mBtnLeave = this.findViewById(R.id.btnLeave);
        this.mTxtMeetingNumber = (TextView)this.findViewById(R.id.txtMeetingNumber);
        this.mTitleBar = this.findViewById(R.id.vTitleBar);
        this.mTxtMeetingTitle = (TextView)this.findViewById(R.id.txtTitle);
        this.mTopicImage = (ImageView)this.findViewById(R.id.imgTitleIcon);
        this.mTxtTopic = (TextView)this.findViewById(R.id.meetingTopic);
        this.mTxtDescription = (TextView)this.findViewById(R.id.txtDescription);
        this.mBtnLeave.setOnClickListener((View.OnClickListener)this);
        this.updateOrientation(context);
        this.updateData();
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_waiting_room_view, (ViewGroup)this);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.updateOrientation(this.getContext());
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateOrientation(this.getContext());
    }

    private void updateOrientation(Context context) {
        if (context == null) {
            return;
        }
        String description = ConfMgr.getInstance().getWaitingRoomLayoutDescription();
        if (StringUtil.isEmptyOrNull((String)description)) {
            this.mPanelDescriptionView.setPadding(0, 0, 0, UIUtil.dip2px((Context)this.getContext(), (float)60.0f));
        } else if (UIUtil.isPortraitMode((Context)context)) {
            if (!StringUtil.isEmptyOrNull((String)description)) {
                this.mPanelDescriptionView.setPadding(0, 0, 0, UIUtil.dip2px((Context)this.getContext(), (float)20.0f));
            }
        } else {
            this.mPanelDescriptionView.setPadding(0, 0, 0, UIUtil.dip2px((Context)this.getContext(), (float)10.0f));
        }
    }

    public void setTitlePadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        if (this.mTitleBar == null) {
            return;
        }
        this.mTitleBar.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    private void updateDefaultType(@NonNull MeetingInfo meetingInfo) {
        this.mTxtDescription.setVisibility(4);
        this.mTopicImage.setVisibility(8);
        if (this.isInEditMode()) {
            this.mTxtTopic.setText((CharSequence)"In Meeting");
            return;
        }
        if (!ConfMgr.getInstance().isWaitingRoomLayoutReady()) {
            this.mTxtTopic.setVisibility(8);
            this.mTxtMeetingTitle.setVisibility(8);
            return;
        }
        this.mTxtMeetingTitle.setVisibility(0);
        this.mTxtMeetingTitle.setText((CharSequence)this.getResources().getString(R.string.zm_msg_waiting_meeting_nitification));
        String topic = meetingInfo.getTopic();
        if (!StringUtil.isEmptyOrNull((String)topic)) {
            this.mTxtTopic.setVisibility(0);
            this.mTxtTopic.setText((CharSequence)topic);
        } else {
            this.mTxtTopic.setVisibility(8);
        }
    }

    private void updateSimpleType(@NonNull MeetingInfo meetingInfo) {
        this.mTopicImage.setVisibility(8);
        if (this.isInEditMode()) {
            this.mTxtTopic.setText((CharSequence)"In Meeting");
            this.mTxtMeetingTitle.setText((CharSequence)this.getResources().getString(R.string.zm_msg_waiting_meeting_nitification));
            return;
        }
        this.mTxtTopic.setVisibility(0);
        this.mTxtMeetingTitle.setVisibility(0);
        String title = ConfMgr.getInstance().getWaitingRoomLayoutTitle();
        if (!StringUtil.isEmptyOrNull((String)title)) {
            this.mTxtMeetingTitle.setText((CharSequence)title);
        } else {
            this.mTxtMeetingTitle.setText((CharSequence)this.getResources().getString(R.string.zm_msg_waiting_meeting_nitification));
        }
        String description = ConfMgr.getInstance().getWaitingRoomLayoutDescription();
        if (!StringUtil.isEmptyOrNull((String)description)) {
            this.mTxtDescription.setVisibility(0);
            this.mTxtDescription.setText((CharSequence)description);
        } else {
            this.mTxtDescription.setVisibility(4);
        }
        String topic = meetingInfo.getTopic();
        if (!StringUtil.isEmptyOrNull((String)topic)) {
            this.mTxtTopic.setVisibility(0);
            this.mTxtTopic.setText((CharSequence)topic);
        } else {
            this.mTxtTopic.setVisibility(8);
        }
        boolean ready = ConfMgr.getInstance().isWaitingRoomLayoutReady();
        String imagePath = ConfMgr.getInstance().getWaitingRoomLayoutImagePath();
        if (ready && !StringUtil.isEmptyOrNull((String)imagePath)) {
            LazyLoadDrawable drawable2 = new LazyLoadDrawable(imagePath);
            if (drawable2.isValidDrawable()) {
                this.mTopicImage.setVisibility(0);
                this.mTopicImage.setImageDrawable((Drawable)drawable2);
            }
        } else {
            this.mTopicImage.setVisibility(8);
        }
    }

    public void updateData() {
        if (this.isInEditMode()) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null || !confContext.supportPutUserinWaitingListUponEntryFeature()) {
            return;
        }
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        if (meetingInfo == null) {
            return;
        }
        this.mTxtMeetingNumber.setText((CharSequence)StringUtil.formatConfNumber((long)meetingInfo.getMeetingNumber()));
        int type = ConfMgr.getInstance().getWaitingRoomLayoutType();
        if (type == 1) {
            this.updateSimpleType(meetingInfo);
        } else {
            this.updateDefaultType(meetingInfo);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnLeave) {
            this.onClickBtnLeave();
        }
    }

    private void onClickBtnLeave() {
        new LeaveAlertDialog().show(((ZMActivity)this.getContext()).getSupportFragmentManager(), LeaveAlertDialog.class.getName());
    }
}

