/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zipow.nydus.NydusUtil;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.MediaDevice;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.meeting.confhelper.CameraComponent;
import java.util.List;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class VideoTip
extends ZMTipFragment
implements View.OnClickListener {
    public static final String ARG_ANCHOR_ID = "anchorId";
    public static final String ARG_ARROW_DIRECTION = "arrowDirection";
    public static final String ARG_SHOW_NO_CAMERA = "showNoCamera";
    private boolean mbShowNoCamera = true;
    private View mBtnNoCamera;
    private ViewGroup mRootView;

    public static void show(FragmentManager fragmentMgr, int anchorId) {
        VideoTip.show(fragmentMgr, anchorId, 3, true);
    }

    public static void show(FragmentManager fragmentMgr, int anchorId, int arrowDirection, boolean showNoCamera) {
        if (fragmentMgr == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putInt(ARG_ANCHOR_ID, anchorId);
        args.putInt(ARG_ARROW_DIRECTION, arrowDirection);
        args.putBoolean(ARG_SHOW_NO_CAMERA, showNoCamera);
        VideoTip tip = new VideoTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, VideoTip.class.getName());
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        VideoTip tip = (VideoTip)fragmentMgr.findFragmentByTag(VideoTip.class.getName());
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        VideoTip tip = (VideoTip)fragmentMgr.findFragmentByTag(VideoTip.class.getName());
        if (tip != null) {
            tip.dismiss();
            return true;
        }
        return false;
    }

    public static void updateIfExists(FragmentManager fragmentMgr) {
        VideoTip tip = (VideoTip)fragmentMgr.findFragmentByTag(VideoTip.class.getName());
        if (tip != null) {
            tip.updateUI();
        }
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        ViewGroup view = (ViewGroup)layoutInflater.inflate(R.layout.zm_video_tip, null);
        this.mBtnNoCamera = view.findViewById(R.id.btnNoCamera);
        Bundle args = this.getArguments();
        ZMTip tip = new ZMTip(context);
        tip.addView((View)view);
        this.mbShowNoCamera = args.getBoolean(ARG_SHOW_NO_CAMERA, true);
        int anchorId = args.getInt(ARG_ANCHOR_ID, 0);
        int arrowDirection = args.getInt(ARG_ARROW_DIRECTION, 3);
        if (anchorId > 0 && (anchor = this.getActivity().findViewById(anchorId)) != null) {
            tip.setAnchor(anchor, arrowDirection);
        }
        this.mBtnNoCamera.setOnClickListener((View.OnClickListener)this);
        this.mRootView = view;
        return tip;
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
    }

    private void updateUI() {
        View v;
        if (!ConfMgr.getInstance().isConfConnected()) {
            this.dismiss();
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            this.dismiss();
            return;
        }
        CmmVideoStatus videoStatus = myself.getVideoStatusObj();
        if (videoStatus == null) {
            this.dismiss();
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            this.dismiss();
            return;
        }
        if (this.mRootView == null) {
            return;
        }
        for (int i = this.mRootView.getChildCount() - 1; i >= 0; --i) {
            View v2 = this.mRootView.getChildAt(i);
            if (v2 == this.mBtnNoCamera) continue;
            this.mRootView.removeView(v2);
        }
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (inflater != null) {
            String frontCamera = null;
            int frontCamId = NydusUtil.getFrontCameraId();
            if (frontCamId >= 0) {
                frontCamera = String.valueOf(frontCamId);
                TextView textView = (TextView)inflater.inflate(R.layout.zm_video_tip_item, null);
                textView.setText((CharSequence)context.getString(R.string.zm_btn_front_camera));
                textView.setTag((Object)frontCamera);
                this.mRootView.addView((View)textView, this.mRootView.getChildCount() - 1);
                textView.setOnClickListener((View.OnClickListener)this);
            }
            String backCamera = null;
            int backCamId = NydusUtil.getBackCameraId();
            if (backCamId >= 0) {
                backCamera = String.valueOf(backCamId);
                TextView textView = (TextView)inflater.inflate(R.layout.zm_video_tip_item, null);
                textView.setText((CharSequence)context.getString(R.string.zm_btn_back_camera));
                textView.setTag((Object)backCamera);
                this.mRootView.addView((View)textView, this.mRootView.getChildCount() - 1);
                textView.setOnClickListener((View.OnClickListener)this);
            }
            List<MediaDevice> camList = videoMgr.getCamList();
            int countUsbCameras = camList.size() - NydusUtil.getNumberOfCameras();
            int usbCameraIndex = 0;
            for (int i = 0; i < camList.size(); ++i) {
                MediaDevice device = camList.get(i);
                if (device == null || StringUtil.isSameString((String)frontCamera, (String)device.getDeviceId()) || StringUtil.isSameString((String)backCamera, (String)device.getDeviceId())) continue;
                String name = this.buildUsbCameraDisplayName((Context)context, device, countUsbCameras, usbCameraIndex++, camList);
                TextView textView = (TextView)inflater.inflate(R.layout.zm_video_tip_item, null);
                textView.setText((CharSequence)name);
                textView.setTag((Object)device.getDeviceId());
                this.mRootView.addView((View)textView, this.mRootView.getChildCount() - 1);
                textView.setOnClickListener((View.OnClickListener)this);
            }
        }
        boolean isCameraStarted = videoStatus.getIsSending();
        String curCamera = videoMgr.getDefaultDevice();
        for (int i = this.mRootView.getChildCount() - 1; i >= 0; --i) {
            View v3 = this.mRootView.getChildAt(i);
            String tag = (String)v3.getTag();
            if (tag != null) {
                if (isCameraStarted) {
                    if (StringUtil.isSameString((String)tag, (String)curCamera)) {
                        v3.setVisibility(8);
                        continue;
                    }
                    v3.setVisibility(0);
                    continue;
                }
                v3.setVisibility(0);
                continue;
            }
            if (isCameraStarted && this.mbShowNoCamera) {
                v3.setVisibility(0);
                continue;
            }
            v3.setVisibility(8);
        }
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getActivity()) && this.mRootView.getChildCount() > 0 && (v = this.mRootView.getChildAt(0)) != null) {
            v.sendAccessibilityEvent(8);
        }
    }

    public String buildUsbCameraDisplayName(Context context, MediaDevice device, int countUsbCameras, int usbCameraIndex, List<MediaDevice> camList) {
        String deviceName = device.getDeviceName();
        if (!StringUtil.isEmptyOrNull((String)deviceName)) {
            int countSameName = 0;
            int deviceIndex = 0;
            for (MediaDevice cam : camList) {
                if (!deviceName.equals(cam.getDeviceName())) continue;
                if (cam == device) {
                    deviceIndex = countSameName;
                }
                ++countSameName;
            }
            if (countSameName <= 1) {
                return deviceName;
            }
            return deviceName + " (" + (deviceIndex + 1) + ")";
        }
        String name = "";
        name = countUsbCameras > 1 ? context.getString(R.string.zm_btn_usb_camera, new Object[]{String.valueOf(usbCameraIndex + 1)}) : context.getString(R.string.zm_btn_usb_camera, new Object[]{""});
        return name;
    }

    public void onClick(View v) {
        if (v == this.mBtnNoCamera) {
            this.onClickBtnNoCamera();
        } else {
            this.onClickOtherCamera((String)v.getTag());
        }
    }

    private void openCamera(String cameraId) {
        if (StringUtil.isEmptyOrNull((String)cameraId)) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            this.dismiss();
            return;
        }
        CmmVideoStatus videoStatus = myself.getVideoStatusObj();
        if (videoStatus == null) {
            this.dismiss();
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            this.dismiss();
            return;
        }
        ConfActivity activity = (ConfActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        CameraComponent cameraComponent = activity.getmCameraComponent();
        if (cameraComponent == null) {
            return;
        }
        if (videoStatus.getIsSending()) {
            if (!StringUtil.isSameString((String)cameraId, (String)videoMgr.getDefaultDevice())) {
                cameraComponent.switchCamera(cameraId);
            }
        } else {
            cameraComponent.switchCamera(cameraId);
        }
    }

    private void onClickOtherCamera(String cameraId) {
        this.openCamera(cameraId);
        this.dismiss();
    }

    private void onClickBtnNoCamera() {
        ConfActivity activity;
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            this.dismiss();
            return;
        }
        CmmVideoStatus videoStatus = myself.getVideoStatusObj();
        if (videoStatus == null) {
            this.dismiss();
            return;
        }
        if (videoStatus.getIsSending() && (activity = (ConfActivity)this.getActivity()) != null) {
            activity.muteVideo(true);
        }
        this.dismiss();
    }
}

