/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AutoCompleteTextView;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.CmmSavedMeeting;
import com.zipow.videobox.view.ConfNumberMgr;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class VanityUrlAutoCompleteTextView
extends AutoCompleteTextView {
    private AutoCompleteAdapter mAdapter;

    public VanityUrlAutoCompleteTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public VanityUrlAutoCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public VanityUrlAutoCompleteTextView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        ArrayList<CmmSavedMeeting> meetings = new ArrayList<CmmSavedMeeting>();
        if (!this.isInEditMode()) {
            meetings.addAll(ConfNumberMgr.loadVanityUrlFromDB());
        }
        this.mAdapter = new AutoCompleteAdapter(this.getContext(), R.layout.zm_simple_dropdown_item_1line, meetings);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void clearHistory() {
        this.mAdapter = new AutoCompleteAdapter(this.getContext(), R.layout.zm_simple_dropdown_item_1line, new ArrayList<CmmSavedMeeting>());
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private class AutoCompleteAdapter
    extends BaseAdapter
    implements Filterable {
        private ArrayList<CmmSavedMeeting> mOriginalValues;
        private AutoCompleteFilter mFilter;
        private List<CmmSavedMeeting> mValues;
        private Context mContext;
        private LayoutInflater mInflater;
        private int mResource;
        private final Object mLock = new Object();

        public AutoCompleteAdapter(Context context, int resource, List<CmmSavedMeeting> objects) {
            this.init(context, resource, objects);
        }

        private void init(Context context, int resource, List<CmmSavedMeeting> objects) {
            this.mContext = context;
            this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            this.mResource = resource;
            this.mValues = objects;
        }

        public int getCount() {
            return this.mValues.size();
        }

        public String getItem(int position) {
            CmmSavedMeeting item = this.getObjectItem(position);
            if (item == null) {
                return "";
            }
            return item.getmConfID();
        }

        private CmmSavedMeeting getObjectItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            return this.mValues.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView == null ? this.mInflater.inflate(this.mResource, parent, false) : convertView;
            CmmSavedMeeting item = this.getObjectItem(position);
            if (item != null) {
                TextView txtId;
                Editable et = Editable.Factory.getInstance().newEditable((CharSequence)item.getmConfID());
                TextView text = (TextView)view.findViewById(R.id.txtTopic);
                if (text != null) {
                    text.setText((CharSequence)et.toString());
                }
                if ((txtId = (TextView)view.findViewById(R.id.txtId)) != null) {
                    txtId.setVisibility(8);
                }
            }
            return view;
        }

        public Filter getFilter() {
            if (this.mFilter == null) {
                this.mFilter = new AutoCompleteFilter();
            }
            return this.mFilter;
        }

        private class AutoCompleteFilter
        extends Filter {
            private AutoCompleteFilter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Filter.FilterResults performFiltering(CharSequence prefix) {
                Filter.FilterResults results = new Filter.FilterResults();
                if (AutoCompleteAdapter.this.mOriginalValues == null) {
                    Object object = AutoCompleteAdapter.this.mLock;
                    synchronized (object) {
                        AutoCompleteAdapter.this.mOriginalValues = new ArrayList(AutoCompleteAdapter.this.mValues);
                    }
                }
                if (prefix == null || prefix.length() == 0) {
                    ArrayList list;
                    Object object = AutoCompleteAdapter.this.mLock;
                    synchronized (object) {
                        list = new ArrayList(AutoCompleteAdapter.this.mOriginalValues);
                    }
                    results.values = list;
                    results.count = list.size();
                } else {
                    ArrayList values;
                    String prefixString = prefix.toString().toLowerCase(CompatUtils.getLocalDefault());
                    Object object = AutoCompleteAdapter.this.mLock;
                    synchronized (object) {
                        values = new ArrayList(AutoCompleteAdapter.this.mOriginalValues);
                    }
                    int count = values.size();
                    ArrayList<CmmSavedMeeting> newValues = new ArrayList<CmmSavedMeeting>();
                    for (int i = 0; i < count; ++i) {
                        CmmSavedMeeting value = (CmmSavedMeeting)values.get(i);
                        String id2 = value.getmConfID();
                        if (StringUtil.isEmptyOrNull((String)id2) || !id2.toLowerCase(CompatUtils.getLocalDefault()).startsWith(prefixString)) continue;
                        newValues.add(value);
                    }
                    results.values = newValues;
                    results.count = newValues.size();
                }
                return results;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                AutoCompleteAdapter.this.mValues = (List)results.values;
                if (results.count > 0) {
                    AutoCompleteAdapter.this.notifyDataSetChanged();
                } else {
                    AutoCompleteAdapter.this.notifyDataSetInvalidated();
                }
            }
        }
    }
}

