/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.box.BoxMgr;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.meeting.confhelper.ShareComponent;
import com.zipow.videobox.confapp.meeting.confhelper.ShareOptionType;
import com.zipow.videobox.dropbox.ZMDropbox;
import com.zipow.videobox.googledrive.GoogleDrive;
import com.zipow.videobox.googledrive.GoogleDriveMgr;
import com.zipow.videobox.onedrive.OneDriveConfig;
import com.zipow.videobox.onedrive.OneDriveManager;
import com.zipow.videobox.util.IShareCustomScreenHandler;
import com.zipow.videobox.util.UIMgr;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class ShareTip
extends ZMTipFragment {
    public static final String ARG_ANCHOR_ID = "anchorId";
    private static final int REQUEST_CODE_IMAGE = 3001;
    private View shareImage;
    private View shareUrl;
    private View shareBookmark;
    private View shareDropbox;
    private View shareNativeFile;
    private View shareScreen;
    private View shareBox;
    private View shareGoogleDrive;
    private View shareWhileboard;
    private View shareOneDrive;
    private View shareOneDriveBusiness;

    public static void show(FragmentManager fragmentMgr, int anchorId) {
        if (fragmentMgr == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putInt(ARG_ANCHOR_ID, anchorId);
        ShareTip sharpTip = new ShareTip();
        sharpTip.setArguments(args);
        sharpTip.show(fragmentMgr, ShareTip.class.getName());
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        ShareTip tip = (ShareTip)fragmentMgr.findFragmentByTag(ShareTip.class.getName());
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        ShareTip tip = (ShareTip)fragmentMgr.findFragmentByTag(ShareTip.class.getName());
        if (tip != null) {
            tip.dismiss();
            return true;
        }
        return false;
    }

    public void onResume() {
        super.onResume();
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getActivity())) {
            this.shareImage.sendAccessibilityEvent(8);
        }
    }

    private void selectShareType(ShareOptionType type) {
        ShareComponent shareComponent;
        ConfActivity activity = (ConfActivity)this.getActivity();
        if (activity != null && (shareComponent = activity.getmShareComponent()) != null) {
            shareComponent.selectShareType(type);
        }
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        ConfActivity activity;
        ZMTip tip = new ZMTip(context);
        View view = layoutInflater.inflate(R.layout.zm_share_tip, (ViewGroup)tip, false);
        LinearLayout shareItemContainer = (LinearLayout)view.findViewById(R.id.shareItemContainer);
        this.shareImage = view.findViewById(R.id.share_image);
        this.shareDropbox = view.findViewById(R.id.share_dropbox);
        this.shareUrl = view.findViewById(R.id.share_url);
        this.shareBookmark = view.findViewById(R.id.share_from_bookmark);
        this.shareNativeFile = view.findViewById(R.id.share_native_file);
        this.shareScreen = view.findViewById(R.id.share_screen);
        this.shareOneDrive = view.findViewById(R.id.share_one_drive);
        this.shareOneDriveBusiness = view.findViewById(R.id.share_one_drive_business);
        this.shareBox = view.findViewById(R.id.share_box);
        this.shareGoogleDrive = view.findViewById(R.id.share_google_drive);
        this.shareWhileboard = view.findViewById(R.id.share_whiteboard);
        this.shareWhileboard.setVisibility(0);
        String handlerClass = ResourcesUtil.getString((Context)context, (int)R.string.zm_config_share_custom_screen_handler);
        if (!StringUtil.isEmptyOrNull((String)handlerClass)) {
            String name = "";
            try {
                Class<?> clazz = Class.forName(handlerClass);
                IShareCustomScreenHandler handler = (IShareCustomScreenHandler)clazz.newInstance();
                name = handler.getShareCustomScreenName((Context)VideoBoxApplication.getInstance());
            }
            catch (Exception clazz) {
                // empty catch block
            }
            View customView = layoutInflater.inflate(R.layout.zm_share_custom_tip_item, null, false);
            TextView shareCustom = (TextView)customView.findViewById(R.id.share_custom);
            shareCustom.setText((CharSequence)name);
            shareCustom.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ShareTip.this.selectShareType(ShareOptionType.SHARE_CUSTOM_SCREEN);
                }
            });
            shareItemContainer.addView(customView);
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmConfContext confContext = null;
        if (confMgr != null) {
            confContext = confMgr.getConfContext();
        }
        if (confContext != null && confContext.isShareDropBoxOFF() || !ZMDropbox.isDropboxLoginSupported(context) || ZMDropbox.getAppKeyPair((Context)this.getActivity()) == null) {
            this.shareDropbox.setVisibility(8);
        }
        if (confContext != null && confContext.isShareOneDriveOFF()) {
            this.shareOneDriveBusiness.setVisibility(8);
            this.shareOneDrive.setVisibility(8);
        } else {
            if (!OneDriveManager.isLoginSupported(context, false) || StringUtil.isEmptyOrNull((String)OneDriveConfig.getClientID(context))) {
                this.shareOneDrive.setVisibility(8);
            }
            if (!OneDriveManager.isLoginSupported(context, true) || StringUtil.isEmptyOrNull((String)OneDriveConfig.getBusinessClientID(context))) {
                this.shareOneDriveBusiness.setVisibility(8);
            }
        }
        if (confContext != null && confContext.isShareBoxComOFF() || StringUtil.isEmptyOrNull((String)BoxMgr.getAppKey(context)) || StringUtil.isEmptyOrNull((String)BoxMgr.getAppSecret(context))) {
            this.shareBox.setVisibility(8);
        }
        if (confContext != null && confContext.isShareGoogleDriveOFF() || !GoogleDrive.canAuthGoogleViaBrowser(context) || StringUtil.isEmptyOrNull((String)GoogleDriveMgr.getClientID(context)) || StringUtil.isEmptyOrNull((String)GoogleDriveMgr.getRedirectURL(context))) {
            this.shareGoogleDrive.setVisibility(8);
        }
        this.shareImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                if (ShareTip.this.checkStoragePermission()) {
                    ShareTip.this.selectShareType(ShareOptionType.SHARE_IMAGE);
                } else {
                    ShareTip.this.requestStoragePermission(3001);
                }
            }
        });
        this.shareBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                ShareTip.this.selectShareType(ShareOptionType.SHARE_BOX);
            }
        });
        this.shareDropbox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                ShareTip.this.selectShareType(ShareOptionType.SHARE_DROPBOX);
            }
        });
        if (ResourcesUtil.getBoolean((Context)context, (int)R.bool.zm_config_no_share_webview, (boolean)false)) {
            this.shareUrl.setVisibility(8);
            this.shareBookmark.setVisibility(8);
        } else {
            this.shareUrl.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    ShareTip.this.selectShareType(ShareOptionType.SHARE_URL);
                }
            });
            this.shareBookmark.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    ShareTip.this.selectShareType(ShareOptionType.SHARE_BOOKMARK);
                }
            });
        }
        this.shareNativeFile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareTip.this.selectShareType(ShareOptionType.SHARE_NATIVE_FILE);
            }
        });
        this.shareOneDrive.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareTip.this.selectShareType(ShareOptionType.SHARE_ONE_DRIVE);
            }
        });
        this.shareOneDriveBusiness.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareTip.this.selectShareType(ShareOptionType.SHARE_ONE_DRIVE_BUSINESS);
            }
        });
        this.shareScreen.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareTip.this.selectShareType(ShareOptionType.SHARE_SCREEN);
            }
        });
        this.shareGoogleDrive.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareTip.this.selectShareType(ShareOptionType.SHARE_GOOGLE_DRIVE);
            }
        });
        this.shareWhileboard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareTip.this.selectShareType(ShareOptionType.SHARE_WHITEBOARD);
            }
        });
        tip.addView(view);
        Bundle args = this.getArguments();
        int anchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (anchorId > 0 && (activity = (ConfActivity)this.getActivity()) != null && (anchor = activity.findViewById(anchorId)) != null) {
            tip.setAnchor(anchor, UIMgr.isLargeMode((Context)this.getActivity()) ? 1 : 3);
        }
        if (!AndroidAppUtil.hasActiviyToSelectImage((Context)context)) {
            this.shareImage.setVisibility(8);
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.shareScreen.setVisibility(8);
        } else {
            MediaProjectionManager mgr = (MediaProjectionManager)context.getSystemService("media_projection");
            Intent intent = null;
            if (mgr != null) {
                intent = mgr.createScreenCaptureIntent();
            }
            if (intent == null || !AndroidAppUtil.hasActivityForIntent((Context)context, (Intent)intent)) {
                this.shareScreen.setVisibility(8);
            }
        }
        return tip;
    }

    private boolean checkStoragePermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0;
    }

    @TargetApi(value=16)
    private void requestStoragePermission(int requestCode) {
        this.zm_requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, requestCode);
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("ShareTipPermissionResult", new EventAction("ShareTipPermissionResult"){

            public void run(IUIElement ui) {
                ((ShareTip)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    protected void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.READ_EXTERNAL_STORAGE".equals(permissions[i])) continue;
            if (grantResults[i] != 0) {
                this.dismiss();
                return;
            }
            if (requestCode != 3001) continue;
            this.selectShareType(ShareOptionType.SHARE_IMAGE);
        }
    }
}

