/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.ScheduledMeetingsListView;
import us.zoom.androidlib.widget.PullDownRefreshListView;
import us.zoom.videomeetings.R;

public class ScheduledMeetingsView
extends LinearLayout
implements PTUI.IMeetingMgrListener,
PullDownRefreshListView.PullDownRefreshListener {
    private ScheduledMeetingsListView mMeetingsListView;
    private View mPanelNoItemMsg;

    public ScheduledMeetingsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ScheduledMeetingsView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_scheduled_meetings, (ViewGroup)this);
        this.mMeetingsListView = (ScheduledMeetingsListView)this.findViewById(R.id.meetingsListView);
        this.mPanelNoItemMsg = this.findViewById(R.id.panelNoItemMsg);
        this.mMeetingsListView.setPullDownRefreshListener(this);
        if (!this.isInEditMode()) {
            this.updateLoading();
            this.updateNoItemMsg();
        }
    }

    public void onResume() {
        this.mMeetingsListView.loadMeetingList(true, true);
        PTUI.getInstance().addMeetingMgrListener(this);
        this.updateLoading();
        this.updateNoItemMsg();
    }

    private void updateLoading() {
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper == null) {
            return;
        }
        helper.checkIfNeedToListUpcomingMeeting();
        this.showLoading(helper.isLoadingMeetingList());
    }

    private void updateNoItemMsg() {
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper == null) {
            return;
        }
        if (this.mMeetingsListView.isEmpty()) {
            if (helper.isLoadingMeetingList()) {
                this.mPanelNoItemMsg.setVisibility(8);
            } else {
                this.mPanelNoItemMsg.setVisibility(0);
            }
        } else {
            this.mPanelNoItemMsg.setVisibility(8);
        }
    }

    public void onStop() {
        this.mMeetingsListView.onStop();
        PTUI.getInstance().removeMeetingMgrListener(this);
    }

    private void showLoading(boolean show) {
        this.mMeetingsListView.showRefreshing(show);
    }

    private void onRefreshingDone() {
        this.mMeetingsListView.notifyRefreshDone();
    }

    public void onPullDownRefresh() {
        this.refresh();
    }

    public boolean isRefreshing() {
        return this.mMeetingsListView.isRefreshing();
    }

    public void refresh() {
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper == null) {
            return;
        }
        PTApp.getInstance().getCalendarIntegrationConfig();
        helper.listMeetingUpcoming();
        this.updateLoading();
        this.updateNoItemMsg();
    }

    @Override
    public void onScheduleMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
    }

    @Override
    public void onListMeetingResult(int result) {
        if (!ZmPtUtils.isCalendarServiceReady()) {
            this.onRefreshingDone();
        } else {
            MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
            if (helper == null) {
                this.onRefreshingDone();
            } else if (!helper.listCalendarEvents()) {
                this.onRefreshingDone();
            }
        }
        this.mMeetingsListView.loadMeetingList(true, false);
        this.updateNoItemMsg();
    }

    @Override
    public void onListCalendarEventsResult(int result) {
        this.onRefreshingDone();
        this.mMeetingsListView.loadMeetingList(true, true);
        this.updateNoItemMsg();
    }

    @Override
    public void onUpdateMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
    }

    @Override
    public void onDeleteMeetingResult(int result) {
    }

    @Override
    public void onStartFailBeforeLaunch(int result) {
    }

    @Override
    public void onPMIEvent(int event, int result, MeetingInfo item) {
    }

    public void onCallStatusChanged(long result) {
        if (this.mMeetingsListView != null) {
            this.mMeetingsListView.onCallStatusChanged(result);
        }
    }

    public void refreshCalenderIntegeration() {
        if (this.mMeetingsListView != null) {
            this.mMeetingsListView.loadMeetingList(true, true);
        }
    }
}

