/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.zipow.videobox.MeetingInfoActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.PMIEditFragment;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.ScheduledMeetingItem;
import com.zipow.videobox.view.ScheduledMeetingsListAdapter;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.PullDownRefreshListView;
import us.zoom.videomeetings.R;

public class ScheduledMeetingsListView
extends PullDownRefreshListView
implements AdapterView.OnItemClickListener {
    private static final String TAG = ScheduledMeetingsListView.class.getSimpleName();
    private ScheduledMeetingsListAdapter mAdapter;

    public ScheduledMeetingsListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public ScheduledMeetingsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ScheduledMeetingsListView(Context context) {
        super(context);
        this.initView();
    }

    public boolean isEmpty() {
        if (this.mAdapter == null) {
            return true;
        }
        return this.mAdapter.isEmpty();
    }

    private void initView() {
        this.mAdapter = new ScheduledMeetingsListAdapter(this.getContext());
        if (this.isInEditMode()) {
            this._editmode_loadAllItems(this.mAdapter);
        } else {
            this.loadMeetingList(true, true);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
    }

    private void _editmode_loadAllItems(ScheduledMeetingsListAdapter adapter) {
        for (int i = 0; i < 10; ++i) {
            ScheduledMeetingItem item = new ScheduledMeetingItem();
            item.setTopic("My Meeting " + (i + 1));
            item.setMeetingNo(100000001 + i);
            item.setMeetingType(i % 3 == 0 ? MeetingInfo.MeetingType.REPEAT : MeetingInfo.MeetingType.SCHEDULE);
            adapter.addItem(item);
        }
    }

    public void loadMeetingList(boolean isLoadCloudMeetings, boolean isLoadCalendarMeetings) {
        this.mAdapter.clear();
        if (isLoadCloudMeetings) {
            this.loadZoomCloudMeetings();
        }
        if (isLoadCalendarMeetings && ZmPtUtils.isCalendarServiceReady()) {
            this.loadCalendarMeetings();
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void loadZoomCloudMeetings() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return;
        }
        int cnt = meetingHelper.getMeetingCount();
        for (int i = 0; i < cnt; ++i) {
            MeetingInfo mi = meetingHelper.getMeetingItemByIndex(i);
            ScheduledMeetingItem item = ScheduledMeetingItem.fromMeetingInfo(mi);
            this.mAdapter.addItem(item);
            if (i != 0 || ZmPtUtils.isShouldHideAddCalendar()) continue;
            item = ScheduledMeetingItem.createAddCalendarItem();
            this.mAdapter.addItem(item);
        }
    }

    private void loadCalendarMeetings() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return;
        }
        List<ScheduledMeetingItem> itemList = ZmPtUtils.getMeetingListFromCalEvents(meetingHelper.getCalendarEvents());
        if (CollectionsUtil.isListEmpty(itemList)) {
            return;
        }
        for (ScheduledMeetingItem item : itemList) {
            this.mAdapter.addItem(item);
        }
        this.mAdapter.sort();
    }

    public void onStop() {
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        Object obj = this.getItemAtPosition(position);
        if (!(obj instanceof ScheduledMeetingItem)) {
            return;
        }
        ScheduledMeetingItem item = (ScheduledMeetingItem)obj;
        if (item.getExtendMeetingType() == 1) {
            SimpleActivity.show(activity, PMIEditFragment.class.getName(), null, 0, true);
        } else if (item.getExtendMeetingType() == -999) {
            PTUserProfile ptUserProfile = PTApp.getInstance().getCurrentUserProfile();
            if (ptUserProfile != null && !StringUtil.isEmptyOrNull((String)ptUserProfile.getCalendarUrl())) {
                UIUtil.openURL((Context)this.getContext(), (String)ptUserProfile.getCalendarUrl());
            }
        } else {
            MeetingInfoActivity.show(activity, item, R.string.zm_title_mymeetings_21854, false, 104);
        }
    }

    public void onCallStatusChanged(long result) {
        this.loadMeetingList(true, true);
    }
}

