/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import us.zoom.androidlib.util.CollectionsUtil;

public class ScheduledMeetingsListAdapter
extends BaseAdapter {
    private static final int ITEM_TYPE_NORMAL = 0;
    private static final int ITEM_TYPE_PMI = 1;
    private ArrayList<ScheduledMeetingItem> mItems = new ArrayList();
    private Context mContext;

    public ScheduledMeetingsListAdapter(Context context) {
        this.mContext = context;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void addItem(ScheduledMeetingItem item) {
        assert (item != null);
        if (this.mItems.indexOf(item) == -1) {
            this.mItems.add(item);
        }
    }

    public void sort() {
        if (!CollectionsUtil.isListEmpty(this.mItems)) {
            Collections.sort(this.mItems, new Comparator<ScheduledMeetingItem>(){

                @Override
                public int compare(ScheduledMeetingItem o1, ScheduledMeetingItem o2) {
                    int extendMeetType1 = o1.getExtendMeetingType();
                    if (extendMeetType1 == 1) {
                        return -1;
                    }
                    int extendMeetType2 = o2.getExtendMeetingType();
                    if (extendMeetType2 == 1) {
                        return 1;
                    }
                    if (extendMeetType1 == -999) {
                        return -1;
                    }
                    if (extendMeetType2 == -999) {
                        return 1;
                    }
                    boolean isRecurring1 = o1.isRecurring();
                    boolean isRecurring2 = o2.isRecurring();
                    if (isRecurring1 && !isRecurring2) {
                        return 1;
                    }
                    if (!isRecurring1 && isRecurring2) {
                        return -1;
                    }
                    if (isRecurring1 && isRecurring2) {
                        return 0;
                    }
                    long delta = o1.getStartTime() - o2.getStartTime();
                    if (delta == 0L) {
                        return 0;
                    }
                    if (delta > 0L) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
    }

    public int findItem(long meetingNo) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ScheduledMeetingItem item = this.mItems.get(i);
            if (meetingNo != item.getMeetingNo()) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(long meetingNo) {
        int position = this.findItem(meetingNo);
        if (position >= 0) {
            this.removeItemAt(position);
        }
    }

    public void removeItemAt(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        ScheduledMeetingItem item = (ScheduledMeetingItem)this.getItem(position);
        return item != null ? item.getMeetingNo() : 0L;
    }

    public int getItemViewType(int position) {
        ScheduledMeetingItem item = (ScheduledMeetingItem)this.getItem(position);
        if (item != null && item.getExtendMeetingType() == 1) {
            return 1;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ScheduledMeetingItem item = (ScheduledMeetingItem)this.getItem(position);
        if (item == null) {
            return null;
        }
        return item.getView(this.mContext, convertView);
    }
}

