/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.PMIEditFragment;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.util.MeetingInvitationUtil;
import com.zipow.videobox.util.TimeFormatUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.TimeZone;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMSendMessageFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.template.Template;
import us.zoom.videomeetings.R;

public class ScheduledMeetingItem
implements Serializable,
View.OnClickListener {
    private static final long serialVersionUID = 1L;
    public static final int ExtendMeetingType_NONE = -999;
    private String mTopic;
    private long mStartTime;
    private long mMeetingNo;
    private int mDuration;
    private String mPassword;
    private MeetingInfo.MeetingType mMeetingType = MeetingInfo.MeetingType.SCHEDULE;
    private String mId;
    private int mMeetingStatus;
    private String mInvitationEmailContent;
    private String mInvitationEmailContentWithTime;
    private boolean mCanJoinBeforeHost;
    private int mRepeatType = 0;
    private long mRepeatEndTime;
    private String mJoinMeetingUrl = null;
    private String mCallInNumber = null;
    private String mH323Gateway = null;
    private boolean mPSTNEnabled = false;
    private String mHostName = null;
    private String mHostId = null;
    private String mHostEmail = null;
    private boolean mIsShareOnlyMeeting = false;
    private int mExtendMeetingType = 0;
    private boolean mHostVideoOff;
    private boolean mAttendeeVideoOff;
    private boolean mVoipOff;
    private boolean mTelephonyOff;
    private String mOtherTeleConfInfo;
    private boolean mSelfTelephoneOn;
    private boolean mUsePmiAsMeetingID;
    private long mOriginalMeetingNo;
    private boolean mIsCNMeetingOn;
    private String mTimeZoneId;
    private boolean mOnlySpecifiedDomainsJoin;
    private boolean mOnlySignJoin;
    private String mSpecialDomains;
    private boolean mIsCanStartMeetingForMySelf = true;

    public static int nativeRepeatTypeToZoomRepeatType(AndroidAppUtil.EventRepeatType repeatType) {
        switch (repeatType) {
            case DAILY: 
            case WORKDAY: {
                return 1;
            }
            case WEEKLY: {
                return 2;
            }
            case BIWEEKLY: {
                return 3;
            }
            case MONTHLY: {
                return 4;
            }
            case YEARLY: {
                return 5;
            }
        }
        return 0;
    }

    public static AndroidAppUtil.EventRepeatType zoomRepeatTypeToNativeRepeatType(int repeatType) {
        switch (repeatType) {
            case 1: {
                return AndroidAppUtil.EventRepeatType.DAILY;
            }
            case 2: {
                return AndroidAppUtil.EventRepeatType.WEEKLY;
            }
            case 3: {
                return AndroidAppUtil.EventRepeatType.BIWEEKLY;
            }
            case 4: {
                return AndroidAppUtil.EventRepeatType.MONTHLY;
            }
            case 5: {
                return AndroidAppUtil.EventRepeatType.YEARLY;
            }
        }
        return AndroidAppUtil.EventRepeatType.NONE;
    }

    public static ScheduledMeetingItem createAddCalendarItem() {
        ScheduledMeetingItem item = new ScheduledMeetingItem();
        item.setExtendMeetingType(-999);
        return item;
    }

    public static ScheduledMeetingItem fromMeetingInfo(MeetingInfo info) {
        ScheduledMeetingItem item = new ScheduledMeetingItem();
        item.setTopic(info.getTopic());
        item.setStartTime(info.getStartTime() * 1000L);
        item.setDuration(info.getDuration());
        item.setMeetingType(info.getType());
        item.setMeetingNo(info.getMeetingNumber());
        item.setPassword(info.getPassword());
        item.setId(info.getId());
        item.setMeetingStatus(info.getMeetingStatus());
        item.setInvitationEmailContent(info.getInviteEmailContent());
        item.setInvitationEmailContentWithTime(info.getInviteEmailContentWithTime());
        item.setCanJoinBeforeHost(info.getCanJoinBeforeHost());
        item.setRepeatType(info.getRepeatType());
        item.setRepeatEndTime(info.getRepeatEndTime() * 1000L);
        item.setJoinMeetingUrl(info.getJoinMeetingUrl());
        item.setCallInNumber(info.getCallinNumber());
        item.setPSTNEnabled(info.getPSTNEnabled());
        item.setH323Gateway(info.getH323Gateway());
        item.setHostId(info.getMeetingHostID());
        item.setHostName(info.getMeetingHostName());
        item.setHostEmail(info.getMeetingHostEmail());
        item.setIsShareOnlyMeeting(info.getIsShareOnlyMeeting());
        item.setExtendMeetingType(info.getExtendMeetingType());
        item.setHostVideoOff(info.getHostVideoOff());
        item.setAttendeeVideoOff(info.getAttendeeVideoOff());
        item.setVoipOff(info.getVoipOff());
        item.setTelephonyOff(info.getTelephonyOff());
        item.setOtherTeleConfInfo(info.getOtherTeleConfInfo());
        item.setSelfTelephoneOn(info.getIsSelfTelephonyOn());
        item.setUsePmiAsMeetingID(info.getUsePmiAsMeetingID());
        item.setOriginalMeetingNo(info.getOriginalMeetingNumber());
        item.setCNMeetingOn(info.getIsCnMeeting());
        item.setTimeZoneId(info.getTimeZoneId());
        item.setOnlySignJoin(info.getIsOnlySignJoin());
        item.setOnlySpecifiedDomainsJoin(info.getIsOnlySpecifiedDomainsJoin());
        item.setSpecialDomains(info.getSpecialDomains());
        return item;
    }

    public static ScheduledMeetingItem fromGoogCalendarEvent(PTAppProtos.GoogCalendarEvent event, boolean canStartMeeting) {
        ScheduledMeetingItem item = new ScheduledMeetingItem();
        item.setmIsCanStartMeetingForMySelf(canStartMeeting);
        item.setTopic(event.getSummary());
        item.setJoinMeetingUrl(event.getLocation());
        long startTime = TimeUtil.stringToMilliseconds((String)event.getStartTime(), (String)"yyyy-MM-dd'T'HH:mm:ssZ");
        long endTime = TimeUtil.stringToMilliseconds((String)event.getEndTime(), (String)"yyyy-MM-dd'T'HH:mm:ssZ");
        if (startTime > 0L && endTime > 0L) {
            item.setStartTime(startTime);
            item.setDuration((int)((endTime - startTime) / 60000L));
        }
        item.setMeetingNo(event.getMeetNo());
        return item;
    }

    public MeetingInfo toMeetingInfo() {
        MeetingInfo meetingInfo = new MeetingInfo();
        meetingInfo.setTopic(this.getTopic());
        meetingInfo.setStartTime(this.getStartTime() / 1000L);
        meetingInfo.setDuration(this.getDuration());
        meetingInfo.setType(this.getMeetingType());
        meetingInfo.setMeetingNumber(this.getMeetingNo());
        meetingInfo.setPassword(this.getPassword());
        meetingInfo.setId(this.getId());
        meetingInfo.setMeetingStatus(this.getMeetingStatus());
        meetingInfo.setInviteEmailContent(this.getInvitationEmailContent());
        meetingInfo.setInviteEmailContentWithTime(this.getInvitationEmailContentWithTime());
        meetingInfo.setCanJoinBeforeHost(this.getCanJoinBeforeHost());
        meetingInfo.setRepeatType(this.getRepeatType());
        meetingInfo.setRepeatEndTime(this.getRepeatEndTime() / 1000L);
        meetingInfo.setJoinMeetingUrl(this.getJoinMeetingUrl());
        meetingInfo.setCallinNumber(this.getCallInNumber());
        meetingInfo.setPSTNEnabled(this.isPSTNEnabled());
        meetingInfo.setH323Gateway(this.getH323Gateway());
        meetingInfo.setMeetingHostID(this.getHostId());
        meetingInfo.setMeetingHostName(this.getHostName());
        meetingInfo.setMeetingHostEmail(this.getHostEmail());
        meetingInfo.setExtendMeetingType(this.getExtendMeetingType());
        meetingInfo.setHostVideoOff(this.isHostVideoOff());
        meetingInfo.setAttendeeVideoOff(this.isAttendeeVideoOff());
        meetingInfo.setVoipOff(this.isVoipOff());
        meetingInfo.setTelephonyOff(this.isTelephonyOff());
        meetingInfo.setOtherTeleConfInfo(this.getOtherTeleConfInfo());
        meetingInfo.setIsSelfTelephonyOn(this.isSelfTelephoneOn());
        meetingInfo.setUsePmiAsMeetingID(this.isUsePmiAsMeetingID());
        meetingInfo.setOriginalMeetingNumber(this.getOriginalMeetingNo());
        meetingInfo.setIsOnlySignJoin(this.isOnlySignJoin());
        meetingInfo.setIsOnlySpecifiedDomainsJoin(this.isOnlySpecifiedDomainsJoin());
        meetingInfo.setSpecialDomains(this.getSpecialDomains());
        return meetingInfo;
    }

    public String getTopic() {
        return this.mTopic;
    }

    public void setTopic(String topic) {
        this.mTopic = topic;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(long time) {
        this.mStartTime = time;
    }

    public long getMeetingNo() {
        return this.mMeetingNo;
    }

    public void setMeetingNo(long meetingNo) {
        this.mMeetingNo = meetingNo;
    }

    public boolean isRecurring() {
        return this.mMeetingType == MeetingInfo.MeetingType.REPEAT;
    }

    public MeetingInfo.MeetingType getMeetingType() {
        return this.mMeetingType;
    }

    public void setMeetingType(MeetingInfo.MeetingType type) {
        this.mMeetingType = type;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public boolean hasPassword() {
        return !StringUtil.isEmptyOrNull((String)this.getPassword());
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id2) {
        this.mId = id2;
    }

    public int getMeetingStatus() {
        return this.mMeetingStatus;
    }

    public void setMeetingStatus(int status) {
        this.mMeetingStatus = status;
    }

    public String getInvitationEmailContent() {
        return this.mInvitationEmailContent;
    }

    public String getInvitationEmailContentWithTime() {
        return this.mInvitationEmailContentWithTime;
    }

    public void setInvitationEmailContent(String invitationEmailContent) {
        this.mInvitationEmailContent = invitationEmailContent;
    }

    public void setInvitationEmailContentWithTime(String invitationEmailContentWithTime) {
        this.mInvitationEmailContentWithTime = invitationEmailContentWithTime;
    }

    public boolean getCanJoinBeforeHost() {
        return this.mCanJoinBeforeHost;
    }

    public void setCanJoinBeforeHost(boolean canJoinBeforeHost) {
        this.mCanJoinBeforeHost = canJoinBeforeHost;
    }

    public void setRepeatType(int type) {
        this.mRepeatType = type;
    }

    public int getRepeatType() {
        return this.mRepeatType;
    }

    public void setRepeatEndTime(long repeatEndTime) {
        this.mRepeatEndTime = repeatEndTime;
    }

    public long getRepeatEndTime() {
        return this.mRepeatEndTime;
    }

    public String getJoinMeetingUrl() {
        return this.mJoinMeetingUrl;
    }

    public void setJoinMeetingUrl(String joinMeetingUrl) {
        this.mJoinMeetingUrl = joinMeetingUrl;
    }

    public String getCallInNumber() {
        return this.mCallInNumber;
    }

    public void setCallInNumber(String mCallInNumber) {
        this.mCallInNumber = mCallInNumber;
    }

    public String getH323Gateway() {
        return this.mH323Gateway;
    }

    public String[] getH323Gateways() {
        if (StringUtil.isEmptyOrNull((String)this.mH323Gateway)) {
            return null;
        }
        String[] items = this.mH323Gateway.split(";");
        return items;
    }

    public void setH323Gateway(String mH323Gateway) {
        this.mH323Gateway = mH323Gateway;
    }

    public boolean isPSTNEnabled() {
        return this.mPSTNEnabled;
    }

    public void setPSTNEnabled(boolean mPSTNEnabled) {
        this.mPSTNEnabled = mPSTNEnabled;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setHostName(String hostName) {
        this.mHostName = hostName;
    }

    public String getHostId() {
        return this.mHostId;
    }

    public void setHostId(String hostId) {
        this.mHostId = hostId;
    }

    public String getHostEmail() {
        return this.mHostEmail;
    }

    public void setHostEmail(String hostEmail) {
        this.mHostEmail = hostEmail;
    }

    public boolean isShareOnlyMeeting() {
        return this.mIsShareOnlyMeeting;
    }

    public void setIsShareOnlyMeeting(boolean isShareOnlyMeeting) {
        this.mIsShareOnlyMeeting = isShareOnlyMeeting;
    }

    public int getExtendMeetingType() {
        return this.mExtendMeetingType;
    }

    public void setExtendMeetingType(int extendMeetingType) {
        this.mExtendMeetingType = extendMeetingType;
    }

    public boolean isHostVideoOff() {
        return this.mHostVideoOff;
    }

    public void setHostVideoOff(boolean hostVideoOff) {
        this.mHostVideoOff = hostVideoOff;
    }

    public boolean isAttendeeVideoOff() {
        return this.mAttendeeVideoOff;
    }

    public void setAttendeeVideoOff(boolean attendeeVideoOff) {
        this.mAttendeeVideoOff = attendeeVideoOff;
    }

    public boolean isVoipOff() {
        return this.mVoipOff;
    }

    public void setVoipOff(boolean voipOff) {
        this.mVoipOff = voipOff;
    }

    public boolean isTelephonyOff() {
        return this.mTelephonyOff;
    }

    public void setTelephonyOff(boolean telephonyOff) {
        this.mTelephonyOff = telephonyOff;
    }

    public String getOtherTeleConfInfo() {
        return this.mOtherTeleConfInfo;
    }

    public void setOtherTeleConfInfo(String info) {
        this.mOtherTeleConfInfo = info;
    }

    public boolean isSelfTelephoneOn() {
        return this.mSelfTelephoneOn;
    }

    public void setSelfTelephoneOn(boolean selfTelephoneOn) {
        this.mSelfTelephoneOn = selfTelephoneOn;
    }

    public boolean isUsePmiAsMeetingID() {
        return this.mUsePmiAsMeetingID;
    }

    public void setUsePmiAsMeetingID(boolean usePmiAsMeetingID) {
        this.mUsePmiAsMeetingID = usePmiAsMeetingID;
    }

    public long getOriginalMeetingNo() {
        return this.mOriginalMeetingNo;
    }

    public void setOriginalMeetingNo(long originalMeetingNo) {
        this.mOriginalMeetingNo = originalMeetingNo;
    }

    public boolean isCnMeetingOn() {
        return this.mIsCNMeetingOn;
    }

    public void setCNMeetingOn(boolean cnMeetingOn) {
        this.mIsCNMeetingOn = cnMeetingOn;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.mTimeZoneId = timeZoneId;
    }

    public String getTimeZoneId() {
        return this.mTimeZoneId;
    }

    public boolean isOnlySpecifiedDomainsJoin() {
        return this.mOnlySpecifiedDomainsJoin;
    }

    public void setOnlySpecifiedDomainsJoin(boolean onlySpecifiedDomainsJoin) {
        this.mOnlySpecifiedDomainsJoin = onlySpecifiedDomainsJoin;
    }

    public boolean isOnlySignJoin() {
        return this.mOnlySignJoin;
    }

    public void setOnlySignJoin(boolean onlySignJoin) {
        this.mOnlySignJoin = onlySignJoin;
    }

    public String getSpecialDomains() {
        return this.mSpecialDomains;
    }

    public boolean ismIsCanStartMeetingForMySelf() {
        return this.mIsCanStartMeetingForMySelf;
    }

    public void setmIsCanStartMeetingForMySelf(boolean mIsCanStartMeetingForMySelf) {
        this.mIsCanStartMeetingForMySelf = mIsCanStartMeetingForMySelf;
    }

    public void setSpecialDomains(String specialDomains) {
        this.mSpecialDomains = specialDomains;
    }

    public View getView(Context context, View convertView) {
        View view = convertView;
        if (this.mExtendMeetingType == 1) {
            if (view == null || !"pmi".equals(view.getTag())) {
                view = View.inflate((Context)context, (int)R.layout.zm_scheduled_meeting_item_pmi, null);
                view.setTag((Object)"pmi");
            }
            this.bindViewPMI(context, view);
        } else if (this.mExtendMeetingType == -999) {
            if (view == null || !"meetingActionItem".equals(view.getTag())) {
                view = View.inflate((Context)context, (int)R.layout.zm_schedule_meeting_add_calendar_item, null);
                view.setTag((Object)"meetingActionItem");
            }
        } else {
            if (view == null || !"meetingItem".equals(view.getTag())) {
                view = View.inflate((Context)context, (int)R.layout.zm_scheduled_meeting_item, null);
                view.setTag((Object)"meetingItem");
            }
            this.bindView(context, view);
        }
        return view;
    }

    private void bindView(Context context, View view) {
        TextView txtTopic = (TextView)view.findViewById(R.id.txtTopic);
        TextView txtTime = (TextView)view.findViewById(R.id.txtTime);
        TextView txtMeetingNo = (TextView)view.findViewById(R.id.txtMeetingNo);
        TextView txtHost = (TextView)view.findViewById(R.id.txtHost);
        Button btnStart = (Button)view.findViewById(R.id.btnStart);
        txtTopic.setText((CharSequence)context.getString(R.string.zm_lbl_topic_colon, new Object[]{this.getTopic()}));
        if (this.isRecurring()) {
            txtTime.setText(R.string.zm_lbl_recurring_meeting);
            txtTime.setTextColor(context.getResources().getColor(R.color.zm_meetinglistitem_time_normal));
        } else if (txtTime.isInEditMode()) {
            txtTime.setText((CharSequence)"2012/11/22 10:00 am");
            txtTime.setTextColor(context.getResources().getColor(R.color.zm_meetinglistitem_time_normal));
        } else {
            txtTime.setText((CharSequence)TimeFormatUtil.formatDateTime(context, this.getStartTime(), true));
            if (TimeUtil.isSameDate((long)this.getStartTime(), (long)System.currentTimeMillis())) {
                txtTime.setTextColor(context.getResources().getColor(R.color.zm_meetinglistitem_time_today));
            } else {
                txtTime.setTextColor(context.getResources().getColor(R.color.zm_meetinglistitem_time_normal));
            }
        }
        if (StringUtil.isEmptyOrNull((String)this.mHostName)) {
            txtHost.setVisibility(8);
        } else {
            txtHost.setText((CharSequence)(context.getText(R.string.zm_lbl_meeting_host_colon) + " " + this.getHostName()));
            txtHost.setVisibility(0);
        }
        txtMeetingNo.setText((CharSequence)(context.getText(R.string.zm_lbl_meeting_id) + " " + StringUtil.formatConfNumber((long)this.getMeetingNo())));
        long activeMeetingNo = view.isInEditMode() ? 0L : PTApp.getInstance().getActiveMeetingNo();
        String activeCallId = view.isInEditMode() ? "" : PTApp.getInstance().getActiveCallId();
        int callStatus = PTApp.getInstance().getCallStatus();
        if (activeMeetingNo == this.getMeetingNo() || activeCallId != null && activeCallId.equals(this.getId())) {
            if (callStatus == 2) {
                btnStart.setText(R.string.zm_btn_back);
            } else {
                btnStart.setText(this.mIsCanStartMeetingForMySelf ? R.string.zm_btn_start : R.string.zm_btn_join);
            }
            btnStart.setVisibility(0);
        } else {
            btnStart.setText(this.mIsCanStartMeetingForMySelf ? R.string.zm_btn_start : R.string.zm_btn_join);
            if (this.isRecurring() || TimeUtil.isSameDate((long)this.getStartTime(), (long)System.currentTimeMillis())) {
                btnStart.setVisibility(0);
            } else {
                btnStart.setVisibility(8);
            }
        }
        btnStart.setEnabled(callStatus != 1);
        btnStart.setOnClickListener((View.OnClickListener)this);
    }

    private void bindViewPMI(Context context, View view) {
        TextView txtMeetingNo = (TextView)view.findViewById(R.id.txtMeetingNo);
        Button btnStart = (Button)view.findViewById(R.id.btnStart);
        Button btnInvite = (Button)view.findViewById(R.id.btnInvite);
        Button btnEdit = (Button)view.findViewById(R.id.btnEdit);
        TextView txtVanityURL = (TextView)view.findViewById(R.id.txtVanityURL);
        long lMeetingNo = this.getMeetingNo();
        String sMeetingNo = String.valueOf(lMeetingNo);
        int iFormat = 0;
        if (sMeetingNo.length() > 10) {
            iFormat = ResourcesUtil.getInteger((Context)context, (int)R.integer.zm_config_long_meeting_id_format_type, (int)iFormat);
        }
        txtMeetingNo.setText((CharSequence)StringUtil.formatConfNumber((long)lMeetingNo, (int)iFormat));
        long activeMeetingNo = view.isInEditMode() ? 0L : PTApp.getInstance().getActiveMeetingNo();
        String activeCallId = view.isInEditMode() ? "" : PTApp.getInstance().getActiveCallId();
        int callStatus = PTApp.getInstance().getCallStatus();
        if (activeMeetingNo == this.getMeetingNo() || activeCallId != null && activeCallId.equals(this.getId())) {
            if (callStatus == 2) {
                btnStart.setText(R.string.zm_btn_back);
            } else {
                btnStart.setText(R.string.zm_btn_start);
            }
        } else {
            btnStart.setText(R.string.zm_btn_start);
        }
        String vanityURL = null;
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            vanityURL = profile.getPMIVanityURL();
        }
        if (StringUtil.isEmptyOrNull(vanityURL)) {
            txtVanityURL.setVisibility(8);
        } else {
            txtVanityURL.setVisibility(0);
            txtVanityURL.setText((CharSequence)vanityURL);
        }
        btnStart.setEnabled(callStatus != 1);
        btnStart.setOnClickListener((View.OnClickListener)this);
        btnInvite.setOnClickListener((View.OnClickListener)this);
        btnEdit.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnStart) {
            this.onClickBtnStart(v.getContext());
        } else if (id2 == R.id.btnInvite) {
            this.onClickBtnInvite(v.getContext());
        } else if (id2 == R.id.btnEdit) {
            this.onClickBtnEdit(v);
        }
    }

    private void onClickBtnStart(Context context) {
        if (this.mIsCanStartMeetingForMySelf) {
            ConfActivity.startMeeting((ZMActivity)context, this.getMeetingNo(), this.getId());
        } else if (!StringUtil.isEmptyOrNull((String)this.mJoinMeetingUrl)) {
            ConfActivity.joinByUrl(context, this.mJoinMeetingUrl);
        }
    }

    private void onClickBtnInvite(Context context) {
        this.sendInvitations(context, -1);
    }

    private void sendInvitations(Context context, int appTypes) {
        String content = MeetingInvitationUtil.buildEmailInvitationContent(context, this, true);
        String topic = context.getString(R.string.zm_title_meeting_invitation_email_topic, new Object[]{this.getTopic()});
        String chooserTitle = context.getString(R.string.zm_lbl_add_invitees);
        String stream = null;
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper != null) {
            String[] filePath;
            String calendarContent = MeetingInvitationUtil.buildEmailInvitationContent(context, this, true);
            this.setInvitationEmailContentWithTime(calendarContent);
            MeetingInfo meetingInfo = this.toMeetingInfo();
            AndroidAppUtil.EventRepeatType repeatType = ScheduledMeetingItem.zoomRepeatTypeToNativeRepeatType(this.mRepeatType);
            if (this.mExtendMeetingType != 1 && (!this.isRecurring() || repeatType != AndroidAppUtil.EventRepeatType.NONE) && helper.createIcsFileFromMeeting(meetingInfo, filePath = new String[]{context.getString(R.string.zm_meeting_invitation_ics_name)}, TimeZone.getDefault().getID())) {
                stream = "file://" + filePath[0];
            }
        }
        String url = this.getJoinMeetingUrl();
        long meetingId = this.getMeetingNo();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("joinMeetingUrl", url);
        config.put("meetingId", String.valueOf(meetingId));
        Template template = new Template(context.getString(R.string.zm_msg_sms_invite_scheduled_meeting));
        String smsContent = template.format(config);
        ZMActivity activity = (ZMActivity)context;
        ZMSendMessageFragment.show((Context)context, (FragmentManager)activity.getSupportFragmentManager(), null, null, (String)topic, (String)content, (String)smsContent, stream, (String)chooserTitle, (int)appTypes);
    }

    private void onClickBtnEdit(View v) {
        ZMActivity activity = (ZMActivity)v.getContext();
        if (activity != null) {
            SimpleActivity.show(activity, PMIEditFragment.class.getName(), null, 0, true);
        }
    }
}

