/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.style.ReplacementSpan;
import us.zoom.androidlib.util.UIUtil;

public class RoundRectBackGroundSpan
extends ReplacementSpan {
    private Context mContext;
    private String mText;
    private int mContentSize;
    private int mInterval = 0;
    private int mRadius = 0;
    private int mPaddingTop = 3;
    private int mPaddingBottom = 3;
    private int mPaddingLeft = 0;
    private int mPaddingRight = 0;

    public RoundRectBackGroundSpan(Context context) {
        this.mContext = context;
    }

    public String getText() {
        return this.mText;
    }

    public void setInterval(int interval) {
        this.mInterval = interval;
    }

    public int getInvterval() {
        return this.mInterval;
    }

    public void setPadding(int left, int right, int top, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingRight = right;
        this.mPaddingTop = top;
        this.mPaddingBottom = bottom;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (text == null || text.length() <= 0) {
            return 0;
        }
        int length = text.length();
        if (start >= length) {
            return 0;
        }
        if (end > length) {
            end = length;
        }
        CharSequence content = text.subSequence(start, end);
        this.mText = content.toString();
        if (fm == null) {
            fm = paint.getFontMetricsInt();
        }
        int diameter = UIUtil.dip2px((Context)this.mContext, (float)30.0f);
        if (fm != null) {
            diameter = fm.bottom - fm.top;
        }
        this.mRadius = diameter / 2;
        this.mContentSize = (int)paint.measureText(content, 0, content.length()) + diameter + this.mInterval * 2 + this.mPaddingLeft + this.mPaddingRight;
        return this.mContentSize;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (text == null || text.length() <= 0) {
            return;
        }
        int length = text.length();
        if (start >= length) {
            return;
        }
        if (end > length) {
            end = length;
        }
        float[] radii = new float[]{this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius};
        RoundRectShape shape = new RoundRectShape(radii, null, null);
        CharSequence content = text.subSequence(start, end);
        ShapeDrawable mBg = new ShapeDrawable((Shape)shape);
        mBg.getPaint().setColor(-13790721);
        int baseLine = y;
        int height = bottom - top;
        int boundLeft = (int)x + this.mInterval + this.mPaddingLeft;
        int boundTop = 0;
        int boundBottom = 0;
        Paint.FontMetricsInt fmi = paint.getFontMetricsInt();
        int boundRight = (int)(x + (float)this.getSize(paint, text, start, end, fmi) - (float)this.mInterval - (float)this.mPaddingRight);
        if (fmi != null) {
            int fontH = fmi.bottom - fmi.top;
            int fontTop = y + fmi.top;
            int fontBottom = y + fmi.bottom;
            if (fontTop - this.mPaddingTop >= top) {
                boundTop = fontTop - this.mPaddingTop;
                boundBottom = fontBottom + this.mPaddingBottom;
            } else {
                boundTop = top;
                boundBottom = boundTop + fontH + this.mPaddingTop + this.mPaddingBottom;
                baseLine = top + this.mPaddingTop - fmi.top;
            }
        } else {
            boundTop = top + 1;
            boundBottom = bottom - 1;
        }
        mBg.setBounds(boundLeft, boundTop, boundRight, boundBottom);
        mBg.draw(canvas);
        paint.setColor(-1);
        canvas.drawText(content, 0, content.length(), x + (float)this.mRadius + (float)this.mInterval, (float)baseLine, paint);
    }
}

