/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.fragment.WebinarRaiseHandFragment;
import com.zipow.videobox.util.UIMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class RaiseHandTip
extends ZMTipFragment
implements View.OnClickListener {
    public static final String ARG_MESSAGE = "message";
    public static final String ARG_ANCHOR_ID = "anchorId";

    public static void showTip(FragmentManager fragmentMgr, String message, int anchorId) {
        if (fragmentMgr == null) {
            return;
        }
        RaiseHandTip preTip = (RaiseHandTip)fragmentMgr.findFragmentByTag(RaiseHandTip.class.getName());
        if (preTip != null) {
            preTip.dismiss();
        }
        Bundle args = new Bundle();
        args.putString(ARG_MESSAGE, message);
        args.putInt(ARG_ANCHOR_ID, anchorId);
        RaiseHandTip tip = new RaiseHandTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, RaiseHandTip.class.getName());
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        RaiseHandTip tip = (RaiseHandTip)fragmentMgr.findFragmentByTag(RaiseHandTip.class.getName());
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        RaiseHandTip tip = (RaiseHandTip)fragmentMgr.findFragmentByTag(RaiseHandTip.class.getName());
        if (tip != null) {
            tip.dismiss();
            return true;
        }
        return false;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = layoutInflater.inflate(R.layout.zm_raisehand_tip, null);
        View contentView = view.findViewById(R.id.content);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        Bundle args = this.getArguments();
        String name = args.getString(ARG_MESSAGE);
        txtMessage.setText((CharSequence)name);
        this.mAutoFocus = false;
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        int anchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (anchorId > 0 && (anchor = this.getActivity().findViewById(anchorId)) != null) {
            tip.setAnchor(anchor, UIMgr.isLargeMode((Context)this.getActivity()) ? 1 : 3);
        }
        contentView.setOnClickListener((View.OnClickListener)this);
        tip.setCornerArcSize(UIUtil.dip2px((Context)context, (float)10.0f));
        tip.setLayoutGravity(3, UIUtil.dip2px((Context)context, (float)60.0f));
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_message_tip_background));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_message_tip_border));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_message_tip_shadow));
        if (!StringUtil.isEmptyOrNull((String)name)) {
            txtMessage.setContentDescription((CharSequence)this.getString(R.string.zm_accessibility_raised_hand_description_23051, new Object[]{name}));
        }
        return tip;
    }

    public void onClick(View v) {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && (myself.isHost() || myself.isCoHost())) {
            this.showRaiseHand();
        }
    }

    private void showRaiseHand() {
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity instanceof ZMActivity) {
            WebinarRaiseHandFragment.showAsActivity((ZMActivity)activity, 0);
        }
    }
}

