/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CheckedTextView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.fragment.PAttendeeListActionDialog;
import com.zipow.videobox.fragment.PListFragment;
import com.zipow.videobox.fragment.PListItemActionDialog;
import com.zipow.videobox.fragment.QAWebinarAttendeeListFragment;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.PAttendeeItem;
import com.zipow.videobox.view.PListAdapter;
import com.zipow.videobox.view.PListItem;
import com.zipow.videobox.view.PListItemActionTip;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMTipLayer;
import us.zoom.videomeetings.R;

public class PListView
extends ListView
implements AdapterView.OnItemClickListener,
View.OnClickListener {
    private static final String TAG = PListView.class.getSimpleName();
    private PListAdapter mAdapter;
    private String mFilter;
    private CheckedTextView mChkQAAnonymous;
    private View mPanelQAAnonymous;
    private boolean isEnableSileMode = false;
    private boolean isEnableWaitingList = false;

    public PListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public PListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public PListView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mAdapter = new PListAdapter(this.getContext(), this);
        this.setItemsCanFocus(true);
        if (this.isInEditMode()) {
            this._editmode_loadAllItems(this.mAdapter);
        } else {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null) {
                if (ConfMgr.getInstance().isConfConnected() && confContext.isWebinar()) {
                    View attendeeView = View.inflate((Context)this.getContext(), (int)R.layout.zm_plist_foot_attendees, null);
                    attendeeView.findViewById(R.id.btnViewAttendee).setOnClickListener((View.OnClickListener)this);
                    this.addFooterView(attendeeView, null, false);
                    this.mPanelQAAnonymous = View.inflate((Context)this.getContext(), (int)R.layout.zm_plist_foot_qa_anonymous, null);
                    this.mPanelQAAnonymous.findViewById(R.id.btnViewQAAnonymouse).setOnClickListener((View.OnClickListener)this);
                    this.mChkQAAnonymous = (CheckedTextView)this.mPanelQAAnonymous.findViewById(R.id.chkQAAnonymous);
                    this.updateQAAnonymously();
                    this.mAdapter.setIsWebinar(true);
                }
                this.isEnableSileMode = confContext.isMeetingSupportSilentMode();
                this.isEnableWaitingList = confContext.supportPutUserinWaitingListUponEntryFeature();
                this.mAdapter.setEnableWaitingList(this.isEnableWaitingList);
            }
            this.loadAllItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
    }

    private void _editmode_loadAllItems(PListAdapter adapter) {
        for (int i = 0; i < 10; ++i) {
            PListItem item = new PListItem();
            item.userId = i;
            item.screenName = "User " + i;
            item.unreadMessageCount = i % 5;
            item.audioOn = i % 2 == 0;
            item.videoOn = i % 4 < 2;
            adapter.addItem(item, null);
        }
    }

    private void loadAllItems(PListAdapter adapter) {
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return;
        }
        boolean isInBOMeeting = false;
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr != null) {
            isInBOMeeting = boMgr.isInBOMeeting();
        }
        int count = userList.getUserCount();
        boolean isHostCohost = ConfLocalHelper.isHostCoHostBOModerator();
        boolean isSupportOnHold = this.isEnableSileMode || this.isEnableWaitingList;
        for (int i = 0; i < count; ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user.isMMRUser() || !isInBOMeeting && user.isInBOMeeting()) continue;
            adapter.addItem(user, this.mFilter, isHostCohost, isSupportOnHold);
        }
        adapter.sortAll();
    }

    public void setInSearchProgress(boolean search) {
        this.mAdapter.setInSearchProgress(search);
        this.mAdapter.notifyDataSetChanged();
    }

    public void reloadAllItems() {
        this.mAdapter.clear();
        this.loadAllItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void filter(String filter) {
        if (filter == null) {
            filter = "";
        }
        filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        String oldFilter = this.mFilter;
        this.mFilter = filter;
        if (oldFilter == null) {
            oldFilter = "";
        }
        if (oldFilter.equals(filter)) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)filter)) {
            if (!StringUtil.isEmptyOrNull((String)oldFilter) && filter.contains(oldFilter)) {
                this.mAdapter.filter(filter);
                this.mAdapter.notifyDataSetChanged();
            } else {
                this.reloadAllItems();
            }
        } else {
            this.reloadAllItems();
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if ((position -= this.getHeaderViewsCount()) < 0 || position >= this.mAdapter.getCount()) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        Object obj = this.mAdapter.getItem(position);
        if (obj == null) {
            return;
        }
        if (obj instanceof PListItem) {
            PListItem item = (PListItem)obj;
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return;
            }
            if (confStatus.isMyself(item.userId)) {
                this.showPListItemActionDialog(item.userId);
            } else {
                CmmUser user = ConfMgr.getInstance().getUserById(item.userId);
                if (user == null) {
                    return;
                }
                if (ConfLocalHelper.isHostCoHostBOModerator()) {
                    this.showPListItemActionDialog(item.userId);
                } else if (!(user.isH323User() || user.isPureCallInUser() || user.inSilentMode())) {
                    if (this.canControlUserCamera(user) && confContext.isMeetingSupportCameraControl()) {
                        this.showPListItemActionDialog(item.userId);
                    } else if (!confContext.isChatOff()) {
                        if (!(user.isHost() || user.isCoHost() || user.isBOModerator() || confStatus.getAttendeeChatPriviledge() != 3)) {
                            return;
                        }
                        this.showChatUI(item);
                    }
                }
            }
        } else if (obj instanceof PAttendeeItem) {
            PAttendeeItem attendeeItem = (PAttendeeItem)obj;
            if (!ConfLocalHelper.isNeedShowAttendeeActionList()) {
                return;
            }
            ZMActivity activity = (ZMActivity)this.getContext();
            if (activity != null) {
                PAttendeeListActionDialog.show(activity.getSupportFragmentManager(), attendeeItem.getConfChatAttendeeItem());
            }
        }
    }

    private boolean canControlUserCamera(CmmUser user) {
        CmmVideoStatus videoStatus = user.getVideoStatusObj();
        boolean userVideoIsSending = false;
        boolean userHasCamera = false;
        int userFeccCamNum = 0;
        if (videoStatus != null) {
            userVideoIsSending = videoStatus.getIsSending();
            userHasCamera = videoStatus.getIsSource();
            userFeccCamNum = videoStatus.getCamFecc();
        }
        boolean canRemoteCtrlCam = false;
        if (user.supportSwitchCam() && userVideoIsSending || userFeccCamNum > 0) {
            canRemoteCtrlCam = true;
        }
        return canRemoteCtrlCam && userVideoIsSending && userHasCamera;
    }

    private void showPListItemActionDialog(long userId) {
        PListItemActionDialog.show(((ZMActivity)this.getContext()).getSupportFragmentManager(), userId);
    }

    private void showChatUI(PListItem item) {
        PListFragment f = PListFragment.getPListFragment(((ZMActivity)this.getContext()).getSupportFragmentManager());
        ConfLocalHelper.showChatUI((ZMFragment)f, item.userId);
    }

    private void showWebinarAttendees() {
        QAWebinarAttendeeListFragment.showAsActivity((ZMActivity)this.getContext(), 0);
    }

    public void updateAttendeeCount() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void updateQAAnonymously() {
        boolean isHost;
        if (this.mPanelQAAnonymous == null || this.mChkQAAnonymous == null) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        boolean bl = isHost = myself != null && (myself.isHost() || myself.isCoHost());
        if (confContext != null && confContext.isWebinar() && isHost && !confContext.isQANDAOFF() && confContext.isAnonymousQAChangable()) {
            this.removeFooterView(this.mPanelQAAnonymous);
            this.addFooterView(this.mPanelQAAnonymous, null, false);
            this.mPanelQAAnonymous.setVisibility(0);
            boolean isAllowed = ConfMgr.getInstance().isAllowAskQuestionAnonymously();
            this.mChkQAAnonymous.setChecked(isAllowed);
        } else if (this.mPanelQAAnonymous != null) {
            this.removeFooterView(this.mPanelQAAnonymous);
        }
    }

    private boolean checkUserValid(CmmUser user) {
        if (user != null) {
            boolean isFailoverUser = user.isFailoverUser();
            BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
            boolean userInBO = user.isInBOMeeting();
            if (!isFailoverUser || boMgr != null && boMgr.isInBOMeeting() == userInBO) {
                return true;
            }
        }
        return false;
    }

    public void onUserJoin(long userId, int flag) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (this.checkUserValid(user)) {
            this.mAdapter.addItem(user, this.mFilter, ConfLocalHelper.isHostCoHostBOModerator(), this.isEnableSileMode);
            this.refreshOrder(user);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onUserLeave(long userId) {
        this.mAdapter.removeItem(userId, this.isEnableSileMode || this.isEnableWaitingList);
        this.refreshOrder(userId);
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        PListItemActionDialog.dismissPListActionDialogForUserId(fm, userId);
        PAttendeeListActionDialog.dismissPAttendeeListActionDialogForUserId(fm, userId);
    }

    public void onUserUpdate(int cmd, long userId, boolean needResort) {
        if (cmd == 1 || cmd == 43) {
            this.reloadAllItems();
            FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            CmmUser myself = ConfMgr.getInstance().getMyself();
            if (myself == null) {
                return;
            }
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus != null) {
                if (confStatus.isSameUser(myself.getNodeId(), userId)) {
                    PListItemActionDialog.dismissPListItemActionDialog(fm);
                } else {
                    PListItemActionDialog.dismissPListActionDialogForUserId(fm, userId);
                }
            }
            PAttendeeListActionDialog.refreshAction(fm, userId);
            return;
        }
        if (cmd == 10 || cmd == 12 || cmd == 13 || cmd == 16 || cmd == 17 || cmd == 18 || cmd == 19 || cmd == 54) {
            return;
        }
        this.updateUser(userId, needResort);
    }

    public void onUserActionsButtonClicked(View btn, PListItem item) {
        ZMTipLayer tipLayer = (ZMTipLayer)((ZMActivity)this.getContext()).findViewById(R.id.tipLayer);
        if (tipLayer.dismissAllTips()) {
            return;
        }
        Rect rcAnchor = this.getAbsoluteRect(btn);
        PListItemActionTip tip = new PListItemActionTip(this.getContext(), item);
        if (rcAnchor.bottom > ((Activity)this.getContext()).getWindow().getDecorView().getHeight() - UIUtil.dip2px((Context)this.getContext(), (float)120.0f)) {
            tip.setAnchor(btn, 3);
        } else {
            tip.setAnchor(btn, 1);
        }
        tip.show(tipLayer);
    }

    public void updateUser(long userId, boolean needResort) {
        FragmentManager fm;
        ZMActivity zmActivity;
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (this.checkUserValid(user)) {
            this.mAdapter.updateItem(user, this.mFilter, ConfLocalHelper.isHostCoHostBOModerator());
            if (needResort) {
                this.refreshOrder(userId);
            } else {
                this.mAdapter.notifyDataSetChanged();
            }
        }
        if ((zmActivity = (ZMActivity)this.getContext()) != null && (fm = zmActivity.getSupportFragmentManager()) != null) {
            if (user.isViewOnlyUserCanTalk()) {
                PAttendeeListActionDialog.refreshAction(fm, userId);
            } else {
                PListItemActionDialog.refreshAction(fm, userId);
            }
        }
    }

    private void refreshOrder(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null) {
            if (user.isViewOnlyUserCanTalk()) {
                this.mAdapter.sortAttendee();
            } else {
                this.mAdapter.sortPanelist();
            }
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void refreshOrder(CmmUser user) {
        if (user != null) {
            if (user.isViewOnlyUserCanTalk()) {
                this.mAdapter.sortAttendee();
            } else {
                this.mAdapter.sortPanelist();
            }
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void ccPrivilegeChange(long userId) {
        this.mAdapter.notifyDataSetChanged();
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        PListItemActionDialog.refreshAction(fm, userId);
    }

    private Rect getAbsoluteRect(View v) {
        Rect rectV = UIUtil.getAbsoluteRect((View)v);
        Rect rectSelf = UIUtil.getAbsoluteRect((View)this);
        rectV.offset(-rectSelf.left, -rectSelf.top);
        return rectV;
    }

    private void onClickQAAnonymouse() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null || !confContext.isWebinar()) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null || !myself.isHost() && !myself.isCoHost()) {
            return;
        }
        boolean checked = !this.mChkQAAnonymous.isChecked();
        ConfMgr.getInstance().handleConfCmd(checked ? 109 : 110);
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnViewAttendee) {
            this.showWebinarAttendees();
        } else if (id2 == R.id.btnViewQAAnonymouse) {
            this.onClickQAAnonymouse();
        }
    }
}

