/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class PListNameRoleLayout
extends ViewGroup {
    private static final String TAG = PListNameRoleLayout.class.getSimpleName();

    public PListNameRoleLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public PListNameRoleLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PListNameRoleLayout(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthParent = View.MeasureSpec.getSize((int)widthMeasureSpec) - paddingLeft - paddingRight;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightParent = View.MeasureSpec.getSize((int)heightMeasureSpec) - paddingTop - paddingBottom;
        int count = this.getChildCount();
        int sumWidth = 0;
        int maxHeight = 0;
        int lMinWidth = 0;
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int remainWidth = widthParent - sumWidth;
            lMinWidth = 0;
            for (int j = 0; j < i; ++j) {
                View lchild = this.getChildAt(j);
                if (lchild.getVisibility() == 8) continue;
                lMinWidth += ViewCompat.getMinimumWidth((View)lchild);
            }
            if ((remainWidth -= lMinWidth) < 0) {
                remainWidth = 0;
            }
            try {
                this.measureChild(child, View.MeasureSpec.makeMeasureSpec((int)remainWidth, (int)Integer.MIN_VALUE), heightMeasureSpec);
            }
            catch (Exception j) {
                // empty catch block
            }
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            sumWidth += width;
            maxHeight = maxHeight > height ? maxHeight : height;
        }
        this.setMeasuredDimension((widthMode == 0x40000000 ? widthParent : sumWidth) + paddingLeft + paddingRight, (heightMode == 0x40000000 ? heightParent : maxHeight) + paddingTop + paddingBottom);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int sumWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int width = child.getMeasuredWidth();
            sumWidth += width;
        }
        int lOffset = this.getPaddingLeft();
        int rOffset = this.getPaddingRight();
        int top = 0;
        int right = r - l - rOffset;
        if (sumWidth < right - lOffset) {
            right = lOffset + sumWidth;
        }
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int left = right - child.getMeasuredWidth();
            if (left < lOffset) {
                left = lOffset;
            }
            top = (b - t - child.getMeasuredHeight()) / 2;
            int bottom = top + child.getMeasuredHeight();
            child.layout(left, top, right, bottom);
            right = left;
        }
    }
}

