/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.fragment.ExpelUserAlertDialog;
import com.zipow.videobox.fragment.MakeHostAlertDialog;
import com.zipow.videobox.fragment.PListFragment;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.PListItem;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class PListItemActionTip
extends ZMTip
implements View.OnClickListener {
    private PListItem mPListItem;

    public PListItemActionTip(Context context, AttributeSet attrs, PListItem item) {
        super(context, attrs);
        this.mPListItem = item;
        this.initView();
    }

    public PListItemActionTip(Context context, PListItem item) {
        super(context);
        this.mPListItem = item;
        this.initView();
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_plistitem_action_tip, (ViewGroup)this);
        Button btnMakeHost = (Button)this.findViewById(R.id.btnMakeHost);
        Button btnChat = (Button)this.findViewById(R.id.btnChat);
        Button btnMute = (Button)this.findViewById(R.id.btnMute);
        Button btnUnmute = (Button)this.findViewById(R.id.btnUnmute);
        Button btnExpel = (Button)this.findViewById(R.id.btnExpel);
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmUser user = confMgr.getUserById(this.mPListItem.userId);
        if (user.getAudioStatusObj().getIsMuted()) {
            btnMute.setVisibility(8);
        } else {
            btnUnmute.setVisibility(8);
        }
        btnMakeHost.setOnClickListener((View.OnClickListener)this);
        btnChat.setOnClickListener((View.OnClickListener)this);
        btnMute.setOnClickListener((View.OnClickListener)this);
        btnUnmute.setOnClickListener((View.OnClickListener)this);
        btnExpel.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnMakeHost) {
            this.onClickBtnMakeHost();
        } else if (id2 == R.id.btnChat) {
            this.onClickBtnChat();
        } else if (id2 == R.id.btnMute) {
            this.onClickBtnMute();
        } else if (id2 == R.id.btnUnmute) {
            this.onClickBtnUnmute();
        } else if (id2 == R.id.btnExpel) {
            this.onClickBtnExpel();
        }
    }

    private void onClickBtnMakeHost() {
        MakeHostAlertDialog.showMakeHostAlertDialog((ZMActivity)this.getContext(), this.mPListItem.userId);
        this.dismiss();
    }

    private void onClickBtnChat() {
        this.showChatUI(this.mPListItem);
        this.dismiss();
    }

    private void onClickBtnMute() {
        ConfMgr.getInstance().handleUserCmd(46, this.mPListItem.userId);
        this.dismiss();
    }

    private void onClickBtnUnmute() {
        ConfMgr.getInstance().handleUserCmd(47, this.mPListItem.userId);
        this.dismiss();
    }

    private void onClickBtnExpel() {
        ExpelUserAlertDialog.showExpelUserAlertDialog((ZMActivity)this.getContext(), this.mPListItem.userId);
        this.dismiss();
    }

    private void showChatUI(PListItem item) {
        PListFragment f = PListFragment.getPListFragment(((ZMActivity)this.getContext()).getSupportFragmentManager());
        ConfLocalHelper.showChatUI((ZMFragment)f, item.userId);
    }
}

