/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmAttentionTrackMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ZMConfUtil;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.ComparablePItemFields;
import com.zipow.videobox.view.PListView;
import us.zoom.videomeetings.R;

public class PListItem {
    public String screenName;
    public String userFBID;
    public long userId;
    public String avatar;
    public boolean audioOn;
    public boolean videoOn;
    public int unreadMessageCount;
    public long audioType = 0L;
    public boolean hasCamera = true;
    private boolean isWebinar = false;
    private boolean isAttentionMode = false;
    private long mRaiseHandTimestamp;
    private ComparablePItemFields comparablePItemFields = new ComparablePItemFields();

    public PListItem() {
    }

    public PListItem(CmmUser user) {
        this.update(user);
    }

    public PListItem(long userId) {
        this.update(userId);
    }

    public PListItem update(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        this.update(user);
        return this;
    }

    public PListItem update(CmmUser user) {
        CmmVideoStatus videoStatus;
        if (user == null) {
            return this;
        }
        if (user.isViewOnlyUserCanTalk()) {
            ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(user.getNodeId());
            if (buddy != null) {
                this.mRaiseHandTimestamp = buddy.getRaiseHandTimestamp();
            }
        } else {
            this.mRaiseHandTimestamp = user.getRaiseHandTimestamp();
        }
        this.screenName = user.getScreenName();
        this.userFBID = user.getUserFBID();
        this.userId = user.getNodeId();
        this.avatar = user.getSmallPicPath();
        this.unreadMessageCount = this.isWebinar ? 0 : ConfMgr.getInstance().getUnreadChatMessagesByUser(this.userId, false).length;
        this.isAttentionMode = user.isInAttentionMode();
        CmmAudioStatus audioStatus = user.getAudioStatusObj();
        if (audioStatus != null) {
            this.audioOn = !audioStatus.getIsMuted();
            this.audioType = audioStatus.getAudiotype();
        }
        if ((videoStatus = user.getVideoStatusObj()) != null) {
            this.videoOn = videoStatus.getIsSending();
            this.hasCamera = videoStatus.getIsSource();
        }
        return this;
    }

    private View createViewByUserId(Context context) {
        View view = null;
        view = View.inflate((Context)context, (int)R.layout.zm_plist_item, null);
        view.setTag((Object)"paneList");
        return view;
    }

    public View getView(PListView plistView, Context context, View convertView) {
        View view = convertView;
        boolean createView = false;
        if (view == null || !"paneList".equals(view.getTag())) {
            createView = true;
        }
        if (createView) {
            view = this.createViewByUserId(context);
        }
        if ("paneList".equals(view.getTag())) {
            this.bindView(context, view);
        }
        return view;
    }

    private void bindView(Context context, View view) {
        AvatarView avatarView = (AvatarView)view.findViewById(R.id.avatarView);
        TextView txtScreenName = (TextView)view.findViewById(R.id.txtScreenName);
        TextView txtRole = (TextView)view.findViewById(R.id.txtRole);
        TextView txtUnreadMessageCount = (TextView)view.findViewById(R.id.txtUnreadMessageCount);
        ImageView imgAudio = (ImageView)view.findViewById(R.id.imgAudio);
        ImageView imgVideo = (ImageView)view.findViewById(R.id.imgVideo);
        ImageView imgLocalRecording = (ImageView)view.findViewById(R.id.imgRecording);
        ImageView imgCMRRecording = (ImageView)view.findViewById(R.id.imgCMRRecording);
        ImageView imgRaiseHand = (ImageView)view.findViewById(R.id.imgRaiseHand);
        ImageView imgAttention = (ImageView)view.findViewById(R.id.imgAttention);
        ImageView imgCc = (ImageView)view.findViewById(R.id.imgCc);
        ImageView imgPureAudio = (ImageView)view.findViewById(R.id.imgPureAudio);
        txtScreenName.setText((CharSequence)this.screenName);
        avatarView.setName(this.screenName);
        view.setBackgroundResource(R.color.zm_transparent);
        if (!view.isInEditMode()) {
            boolean isShare;
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmConfStatus confStatus = confMgr.getConfStatusObj();
            CmmUser myself = confMgr.getMyself();
            CmmUser user = confMgr.getUserById(this.userId);
            CmmAttentionTrackMgr atMgr = confMgr.getAttentionTrackAPI();
            ShareSessionMgr shareMgr = confMgr.getShareObj();
            if (user == null) {
                return;
            }
            boolean isHost = ConfUI.getInstance().isDisplayAsHost(this.userId);
            boolean isCohost = ConfUI.getInstance().isDisplayAsCohost(this.userId);
            txtRole.setVisibility(0);
            if (confStatus != null && confStatus.isMyself(this.userId)) {
                if (isHost) {
                    txtRole.setText((CharSequence)context.getResources().getString(R.string.zm_lbl_role_me_host));
                } else if (isCohost) {
                    txtRole.setText((CharSequence)context.getResources().getString(R.string.zm_lbl_role_me_cohost));
                } else {
                    txtRole.setText((CharSequence)context.getResources().getString(R.string.zm_lbl_role_me));
                }
            } else {
                view.setBackgroundResource(ConfLocalHelper.isGuest(user) && !ConfLocalHelper.isGuestForMyself() ? R.drawable.zm_list_selector_guest : R.color.zm_transparent);
                if (isHost) {
                    txtRole.setText((CharSequence)context.getResources().getString(R.string.zm_lbl_role_host));
                } else if (isCohost) {
                    txtRole.setText((CharSequence)context.getResources().getString(R.string.zm_lbl_role_cohost));
                } else if (user.inSilentMode()) {
                    txtRole.setText((CharSequence)context.getResources().getString(R.string.zm_lbl_role_in_silent_mode));
                } else {
                    txtRole.setVisibility(8);
                }
            }
            imgCc.setVisibility(user.canActAsCCEditor() && user.canEditCC() ? 0 : 8);
            Boolean isRecording = user.isRecording();
            Boolean isCMRRecording = false;
            RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
            if (recordMgr != null && recordMgr.recordingMeetingOnCloud() && !recordMgr.isCMRPaused() && (isHost || isCohost)) {
                isCMRRecording = true;
            }
            if (isCMRRecording.booleanValue()) {
                imgLocalRecording.setVisibility(8);
                imgCMRRecording.setVisibility(0);
                imgCMRRecording.setContentDescription((CharSequence)context.getResources().getString(R.string.zm_description_plist_status_recording));
            } else if (isRecording.booleanValue()) {
                imgCMRRecording.setVisibility(8);
                imgLocalRecording.setVisibility(0);
                imgLocalRecording.setContentDescription((CharSequence)context.getResources().getString(R.string.zm_description_plist_status_recording));
            } else {
                imgLocalRecording.setVisibility(8);
                imgCMRRecording.setVisibility(8);
            }
            if (user.isPureCallInUser()) {
                avatarView.setAvatar(R.drawable.zm_phone_avatar);
            } else if (user.isH323User()) {
                avatarView.setAvatar(R.drawable.zm_h323_avatar);
            } else {
                avatarView.setAvatar(this.avatar);
            }
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null && confContext.isFeedbackEnable()) {
                int iconId = CmmFeedbackMgr.getIconIdByFeedback(user.getFeedback());
                if (iconId == 0) {
                    imgRaiseHand.setVisibility(8);
                } else {
                    imgRaiseHand.setVisibility(0);
                    imgRaiseHand.setImageResource(iconId);
                }
            } else {
                imgRaiseHand.setVisibility(user.getRaiseHandState() ? 0 : 8);
                imgRaiseHand.setContentDescription((CharSequence)context.getResources().getString(R.string.zm_description_plist_status_raise_hand));
            }
            boolean bl = isShare = shareMgr != null && (shareMgr.getShareStatus() == 3 || shareMgr.getShareStatus() == 2);
            if (atMgr != null && atMgr.isConfAttentionTrackEnabled() && isShare && (myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
                imgAttention.setVisibility(this.isAttentionMode ? 4 : 0);
            } else {
                imgAttention.setVisibility(8);
            }
            if (user.isSharingPureComputerAudio()) {
                imgPureAudio.setVisibility(0);
                imgPureAudio.setContentDescription((CharSequence)context.getResources().getString(R.string.zm_accessibility_audio_sharing_41468, new Object[]{this.screenName}));
            } else {
                imgPureAudio.setVisibility(8);
            }
        }
        String contentDescription = null;
        boolean hasAudio = this.audioType != 2L;
        avatarView.setVisibility(0);
        imgAudio.setVisibility(hasAudio ? 0 : 4);
        imgVideo.setVisibility(this.hasCamera ? 0 : 4);
        imgAudio.setImageResource(ZMConfUtil.getAudioImageResId(view.isInEditMode(), this.audioOn, this.audioType, this.userId));
        imgVideo.setImageResource(this.videoOn ? R.drawable.zm_video_on : R.drawable.zm_video_off);
        contentDescription = context.getResources().getString(this.audioOn ? R.string.zm_description_plist_status_audio_on : R.string.zm_description_plist_status_audio_off);
        imgAudio.setContentDescription((CharSequence)contentDescription);
        contentDescription = context.getResources().getString(this.videoOn ? R.string.zm_description_plist_status_video_on : R.string.zm_description_plist_status_video_off);
        imgVideo.setContentDescription((CharSequence)contentDescription);
        Drawable drawable2 = imgAudio.getDrawable();
        if (drawable2 instanceof AnimationDrawable) {
            ((AnimationDrawable)drawable2).start();
        }
        if (!this.isWebinar && this.unreadMessageCount > 0) {
            txtUnreadMessageCount.setVisibility(0);
            String message = this.unreadMessageCount < 100 ? String.valueOf(this.unreadMessageCount) : "99+";
            txtUnreadMessageCount.setText((CharSequence)message);
            contentDescription = context.getResources().getString(R.string.zm_description_plist_status_unread_chat_message, new Object[]{message});
            txtUnreadMessageCount.setContentDescription((CharSequence)contentDescription);
        } else {
            txtUnreadMessageCount.setVisibility(8);
        }
    }

    public void setWebinar(boolean isWebinar) {
        this.isWebinar = isWebinar;
    }

    public long getmRaiseHandTimestamp() {
        return this.mRaiseHandTimestamp;
    }

    @NonNull
    public ComparablePItemFields getComparablePItemFields() {
        return this.comparablePItemFields;
    }
}

