/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.util.PListItemComparator;
import com.zipow.videobox.util.PListItemNewComparator;
import com.zipow.videobox.view.PAttendeeItem;
import com.zipow.videobox.view.PAttendeeListAdapter;
import com.zipow.videobox.view.PListItem;
import com.zipow.videobox.view.PListView;
import com.zipow.videobox.view.WaitingListAdapter;
import com.zipow.videobox.view.WaitingListItem;
import java.util.ArrayList;
import java.util.Collections;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class PListAdapter
extends BaseAdapter {
    private ArrayList<PListItem> mPListItems = new ArrayList();
    private WaitingListAdapter mWaitingAdapter;
    private PAttendeeListAdapter mPAttendeeListAdapter;
    private Context mContext;
    private PListView mPListView;
    private boolean isWebinar = false;
    private boolean isInSearchProgress = false;
    private boolean isEnableWaitingList;
    private int mOnHoldLabelPos = -1;
    private int mPListLabelPos = -1;
    private int mPListSeachPos = -1;
    private int mAttendeeLabelPos = -1;

    public PListAdapter(Context context, PListView pListView) {
        this.mContext = context;
        this.mPListView = pListView;
        this.mWaitingAdapter = new WaitingListAdapter(context);
        this.mPAttendeeListAdapter = new PAttendeeListAdapter(context);
    }

    public void clear() {
        this.mPListItems.clear();
        this.mWaitingAdapter.clear();
        this.mPAttendeeListAdapter.clear();
    }

    public void setEnableWaitingList(boolean isEnableWaitingList) {
        this.isEnableWaitingList = isEnableWaitingList;
    }

    public void setIsWebinar(boolean isWebinar) {
        this.isWebinar = isWebinar;
    }

    public void addItem(CmmUser user, String filter, boolean isHostCoHost, boolean isSupportOnHold) {
        if (user == null) {
            return;
        }
        if (isSupportOnHold && isHostCoHost && user.inSilentMode()) {
            this.addItem(new WaitingListItem(user), filter);
        } else if (!user.isViewOnlyUserCanTalk()) {
            this.addItem(new PListItem(user), filter);
        } else {
            this.addItem(new PAttendeeItem(user), filter);
        }
    }

    private void addItem(WaitingListItem item, String filter) {
        this.mWaitingAdapter.addItem(item, filter);
    }

    public void addItem(PListItem item, String filter) {
        this.updateItem(item, filter);
    }

    public void addItem(PAttendeeItem item, String filter) {
        this.updateItem(item, filter);
    }

    public void updateItem(CmmUser user, String filter, boolean isHostCohHost) {
        if (user == null) {
            return;
        }
        if (isHostCohHost) {
            this.updateItem(new WaitingListItem(user), filter);
        }
        if (user.isViewOnlyUserCanTalk()) {
            this.updateItem(new PAttendeeItem(user), filter);
        } else {
            this.updateItem(new PListItem(user), filter);
        }
    }

    private void updateItem(PAttendeeItem item, String filter) {
        this.mPAttendeeListAdapter.updateItem(item, filter);
    }

    private void updateItem(WaitingListItem item, String filter) {
        this.mWaitingAdapter.updateItem(item, filter);
    }

    private void updateItem(PListItem item, String filter) {
        assert (item != null);
        CmmUser user = ConfMgr.getInstance().getUserById(item.userId);
        if (user == null || user.isViewOnlyUserCanTalk()) {
            return;
        }
        item.setWebinar(this.isWebinar);
        int position = this.findPListItem(item.userId);
        if (position >= 0) {
            if (this.isPListItemAcceptedByFilter(item, filter) && !user.inSilentMode()) {
                this.mPListItems.set(position, item);
            } else {
                this.mPListItems.remove(position);
            }
        } else if (this.isPListItemAcceptedByFilter(item, filter) && !user.inSilentMode()) {
            this.mPListItems.add(item);
        }
    }

    private boolean isPListItemAcceptedByFilter(PListItem item, String filter) {
        boolean accepted = true;
        if (!StringUtil.isEmptyOrNull((String)filter)) {
            String name = item.screenName;
            if (name == null) {
                name = "";
            }
            if (!name.toLowerCase(CompatUtils.getLocalDefault()).contains(filter)) {
                accepted = false;
            }
        }
        return accepted;
    }

    public int findPListItem(long userId) {
        for (int i = 0; i < this.mPListItems.size(); ++i) {
            PListItem item = this.mPListItems.get(i);
            if (userId != item.userId) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(long userId, boolean isSupportHoldOn) {
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return;
        }
        CmmUser user = userList.getLeftUserById(userId);
        if (user == null) {
            return;
        }
        if (user.isViewOnlyUserCanTalk()) {
            this.mPAttendeeListAdapter.removeItem(userId);
        }
        if (isSupportHoldOn && user.inSilentMode()) {
            this.mWaitingAdapter.removeItem(userId);
        } else {
            int position = this.findPListItem(userId);
            if (position >= 0) {
                this.removePListItemAt(position);
            }
        }
    }

    private void removePListItemAt(int position) {
        if (position < 0 || position >= this.mPListItems.size()) {
            return;
        }
        this.mPListItems.remove(position);
    }

    public void filter(String filter) {
        if (StringUtil.isEmptyOrNull((String)filter)) {
            return;
        }
        for (int i = this.mPListItems.size() - 1; i >= 0; --i) {
            PListItem item = this.mPListItems.get(i);
            String name = item.screenName;
            if (name == null) {
                name = "";
            }
            if (name.toLowerCase(CompatUtils.getLocalDefault()).contains(filter)) continue;
            this.mPListItems.remove(i);
        }
        this.mWaitingAdapter.filter(filter);
        if (this.isWebinar) {
            this.mPAttendeeListAdapter.filter(filter);
        }
    }

    public void setInSearchProgress(boolean search) {
        this.isInSearchProgress = search;
    }

    public int getCount() {
        return this.checkCount();
    }

    private int checkCount() {
        int plistCount = this.mPListItems.size();
        int onHoldCount = this.mWaitingAdapter.getCount();
        int pAttendeeCount = this.mPAttendeeListAdapter.getCount();
        int count = 0;
        if (onHoldCount > 0) {
            this.mOnHoldLabelPos = 0;
            ++count;
        } else {
            this.mOnHoldLabelPos = -1;
        }
        count += onHoldCount;
        this.mPListLabelPos = this.isWebinar || onHoldCount > 0 ? count++ : -1;
        this.mPListSeachPos = !this.isInSearchProgress && plistCount > 7 ? count++ : -1;
        count += plistCount;
        this.mAttendeeLabelPos = this.isWebinar || pAttendeeCount > 0 ? count++ : -1;
        return count += pAttendeeCount;
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        if (position == this.mOnHoldLabelPos || position == this.mPListLabelPos || position == this.mPListSeachPos || position == this.mAttendeeLabelPos) {
            return position;
        }
        int plistCount = this.mPListItems.size();
        int onHoldCount = this.mWaitingAdapter.getCount();
        int pAttendeeCount = this.mPAttendeeListAdapter.getCount();
        int pos = position;
        if (this.mOnHoldLabelPos >= 0) {
            --pos;
        }
        if (onHoldCount > 0 && pos < onHoldCount) {
            return this.mWaitingAdapter.getItem(pos);
        }
        pos -= onHoldCount;
        if (this.mPListLabelPos >= 0) {
            --pos;
        }
        if (this.mPListSeachPos >= 0) {
            --pos;
        }
        if (pos < plistCount) {
            return this.mPListItems.get(pos);
        }
        pos -= plistCount;
        if (this.mAttendeeLabelPos >= 0) {
            --pos;
        }
        if (pos < pAttendeeCount) {
            return this.mPAttendeeListAdapter.getItem(pos);
        }
        return position;
    }

    public long getItemId(int position) {
        Object item = this.getItem(position);
        if (item == null) {
            return 0L;
        }
        if (item instanceof PListItem) {
            return ((PListItem)item).userId;
        }
        if (item instanceof WaitingListItem) {
            return ((WaitingListItem)item).userId;
        }
        if (item instanceof PAttendeeItem) {
            return ((PAttendeeItem)item).nodeID;
        }
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Object item = this.getItem(position);
        if (item == null) {
            return null;
        }
        if (item instanceof PListItem) {
            return ((PListItem)item).getView(this.mPListView, this.mContext, convertView);
        }
        if (item instanceof WaitingListItem) {
            return ((WaitingListItem)item).getView(this.mContext, convertView);
        }
        if (item instanceof PAttendeeItem) {
            return ((PAttendeeItem)item).getView(this.mContext, convertView);
        }
        if (position == this.mOnHoldLabelPos) {
            return this.getOnHoldLabelView(this.mContext, convertView, parent);
        }
        if (position == this.mPListLabelPos) {
            return this.getPlistLabelView(this.mContext, convertView, parent);
        }
        if (position == this.mAttendeeLabelPos) {
            return this.getPAttendeeListLabelView(this.mContext, convertView, parent);
        }
        if (position == this.mPListSeachPos) {
            return this.getSearchDummyView(this.mContext, convertView, parent);
        }
        return null;
    }

    private View getOnHoldLabelView(Context context, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null || !"onHoldLabel".equals(view.getTag())) {
            view = View.inflate((Context)context, (int)R.layout.zm_plist_cate_label, null);
            view.setTag((Object)"onHoldLabel");
        }
        TextView vLabel = (TextView)view.findViewById(R.id.txtLabel);
        TextView vAdmitBtn = (TextView)view.findViewById(R.id.btn_admit_all);
        vAdmitBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PListAdapter.this.mWaitingAdapter != null) {
                    PListAdapter.this.mWaitingAdapter.admitAll();
                }
            }
        });
        String label = "";
        int waitingCount = this.mWaitingAdapter.getCount();
        if (this.isEnableWaitingList) {
            label = context.getString(R.string.zm_lbl_people_in_waiting, new Object[]{waitingCount});
            vAdmitBtn.setText(R.string.zm_btn_admit_all_39690);
        } else {
            label = context.getString(R.string.zm_lbl_people_on_hold, new Object[]{waitingCount});
            vAdmitBtn.setText(R.string.zm_btn_take_off_all_39690);
        }
        if (waitingCount >= 2) {
            vAdmitBtn.setVisibility(0);
        } else {
            vAdmitBtn.setVisibility(8);
        }
        vLabel.setText((CharSequence)label);
        return view;
    }

    private View getPlistLabelView(Context context, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null || !"plistLabelView".equals(view.getTag())) {
            view = View.inflate((Context)context, (int)R.layout.zm_plist_cate_label, null);
            view.setTag((Object)"plistLabelView");
        }
        TextView vLabel = (TextView)view.findViewById(R.id.txtLabel);
        TextView vAdmitBtn = (TextView)view.findViewById(R.id.btn_admit_all);
        vAdmitBtn.setVisibility(8);
        String label = "";
        label = this.isWebinar ? context.getString(R.string.zm_lbl_participants_in_meeting, new Object[]{this.mPListItems.size()}) : context.getString(R.string.zm_lbl_participants_in_waiting, new Object[]{this.mPListItems.size()});
        vLabel.setText((CharSequence)label);
        return view;
    }

    private View getPAttendeeListLabelView(Context context, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null || !"pAttendeeListLabelView".equals(view.getTag())) {
            view = View.inflate((Context)context, (int)R.layout.zm_plist_cate_label, null);
            view.setTag((Object)"pAttendeeListLabelView");
        }
        TextView vLabel = (TextView)view.findViewById(R.id.txtLabel);
        TextView vAdmitBtn = (TextView)view.findViewById(R.id.btn_admit_all);
        vAdmitBtn.setVisibility(8);
        String label = "";
        if (this.isWebinar) {
            label = context.getString(R.string.zm_webinar_txt_attendees, new Object[]{ConfMgr.getInstance().getViewOnlyUserCount()});
        }
        vLabel.setText((CharSequence)label);
        return view;
    }

    private View getSearchDummyView(Context context, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null || !"searchDummyView".equals(view.getTag())) {
            view = View.inflate((Context)context, (int)R.layout.zm_plist_search_dummy, null);
            view.setTag((Object)"searchDummyView");
        }
        view.findViewById(R.id.edtSearchDummy).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ZMActivity activity = (ZMActivity)PListAdapter.this.mContext;
                if (activity != null) {
                    activity.onSearchRequested();
                }
            }
        });
        return view;
    }

    public void sortAll() {
        this.sortPanelist();
        this.sortAttendee();
    }

    public void sortPanelist() {
        if (Build.VERSION.SDK_INT == 19 || Build.VERSION.SDK_INT == 17 || Build.VERSION.SDK_INT == 15 || Build.VERSION.SDK_INT == 14) {
            PListItemNewComparator.updatePlistItems(this.mPListItems);
            Collections.sort(this.mPListItems, new PListItemNewComparator(CompatUtils.getLocalDefault()));
        } else {
            Collections.sort(this.mPListItems, new PListItemComparator(CompatUtils.getLocalDefault()));
        }
    }

    public void sortAttendee() {
        this.mPAttendeeListAdapter.sort();
    }
}

