/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.util.PAttendeeItemComparator;
import com.zipow.videobox.view.PAttendeeItem;
import java.util.ArrayList;
import java.util.Collections;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;

public class PAttendeeListAdapter
extends BaseAdapter {
    private ArrayList<PAttendeeItem> mItems = new ArrayList();
    private Context mContext;

    public PAttendeeListAdapter(Context context) {
        this.mContext = context;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void addItem(PAttendeeItem item, String filter) {
        this.updateItem(item, filter);
    }

    public void updateItem(PAttendeeItem item, String filter) {
        assert (item != null);
        CmmUser user = ConfMgr.getInstance().getUserById(item.nodeID);
        if (user == null || !user.isViewOnlyUserCanTalk()) {
            return;
        }
        int position = this.findItem(item.nodeID);
        if (position >= 0) {
            if (this.isItemAcceptedByFilter(item, filter)) {
                this.mItems.set(position, item);
            } else {
                this.mItems.remove(position);
            }
        } else if (this.isItemAcceptedByFilter(item, filter)) {
            this.mItems.add(item);
        }
    }

    private boolean isItemAcceptedByFilter(PAttendeeItem item, String filter) {
        boolean accepted = true;
        if (!StringUtil.isEmptyOrNull((String)filter)) {
            String name = item.name;
            if (name == null) {
                name = "";
            }
            if (!name.toLowerCase(CompatUtils.getLocalDefault()).contains(filter)) {
                accepted = false;
            }
        }
        return accepted;
    }

    public int findItem(long userId) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            PAttendeeItem item = this.mItems.get(i);
            if (userId != item.nodeID) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(long userId) {
        int position = this.findItem(userId);
        if (position >= 0) {
            this.removeItemAt(position);
        }
    }

    public void removeItemAt(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
    }

    public void filter(String filter) {
        if (StringUtil.isEmptyOrNull((String)filter)) {
            return;
        }
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            PAttendeeItem item = this.mItems.get(i);
            String name = item.name;
            if (name == null) {
                name = "";
            }
            if (name.toLowerCase(CompatUtils.getLocalDefault()).contains(filter)) continue;
            this.mItems.remove(i);
        }
    }

    public int getCount() {
        return this.mItems.size();
    }

    public PAttendeeItem getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        PAttendeeItem item = this.getItem(position);
        return item != null ? item.nodeID : 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        PAttendeeItem item = this.getItem(position);
        if (item == null) {
            return null;
        }
        return item.getView(this.mContext, convertView);
    }

    public void sort() {
        Collections.sort(this.mItems, new PAttendeeItemComparator(CompatUtils.getLocalDefault()));
    }
}

